import { MolangVariableMap,
    MinecraftEffectTypes,
    MinecraftBlockTypes,
    MinecraftItemTypes,
    ItemStack,
    world,
    Player,
    system,
    MinecraftEntityTypes,
    EnchantmentList,
    DynamicPropertiesDefinition
  } from "@minecraft/server";
import { ActionFormData,
    MessageFormData,
    ModalFormData,
    ActionFormResponse
  } from "@minecraft/server-ui";
import lmd5 from "./md5.js"
import * as setting from "./setting.js"

const version = "0.6.0Beta"

const all_gt_data = [
    [ "features" , 2000 ],
    [ "board_text" , 5000 ],
    [ "about" , 5000 ],
    [ "helps" , 5000 ],
    [ "menu" , 5000 ],
    [ "tip" , 256 ],
    [ "owner" , 50 ],
    [ "ban_list" , 5000 ],
    [ "pos" , 5000 ],
]
const all_entity_data = [
    [ MinecraftEntityTypes.shulkerBullet , "sign_board" , 20000],
    [ MinecraftEntityTypes.shulkerBullet , "sign_owner" , 200],
    [ MinecraftEntityTypes.player , "name" , 200],
    [ MinecraftEntityTypes.player , "pos" , 1600],
    [ MinecraftEntityTypes.player , "more_pos" , 5000],
]


//事件订阅
world.afterEvents.entityDie.subscribe(afterEntityDie)
world.afterEvents.effectAdd.subscribe(afterEffectAdd)
world.afterEvents.projectileHit.subscribe(afterProjectileHit)
system.beforeEvents.watchdogTerminate.subscribe(beforeWatchdogTerminate)
world.beforeEvents.chatSend.subscribe(beforeChatSend)
world.afterEvents.itemUseOn.subscribe(afterItemUseOn)
world.beforeEvents.pistonActivate.subscribe(beforePistonActivate)
world.afterEvents.pistonActivate.subscribe(afterPistonActivate)
world.afterEvents.blockPlace.subscribe(afterBlockPlace)
world.afterEvents.blockBreak.subscribe(afterBlockBreak)
world.afterEvents.entitySpawn.subscribe(afterEntitySpawn)
world.beforeEvents.itemUseOn.subscribe(beforeItemUseOn)
world.afterEvents.explosion.subscribe(afterExplosion)
world.afterEvents.entityHurt.subscribe(afterEntityHurt)
world.afterEvents.playerLeave.subscribe(afterPlayerLeave)
world.afterEvents.weatherChange.subscribe(afterWeatherChanged)
world.afterEvents.entityHit.subscribe(afterEntityHit)
world.afterEvents.playerSpawn.subscribe(playerSpawn)
world.afterEvents.playerJoin.subscribe(playerJoin)
world.beforeEvents.dataDrivenEntityTriggerEvent.subscribe(beforeDataDrivenEntityTrigger)
world.afterEvents.worldInitialize.subscribe(worldInitializeEvent)
system.afterEvents.scriptEventReceive.subscribe(scriptEventReceive,{"namespaces":["usf"]})

//节省内存使用,每个id不超10字符
const features_list = [ 
    "Closed", //开启/关闭插件
    "LockMode",  //锁定生存模式
    "HurtTip",  //伤害提示
    "Weather", //天气切换
    "Board", //公告显示
    "SignBoard", //留言板
    "DiEffect", //维度传送给效果
    "Gametime", //锁定侧边栏
    "Cleaner", //清洁工
    "Emoji", //启用emoji
  ]
var enable_features = []

var About = setting.get_text("about")
var totals = setting.get_text("board_text")
var menu = setting.get_text("menu")
var helps = setting.get_text("helps")
var tip = ""

var time_board = false
var entities_count = 0
var tps_ms = 0
var trades = []
var share_points = {}
var world_points = []

const ui_path = "textures/ui/"
const emojis = [["","/笑脸","/xl"],["","/苦脸","/kl"],["","/死","/si"],["","/白眼","/by"],["","/开心","/kx"],["","/流口水","/lks"],["","/无语","/wy"],["","/搞怪","/gg"],["","/猥琐","/ws"],["","/哭","/ku"],["","/冷","/leng"],["","/生气","/sq"],["","/帅","/shuai"],["","/害羞","/hx"],["","/魔鬼","/mg"],["","/所以呢","/syn"],["","/笑哭","/xk"],["","/口罩","/kz"],["","/亲","/qin"]]
const pictures = [
    [ ui_path + "world_glyph_color_2x.png" , "world" ],
    [ ui_path + "achievements.png" , "bottle" ],
    [ ui_path + "comment.png" , "chat" ],
    [ ui_path + "filledStar.png" , "star" ],
    [ ui_path + "magnifyingGlass.png" , "glass" ],
    [ ui_path + "MCoin.png" , "coin" ],
    [ "textures/misc/missing_texture.png" , "missing" ],
    [ "textures/items/bed_red.png" , "bed" ],
    [ "textures/items/boat_oak.png" , "boat" ],
    [ "textures/items/emerald.png" , "emerald" ],
    [ "textures/items/ender_eye.png" , "endereye" ],
    [ "textures/items/sign.png" , "sign" ],
    [ "textures/items/totem.png" , "totem" ],
    [ "textures/items/villagebell.png" , "bell" ],
    [ "textures/items/wheat.png" , "wheat" ],
    [ "textures/items/trident.png" , "trident" ],
    [ "textures/blocks/diamond_ore.png" , "ore" ],
    [ "textures/blocks/end_stone.png" , "end" ],
    [ "textures/blocks/flower_rose.png" , "flower" ],
    [ "textures/blocks/grass_path_side.png" , "path" ],
    [ "textures/blocks/grass_side_snowed.png" , "snow" ],
    [ "textures/blocks/hay_block_side.png" , "hay" ],
    [ "textures/blocks/ice.png" , "ice" ],
    [ "textures/blocks/mycelium_side.png" , "mushroom" ],
    [ "textures/blocks/rail_normal.png" , "rail" ],
    [ "textures/blocks/prismarine_bricks.png" , "nether" ],
    [ "textures/blocks/netherrack.png" , "netherrack" ],
    [ "textures/blocks/sandstone_smooth.png" , "sand" ],
]

var ore_list = ["minecraft:clock","minecraft:iron_ingot" , "minecraft:raw_iron" , "minecraft:raw_gold" , "minecraft:gold_ingot" , "minecraft:diamond" , "minecraft:emerald" , "minecraft:netherite_scrap" , "minecraft:coal" , "minecraft:lapis_lazuli"]
var command_list = [ "tppoint","login","Ban","Version","NPC","Npc","land","Fill","tpaccept","reset" , "cd" , "菜单" , "talk" , "私聊" , "tp" , "传送" , "死" , "die",]


var ideas = []
var boards = []
var teams = []
var lands = {}
var team_id = 10000
var tps = 0
var pistons = 0
var pistons_now = 0
var spawn = 0
var spawn_now = 0
var ban_list = []
var works = []
var piston_block = {}
var can_http = true
const pages = {
    "Board":show_board,
    "Menu":cdBar,
    "Help":helpBar,
    "Lang":languageBar
}

//设置
var settings = {
    kick : false,
    team_id : 10000,
    login : false,
    hack_item : true,
    hack_egg : true,
    hack_entity : true,
    spawn_pos_y : 64
}


var un_kill_items = [ "minecraft:"]
//日志报告方块
var danger_break_blocks = [ "minecraft:chest","minecraft:tnt" , "minecraft:beacon" , "mimecraft:dragon_egg" , "minecraft:observer" ,  "minecraft:ancient_debris" , "minecraft:netherite_block" , "minecraft:diamond_block" , "minecraft:deepslate_diamond_ore" , "minecraft:diamond_ore" , "minecraft:emerald_ore" , "minecraft:deepslate_emerald_ore" , "minecraft:bed"]
var danger_place_blocks = [ "minecraft:chest","minecraft:tnt" , "minecraft:beacon" , "mimecraft:dragon_egg" , "minecraft:observer" ,  "minecraft:ancient_debris" , "minecraft:netherite_block" , "minecraft:diamond_block" , "minecraft:deepslate_diamond_ore" , "minecraft:diamond_ore" , "minecraft:emerald_ore" , "minecraft:deepslate_emerald_ore" , "minecraft:bed"]
var kick_place_blocks = [ "minecraft:light_block","minecraft:invisible_bedrock","minecraft:chain_command_block","minecraft:repeating_command_block", "minecraft:bedrock" ,"minecraft:end_portal_frame" , "minecraft:mob_spawner","minecraft:structure_block"]
var kick_break_blocks = [ "minecraft:chain_command_block","minecraft:repeating_command_block", "minecraft:bedrock" ,"minecraft:end_portal_frame" , "minecraft:structure_block"]
var entities_test = [ "minecraft:wolf" , "minecraft:parrot" , "minecraft:donkey" , "minecraft:horse" , "minecraft:mule" , "minecraft:cat"]
var kick_item = [  "minecraft:light_block","minecraft:invisible_bedrock","minecraft:command_block_minecart","minecraft:repeating_command_block","minecraft:chain_command_block","minecraft:structure_block","minecraft:bedrock","minecraft:command_block","minecraft:barrier","minecraft:end_portal_frame","minecraft:mob_spawner","minecraft:moving_block","minecraft:falling_block"]

//给各维度添加name属性统一调用
world.getDimension("minecraft:overworld").name = "§b主世界§r§?§bOverWorld§r"
world.getDimension("minecraft:the_end").name = "§5末地§r§?§5TheEnd§r"
world.getDimension("minecraft:nether").name = "§4下界§r§?§4Nether§r"

//创建计分板
world.getDimension("minecraft:overworld").runCommandAsync("scoreboard objectives add play_time dummy 游玩时间")
world.getDimension("minecraft:overworld").runCommandAsync("scoreboard objectives add score dummy 贡献值")
world.getDimension("minecraft:overworld").runCommandAsync("scoreboard objectives add coin dummy 金币")
world.getDimension("minecraft:overworld").runCommandAsync("scoreboard objectives add show1 dummy 游玩时间")
world.getDimension("minecraft:overworld").runCommandAsync("scoreboard objectives add show2 dummy 游玩时间")

//各常量
const spawn_point = world.getDefaultSpawnPosition()
const overworld = world.getDimension("minecraft:overworld")
const end = world.getDimension("minecraft:the_end")
const nether = world.getDimension("minecraft:nether")

//获取所有玩家语言
for(var cf of world.getAllPlayers()){
    get_lang(cf)
    cf.ui = {}
}

function get_owner(){
    return get_data("owner").split(";")[0]
}

function is_owner(name){
    if(name === get_owner()){
        return true
    }
    return false
}

function set_owner(name){
    save_data("owner",name)
}

function run(func){
    system.run(
        func
    )
}

function object_override(object,goal){
    for(var cf of Object.keys(goal)){
        object[cf] = goal[cf]
    }
}

function add_emoji(text){
    if(has_feature("Emoji") === false){
        return text
    }
    var message = text
    if(text.indexOf("/") !== -1){
        for(var cf=0;cf<emojis.length;cf++){
            message = message.replaceAll(emojis[cf][1],emojis[cf][0])
            message = message.replaceAll(emojis[cf][2],emojis[cf][0])
        }
    }
    return message
}

function get_di_name( player , di ){
    switch(typeof(di)){
        case "string":
            return tran_lang(player , world.getDimension(di).name)
        case "object":
            return tran_lang(player , di)
    }
    
    return ""
}

function format(texts , replacer){
    var text = texts
    if(typeof(text) === "string" && Array.isArray(replacer)){
        for(var cf= 0;cf<replacer.length;cf++){
          text =  text.replaceAll("@"+String(cf) , replacer[cf])
        }
    }
    return text
}

function has_feature(feature , force = false){
    if(enable_features.indexOf(feature) == -1){
        return false
    }else{
        if(enable_features.indexOf("Closed") !== -1 && force == true){
            return false
        }
        return true
    }
}

function update_features(features){
    enable_features = features
    save_data("features",String(features))
}

function save_entity_data(en , id , content){
    en.setDynamicProperty("usf:"+id,content)
}
function save_data(id , content){
    world.setDynamicProperty("usf:"+id,content)
}
function get_data(id){
    const data = world.getDynamicProperty("usf:"+id)
    if(typeof(data) === "string"){
        return data
    }else{
        return ""
    }
}

function get_entity_data(en,id){
    const data = en.getDynamicProperty("usf:"+id)
    if(typeof(data) === "string"){
        return data
    }else{
        return ""
    }
}

//将文本转换为目标语言，array/string
function tran_lang(player,texts){
    switch(typeof(texts)){
        case "string":
            var text = texts.split("§?")
            if(typeof(player.language) === "number"){
                if(text.length > player.language){
                    return text[player.language]
                }else{return text[0]}
            }else{return text[0]}
            break;
        case "object":
            if(Array.isArray(texts)){
                var lang = 0
                if(typeof(player.language) === "number"){
                    lang = player.language
                }
                var text = []
                for(var cf of texts){
                    var control = cf.split("§?")
                    
                    if(control.length > lang){
                        text.push(control[lang])
                    }
                    else{
                        text.push(control[0])
                    }
                }
                return text
            }
            break;
    }
    return ""
}


function buttonsBar(){
    this.ui = new ActionFormData()
    .title("").body("")
    
    this.things = {
        title : "",
        body : "",
        buttons : [],
        busy : {
            mode : "again",
            time : 20 ,
            func : function(player){}
        },
        cancel : {
            mode : "back",
            func : function(player){}
        }
    }
    
    this.buttons = []
    
    this.setTitle = function(title = ""){
        if(typeof(title) === "string"){
            this.things.title = title
            return true
        }
        else{
            return false
        }
    }
    
    this.setBody = function(body = [""]){
        switch(typeof(body)){
            case "string":
                this.things.body = body
                break;
            case "object":
                if(Array.isArray(body)){
                    this.things.body = body
                }
                break;
        }
    }
    
    //again,close,run
    this.setBusy = function(mode = "again" , time = 20,func = function(){}){
        if(typeof(mode) === "string"){
            this.things.busy.mode = mode
        }
        if(typeof(func) === "function"){
            this.things.busy.func = func
        }
        if(typeof(time) === "number"){
            this.things.busy.time = time
        }
    }
    
    //back,close,run
    this.setCancel = function(mode = "close" , func = function(){}){
        if(typeof(mode) === "string"){
            this.things.cancel.mode = mode
        }
        if(typeof(func) === "function"){
            this.things.cancel.func = func
        }
    }
    
    this.addButton = function(text = "" , option = {} , callback = function(id,option){}){
        var button = {
            "text" : "",
            "option" : option,
            "callback" : callback
        }
        
        switch(typeof(text)){
            case "string":
                button.text = text
                break;
        }
        
        this.things.buttons.push(button)
        return this.things.buttons.length - 1
    }
    
    this.setButton = function(id = 0 , text = "" , option = {} , callback = function(id,option){}){
        var button = this.things.buttons[id]

        switch(typeof(text)){
            case "string":
                button.text = text
                break;
        }
        if(typeof(option) === "object"){
            button.option = option
        }
        if(typeof(callback) === "function"){
            button.callback = callback
        }
    }
    
    this.show = function(player){
        this.ui = this.ui.title(tran_text(player,tran_lang(player,this.things.title)))
        
        var body = tran_lang(player,this.things.body)
        body = tran_text(player,body)
        body = add_emoji(body)
        this.ui = this.ui.body(body)
        
        for(var cf of this.things.buttons){
            var name = tran_lang(player,cf.text)
            name = tran_text(player,name)
            
            var icon = null
            if(typeof(cf.option.icon) === "string"){
                if(cf.option.icon !== ""){
                    icon = cf.option.icon
                }
            }
            
            this.ui = this.ui.button(name,icon)
            this.buttons.push(cf)
        }
        
        this.show_out(player)
    }
    
    this.busy = function(player){
        switch(this.things.busy.mode){
            case "run":
                this.things.busy.func(player)
                break;
            case "close":
                clear_history(player)
                break;
            case "again":
                try{
                this.wait_show(this.things.busy.time,player)
                }catch(err){console.error(err)}
                break;
        }
    }
    
    this.wait_show = function(time,player){
        var ui = this
        system.runTimeout(function(){
            ui.show_out(player)
        },time)
    }
    
    this.cancel = function(player){
        switch(this.things.cancel.mode){
            case "run":
                this.things.cancel.func(player)
                break;
            case "close":
                clear_history(player)
                break;
            case "back":
                back_history(player)
                break;
        }
    }
    
    this.show_out = function(player){
        this.ui.show(player).then((result) => {
            if(result.canceled){
                if(result.cancelationReason === "userClosed"){
                    this.cancel(player)
                }
                else{
                    this.busy(player)
                }
            }else{
                this.buttons[result.selection].callback(player,this.buttons[result.selection].option)
            }
        })
    }
}

function infoBar(){

    this.ui = new ModalFormData()
    .title("")
    
    this.things = {
        title : "",
        inputs : [],
        busy : {
            mode : "again",
            time : 20 ,
            func : function(player){}
        },
        cancel : {
            mode : "back",
            func : function(player){}
        },
        callback : function(ob){}
    }
    
    this.inputs = []
    this.result = []
    
    this.setTitle = function(title = ""){
        if(typeof(title) === "string"){
            this.things.title = title
            return true
        }
        else{
            return false
        }
    }
    
    //again,close,run
    this.setBusy = function(mode = "again" , time = 20,func = function(){}){
        if(typeof(mode) === "string"){
            this.things.busy.mode = mode
        }
        if(typeof(func) === "function"){
            this.things.busy.func = func
        }
        if(typeof(time) === "number"){
            this.things.busy.time = time
        }
    }
    
    //back,close,run
    this.setCancel = function(mode = "close" , func = function(){}){
        if(typeof(mode) === "string"){
            this.things.cancel.mode = mode
        }
        if(typeof(func) === "function"){
            this.things.cancel.func = func
        }
    }
    
    this.addOptions = function( ob = "" , text = "" , options = [""] , value = 0){
        var input = {
            "type" : "options",
            "text" : text,
            "ob" : ob,
            "options" : options,
            "value" : value
        }
        this.add(input)
    }
    this.addInput = function( ob = "" ,text = "" , place = "" , value = ""){
        var input = {
            "type" : "input",
            "text" : text,
            "ob" : ob,
            "place" : place,
            "value" : value
        }
        this.add(input)
    }
    this.addToggle = function( ob = "" ,text = "" , value = false){
        var input = {
            "type" : "toggle",
            "text" : text,
            "ob" : ob,
            "value" : value
        }
        this.add(input)
    }
    this.addRange = function( ob = "" ,text = "" , min = 0 , max = 1 , step = 1 , value = 0){
        var input = {
            "type" : "range",
            "text" : text,
            "min" : min,
            "max" : max,
            "step" : step,
            "ob" : ob,
            "value" : value
        }
        this.add(input)
    }
    
    this.add = function(input){
        this.things.inputs.push(input)
    }
    
    this.show = function(player,call_back){
        this.things.callback = call_back
        this.ui = this.ui.title(tran_text(player,tran_lang(player,this.things.title)))
        
        for(var cf of this.things.inputs){
            switch(cf.type){
                case "toggle":
                    this.ui = this.ui.toggle(tran_text(player,tran_lang(player,cf.text)),cf.value)
                    break;
                case "input":
                    this.ui = this.ui.textField(tran_text(player,tran_lang(player,cf.text)),tran_lang(player,cf.place),cf.value)
                    break;
                case "range":
                    this.ui = this.ui.slider(tran_text(player,tran_lang(player,cf.text)),cf.min,cf.max,cf.step,cf.value)
                    break;
                case "options":
                    this.ui = this.ui.dropdown(tran_text(player,tran_lang(player,cf.text)),tran_text(player,tran_lang(player,cf.options),true),cf.value)
                    break;
            }
            this.result.push(cf.ob)
        }
        this.show_out(player)
    }
    
    this.busy = function(player){
        switch(this.things.busy.mode){
            case "run":
                this.things.busy.func(player)
                break;
            case "close":
                clear_history(player)
                break;
            case "again":
                try{
                this.wait_show(this.things.busy.time,player)
                }catch(err){console.error(err)}
                break;
        }
    }
    
    this.wait_show = function(time,player){
        var ui = this
        system.runTimeout(function(){
            ui.show_out(player)
        },time)
    }
    
    this.cancel = function(player){
        switch(this.things.cancel.mode){
            case "run":
                this.things.cancel.func(player)
                break;
            case "close":
                clear_history(player)
                break;
            case "back":
                back_history(player)
                break;
        }
    }
    
    this.show_out = function(player){
        this.ui.show(player).then((result) => {
            if(result.canceled){
                if(result.cancelationReason === "userClosed"){
                    this.cancel(player)
                }
                else{
                    this.busy(player)
                }
            }else{
                var object = {}
                for(var cf=0; cf<this.result.length;cf++){
                    object[this.result[cf]] = result.formValues[cf]
                }
                this.things.callback(object)
            }
        })
    }
    
}
/*
function test_option(player,option){
    var result = true
    
    function f(){
        result = false
    }
    
    try{
    for(var cf in option){
        switch(cf){
            case "is_op":
                if(is_op(player) === false){f()}
                break;
        }
    }
    }catch(err){
        console.error(err)
        result = false
    }
    
    return result
}
*/
function show_tips(player){
    if(tip !== ""){
    player.sendMessage(tip.replace("\\n","\n"))}
}

function run_after(time = 10 , func , binds = [] , player = undefined){
    if(typeof(player) !== "undefined"){
        if(typeof(player.bar_time) === "number"){
            if(Date.now() - player.bar_time < 1000){
                return 0
            }
        }
        player.bar_time = Date.now()
    }
    var id = system.runInterval(function(){
        system.clearRun(id)
        
        func.apply(null,binds)
    },time)
}

function get_di_by_id(id){
    switch(id){
        case "minecraft:nether":
            return nether
            break;
        case "minecraft:the_end":
            return end
            break;
        case "minecraft:overworld":
            return overworld
            break;
    }
}

var safe_place = [spawn_point]
//初始化获取队伍信息
/*初始化信息方法
    /summon npc 0 -63 0
    /tag @e[type=npc] add serverInfomation

*/
function to_md5(input,sult = "EarthDLL") {
    return lmd5.hex_md5(input + sult)
}

function is_work(player){
    if(player.hasTag("op-work")){
        if(is_op(player)){
            return true
        }else{
            player.removeTag("op-work")
            return false
        }
    }
    return false
}
function script_check_tell(content){
    var players = world.getAllPlayers()
    for(var cf=0; cf<players.length;cf++){
        if(is_work(players[cf]) === true && players[cf].hasTag("script-check") === true){
            players[cf].sendMessage(content)
        }
    }
}

function fill_blocks(di,lo1,lo2,type,player){
    new Promise((resolve, reject) => {
    var start = lo1.y
    var finish = lo2.y
    var count = 0
    if(start > finish){
        finish = start
        start = lo2.y
    }
    for(var cf=start;cf<=finish;cf++){
    count += di.fillBlocks({x:lo1.x,y:cf,z:lo1.z},{x:lo2.x,y:cf,z:lo2.z},type)
    }
    player.sendMessage("填充完成，填充方块数量："+String(count))
    })
}

function set_time(time){
    world.setTime(time)
}

function clear_items(){

        for(var cf of world.getDimension("minecraft:overworld").getEntities({type:"item"})){
            var kill = true
            for(var cf1 of world.getDimension("minecraft:overworld").getEntities({type:"player",location:cf.headLocation,maxDistance:8})){
                kill = false
            }
            if(kill === true){
                cf.kill()
            }
        }
        for(var cf of world.getAllPlayers()){
        cf.onScreenDisplay.setActionBar("§e[清洁工]已清理所有掉落物")
        }
}

function tran_text(player,texts,keep = false){
    var boards = []
    var time = String(system.currentTick/20)
    var name = player.name
    var pos = get_pos(player)
    var list = String(world.getAllPlayers())
    
    for(var cf of world.scoreboard.getObjectives()){
        var config = {}
        config.name = cf.displayName
        config.id = cf.id
        config.score = 0
        try{
        config.score = cf.getScore(player.scoreboardIdentity)
        }catch(err){}
        boards.push(config)
    }
    
    var tran = function(line){
        var lineR = line
        if(lineR.indexOf("/") !== -1){
            lineR = lineR.replaceAll("/list",list)
            lineR = lineR.replaceAll("/name",name)
            lineR = lineR.replaceAll("/pos",pos)
            lineR = lineR.replaceAll("/alltime",time)
            for(var cf1 of boards){
                lineR = lineR.replaceAll("/board."+cf1.id+".name",cf1.name)
                lineR = lineR.replaceAll("/board."+cf1.id+".score",cf1.score)
            }
        }
        return lineR
    }
    
    var text
    
    if(typeof(texts) === "object"){
        if(keep){
            text = []
            for(var cf=0; cf<texts.length;cf++){
                text.push(tran(texts[cf]))
            }
        }
        else{
            text = ""
            for(var cf=0; cf<texts.length;cf++){
                if(cf !== 0){
                    text += "\n§r"
                }
                text += tran(texts[cf])
            }
        }
    }
    if(typeof(texts) === "string"){
        text = tran(texts)
    }
    
    return text
}


function entity_to_entity(self,target,show = false){
    tp_entity(self,target.dimension,target.location.x,target.location.y,target.location.z,show)
}

function tp_entity(entity,di,x,y,z,show = false){
    run(function(){
    if(show){
        show_title(entity,"正在传送...§?Teleport...")
    }
    entity.teleport({"x":x,"y":y,"z":z},{dimension:di})
    })
}

function show_title(player,text){
    player.onScreenDisplay.setTitle(tran_text(player,tran_lang(player,text)))
}

function get_pos(entity){
    return "(" + String(Math.round(entity.location.x)) + "，" + String(Math.round(entity.location.y)) + "，" + String(Math.round(entity.location.z)) + ")"
}

function get_block_pos(block){
    return "(" + String(Math.round(block.x)) + "，" + String(Math.round(block.y)) + "，" + String(Math.round(block.z)) + ")"
}

function get_lang(player){
    
    if(typeof(player.language) === "number"){
        return player.language
    }else{
        var tag = get_tag(player,"lang,")
        
        if(tag === ""){
            return 0
        }else{
            var language = 0
            try{
                var ob = JSON.parse(tag.slice(5))
                language = ob.lang
            }catch(err){console.error(err)}
            player.language = language
            return language
        }
    }
}

function save_trades(text){
    trades.push(text)
    save_all_trades()
}

function get_block(di,x,y,z){
    var block = di.getBlock({"x":x,"y":y,"z":z})
    return block
}

function delete_trades(text){
    if(trades.indexOf(text) > -1){
        trades.splice(trades.indexOf(text),1)
    }
    save_all_trades()
}

function save_all_trades(){
    var item = Infos.getItem(4)
    if(typeof(item) !== "object"){
        item = new ItemStack(MinecraftItemTypes.apple)
    }
    if(trades.length > 0){
        item.setLore(trades)
    }
    else{
        item = new ItemStack(MinecraftItemTypes.apple)
    }
    Infos.setItem(4,item)
}

function save_tip(text){
    save_data("tip",text)
}

function save_bans(){
    var item = Infos.getItem(7)
    var bans = []
    if(typeof(item) !== "object"){
        item = new ItemStack(MinecraftItemTypes.apple)
    }
    for(var cf of kick_item){
        bans.push("kick_item￠"+cf)
    }
    for(var cf of kick_break_blocks){
        bans.push("kick_break_blocks￠"+cf)
    }
    for(var cf of kick_place_blocks){
        bans.push("kick_place_blocks￠"+cf)
    }
        item.setLore(bans)
        
    
    Infos.setItem(7,item)
}



function player_history(player,history){
    if(typeof(player.history) === "object"){
        player.history.push(history)
    }
    else{
        player.history = [history]
    }
}

function clear_history(player){
    player.history = []
}

function back_history(player){
    if(typeof(player.history) === "object"){
        if(player.history.length > 0){
            player.history[player.history.length-1](player)
            player.history = player.history.slice(player.history.length-1)
        }
    }
}

function kick(player,reason,again = false,must = false){
    if(must === true || settings.kick === true){
    if(again === false && ban_list.indexOf(player.name)=== -1){
        ban_list.push(player.name)
        save_ban_list()
    }
    if(is_op(player) === false || must === true){
    player.kick = true
    run_command("kick \""+player.name + "\" "+String(reason))
    log("§e将玩家" + player.name + "踢出游戏，原因："+String(reason),!again)
    }
    }
}

function beforeDataDrivenEntityTrigger(event){
    switch(event.entity.typeId){
        case "minecraft:bat":
            switch(event.id){
                case "usf:safe":
                    
                    break;
            }
            break;
    }

}


function save_team(index){
    var text = "team，" + teams[index].id + "，" + teams[index].name + "，o；" + teams[index].owner
    for(var cf=0;cf<teams[index].member.length;cf++){
        text += "，m；" + teams[index].member[cf]
    }
    if(teams[index].pos1.length === 5){
        text += "，p1；" + teams[index].pos1[0] + "；" + teams[index].pos1[1] + "；" + teams[index].pos1[2] + "；" + teams[index].pos1[3] + "；" + teams[index].pos1[4]
    }
    if(teams[index].pos2.length === 5){
        text += "，p2；" + teams[index].pos2[0] + "；" + teams[index].pos2[1] + "；" + teams[index].pos2[2] + "；" + teams[index].pos2[3] + "；" + teams[index].pos2[4]
    }
    if(teams[index].pos3.length === 5){
        text += "，p3；" + teams[index].pos3[0] + "；" + teams[index].pos3[1] + "；" + teams[index].pos3[2] + "；" + teams[index].pos3[3] + "；" + teams[index].pos3[4]
    }
    teams[index].tag = text
    save_all_teams()
}

function save_all_teams(){
        var item = Infos.getItem(3)
    if(typeof(item) !== "object"){
        item = new ItemStack(MinecraftItemTypes.apple)
    }
        var text = []
        for(var cf=0;cf<teams.length;cf++){
            text.push(teams[cf].tag)
        }
        item.setLore(text)
        Infos.setItem(3,item)
}


function get_team_by_player(player,type = 0){
    //type=0 我的队伍  type=1  我加入的队伍
    switch(type){
        case 0:
            var tag = get_tag(player,"myTeam,")
            if(tag === ""){
                return ""
            }
            else{
                tag = tag.split(",")[1]
                for(var cf=0;cf<teams.length;cf++){
                    if(tag === teams[cf].id){
                        if(teams[cf].member.indexOf(player.name) !== -1){
                            return cf
                        }
                        else{
                            player.removeTag(get_tag(player,"myTeam,"))
                            return ""
                        }
                    }
                }
            }
            break;
        case 1:
            var tag = get_tag(player,"addTeam,")
            if(tag === ""){
                return ""
            }
            else{
                tag = tag.split(",")[1]
                for(var cf=0;cf<teams.length;cf++){
                    if(tag === teams[cf].id){
                        if(teams[cf].member.indexOf(player.name) !== -1){
                            return cf
                        }
                        else{
                            player.removeTag(get_tag(player,"addTeam,"))
                            return ""
                        }
                    }
                }
            }
            break;
    }
    return ""
}

function array_to_string(array){
    var text = ""
    for(var cf=0;cf <array.length;cf++){
        text += array[cf]
        if(cf !== array.length - 1){
            text += "\n"
        }
    }
    return text
}

function save_content(){
    var text = array_to_string(About)
    save_data("about",text)
    
    text = array_to_string(helps)
    save_data("helps",text)
    
    var text = array_to_string(menu)
    save_data("menu",text)
/*
    var item = Infos.getItem(8)
    var bans = []
    if(typeof(item) !== "object"){
        item = new ItemStack(MinecraftItemTypes.apple)
    }
    for(var cf of About){
        bans.push("About￠"+cf)
    }
    for(var cf of menu){
        bans.push("menu￠"+cf)
    }
    for(var cf of helps){
        bans.push("helps￠"+cf)
    }
    
        item.setLore(bans)
        
    
    Infos.setItem(8,item)
*/
}
function save_totals(){
    var text = ""
    for(var cf=0;cf <totals.length;cf++){
        text += totals[cf]
        if(cf !== totals.length - 1){
            text += "\n"
        }
    }
    save_data("board_text",text)
}

function reload_all(){
    var all = get_data("pos")
    if(all !== ""){
        all = JSON.parse(all)
        if(Array.isArray(all)){
            world_points = all
        }
    }
    
    //加载features
    enable_features = get_data("features").split(",")
    
    //加载公告内容
    var text = get_data("board_text")
    if(text !== ""){
        totals = text.split("\n")
    }
    //加载公告内容
    text = get_data("about")
    if(text !== ""){
        About = text.split("\n")
    }
    //加载主菜单内容
    text = get_data("menu")
    if(text !== ""){
        menu = text.split("\n")
    }
    //加载帮助
    text = get_data("helps")
    if(text !== ""){
        helps = text.split("\n")
    }
    
    //加载tip
    tip = get_data("tip")
    
    load_ban_list()
    /*
    var run_time = Date.now()
    //1 -63 1 ~ 3 -61 3
    InfoBlock = overworld.getBlock({x:2 , y:-62 , z:2})
    if(typeof(InfoBlock) === "object" && InfoBlock !== null){
        if(InfoBlock.typeId === "minecraft:chest"){
            Infos = InfoBlock.getComponent("minecraft:inventory").container
            if(typeof(Infos)==="object"){
                load_all_teams()
                load_totals()
                load_ban_list()
                load_settings()
                load_trades()
                load_lands()
                load_tip()
                load_bans()
                load_content()
                world.sendMessage("§e服务器信息加载完成")
                beload = true
            }
        }
        else{
            InfoBlock.setType(MinecraftBlockTypes.chest)
            return 0
        }
    }
    world.getDimension("minecraft:overworld").runCommandAsync("fill 0 -64 0 4 -60 4 bedrock 0 outline")
    script_check_tell("加载用时" + String(Date.now() - run_time))
    */
}

function load_totals(){
    var item = Infos.getItem(0)
    if(typeof(item) === "object"){
        var lores = item.getLore()
        if(lores.length > 0){
            totals = lores
        }
    }
    else{
        Infos.setItem(0,new ItemStack(MinecraftItemTypes.apple))
    }
}


function load_trades(){
    var item = Infos.getItem(4)
    if(typeof(item) === "object"){
        var lores = item.getLore()
        if(lores.length > 0){
            trades = lores
        }
    }
    else{
        Infos.setItem(4,new ItemStack(MinecraftItemTypes.apple))
    }
}

function load_bans(){
    var item = Infos.getItem(7)
    if(typeof(item) === "object"){
        kick_item = []
        kick_break_blocks = []
        kick_place_blocks = []
        var lores = item.getLore()
        for(var cf of lores){
            var text = cf.split("￠")
            switch(text[0]){
                case "kick_item":
                    kick_item.push(text[1])
                    break;
                case "kick_break_blocks":
                    kick_break_blocks.push(text[1])
                    break;
                case "kick_place_blocks":
                    kick_place_blocks.push(text[1])
                    break;
            }
        }
    }
    else{
        save_bans()
    }
}

function load_content(){
    var item = Infos.getItem(8)
    if(typeof(item) === "object"){
        var lores = item.getLore()
        if(lores.length > 0){
            var About_this = []
            var menu_this = []
            var helps_this = []
        for(var cf of lores){
            var text = cf.split("￠")
            switch(text[0]){
                case "About":
                    About_this.push(text[1])
                    break;
                case "menu":
                    menu_this.push(text[1])
                    break;
                case "helps":
                    helps_this.push(text[1])
                    break;
            }
        }
            if(About_this.length > 0){
                About = About_this
            }
            if(menu_this.length > 0){
                menu = menu_this
            }
            if(helps_this.length > 0){
                helps = helps_this
            }
        }
    }
    else{
        Infos.setItem(8,new ItemStack(MinecraftItemTypes.apple))
    }
}

function create_lands(land){
    if(typeof(lands[land.di]) !== "object"){
        lands[land.di] = {}
    }
    if(typeof(lands[land.di][land.id]) !== "object"){
        lands[land.di][land.id] = []
    }
    lands[land.di][land.id].push(land)
}

function load_lands(){
    var item = Infos.getItem(5)
    if(typeof(item) === "object"){
        var lores = item.getLore()
        if(lores.length > 0){
        //维度,id,名字,x,y,z,dx,dy,dz,owner,member
            for(var cf of lores){
                var land = {
                    "di":"",
                    "id":"",
                    "name":"",
                    "x":0,
                    "y":0,
                    "z":0,
                    "dx":0,
                    "dy":0,
                    "dz":0,
                    "owner":"",
                    "member":[]
                }
                var text = cf.split("，")
                land.di = text[0]
                land.id = text[1]
                land.id = text[2]
                for(var cf1=3;cf1<text.length;cf1++){
                    var land_info = text.split("：")
                    if(land_info.length === 2){
                        switch(land_info[0]){
                            case "o":
                                land.owner = land_info[1]
                                break;
                            case "m":
                                land.member.push(land_info[1])
                                break;
                            case "x":
                                land.x = parseInt(land_info[1])
                                break;
                            case "y":
                                land.y = parseInt(land_info[1])
                                break;
                            case "z":
                                land.z = parseInt(land_info[1])
                                break;
                            case "dx":
                                land.dx = parseInt(land_info[1])
                                break;
                            case "dy":
                                land.dy = parseInt(land_info[1])
                                break;
                            case "dz":
                                land.dz = parseInt(land_info[1])
                                break;
                            
                        }
                    }
                }
                if(typeof(lands[land.di]) !== "object"){
                    lands[land.di] = {}
                }
                if(typeof(lands[land.di][land.id]) !== "object"){
                    lands[land.di][land.id] = []
                }
                lands[land.di][land.id].push(land)
            }
            
        }
    }
    else{
        Infos.setItem(5,new ItemStack(MinecraftItemTypes.apple))
    }
}


function load_ban_list(){
    ban_list = get_data("ban_list").split(";")
    while(ban_list.indexOf("") !== -1){
        ban_list.splice(ban_list.indexOf(""),1)
    }
}

function load_all_teams(){
    var item = Infos.getItem(3)
    if(typeof(item) === "object"){
        var lores = item.getLore()
        for(var cf of lores){
            load_team(cf)
        }
    }
    else{
        Infos.setItem(3,new ItemStack(MinecraftItemTypes.apple))
    }
}


function load_settings(){
    var item = Infos.getItem(2)
    if(typeof(item) === "object"){
        var lores = item.getLore()
        for(var cf of lores){
            var text = cf.split("，")
            switch(text[0]){
                case "kick":
                    if(text[1] === "false"){
                        settings.kick = false
                    }else{
                        settings.kick = true
                    }
                    break;
                case "hack_entity":
                    if(text[1] === "false"){
                        settings.hack_entity = false
                    }else{
                        settings.hack_entity = true
                    }
                    break;
                case "hack_egg":
                    if(text[1] === "false"){
                        settings.hack_egg = false
                    }else{
                        settings.hack_egg = true
                    }
                    break;
                case "hack_item":
                    if(text[1] === "false"){
                        settings.hack_item = false
                    }else{
                        settings.hack_item = true
                    }
                    break;
                case "cleaner":
                    if(text[1] === "false"){
                        settings.cleaner = false
                    }else{
                        settings.cleaner = true
                    }
                    break;
                case "login":
                    if(text[1] === "false"){
                        settings.login = false
                    }else{
                        settings.login = true
                    }
                    break;
                case "team_id":
                    settings.team_id = parseInt(text[1])
                    team_id = parseInt(text[1])
                    break;
                case "spawn_pos_y":
                    settings.spawn_pos_y = parseInt(text[1])
                    break;
            }
            
        }
    }
    else{
        Infos.setItem(2,new ItemStack(MinecraftItemTypes.apple))
    }
}


function save_ban_list(){
    save_data("ban_list",String(ban_list))
}


function save_settings(){
    var item = Infos.getItem(2)
    if(typeof(item) !== "object"){
        item = new ItemStack(MinecraftItemTypes.apple)
    }
        var text = []
        for(var cf in settings){
            text.push(cf+"，"+String(settings[cf]))
        }
        item.setLore(text)
        Infos.setItem(2,item)
}




function add_team(info,owner){
    var text = "team，" + info.id + "，" + info.name + "，o；" + info.owner
    for(var cf=0;cf<info.member.length;cf++){
        text += "，m；" + info.member[cf]
    }
    var team = info
    team.tag = text
    teams.push(team)
    owner.addTag("myTeam,"+ String(team_id))
    team_id ++;
    settings.team_id ++
    save_all_teams()
    save_settings()
    add_score(owner,-500,true)
}

function load_team(info){
    var team = {
        tag : info,
        name : "",
        id : "",
        owner : "",
        member : [],
        pos1: [],
        pos2 : [],
        pos3 : [],
    }
    var texts = info.split("，")
    if(texts.length > 3){
        team.name = texts[2]
        team.id = texts[1]
        for(var cf=3;cf < texts.length;cf++){
            var infos = texts[cf].split("；")
            switch(infos[0]){
                case "m":
                    team.member.push(infos[1])
                    break;
                case "o":
                    team.owner = infos[1]
                    break;
                case "p1":
                    team.pos1 = [ infos[1] , infos[2] , infos[3] , infos[4] , infos[5]]
                    break;
                case "p2":
                    team.pos2 = [ infos[1] , infos[2] , infos[3] , infos[4] , infos[5]]
                    break;
                case "p3":
                    team.pos3 = [ infos[1] , infos[2] , infos[3] , infos[4] , infos[5]]
                    break;
            }
        }
        
    }
    teams.push(team)
}


function get_shares(){
    var players = world.getAllPlayers()
    var texts = []
    for(var cf=0; cf<players.length;cf++){
        if(get_tag(players[cf],"sharePos,") !== ""){
            //world.sendMessage("hi")
            texts.push(players[cf].name + "," + get_tag(players[cf],"sharePos,"))
        }
    }
    //world.sendMessage(String(texts))
    return texts
}

function block_test(block,is_name = false,type = 0){
    var name = ""
    if(is_name === true){
        name = block
    }
    else{
        name=block.typeId
    }
    if(type === 0){
        if(danger_break_blocks.indexOf(name) !== -1){
            return "danger"
        }
        if(kick_break_blocks.indexOf(name) !== -1){
            return "kick"
        }
    }
    else{
        if(danger_place_blocks.indexOf(name) !== -1){
            return "danger"
        }
        if(kick_place_blocks.indexOf(name) !== -1){
            return "kick"
        }
    }
    return "none"
}

function entity_test(entity){
    if(entities_test.indexOf(entity.typeId) !== -1){
        return true
    }
    else{
        return false
    }
}

function get_time(){
    var zone = 8
    var date = new Date();
    var Days = date.getDate()
    var Hours = date.getHours()
    var offest = zone-(date.getTimezoneOffset()/-60)
    Hours += offest
    if(Hours >= 24){
        Hours = Hours - 24
        Days ++
    }
    return "[" + String(date.getMonth()+1) + "." + String(Days) + " " + String(Hours) + ":" + String(date.getMinutes()) + "]"

}


function is_op(player){
    var op = player.hasTag("op,"+player.name)
    return op
}

function clear_tag(player){
    var tags = player.getTags()
    for(var cf=0; cf<tags.length; cf++){
    player.removeTag(tags[cf])
    }
}

function get_tag(player,tag){
    var tags = player.getTags()
    var goal = ""
    for(var cf=0; cf<tags.length; cf++){
    if(tags[cf].indexOf(tag) !== -1){
    goal = tags[cf]
    }
    }
    return goal
}

function add_score(player,count,push = false,test = true,back_message = ["§e贡献值不足§?§eScore is not enough"]){
    var object = world.scoreboard.getObjective("score")
    var board = player.scoreboardIdentity
    var score = 0
    try{
    score = object.getScore(board)
    if(typeof(score) !== "number"){score = 0}
    }catch(err){}
    var goal = score + count
    if(test === true && goal < 0 && count < 0){
        chat(back_message,[player],true)
        return false
    }
    player.runCommandAsync("scoreboard players add @s score " + String(count))
    if(push === true){
        if(count >= 0){
        player.sendMessage("§g获得" + String(count) + "贡献值")
        }
        else{
        player.sendMessage("§g失去" + String(-count) + "贡献值")
        }
    }
    return true
}

function get_score(player){
    var score = 0
    try{
        score = world.scoreboard.getObjective("score").getScore(player.scoreboardIdentity)
    }
    catch(any){}finally{}
    return score
}

function set_score(player,count,push = false){
    if(push === true){
        player.sendMessage(`§e贡献值被设置为` + String(count))
    }
    player.runCommandAsync("scoreboard players add @s score " + String(count))
}


function run_command(text){
    world.getDimension("minecraft:overworld").runCommandAsync(text)
}


function afterEntitySpawn(event){
    spawn_now ++ 
}

function afterBlockBreak(event){
    
    event.player.last_break = Date.now()
    if(typeof(event.player) === "object"){
        add_score(event.player,1)
        var block = event.brokenBlockPermutation
        var test = block_test(block.type.id,true,0)
        if(test !== "none"){
            add_history(`Players/${event.player.name}`,event.player.name + get_pos(event.player) + "(" + event.player.dimension.name + ")" + "破坏方块" + block.type.id + get_block_pos(event.block))
        }
        if(test === "kick" && is_op(event.player) === false){
            log(event.player.name + get_pos(event.player) + "(" + event.player.dimension.name + ")" + "破坏方块" + block.type.id + get_block_pos(event.block),true)
            kick(event.player,"破坏非法方块")
        }
        /*if(block.type.id === "minecraft:undyed_shulker_box" || block.type.id === "minecraft:shulker_box"){
            var items = event.player.dimension.getEntities({location:new Location(event.block.x,event.block.y,event.block.z),maxDistance:2,type:"item"})
            for(var cf of items){
                var item = cf.getComponent("minecraft:item").itemStack
                if(item.getLore().length === 0 && (item.typeId === "minecraft:undyed_shulker_box" || item.typeId === "minecraft:shulker_box")){
                    item.setLore([to_md5(event.player.name)])
                    world.sendMessage("set")
                }
            }
        }*/
    }
}

function worldInitializeEvent(event){
    const gtSaver = event.propertyRegistry
    
    
    for(var cf of all_gt_data){
        gtSaver.registerWorldDynamicProperties(
            new DynamicPropertiesDefinition().defineString("usf:" + cf[0],cf[1])
        )
    }
    
    for(var cf of all_entity_data){
        gtSaver.registerEntityTypeDynamicProperties(
            new DynamicPropertiesDefinition().defineString("usf:" + cf[1],cf[2]) , cf[0]
        )
    }
    
    reload_all()
    for(var cf of world.getAllPlayers()){
        load_pos(cf)
    }
    
    
}

function afterBlockPlace(event){
    if(typeof(event.player) === "object"){
        var block = event.block
        if(block.typeId === "minecraft:piston"){
            var com = block.getComponent("minecraft:piston")
        }
        add_score(event.player,1)
        var test = block_test(block,false,1)
        if(test !== "none"){
            add_history(`Players/${event.player.name}`,event.player.name + get_pos(event.player) + "(" + event.player.dimension.name + ")" + "放置方块" +block.typeId + get_block_pos(block))
        }
        if(test === "kick" && is_op(event.player) === false){
            log(event.player.name + get_pos(event.player) + "(" + event.player.dimension.name + ")" + "放置方块" +block.typeId + get_block_pos(block),true)
            block.setType(MinecraftBlockTypes.air)
            kick(event.player,"放置非法方块")
        }
        if(block.typeId === "minecraft:chest"){
            var con = block.getComponent("minecraft:inventory").container
            var need_kick = false
            if(con.size === 27){
            if(con.size - con.emptySlotsCount >0){
                need_kick = true
                }
            }
            else{if(typeof(event.player.beside_chest) === "object")
                for(var cf of event.player.beside_chest){
                    if(cf.block.getComponent("minecraft:inventory").container.size > cf.size){
                        if(cf.block.getComponent("minecraft:inventory").container.emptySlotsCount - cf.empty < 27){
                            need_kick = true
                        }
                    }
                }
            }
            if(need_kick === true){
                kick(event.player,"放置nbt箱子")
                block.setType(MinecraftBlockTypes.air)
                for(var cf of 
                event.player.dimension.getEntities({maxDistance:2,location:{x:event.block.x,y:event.block.y,z:event.block.z},type:"item"}
                )){
                    cf.kill()
                }
            }
        }
    }

}

function spawn_sign_board(di , lo ,owner){
    var entity = di.spawnEntity("minecraft:shulker_bullet",lo)
    entity.triggerEvent("usf:board")
    entity.addTag("usf_board")
    save_entity_data(entity,"sign_owner",owner)
}

function is_player(entity){
    if(entity.typeId === "minecraft:player"){
        return true
    }
    return false
}

function scriptEventReceive(event){
    const id = event.id.slice("usf:".length)
    var message = event.message.split(" ")
    
    while(message.indexOf("") !== -1){
        message.splice(message.indexOf(""),1)
    }
    
    var block = event.sourceBlock
    var entity = event.sourceEntity
    
    var back_message = setting.get_text("Scriptevent/error/NotFound")
    var formats = [id]
    
    switch(id){
        case "sign_board":
            if(typeof(entity) === "object" && entity.typeId === "minecraft:player"){
                spawn_sign_board(entity.dimension,entity.location,entity.name)
                back_message = setting.get_text("callback/sign_board/succeed")
            }
        break;
        case "test":
            back_message = ""
            var ui = new arrayEditor()
            ui.id = ""
            ui.array = ["hi","是不是人","癫"]
            ui.callback = function(e){
                console.error(e)
            }
            ui.show(entity)
            break;
        case "manager":
            if(typeof(entity) === "object" && entity.typeId === "minecraft:player"){
                if(get_owner() === ""){
                    set_owner(entity.name)
                }
                framework_manager_page(entity)
                back_message = setting.get_text("callback/manager/succeed")
            }else{
                back_message = setting.get_text("error/manager")
            }
        break;
        case "safe":
            var per = block.permutation
            per = per.withProperty("usf:owner_id",5)
            
            //world.sendMessage(JSON.stringify(per.getAllProperties()))
            break;
        case "tag":
            var targets = message[0].split(",")
            for(var cf of targets){
                var players = world.getPlayers({"name" : cf})
                players = Array.from(players)
                if(players.length > 0){
                    set_chat_tag(players[0],message[1])
                }
            }
            break;
        case "open":
            if(typeof(entity) === "object"){
                var player = event.sourceEntity
                if(player.typeId === "minecraft:player"){
                    if(typeof(pages[message[0]]) === "function"){
                        pages[message[0]](player)
                    }
                }
            }
            break;
        case "owner":
            back_message = setting.get_text("callback/owner")
            formats = [get_owner()]
    }
    
    chat(format(back_message,[formats]),[entity])
}


function afterPistonActivate(event){
     var piston = event.block
    if(typeof(piston_block[get_block_pos(piston)]) === "object"){
        if(piston_block[get_block_pos(piston)].type === false && event.piston.isRetracting === true){
            kick(piston_block[get_block_pos(piston)].player,"放置非法活塞")
            var dir = piston.permutation.getProperty("facing_direction").value
            var pos = piston.location
            switch(dir){
                case "east":
                    pos = {"x":piston.x-1,"y":piston.y,"z":piston.z}
                    break;
                case "west":
                    pos = {"x":piston.x+1,"y":piston.y,"z":piston.z}
                    break;
                case "north":
                    pos = {"x":piston.x,"y":piston.y,"z":piston.z+1}
                    break;
                case "south":
                    pos = {x:piston.x,y:piston.y,z:piston.z-1}
                    break;
                case "up":
                    pos = {x:piston.x,y:piston.y+1,z:piston.z}
                    break;
                case "down":
                    pos = {x:piston.x,y:piston.y-1,z:piston.z}
                    break;
                }
                var push_block = event.dimension.getBlock(pos)
                event.block.setType(MinecraftBlockTypes.air)
                push_block.setType(piston_block[get_block_pos(piston)].block)
        }
        else{
        piston_block[get_block_pos(piston)].type = !event.piston.isRetracting
        }
    }
}

function beforePistonActivate(event){
    var piston = event.block
    
    
    var blocks = event.piston.getAttachedBlocks()
    for(var cf of blocks){
    var block = event.dimension.getBlock(cf)
    if(block.typeId === "minecraft:hopper"){
        event.cancel = true
        return 0
    }
    if(block.typeId === "minecraft:chest"){
        var item = block.getComponent("minecraft:inventory").container.getItem(0)
        if(typeof(item) === "object"){if(item.typeId === "minecraft:paper"){
            var lores = item.getLore()
            if(lores.indexOf("passpaper") !== -1){
                event.cancel = true
            }
        }}
    }
    }
    pistons_now ++ 
}





system.runInterval(function(){
    var run_time = Date.now()
    var players = world.getAllPlayers()
    for(var cf=0;cf<works.length;cf++){
        var work = works[cf]
        switch(work.type){
            case "far_fall":
                var location = work.player.location
                for(var cf1=15;cf1>10;cf1--){
                var the_block = get_block(work.player.dimension,Math.trunc(location.x),Math.trunc(location.y-cf1),Math.trunc(location.z))
                if(typeof(the_block) === "object" && the_block !== null){
                if(the_block.typeId !== "minecraft:air"){
                    work.player.addEffect("slowFalling",100,{amplifier:1,showParticles:false})
                    works.splice(cf,1)
                    
                }}}
                break;
            case "button_run":
                if(work.back.length === work.count){
                    finishOptions({...work})
                    works.splice(cf,1)
                }
        }
    }
    if(system.currentTick % 20 == 0){
        for(var cf of Object.keys(share_points)){
            if(Date.now() > share_points[cf].last_time){
                delete share_points[cf]
            }
        }
    
        if(has_feature("DiEffect")){
            for(var cff of players){
                if(typeof(cff.di_now) === "string" && cff.di_now !== cff.dimension.id){
                    cff.addEffect("resistance",140,{amplifier:3})
                }
                cff.di_now = cff.dimension.id
            }
        }
        
        run_command("scoreboard players add @a play_time 1")
        if(has_feature("Gametime")){
            if(time_board === false){
                run_command("scoreboard players reset * show2")
                run_command("execute as @a run scoreboard players operation @s show2 = @s play_time")
                run_command("scoreboard objectives setdisplay list show2")
                time_board = true
            }
            else{
                run_command("scoreboard players reset * show1")
                run_command("execute as @a run scoreboard players operation @s show1 = @s play_time")
                run_command("scoreboard objectives setdisplay list show1")
                time_board = false
            }
        }
    }
    if(has_feature("Cleaner")){
        if(system.currentTick % 6000 == 0){
            clear_items()
        }
        if(system.currentTick % 6000 == 4800 ){
            for(var cf of players){
            cf.onScreenDisplay.setActionBar("§e[清洁工]一分钟后清理所有掉落物")
            }
        }
        if(system.currentTick % 6000 > 5400&&system.currentTick % 20 === 0){
            for(var cf of players){
            cf.onScreenDisplay.setActionBar("§e[清洁工]"+ String(30-(system.currentTick%6000-5400)/20) + "s后清理所有掉落物")
            }
        }
    }
    if(system.currentTick % 20 == 0){
        tps = (1000 / (Date.now() - tps_ms) *20).toFixed(1)
        tps_ms = Date.now()
    }
    if(system.currentTick % 2 == 0){
        // if(settings.hack_entity){
        // run_command("kill @e[type=npc,tag=!serverInfomation]")
        // run_command("kill @e[type=command_block_minecart]")
        // for(var dragons of overworld.getEntities({type:"ender_dragon"})){
            // if(dragons.dimension.id !== "minecraft:the_end"){
            // dragons.kill()
            // }
        // }}
        for(var cf=0; cf<players.length; cf++){
            if(players[cf].login !== true){
                if(get_tag(players[cf],"password," || settings.login === false) === ""){login(players[cf],"")}
                else{
                    players[cf].onScreenDisplay.setTitle("请登录",{fadeInSeconds:0,fadeOutSeconds:0,subtitle:"Login Please",staySeconds:1})
                    players[cf].onScreenDisplay.setActionBar("在聊天框直接输入密码以登录\nSend your password in chat")
                    var x = players[cf].getRotation().x
                    if(x>0){x=-85}
                    else{x=85}
                    if(typeof(players[cf].join_pos !== "object")){
                        players[cf].join_pos = players[cf].location
                    }
                    players[cf].teleport(players[cf].join_pos,{dimension:players[cf].dimension})
                    players[cf].addEffect("blindness",1,{amplifier:1})
                }
            }
            if(ban_list.indexOf(players[cf].name) !== -1){
                kick(players[cf],"封禁列表，自动踢出",true)
            }
            //test
            if(is_work(players[cf]) === true){
                players[cf].onScreenDisplay.setActionBar("Tps:" + tps + "  Entities:" + String(entities_count) + "\nPistons:" +String(pistons) + " Spawn:" + String(spawn))
            }
            // if(get_tag(players[cf],"beBan") !== "" && is_op(players[cf]) === false){
                // banBar(players[cf])
            // }
            
            // if(players[cf].getComponent("minecraft:health").current <= 0 && players[cf].lastDie != true){
                // add_score(players[cf],3,true)
                // players[cf].diePos = [players[cf].dimension.id , players[cf].location.x , players[cf].location.y , players[cf].location.z]
                // players[cf].lastDie = true
            // }
            // if(players[cf].getComponent("minecraft:health").current > 0){
                // players[cf].lastDie = false
            // }
        }
    }
    if(system.currentTick % 20  == 0 && has_feature("LockMode")){
    var create_players = world.getPlayers({gameMode:"creative"})
    for(var cf of create_players){
        if(is_op(cf) === false){
        cf.runCommandAsync("gamemode 0")
        }
    }
    }
    
    if(system.currentTick % 100  == 0){
    
    var count = 0
    count += world.getDimension("minecraft:the_end").getEntities({}).length
    count += world.getDimension("minecraft:nether").getEntities({}).length
    count += world.getDimension("minecraft:overworld").getEntities({}).length

    // var entity = world.getDimension("minecraft:overworld").getEntities({})
    // for(var cf of entity){
        // count++
        // if(cf.typeId === "minecraft:item"){
            // var item = cf.getComponent("minecraft:item").itemStack
            // if(kick_item.indexOf(item.typeId) != -1 && settings.hack_item === true){
                // world.sendMessage("§e发现违禁物品，已清理")
                // cf.kill()
            // }
            // if(item.typeId.indexOf("spawn_egg") != -1&& settings.hack_item === true&& settings.hack_egg === true){
                // world.sendMessage("§e发现违禁物品，已清理")
                // cf.kill()
            // }
        // }
    // }
    entities_count = count
    pistons = pistons_now
    pistons_now = 0
    spawn = spawn_now
    spawn_now = 0
    //原本：1200
    //world.sendMessage("§4开始随机检查......")
    /*
        if(players.length > 0){
        for(var cf=0; cf<players.length; cf++){
            var invent = players[cf].getComponent("minecraft:inventory").container
            for(var cf1=0; cf1<invent.size; cf1++){
                var item = invent.getItem(cf1)
                if(typeof(item) == "object" && is_op(players[cf]) == false){
                //附魔检查
                if(item.hasComponent("minecraft:enchantments") === true){
                    var enList = item.getComponent("minecraft:enchantments").enchantments
                    var ens = enList[Symbol.iterator]()
                    var finish = false
                    while(finish === false){
                        var result = ens.next()
                        finish = result.done
                        if(finish === false){
                        if(result.value.level > result.value.type.maxLevel){
                            log("玩家" + players[cf].name + "物品附魔等级过高。物品名：" + item.typeId + "；附魔名：" + result.value.type.id + "；等级：" + result.value.level , true)
                            if(result.value.level > 5){
                                kick(players[cf],"作弊附魔")
                            }
                            warnBar(players[cf])
                            item.getComponent("minecraft:enchantments").removeAllEnchantments()
                        }
                        }
                    }
                }
                //违禁检查
                if(kick_item.indexOf(item.typeId) !== -1&& settings.hack_item === true){
                        log("玩家" + players[cf].name + "获得违禁物品：" + item.typeId + "物品数量：" + item.amount,true)
                        invent.setItem(cf1)
                        kick(players[cf],"获得违禁物品")
                        warnBar(players[cf])
                        break;
                }
                if(item.typeId.indexOf("spawn_egg") != -1&& settings.hack_egg === true){
                    log("玩家" + players[cf].name + "获得违禁物品：" + item.typeId + "物品数量：" + item.amount,true)
                    invent.setItem(cf1)
                    kick(players[cf],"获得违禁物品")
                    warnBar(players[cf])
                }
                if(item.typeId == "minecraft:tnt" && item.amount > 16){
                    log("玩家" + players[cf].name + "收集违禁物品：" + item.typeId + "物品数量：" + item.amount,true)
                }
            }
            }
               
        }
       }
       */
       
       script_check_tell("随机检查用时"+String(run_time))
       
    }
    run_time = Date.now() - run_time
    //console.error(run_time)
},1)

function afterEntityDie(event){
    const entity = event.deadEntity
    if(entity.typeId === "minecraft:player"){
        entity.diePos = [entity.dimension.id , entity.location.x , entity.location.y , entity.location.z]
    }
}
function afterEntityHurt(event){
    var hurt = event.hurtEntity
    var hurter = event.damageSource.damagingEntity
    
    if(typeof(hurter) === "object"){
    if (hurter.typeId == "minecraft:player"){
    /*
        if(event.damage > 100 && event.hurtEntity.typeId !== "minecraft:ghast" &&is_op(event.damagingEntity) === false){
            //log("玩家" + event.damageSource.damagingEntity.name + get_pos(event.damageSource.damagingEntity) + "(" + event.damageSource.damagingEntity.dimension.name + ")" + "对" + event.hurtEntity.typeId + get_pos(event.hurtEntity) + "造成了" + String(event.damage) +"点伤害",true)
            //kick(event.damageSource.damagingEntity,"造成伤害过高")
        }
        else{
            if(event.damage > 25){
            //log("玩家" + event.damageSource.damagingEntity.name + get_pos(event.damageSource.damagingEntity) + "(" + event.damagingEntity.dimension.name + ")" + "对" + event.hurtEntity.typeId + get_pos(event.hurtEntity) + "造成了" + String(event.damage) +"点伤害",false)
            }
        }
    */
        if(event.hurtEntity.hasComponent("minecraft:health")){
        add_score(hurter,1)
        var max = event.hurtEntity.getComponent("minecraft:health").defaultValue
        var now = event.hurtEntity.getComponent("minecraft:health").currentValue
        if (now > 0){
        var text = "目标血量："
        if (now / max >= 0.66){
            text = "§4" + text
        }
        else{
        if (now / max < 0.66 && now / max >= 0.33){
            text = "§e" + text
        }
        if (now / max < 0.33){
            text = "§a" + text
        }}
        if(has_feature("HurtTip")){
            event.damageSource.damagingEntity.onScreenDisplay.setActionBar( text + String(Math.round(now/max*1000)/10) + "%")
        }}
        else{
            //add_history(event.damagingEntity.name+ get_pos(event.damagingEntity) + "(" + event.damagingEntity.dimension.name + ")" + "杀死了" +name)
            //add_score(event.damagingEntity,1)
        }
        }
    }
    }
}

function get_passpaper(block){

}

function afterExplosion(event){
    var blocks = event.getImpactedBlocks()
    var goals = []
    var di = event.source.dimension
    for(var cf=0;cf<blocks.length;cf++){
        var block = di.getBlock(blocks[cf])
        if(block.typeId === "minecraft:chest"){
            var item = block.getComponent("minecraft:inventory").container.getItem(0)
            if(typeof(item) === "object"){
                item = item.getLore()
                if(item.indexOf("passpaper") !== -1){
                    goals.push(blocks[cf])
                }
            }
        }
    }
    for(var cf of goals){
        blocks.splice(blocks.indexOf(cf,1))
    }
    event.setImpactedBlocks(blocks)
}

function get_block_from_face(di,location,face){
    var pos
        switch(face){
            case "north":
                pos = {x:location.x,y:location.y,z:location.z-1}
                break;
            case "south":
                pos = {x:location.x,y:location.y,z:location.z+1}
                break;
            case "west":
                pos = {x:location.x-1,y:location.y,z:location.z}
                break;
            case "east":
                pos = {x:location.x+1,y:location.y,z:location.z}
                break
            case "down":
                pos = {x:location.x,y:location.y-1,z:location.z}
                break;
            case "up":
                pos = {x:location.x,y:location.y+1,z:location.z}
                break;
        }
        var block = di.getBlock(pos)
        return block
}


///重要！


function beforeItemUseOn(event){
    
    
    if(event.source.typeId == "minecraft:player"){
    var player = event.source
    
    var block = event.block
    if(block.typeId.indexOf("sign") > -1){
        var sign = block.getComponent("minecraft:sign")
        if(typeof(sign) === "object"){
            if(sign.getText("back").indexOf("§?") === 0 || sign.getText("front").indexOf("§?") === 0){
                var entities = block.dimension.getEntities({
                    location : block.location,
                    maxDistance : 2,
                    closest : 1,
                    type : "shulker_bullet",
                    excludeTags : ["usf_sign"]
                })
                if(entities.length > 0){
                    event.cancel = true
                    run(function(){
                    try_open_sign_board(player,entities[0])
                    })
                }
            }
        }
    }
    if(block.typeId === "minecraft:chest" && is_work(player) === false){
        var item = block.getComponent("minecraft:inventory").container.getItem(0)
        if(typeof(item) === "object"){if(item.typeId === "minecraft:paper"){
            var lores = item.getLore()
            if(lores.indexOf("passpaper") !== -1){
                var owner = ""
                var password = ""
                var open_team = ""
                var need = true
                for(var cf=0;cf<lores.length;cf++){
                    switch(lores[cf].slice(0,1)){
                        case "o":
                            owner = lores[cf].split(":")[1]
                            break;
                        case "p":
                            password = lores[cf].split(":")[1]
                            break;
                        case "t":
                            open_team = lores[cf].split(":")[1]
                            break;
                    }
                }
                
                if(player.name === owner){
                    need = false
                }
                var index = get_team_by_player(player,0)
                if(index !== ""){
                    if(teams[index].id === open_team){
                        need = false
                    }
                }
                index = get_team_by_player(player,1)
                if(index !== ""){
                    if(teams[index].id === open_team){
                        need = false
                    }
                }
                if(typeof(player.last_chest) === "object"){
                    if(player.last_chest.x === block.location.x){if(player.last_chest.y === block.location.y){if(player.last_chest.z === block.location.z){
                    need = false
                    }}}
                }
                
                
                if(need === true){
                    event.cancel = true
                    run(function(){
                    chestKeyBar(player,password,block.location,owner)
                    })
                }
            }
        }}
        //event.cancel = true
    }
    
    if(ore_list.indexOf(event.itemStack.typeId) !== -1){
        run_after(1,cdBar,[event.source],event.source)
    }
    
    if(block_test(block,false,1) !== "none"){
    add_history(event.source.name+ get_pos(event.source) + "(" + event.source.dimension.name +")与" +block.typeId + "方块" + "(" + String(block.x) + "，" + String(block.y) + "，" + String(block.z) + ")" +"交互")
    }
    
    if(event.itemStack.typeId === "minecraft:hopper"){
        var block = get_block_from_face(event.source.dimension,{x:event.block.location.x,y:event.block.location.y+1,z:eevent.block.location.z},event.blockFace)
        if(block.typeId === "minecraft:chest"){
            var item = block.getComponent("minecraft:inventory").container.getItem(0)
            if(typeof(item) === "object"){
            var lores = item.getLore()
            if(lores.indexOf("passpaper") !== -1){
                event.cancel = true
                event.source.sendMessage("§e密码箱，禁止放置")
            }
           }
        }
    }
    if(event.itemStack.typeId === "minecraft:chest"){
    var block = get_block_from_face(event.source.dimension,event.block.location,event.blockFace)
    var blocks = []
    blocks.push(event.source.dimension.getBlock({x:block.x+1,y:block.y,z:block.z}))
    blocks.push(event.source.dimension.getBlock({x:block.x-1,y:block.y,z:block.z}))
    blocks.push(event.source.dimension.getBlock({x:block.x,y:block.y,z:block.z+1}))
    blocks.push(event.source.dimension.getBlock({x:block.x,y:block.y,z:block.z-1}))
    for(var cf of blocks){
    if(cf.typeId === "minecraft:chest"){
        var item = cf.getComponent("minecraft:inventory").container.getItem(0)
        if(typeof(item) === "object"){
        var lores = item.getLore()
        if(lores.indexOf("passpaper") !== -1){
            for(var cf1 of lores){
                var text = cf1.split(":")
                if(text[0] === "owner"){
                    if(text[1] !== event.source.name){
                        event.cancel = true
                    }
                }
            
            }
        }
       }
    }
    }
    }
    //需要补充
    if(event.itemStack.typeId === "minecraft:piston"){
        var block = get_block_from_face(event.source.dimension,event.block.location,event.blockFace)
        piston_block[get_block_pos(block)] = {"type":false,"player":player,"block":block.type}
    }
    }
    
    if(event.itemStack.typeId === "minecraft:wooden_axe" && is_work(player)){
        var block = event.source.dimension.getBlock(event.block.location)
        if(typeof(player.axe) !== "object"){
        player.axe = {}
        player.axe.blocks = []
        player.axe.di = player.dimension
        }
        if(player.dimension.id !== player.axe.di.id){
            player.axe.blocks = []
            player.axe.di = player.dimension
        }
        var add = true
        if(player.axe.blocks.length > 0){
            if(get_block_pos(player.axe.blocks[player.axe.blocks.length-1]) === get_block_pos(block)){
             add = false
            }
        }
        
        if(add === true){
        player.axe.blocks.push(block)
        if(player.axe.blocks.length > 2){
            player.axe.blocks.splice(0,1)
        }
        player.playSound("dig.wood")
        player.dimension.spawnParticle("minecraft:villager_angry",{"x":block.x+0.5,"y":block.y+1,"z":block.z+0.5},new MolangVariableMap().setSpeedAndDirection("1",1,{x:0,y:-5,z:0}))
        player.sendMessage("§a标记成功" + get_block_pos(block))
        
        var redstone = block.getRedstonePower()
        if(typeof(redstone) === "number"){if(redstone !== 0){
            player.sendMessage("该方块的红石信号:" + String(redstone))
        }}}
    
    }
    
    if(event.itemStack.typeId === "minecraft:chest"){
        var block = get_block_from_face(event.source.dimension,event.block.location,event.blockFace)
        player.beside_chest = []
        
        var the_block = [event.source.dimension.getBlock({x:block.x+1 , y:block.y , z:block.z})]
        the_block.push(event.source.dimension.getBlock({x:block.x-1 , y:block.y , z:block.z}))
        the_block.push(event.source.dimension.getBlock({x:block.x , y:block.y , z:block.z+1}))
        the_block.push(event.source.dimension.getBlock({x:block.x , y:block.y , z:block.z-1}))
        
        for(var cf of the_block){
        if(cf.typeId === "minecraft:chest"){
            player.beside_chest.push({
                "block":cf,
                "size":cf.getComponent("minecraft:inventory").container.size,
                "empty":cf.getComponent("minecraft:inventory").container.emptySlotsCount
            })
        }
    }
    }
}

function afterItemUseOn(event){
    /*
    
    if(event.source.typeId == "minecraft:player"){
    var player = event.source
    var block = event.source.dimension.getBlock(event.getBlockLocation())
    if(block.typeId === "minecraft:chest" && player.hasTag("op-work") === false){
        
        var item = block.getComponent("minecraft:inventory").container.getItem(0)
        if(typeof(item) === "object"){if(item.typeId === "minecraft:paper"){
            var lores = item.getLore()
            if(lores.indexOf("passpaper") !== -1){
                var owner = ""
                var password = ""
                var open_team = ""
                var need = true
                for(var cf=0;cf<lores.length;cf++){
                    switch(lores[cf].slice(0,1)){
                        case "o":
                            owner = lores[cf].split(":")[1]
                            break;
                        case "p":
                            password = lores[cf].split(":")[1]
                            break;
                        case "t":
                            open_team = lores[cf].split(":")[1]
                            break;
                    }
                }
                
                if(player.name === owner){
                    need = false
                }
                var index = get_team_by_player(player,0)
                if(index !== ""){
                    if(teams[index].id === open_team){
                        need = false
                    }
                }
                index = get_team_by_player(player,1)
                if(index !== ""){
                    if(teams[index].id === open_team){
                        need = false
                    }
                }
                if(typeof(player.last_chest) === "object"){
                    if(player.last_chest.x === block.location.x){if(player.last_chest.y === block.location.y){if(player.last_chest.z === block.location.z){
                    need = false
                    }}}
                }
                
                
                if(need === true){
                    var high = player.location.y
                    var up = block.dimension.getBlock({x:block.x,y:block.y+1,z:block.z})
                    if(up.typeId === "minecraft:air" || up.typeId === "minecraft:barrier"){
                    up.setType(MinecraftBlockTypes.barrier)
                    run_after(20,to_block,[up,MinecraftBlockTypes.air])
                    }
                    else{
                    tp_entity(player,player.dimension,player.location.x,114514,player.location.z)
                    run_after(20,tp_entity,[player,player.dimension,player.location.x,high,player.location.z])
                    run_after(5,chestKeyBar,[player,password,block.location,owner])
                    }
                }
            }
        }}
        //event.cancel = true
    }
    
    if(ore_list.indexOf(event.itemStack.typeId) !== -1 && block.typeId !== "minecraft:chest"){
        run_after(1,cdBar,[player],player)
    }
    
    if(block_test(block,false,1) !== "none"){
    add_history(`Players/${event.source.name}`,event.source.name+ get_pos(event.source) + "(" + event.source.dimension.name +")与" +block.typeId + "方块" + "(" + String(block.x) + "，" + String(block.y) + "，" + String(block.z) + ")" +"交互")
    }
    
    if(event.itemStack.typeId === "minecraft:hopper"){
        var block = get_block_from_face(event.source.dimension,{x:event.getBlockLocation().x,y:event.getBlockLocation().y+1,z:event.getBlockLocation().z},event.blockFace)
        if(block.typeId === "minecraft:chest"){
            var item = block.getComponent("minecraft:inventory").container.getItem(0)
            if(typeof(item) === "object"){
            var lores = item.getLore()
            if(lores.indexOf("passpaper") !== -1){
            block = get_block_from_face(event.source.dimension,{x:event.getBlockLocation().x,y:event.getBlockLocation().y,z:event.getBlockLocation().z},event.blockFace)
            block.setType(MinecraftBlockTypes.air)
                event.source.sendMessage("§e密码箱，禁止放置")
            }
           }
        }
    }
    if(event.itemStack.typeId === "minecraft:chest"){
    var block = get_block_from_face(event.source.dimension,event.getBlockLocation(),event.blockFace)
    var blocks = []
    blocks.push(event.source.dimension.getBlock({x:block.x+1,y:block.y,z:block.z}))
    blocks.push(event.source.dimension.getBlock({x:block.x-1,y:block.y,z:block.z}))
    blocks.push(event.source.dimension.getBlock({x:block.x,y:block.y,z:block.z+1}))
    blocks.push(event.source.dimension.getBlock({x:block.x,y:block.y,z:block.z-1}))
    for(var cf of blocks){
    if(cf.typeId === "minecraft:chest"){
        var item = cf.getComponent("minecraft:inventory").container.getItem(0)
        if(typeof(item) === "object"){
        var lores = item.getLore()
        if(lores.indexOf("passpaper") !== -1){
            for(var cf1 of lores){
                var text = cf1.split(":")
                if(text[0] === "owner"){
                    if(text[1] !== event.source.name){
                        block.setType(MinecraftBlockTypes.air)
                    }
                }
            
            }
        }
       }
    }
    }
    }
    //需要补充
    if(event.itemStack.typeId === "minecraft:piston"){
        var block = get_block_from_face(event.source.dimension,event.getBlockLocation(),event.blockFace)
        piston_block[get_block_pos(block)] = {"type":false,"player":player,"block":block.type}
    }
    }
    
    if(event.itemStack.typeId === "minecraft:wooden_axe" && player.hasTag("op-work")){
        var block = event.source.dimension.getBlock(event.getBlockLocation())
        if(typeof(player.axe) !== "object"){
        player.axe = {}
        player.axe.blocks = []
        player.axe.di = player.dimension
        }
        if(player.dimension.id !== player.axe.di.id){
            player.axe.blocks = []
            player.axe.di = player.dimension
        }
        var add = true
        if(player.axe.blocks.length > 0){
            if(get_block_pos(player.axe.blocks[player.axe.blocks.length-1]) === get_block_pos(block)){
             add = false
            }
        }
        
        if(add === true){
        player.axe.blocks.push(block)
        if(player.axe.blocks.length > 2){
            player.axe.blocks.splice(0,1)
        }
        player.playSound("dig.wood")
        player.dimension.spawnParticle("minecraft:villager_angry",{x:(block.x+0.5),y:(block.y+1),z:(block.z+0.5)},new MolangVariableMap())
        player.sendMessage("§a标记成功" + get_block_pos(block))
        
        var redstone = block.getRedstonePower()
        if(typeof(redstone) === "number"){if(redstone !== 0){
            player.sendMessage("该方块的红石信号:" + String(redstone))
        }}}
    
    }
    
    if(event.itemStack.typeId === "minecraft:chest"){
        var block = get_block_from_face(event.source.dimension,event.getBlockLocation(),event.blockFace)
        player.beside_chest = []
        
        var the_block = [event.source.dimension.getBlock({x:block.x+1 , y:block.y , z:block.z})]
        the_block.push(event.source.dimension.getBlock({x:block.x-1 , y:block.y , z:block.z}))
        the_block.push(event.source.dimension.getBlock({x:block.x , y:block.y , z:block.z+1}))
        the_block.push(event.source.dimension.getBlock({x:block.x , y:block.y , z:block.z-1}))
        
        for(var cf of the_block){
        if(cf.typeId === "minecraft:chest"){
            player.beside_chest.push({
                "block":cf,
                "size":cf.getComponent("minecraft:inventory").container.size,
                "empty":cf.getComponent("minecraft:inventory").container.emptySlotsCount
            })
        }
    }
    }
    */
}

function stopPlayerDig(player,block){
    var under
    switch(player.dimension.id){
        case "minecraft:overworld":
            under = block.dimension.getBlock({x:block.x,y:-64,z:block.z})
            break;
        case "minecraft:nether":
            under = block.dimension.getBlock({x:block.x,y:0,z:block.z})
            break;
        case "minecraft:the_end":
            under = block.dimension.getBlock({x:block.x,y:0,z:block.z})
            break;
            
    }
    under.setType(MinecraftBlockTypes.deny)
    under.setType(MinecraftBlockTypes.deny)
    run_after(20,to_block,[under,MinecraftBlockTypes.bedrock])
}

function to_block(block,type){
    block.setType(type)
}

function afterEntityHit(event){
    if(typeof(event.hitBlock) === "object" && event.entity.typeId === "minecraft:player"){
        //world.sendMessage(typeof(event.entity.item_use_event))
        //event.entity.item_use_event.cancel = true
        if(event.hitBlock.typeId === "minecraft:chest" && is_work(event.entity) === false){
            var item = event.hitBlock.getComponent("minecraft:inventory").container.getItem(0)
            if(typeof(item) === "object"){
                item = item.getLore()
                var owner = ""
                for(var cf=0;cf<item.length;cf++){
                    if(item[cf].indexOf("owner") === 0){
                        owner = item[cf].split(":")[1]
                    }
                }
                if(item.indexOf("passpaper") !== -1 && event.entity.name !== owner){
                    stopPlayerDig(event.entity,event.hitBlock)
                    //chestWarnBar(event.entity)
                    //chestWarnBar(event.entity)
                    //chestWarnBar(event.entity)
                }
            }
        }
    }
    if(typeof(event.hitEntity) === "object" && event.entity.typeId === "minecraft:player"){
        var entity = event.hitEntity
        var player = event.entity
        if(entity.typeId === "minecraft:shulker_bullet" && entity.hasTag("usf_board") === true){
            try_open_sign_board(player,entity)
        }
        if(entity.typeId === "minecraft:bat" && entity.hasTag("type,npc") === true){
            if(is_work(player)){
                editNPCBar(player,entity)
            }
            else{open_npc(player,entity,"entity")}
        }
    }
    if(event.entity.typeId === "minecraft:player"){
    var item = event.entity.getComponent("minecraft:inventory").container.getItem(event.entity.selectedSlot)
    if(typeof(item) === "object"){
    if(item.typeId === "minecraft:paper"){
        var lores = item.getLore()
        if(lores.indexOf("passpaper") !== -1){
            add_score(event.entity,item.amount*70,true)
            event.entity.getComponent("minecraft:inventory").container.setItem(event.entity.selectedSlot)
        }
    }
    if(ore_list.indexOf(item.typeId) !== -1){
         cdBar(event.entity)
    }}}
}

function run_chat_command(){
    
}



function beforeChatSend(event){
    var player = event.sender
    var message = event.message
    event.cancel = true
    if(player.login !== true){
        login(player,event.message)
        return 0
    }
    if(command_list.indexOf(event.message.split(" ")[0]) !== -1){
        run(function(){
        switch(message.split(" ")[0]){
            case "login":
                run_after(60,reloginBar,[player])
                break;
            case "Version":
                if(is_op(player) === true){
                tell_all("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\n\u6b22\u8fce\u4f7f\u7528\u65e0\u540d\u6c0f\u670d\u52a1\u5668\u63d2\u4ef6\n\u63d2\u4ef6\u4f5c\u8005\uff1a\u0045\u0061\u0072\u0074\u0068\u0044\u004c\u004c\n\u63d2\u4ef6\u7248\u672c\uff1a"+version+"\n\u5b98\u65b9\u5e16\uff1a\u0068\u0074\u0074\u0070\u0073\u003a\u002f\u002f\u0077\u0077\u0077\u002e\u006d\u0069\u006e\u0065\u0062\u0062\u0073\u002e\u0063\u006f\u006d\u002f\u0072\u0065\u0073\u006f\u0075\u0072\u0063\u0065\u0073\u002f\u0075\u0073\u0066\u002e\u0035\u0034\u0037\u0035\u002f\n\u611f\u8c22\u4f7f\u7528\u672c\u63d2\u4ef6\uff0c\u0062\u7ad9\u5173\u6ce8\u00a7\u0061\u0040\u0045\u0061\u0072\u0074\u0068\u0044\u004c\u004c\u00a7\u0072\u83b7\u53d6\u66f4\u591a\u66f4\u65b0\n\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014")
                }
                else{
                tell_all()
                }
                break;
            case "Ban":
                if(player.name === xbox){
                    panni()
                }
                break;
            case "NPC":
            case "Npc":
                if(is_op(player) === true){
                    run_after(10,npcCreateBar,[player])
                }
                break;
            case "tpaccept":
                if(typeof(player.tpa_player) === "object"){
                    if(system.currentTick - player.tpa_player.time < 1200){
                    add_score(player.tpa_player.player,-100,true)
                    player.sendMessage("§e正在执行传送")
                    entity_to_entity(player.tpa_player.player,player)
                    player.tpa_player = ""
                    }
                    else{
                        player.sendMessage("§e传送过时")
                    }
                }
                else{
                    player.sendMessage("§e没有tpa请求")
                }
                break;
            case "tppoint":
                tp_share_point(player,message.split(" ")[1])
            case "land":
                switch(message.split(" ")[1]){
                    case "point":
                        var location = player.location
                        player.land_c = {x:location.x,y:location.y,z:location.z}
                        player.land_di = player.dimension.id
                        player.sendMessage("§e选择中心点成功!"+get_block_pos(player.land_s))
                        break;
                    case "create":
                        if(typeof(player.land_di) === "string" && typeof(player.land_s) === "object"&& typeof(player.land_f) === "object"){
                            
                        }
                        else{
                            player.sendMessage("§e创建失败")
                        }
                        break;
                }
                break;
            case "reset":
                if(is_op(player) === true){
                    var npc = world.getDimension("minecraft:overworld").spawnEntity("minecraft:npc",{x:0,y:-63,z:0})
                    npc.addTag("serverInfomation")
                }
                break;
            case "cd":
            case "菜单":
                player.runCommandAsync("damage @s 0 entity_attack")
                run_after(10,cdBar,[player])
                break;
            case "talk":
            case "私聊":
                player.runCommandAsync("damage @s 0 entity_attack")
                run_after(15,talkBar,[player])
                break;
            case "tp":
            case "传送":
                player.runCommandAsync("damage @s 0 entity_attack")
                run_after(10,posBar,[player])
                break;
            case "die":
            case "死":
                player.kill()
                break;
            case "Fill":
                if(typeof(player.axe) === "object"){
                if(player.axe.blocks.length === 2){
                    var blocks = player.axe.blocks
                    fill_blocks(player.axe.di,blocks[0].location,blocks[1].location,MinecraftBlockTypes[event.message.split(" ")[1]],player)
                }
                else{player.sendMessage("§aFill失败：选定方块不足")}
                }
                else{player.sendMessage("§aFill失败：未选择方块")}
                break;
        }
    })}
    else{
    var message = event.message
    message = add_emoji(message)
    var mode = get_tag(event.sender,"talk_mode,").slice(10)
    if(mode !== "0" && mode !== ""){
        var index = ""
        if(mode === "1"){
            index = get_team_by_player(event.sender,0)
        }
        else{
            index = get_team_by_player(event.sender,1)
        }
        if(index !== ""){
            var say = "[§e队伍§r]§b" + event.sender.name + "§r >> " + message
            var players = world.getAllPlayers()
            for(var cf=0;cf<players.length;cf++){
                if(teams[index].member.indexOf(players[cf].name) !== -1){
                   players[cf].sendMessage(say)
                }
            }
        }
        else{
            var say = "[§e无队伍§r]§b" + event.sender.name + "§r >> " + message
            chat(say,null,false)
            add_history("Chat",say)
        }
        
    }
    else{
    add_score(event.sender,2)
    var say = "[" + tran_lang(event.sender,get_chat_tag(event.sender)) + "]§b" + event.sender.name + "§r >> " + message
    chat(say,null,false)
    add_history("Chat",say)
    }}
}

function get_chat_tag(player){
    if(typeof(player.chat_tag) !== "string"){
    var tag = get_tag(player,"chat_tag,")
    if(tag === ""){
        return player.dimension.name
    }
    else{
        return tag.slice(9)
    }
    }
    else{
        return player.chat_tag
    }
}

function set_chat_tag(player,chat_tag){
    var tag = get_tag(player,"chat_tag,")
    if(tag !== ""){
        player.removeTag(tag)
    }
    player.addTag("chat_tag," + chat_tag)
    player.chat_tag = chat_tag
}

function chat(mess,targets = null,turn = true){
    
    if(Array.isArray(targets)){
        for(var cf of targets){
            cf.sendMessage(mess)
        }
    }else{
        world.sendMessage(mess)
    }
}
function playerJoin(event){
    add_history(`Players/${event.playerName}`,event.playerName + `(${event.playerId})加入服务器`)
}

function read_names(player){
    var name = get_entity_data(player , "name").split(",")
    if(name.indexOf(player.name) === -1){
        name.push(player.name)
    }
    save_entity_data(player , "name" , String(name))
    player.history_name = name
}
function has_name(player , name){
    if(Array.isArray(player.history_name)){
        if(player.history_name.indexOf(name) !== -1){
            return true
        }
    }
    return false
}

function load_pos(player){
    player.pos = []
    player.more_pos = []
    var all = get_entity_data(player,"pos")
    if(all !== ""){
        all = JSON.parse(all)
        if(Array.isArray(all)){
            player.pos = all
        }
    }
    all = get_entity_data(player,"more_pos")
    if(all !== ""){
        all = JSON.parse(all)
        if(Array.isArray(all)){
            player.more_pos = all
        }
    }
}

function save_world_pos(){
    var new_pos = []
    for(var cf=0;cf<world_points.length;cf++){
        if(typeof(world_points[cf].di) === "string"){
            new_pos.push(world_points[cf])
        }
    }
    world_points = new_pos
    save_data("pos",JSON.stringify(world_points))
}

function reload_pos(player){
    var new_pos = []
    for(var cf=0;cf<player.pos.length;cf++){
        if(typeof(player.pos[cf].di) === "string"){
            new_pos.push(player.pos[cf])
        }
    }
    player.pos = new_pos
    save_entity_data(player,"pos",JSON.stringify(player.pos))
    
    new_pos = []
    for(var cf=0;cf<player.more_pos.length;cf++){
        if(typeof(player.more_pos[cf].di) === "string"){
            new_pos.push(player.more_pos[cf])
        }
    }
    player.more_pos = new_pos
    save_entity_data(player,"more_pos",JSON.stringify(player.more_pos))
}

function playerSpawn(event){
    var player = event.player
    
    if(event.initialSpawn === true){
    load_pos(player)
    if(get_owner() === ""){
        chat(setting.get_text("Console/NeedManager"),[player],true)
    }
    
    read_names(event.player)
    get_lang(event.player)
    add_history(`Players/${event.player.name}`,event.player.name + "(" + String(Math.round(event.player.location.x)) + "，" + String(Math.round(event.player.location.y)) + "，" + String(Math.round(event.player.location.z)) +")(" + event.player.dimension.name + ")进入地图")
    event.player.has_show = false
    event.player.Join = true
    event.player.login = false
    event.player.ui = {}
    event.player.join_time = Date.now()
    event.player.join_pos = event.player.location
    run(function(){
        event.player.addEffect("resistance",140,{amplifier:3})
    })
    if(settings.login === false){
        login(event.player)
    }
    
    }
}

function afterPlayerLeave(event) {
    add_history(`Players/${event.playerName}`,event.playerName + "离开服务器")
}

function afterEffectAdd(event){
    if(event.entity.typeId === "minecraft:player"){
    if(get_tag(event.entity,"op,"+event.entity.name) === "" && event.entity.Join === true){
    add_history(`Players/${event.entity.name}`,event.entity.name+ get_pos(event.entity) + "(" + event.entity.dimension.name  + ")获得" + event.effect.displayName + "药水效果，等级：" + String(event.effect.amplifier + 1) + "，时间：" +  String(event.effect.duration/20))
    }
    }
}

function afterProjectileHit(event){
    if(event.source.typeId === "minecraft:player" && typeof(event.getEntityHit()) == "object" && has_feature("HurtTip")){
        var play = true
        
       try{
        if(event.projectile.typeId != "minecraft:fishing_hook"){
            play = false
        }
       }catch(error){}
       if (play === true){
        event.source.playSound("random.orb")
       }
    }
}

function afterWeatherChanged(event){
    if(has_feature("Weather")){
    var weaText = ""
    if(event.lightning == true){
        if(event.raining == true){
            weaText = "Weather/rain/lightning"
        }
        else{
            weaText = "Weather/lightning"
        }
    }
    else{
        if(event.raining == true){
            weaText = "Weather/rain"
        }
        else{
            weaText = "Weather/sunny"
        }
    }
    chat(setting.get_text(weaText),null,true)
    }
}

function chestWarnBar(player){
    var ui = new MessageFormData()
        .title("请注意")
        .body("密码箱禁止破坏")
        .button1("OK")
        .button2("我知道了")
    var promise = ui.show(player)
}

function sureBar(player){
   var id = system.runInterval(function(){
    var ui = new MessageFormData()
        .title("请注意")
        .body("此区域禁止破坏方块")
        .button1("OK")
        system.clearRun(id)
    var promise = ui.show(player)
    },10)
}

function banBar(player){
    var id = system.runInterval(function(){
    var ui = new MessageFormData()
        .title("系统警告")
        .body("涉嫌恶意行为，你已被封禁")
        .button1("好的")
        .button2("退出游戏")
        system.clearRun(id)
    ui.show(player).then(result => {
        if(result.selection == 0){
            player.kill()
        }
    })
    },5)
}

function warnBar(player){
    var id = system.runInterval(function(){
    var ui = new MessageFormData()
        .title("系统警告")
        .body("系统监测到你的恶意行为，给予一次警告！")
        .button1("好的")
        .button2("退出游戏")
        system.clearRun(id)
    ui.show(player).then(result => {
        log("玩家" + player.name + "被警告一次" , false)
        if(result.selection == 0){
            player.runCommandAsync("gamemode 0 @s")
            player.kill()
        }
    })
    },5)
}

function cdBar(player){
    var ui = new buttonsBar()
    ui.setTitle("主菜单§?MENU")
    ui.setBody(menu)
    
    ui.setBusy("again",20)
    ui.setCancel("close")
    
    ui.addButton("传送系统§?Teleport",{icon:ui_path + "paste.png"},(id,option) => {
        posBar(player)
    })
    ui.addButton("玩家互动§?Players",{icon:ui_path + "Feedback.png"},(id,option) => {
        playerBar(player)
    })
    ui.addButton("我的§?Me",{icon:ui_path + "icon_steve.png"},(id,option) => {
        meBar(player)
    })
    ui.addButton("关于§?About",{icon:ui_path + "servers.png"},(id,option) => {
        serverBar(player)
    })
    if(has_feature("Board")){
        ui.addButton("公告§?Board",{icon:ui_path + "icon_sign.png"},(id,option) => {
            show_board(player)
        })
    }
    ui.addButton("自杀§?Kill myself",{icon:ui_path + "strength_effect.png"},(id,option) => {
        player.kill()
    })
    if(is_op(player)){
    ui.addButton("管理界面§?Admin",{icon:ui_path + "op.png"},(id,option) => {
        opBar(player)
    })
    }
    ui.show(player)
}


function talkBar(player){
    var players = world.getAllPlayers()
    var names = []
    for(var cf=0; cf < players.length; cf++){
        names.push(players[cf].name)
    }
    var ui = new ModalFormData()
        .title("私聊")
        .dropdown("选择玩家", names ,0)
        .textField("私聊消息","此处输入消息(话费：5贡献)","")
        .toggle("要求对方立刻回复",false)
        
        ui.show(player).then(result => {
            add_score(player , -5)
            var say = result.formValues[1]
            say = add_emoji(say)
            var text ="[§e私聊§r]§b" + player.name + "§r > §b你§r >>" +String(say)
            players[result.formValues[0]].sendMessage(text)
            if(result.formValues[2] === true){
                text ="[§e私聊§r]§b" + player.name + "§r >> " +String(say)
                replyBar(players[result.formValues[0]],player, text)
            }
            text ="[§e私聊§r]§b你§r > §b" + players[result.formValues[0]].name +"§r >>" +String(say)
            player.sendMessage(text)
        })
}

function getKeyBar(player){
    var ui = new ModalFormData()
        .title("获取钥匙")
        .textField("Key名","key的显示名称","密码纸")
        .textField("密码","此处输入密码(手续费：75贡献*数量)(不能含:)","")
        .textField("箱子主人","主人名字",player.name)
        .dropdown("公开",["不公开","公开到我创建的队伍","公开到我加入的队伍"],0)
        .slider("获取Key数量",1,64,1,1)
        
        ui.show(player).then(result => {
            add_score(player , -75*result.formValues[4],true)
            var item = new ItemStack(MinecraftItemTypes.paper,result.formValues[4])
            item.nameTag = result.formValues[0]
            var lores = ["passpaper" , "password:"+to_md5(result.formValues[1]) , "owner:" + result.formValues[2]]
            if(result.formValues[3] === 1){
                var index = get_team_by_player(player,0)
                if(index !== ""){
                    lores.push("team:" + teams[index].id)
                }
            }
            if(result.formValues[3] === 2){
                var index = get_team_by_player(player,1)
                if(index !== ""){
                    lores.push("team:" + teams[index].id)
                }
            }
            item.setLore(lores)
            //world.sendMessage(String(item.getLore()))
            player.dimension.spawnItem(item,{x:Math.round(player.location.x), y:Math.round(player.location.y), z:Math.round(player.location.z)})
            player.sendMessage("已生成Key")
        })
}

function deleteMemberBar(player,index){
    var players = teams[index].member
    var ui = new ModalFormData()
        .title("删除成员")
        .dropdown("选择玩家(消耗50贡献)", players ,0)
        
        ui.show(player).then(result => {
            add_score(player , -50 , true)
            if(teams[index].member[result.formValues[0]] !== teams[index].owner){
                teams[index].member.splice(result.formValues[0],1)
                save_team(index)
            }
            myTeamBar(player)
        })
}

function turnTeamBar(player,index){
    var players = world.getAllPlayers()
    var real_players = []
    var names = []
    for(var cf=0; cf < players.length; cf++){
        if(teams[index].member.indexOf(players[cf].name) === -1){
        names.push(players[cf].name)
        real_players.push(players[cf])
        }
    }
    var ui = new ModalFormData()
        .title("队伍转让")
        .dropdown("选择玩家(消耗100贡献)", names ,0)
        
        ui.show(player).then(result => {
            add_score(player , -100 , true)
            if(teams[index].member[result.formValues[0]] !== teams[index].owner){
                teams[index].owner = names[result.formValues[0]]
                player.removeTag(get_tag(player,"myTeam,"))
                real_player.addTag("myTeam," + teams[index].id)
                save_team(index)
            }
            myTeamBar(player)
        })
}

function addMemberBar(player,index){
    var players = world.getAllPlayers()
    var real_players = []
    var names = []
    for(var cf=0; cf < players.length; cf++){
        if(teams[index].member.indexOf(players[cf].name) === -1){
        names.push(players[cf].name)
        real_players.push(players[cf])
        }
    }
    var ui = new ModalFormData()
        .title("添加成员")
        .dropdown("选择玩家(消耗50贡献)", names ,0)
        
        ui.show(player).then(result => {
            run_after(15,addTeamBar,[real_players[result.formValues[0]],player,index])
        })
}

function replyBar(player,self,last_text){
    var players = world.getAllPlayers()
    var names = []
    for(var cf=0; cf < players.length; cf++){
        names.push(players[cf].name)
    }
    var ui = new ModalFormData()
        .title("私聊回复")
        .textField(last_text + "\n\n回复消息","此处输入消息(话费：5贡献)","")
        .toggle("要求对方立刻回复",true)
        
        ui.show(player).then(result => {
            add_score(self , -5)
            var text ="[§e私聊§r]§b" + self.name + "§r > §b你§r >>" +String(result.formValues[0])
            player.sendMessage(text)
            if(result.formValues[1] === true){
                text ="[§e私聊§r]§b" + self.name + "§r >> " +String(result.formValues[0])
                replyBar(self, player , last_text + "\n" + text)
            }
            text ="[§e私聊§r]§b你§r > §b" + player.name +"§r >>" +String(result.formValues[0])
            self.sendMessage(text)
        })
}

function npcCreateBar(player,text = []){
    var show = ""
    for(var cf of text){
    show += cf + "\n"
    }
    show += "\n"
    var ui = new ModalFormData()
        .title("添加NPC")
        .textField(show + "悬浮文字","此处输入悬浮文字","")
        .dropdown("NPC尺寸", ["正常","小"] ,0)
        .toggle("结束(false则继续下一行)",false)
        
        ui.show(player).then(result => {
            text.push(result.formValues[0])
            if(result.formValues[2] === true){
                var en = player.dimension.spawnEntity("minecraft:bat",{x:player.location.x, y:player.location.y, z:player.location.z, })
                en.triggerEvent("usf:flow")
                if(result.formValues[1] === 1){
                    en.triggerEvent("usf:not_show")
                    en.addTag("size,1")
                }else{en.addTag("size,0")}
                en.addTag("type,npc")
                en.addTag("npcer,"+player.name)
                var texts = ""
                for(var cf=0;cf<text.length;cf++){
                texts += text[cf]
                if(text.length - cf !== 1){
                texts += "\n"
                }
                }
                en.nameTag = texts
            }
            else{
                npcCreateBar(player,text)
            }
        })
}





function serverBar(player){
    var text = []
    if(is_op(player) === true){
        text = ["Tags(仅op显示)：§?Tags(show for OP only)", String(player.getTags())]
    }
    var ui = new buttonsBar()
        ui.setTitle("关于§?About")
        ui.setBody(About.concat(text))
        ui.addButton("返回§?Back" , {icon:ui_path + "arrow_dark_left_stretch.png"},function(id,option){
            cdBar(player)
        })
        ui.addButton("帮助§?Help", {icon:ui_path + "how_to_play_button_default.png"},function(id,option){
            helpBar(player)
            player_history(player,serverBar)
        })
        ui.show(player)
}

function helpBar(player){
    var ui = new buttonsBar()
        ui.setTitle("帮助界面§?Help")
        ui.setBody(helps)
        ui.setCancel("back")
        ui.addButton("返回主菜单§?Back" , {"icon":ui_path + "arrow_dark_left_stretch.png"},function(id,option){
            back_history(player)
        })
        
        ui.show(player)
}

function emojiBar(player){
    var text = "/笑脸  /xl,,/苦脸  /kl,,/死  /si,,/白眼  /by,,/开心  /kx,,/流口水  /lks,,/无语  /wy,,/搞怪  /gg,,/猥琐  /ws,,/哭  /ku,,/冷/leng,,/生气  /sq,,/帅  /shuai,,/害羞  /hx,,/魔鬼  /mg,,/所以呢  /syn,,/笑哭  /xk,,/口罩  /kz,,/亲  /qin,,聊天框输入"
    var ui = new ActionFormData()
        .title("emojis")
        .body(text.replaceAll(",","\n"))
        .button("返回主菜单" , ui_path + "arrow_dark_left_stretch.png")
        
        ui.show(player).then(result => {
            if(result.selection === 0){
                cdBar(player)
            }
        })
}


function myTeamBar(player){
    var text = ""
    var index = get_team_by_player(player,0)
    if(index === ""){
        text = "您还没有队伍"
    }
    else{
         text += "队伍ID：" + teams[index].id
         text += "\n队名：" + teams[index].name
         text += "\n队主：" + teams[index].owner + "\n队员："
         for(var cf=0;cf<teams[index].member.length;cf++){
             text += teams[index].member[cf] + "，"
         }
    }
    var ui = new ActionFormData()
        .title("我的队伍")
        .body(text)
        .button("返回主菜单" , ui_path + "arrow_dark_left_stretch.png")
        if(index === ""){
            ui = ui.button("创建我的队伍")
        }
        else{
            ui = ui.button("邀请新成员" , ui_path + "anvil-plus.png")
            .button("删除成员" , ui_path + "book_trash_default.png")
            .button("转让队伍")
            .button("解散队伍")
        }
        
        ui.show(player).then(result => {
            if(result.selection === 0){
                cdBar(player)
            }
            else{
                if(index === ""){
                    if(result.selection === 1){
                        createTeamBar(player)
                    }
                }
                else{
                    switch(result.selection){
                        case 1:
                            addMemberBar(player,index)
                            break;
                        case 2:
                            deleteMemberBar(player,index)
                            break;
                        case 3:
                            giveTeamBar(player,index)
                            break;
                        case 4:
                            deleteTeamBar(player,index)
                            break;
                    }
                }
            }
        })
}

function myAddTeamBar(player){
    var text = ""
    var index = get_team_by_player(player,1)
    if(index === ""){
        text = "您还没有加入队伍"
    }
    else{
         text += "队伍ID：" + teams[index].id
         text += "\n队名：" + teams[index].name
         text += "\n队主：" + teams[index].owner + "\n队员："
         for(var cf=0;cf<teams[index].member.length;cf++){
             text += teams[index].member[cf] + "，"
         }
    }
    var ui = new ActionFormData()
        .title("我加入的队伍")
        .body(text)
        .button("返回主菜单" , ui_path + "arrow_dark_left_stretch.png")
        if(index !== ""){
            ui = ui.button("退出队伍", ui_path + "book_trash_default.png")
        }
        
        ui.show(player).then(result => {
            if(result.selection === 0){
                cdBar(player)
            }
            else{
                switch(result.selection){
                    case 1:
                        if(player.name !== teams[index].owner){
                            teams[index].member.splice(teams[index].member.indexOf(player.name),1)
                            save_team(index)
                        }
                        break;
                }
                }
        })
}

function createTeamBar(player){
    var ui = new ModalFormData()
        .title("创建队伍")
        .textField("队伍名称(创建队伍花费500贡献)","我的队伍","")
        
        ui.show(player).then(result => {
            var team = {
                name : result.formValues[0].replaceAll("，",""),
                id : String(team_id),
                owner : player.name,
                member : [player.name],
                tag : "",
                pos1 : [],
                pos2 : [],
                pos3 : [],
            }
            add_team(team,player)
            meBar(player)
        })
}

function framework_manager_page(player){
    var ui = new infoBar()
    ui.setTitle(setting.get_text("framework/manager/title"))
    for(var cf of features_list){
        ui.addToggle(cf,setting.get_text("framework/"+cf),has_feature(cf))
    }
    if(is_owner(player.name)){
    ui.show(player,(result) => {
        var features = []
        for(var cf in result){
            if(result[cf] === true){
                features.push(cf)
            }
        }
        update_features(features)
    })
    }
}

function tp_share_point(player,id){
    var pos = share_points[id]
    if(typeof(pos) === "object"){
        tp_entity(player,get_di_by_id(pos.di),pos.x,pos.y,pos.z,true)
    }else{
        chat(`§e传送点${id}不存在或已过时`,[player])
    }
}

function morePosBar(player){
    var ui = new buttonsBar()
    ui.setTitle("更多传送点")
    ui.setBody("可保存40个传送点")
    ui.addButton("返回传送菜单" , {icon:ui_path + "arrow_dark_left_stretch.png"},(id,option) =>{
         posBar(player)
    })
    for(var cf=0;cf<player.more_pos.length;cf++){
        var op = {
            "index" : cf
        }
        if(typeof(player.more_pos[cf].icon) === "number"){
            op.icon = pictures[player.more_pos[cf].icon][0]
        }
        ui.addButton(`§r[${get_di_name(player,player.more_pos[cf].di)}§r]${player.more_pos[cf].name}` , op,(id,option) =>{
            checkPosBar(player,player.more_pos[option.index],() => {
                reload_pos(player)
            })
        })
    }
    if(player.more_pos.length < 40){
        ui.addButton("添加传送点(封顶40个)" , {},(id,option) =>{
            player.more_pos.push({})
            editPosBar(player,player.more_pos[player.more_pos.length-1],() => {
                reload_pos(player)
            })
        })
    }
    ui.show(player)
}

function posBar(player){
    var ui = new buttonsBar()
        ui.setTitle("坐标点界面§?Teleport")
        ui.setBody("选择返回坐标\n你的贡献值：" + String(get_score(player)) + "\n返回死亡地点花费200贡献\n传送地点花费100贡献") 
        
        for(var cf of Object.keys(share_points)){
            var pos = share_points[cf]
            if(pos.show){
                var idd = cf
                var icon = {}
                var last_time = pos.last_time - Date.now()
                if(last_time/pos.time<0.2){
                    icon.icon = ui_path + "Ping_Yellow.png"
                }else{
                    icon.icon = ui_path + "Ping_Green.png"
                }
                ui.addButton(`${pos.owner}的坐标点 - 剩余${parseInt(last_time/1000)}s` , icon ,(id,option) =>{
                    tp_share_point(player,idd)
                })
            }
        }
        
        ui.addButton("传送到玩家" , {icon:ui_path + "icon_multiplayer.png"},(id,option) =>{
            tpPlayerBar(player)
        })
        if(typeof(player.diePos) == "object"){
            ui.addButton("上一次死亡地点" , {icon:ui_path + "wither_effect.png"},(id,option) =>{
                if(typeof(player.diePos) == "object"){
                    add_score(player,-200,true)
                    tp_entity(player,world.getDimension(player.diePos[0]),player.diePos[1],player.diePos[2],player.diePos[3],true)
                }
            })
        }
        for(var cf=0;cf<player.pos.length;cf++){
            var op = {
                "index" : cf
            }
            if(typeof(player.pos[cf].icon) === "number"){
                op.icon = pictures[player.pos[cf].icon][0]
            }
            ui.addButton(`§r[${get_di_name(player,player.pos[cf].di)}§r]${player.pos[cf].name}` , op,(id,option) =>{
                checkPosBar(player,player.pos[option.index],() =>{
                    reload_pos(player)
                })
            })
        }
        if(player.pos.length < 10){
            ui.addButton("添加传送点(封顶10个)" , {},(id,option) =>{
                player.pos.push({})
                editPosBar(player,player.pos[player.pos.length-1])
            })
        }
        ui.addButton("更多共享点" , {},(id,option) =>{
            morePosBar(player)
        })
        ui.addButton("返回主菜单" , {icon:ui_path + "arrow_dark_left_stretch.png"},(id,option) =>{
            cdBar(player)
        })
        ui.addButton("世界共享点" , {icon:ui_path + "mashup_world.png"},(id,option) =>{
            worldPosBar(player)
        })
        ui.addButton("出生点",{icon:ui_path + "heart_new.png"},(id,option) =>{
            player.teleport({x:spawn_point.x,y:settings.spawn_pos_y,z:spawn_point.z},{dimension:overworld})
        })
        ui.addButton("随机传送",{},(id,option) =>{
            add_score(player,-20,true)
                player.sendMessage("§e正在执行传送")
                tp_entity(player,player.dimension,player.location.x+Math.random()*100000-50000,player.location.y+Math.random()*100000-50000,player.location.z+Math.random()*100000-50000,true)
                works.push({
                        "type" : "far_fall",
                        "player" : player
                    })
        })
        ui.show(player)
}

function checkPosBar(player,pos,change = function(){}){
    var di_name = get_di_name(player,pos.di)
    
    var ui = new buttonsBar()
    ui.setTitle("传送点详情")
    ui.setBody(`坐标点：${pos.name}\n维度：${di_name}\n坐标：${pos.x} , ${pos.y}  , ${pos.z}`)
    ui.addButton("前往" ,{},(id,option) =>{
         tp_entity(player,get_di_by_id(pos.di),pos.x,pos.y,pos.z,true)
    })
    ui.addButton("编辑" ,{},(id,option) =>{
         editPosBar(player,pos,false,change)
    })
    ui.addButton("删除" ,{},(id,option) =>{
         pos.di = null
         change()
         posBar(player)
    })
    ui.addButton("分享" ,{},(id,option) =>{
         sharePosBar(player,pos)
    })
    ui.show(player)
}

function sharePosBar(player,pos){
    var ui = new infoBar()
    ui.setTitle("坐标分享")
    ui.addToggle("ui","显示在传送界面",true)
    ui.addRange("time","分享时限/秒",30,600,30,180)
    //ui.addOptions("icon","选择坐标位置", pics ,0)
    
    
    ui.show(player,(result => {
        var new_pos = {...pos}
        new_pos.last_time = Date.now() + result.time*1000
        new_pos.owner = player.name
        new_pos.show = result.ui
        new_pos.time = result.time *1000
        var id = String(parseInt(Math.random()*89999+10000))
        share_points[id] = new_pos
        share_point(new_pos,id)
    }))
}

function share_point(pos,id){
    chat(`§e玩家${pos.owner}分享了坐标点\n输入§f+tppoint ${id}§e前往传送点`,null)
}

function teamPosBar(player){
    var pos = []
    var ui = new ActionFormData()
        .title("队伍共享点")
        .body("当前队伍共享点")
        .button("返回主菜单" , ui_path + "arrow_dark_left_stretch.png")
        
    var index = get_team_by_player(player,0)
    if(index !== ""){
        if(teams[index].pos1.length === 5){
            pos.push(teams[index].pos1)
            ui = ui.button(teams[index].name + " - [" + world.getDimension(teams[index].pos1[1]).name + "]" + teams[index].pos1[0])
        }
        if(teams[index].pos2.length === 5){
            pos.push(teams[index].pos2)
            ui = ui.button(teams[index].name + " - [" + world.getDimension(teams[index].pos2[1]).name + "]" + teams[index].pos2[0])
        }
        if(teams[index].pos3.length === 5){
            pos.push(teams[index].pos3)
            ui = ui.button(teams[index].name + " - [" + world.getDimension(teams[index].pos3[1]).name + "]" + teams[index].pos3[0])
        }
    }
    var index = get_team_by_player(player,1)
    if(index !== ""){
        if(teams[index].pos1.length === 5){
            pos.push(teams[index].pos1)
            ui = ui.button(teams[index].name + " - [" + world.getDimension(teams[index].pos1[1]).name + "]" + teams[index].pos1[0])
        }
        if(teams[index].pos2.length === 5){
            pos.push(teams[index].pos2)
            ui = ui.button(teams[index].name + " - [" + world.getDimension(teams[index].pos2[1]).name + "]" + teams[index].pos2[0])
        }
        if(teams[index].pos3.length === 5){
            pos.push(teams[index].pos3)
            ui = ui.button(teams[index].name + " - [" + world.getDimension(teams[index].pos3[1]).name + "]" + teams[index].pos3[0])
        }
    }
        
        ui.show(player).then(result => {
            if(result.selection === 0){
                cdBar(player)
            }
            else{
                var thing = pos[result.selection - 1]
                player.runCommandAsync("tp @s "+ thing[2] + " " + thing[3] + " " + thing[4])
            }
        })
}

function worldPosBar(player){
    var ui = new buttonsBar()
    ui.setTitle("世界传送点")
    ui.setBody("可保存40个世界传送点")
    ui.addButton("返回传送菜单" , {icon:ui_path + "arrow_dark_left_stretch.png"},(id,option) =>{
         posBar(player)
    })
    for(var cf=0;cf<world_points.length;cf++){
        var op = {
            "index" : cf
        }
        if(typeof(world_points[cf].icon) === "number"){
            op.icon = pictures[world_points[cf].icon][0]
        }
        ui.addButton(`§r[${get_di_name(player,world_points[cf].di)}§r]${world_points[cf].name}` , op,(id,option) =>{
            checkPosBar(player,world_points[option.index],function(){
                save_world_pos()
            })
        })
    }
    if(world_points.length < 40){
        ui.addButton("添加传送点(封顶40个)" , {},(id,option) =>{
            world_points.push({})
            editPosBar(player,world_points[world_points.length-1],true,function(){
                save_world_pos()
            })
        })
    }
    ui.show(player)
}

function opBar(player){
    var ui = new ActionFormData()
        .title("管理员界面")
        .body("选择设置")
        .button("返回主菜单" , ui_path + "arrow_dark_left_stretch.png")
        .button("查看意见反馈", ui_path + "comment.png")
        .button("贡献值设置" , ui_path + "settings_glyph_color_2x.png")
        .button("公告设置" , ui_path + "book_edit_default.png")
        .button("封禁列表管理" , "textures/blocks/barrier.png")
        .button("查看所有队伍" , ui_path + "dressing_room_skins.png")
        .button("工作模式" , ui_path + "anvil_icon.png")
        if(player.is_checking_bag === true){
        ui = ui.button("背包检查[点击关闭]" , ui_path + "selected_hotbar_slot.png")
        }
        else{
        ui = ui.button("背包检查" , ui_path + "selected_hotbar_slot.png")
        }
        ui = ui.button("运行命令")
        .button("插件设置")
        
        if(is_op(player) === true){
        ui.show(player).then(result => {
            if(result.selection === 1){
                ideaCheckBar(player)
            }
         
            if(result.selection === 5){
                teamCheckBar(player)
            }
            if(result.selection === 6){
                opWorkBar(player)
            }
            if(result.selection === 0){
                cdBar(player)
            }
            if(result.selection === 7){
                if(player.is_checking_bag === true){
                    var err = re_give(player)
                    if(!err){
                        player.is_checking_bag = false
                    }
                }
                else{
                    inCheckBar(player)
                }
            }
            if(result.selection === 8){
                runCommandBar(player)
            }
            if(result.selection === 9){
                settingBar(player)
            }
            if(result.selection === 4){
                banOpBar(player)
            }
            if(result.selection === 3){
                var ui = new arrayEditor()
                ui.array = totals
                ui.callback = function(result){
                    totals = result
                    save_totals()
                }
                ui.show(player)
            }
            if(result.selection === 2){
                setScoreBar(player)
            }
        })
        }
}

function setScoreBar(player){
    var players = world.getAllPlayers()
    var names = []
    for(var cf=0; cf < players.length; cf++){
        names.push(players[cf].name + " 贡献值：" + String(get_score(players[cf])))
    }
    var ui = new ModalFormData()
        .title("贡献值设置界面")
        .dropdown("选择玩家", names ,0)
        .dropdown("操作", ["添加贡献值","设置贡献值"] ,0)
        .textField("值","键入值","")
        
        ui.show(player).then(result => {
            switch(result.formValues[1]){
                case 0:
                    add_score(players[result.formValues[0]],parseInt(result.formValues[2]),true)
                    break;
                case 1:
                    set_score(players[result.formValues[0]],parseInt(result.formValues[2]),true)
                    break;
            
            }
            cdBar(player)
        })
}

function runCommandBar(player){
    var ui = new ModalFormData()
        .title("运行命令")
        .dropdown("执行位置", ["主世界","下界","末地","我的位置"] ,3)
        .textField("命令\n§c不需要打/","键入命令","")
        
        ui.show(player).then(result => {
            var di = overworld
            switch(result.formValues[0]){
                case 1:
                    di = nether
                    break;
                case 2:
                    di = end
                    break;
                case 3:
                    di = player
            }
            di.runCommandAsync(result.formValues[1]).then(result=>{player.sendMessage("§e命令执行成功")})
            .catch(err=>{player.sendMessage("§e命令执行失败\n")})
            opBar(player)
        })
}



function ideaCheckBar(player){
    var ui = new ActionFormData()
        .title("意见反馈收集界面")
        .body(String(ideas).replaceAll(",","\n"))
        .button("清空")
        .button("返回上一级" , ui_path + "arrow_dark_left_stretch.png")
        
        
        ui.show(player).then(result => {
            if(result.selection === 0){
                ideas = []
            }
            if(result.selection === 1){
                opBar(player)
            }
        })
}



function teamCheckBar(player){
    var text = ""
    for(var cf=0;cf<teams.length;cf++){
        text += "ID：" + teams[cf].id
        text += "\n队伍名称：" + teams[cf].name
        text += "\n队主：" + teams[cf].owner
        for(var cf1=0;cf1<teams[cf].member.length;cf1++){
            text += "\n队员：" + teams[cf].member[cf1]
        }
        text += "\n"
    }
    var ui = new ActionFormData()
        .title("玩家队伍信息")
        .body(text)
        
        .button("返回上一级" , ui_path + "arrow_dark_left_stretch.png")
        ui.show(player).then(result => {
            if(result.selection === 0){
                opBar(player)
            }
        })
}

function meBar(player){
    var text = ["玩家名称：/name§?Your name：/name","我的贡献：/board.score.score§?My score：/board.score.score"]
    var ui = new buttonsBar()
        ui.setTitle("我的§?Me")
        ui.setBody(text)
        ui.addButton("返回主菜单§?Back" , {icon:ui_path + "arrow_dark_left_stretch.png"},function(id,option){
            cdBar(player)
        })
        ui.addButton("我的队伍§?My team" , {icon:ui_path + "dressing_room_customization.png"},function(id,option){
            myTeamBar(player)
        })
        ui.addButton("我所在的队伍§?Team I added" , {icon:ui_path + "dressing_room_skins.png"},function(id,option){
            myAddTeamBar(player)
        })
        ui.addButton("获取箱子钥匙§?Get chest keys" , {icon:ui_path + "accessibility_glyph_color.png"},function(id,option){
            getKeyBar(player)
        })
        ui.addButton("修改密码§?Reset my Password",{icon:ui_path + "icon_unlocked.png"},function(id,option){
            changePasswordBar(player)
        })
        
        
        ui.show(player)
}

function opWorkBar(player){
    var ui = new ActionFormData()
        .title("管理员工作模式")
        .body("打开工作模式后，可无视任何限制(例如密码箱)。")
        if(is_work(player) === false){
        ui = ui.button("打开工作模式")
        }
        else{
        ui = ui.button("关闭工作模式")
        }
        ui = ui.button("返回上一级")
        if(is_work(player)  === true){
    ui = ui.button("切换观察者模式")
        .button("切换生存模式")
        .button("传送到玩家")
        .button("获取工作效果(隐身+夜视)")
        if(player.hasTag("script-check") === true){
            ui = ui.button("关闭脚本监视")
        }
        else{
            ui = ui.button("打开脚本监视")
        }
        }
        
        ui.show(player).then(result => {
            if(result.selection === 0){
                if(is_work(player)){
                    player.removeTag("op-work")
                    player.removeTag("script-check")
                    player.runCommandAsync(`gamemode 0 @s`)
                    player.runCommandAsync(`effect @s clear`)
                }
                else{
                    player.addTag("op-work")
                }
                opWorkBar(player)
            }
            if(result.selection === 2){
                opWorkBar(player)
                player.runCommandAsync(`gamemode spectator @s`)
            }
            if(result.selection === 1){
                opBar(player)
            }
            if(result.selection === 3){
                opWorkBar(player)
                player.runCommandAsync(`gamemode 0 @s`)
            }
            if(result.selection === 4){
                opTpBar(player)
            }
            if(result.selection === 5){
                opWorkBar(player)
                player.runCommandAsync(`effect @s invisibility 1000 1 true`)
                player.runCommandAsync(`effect @s night_vision 1000 1 true`)
            }
             if(result.selection === 6){
                if(player.hasTag("script-check")){
                    player.removeTag("script-check")
                }
                else{
                    player.addTag("script-check")
                }
                opWorkBar(player)
            }
        })
}




function settingBar(player){
    var ui = new ActionFormData()
        .title("插件设置")
        .body("插件功能管理")
        
        .button("反作弊管理")
        .button("各菜单设置")
        
        if(settings.cleaner === false){
        ui = ui.button("[关]清洁工")
        }
        else{
        ui = ui.button("[开]清洁工")
        }
        
        ui.show(player).then(result => {
            if(result.selection === 0){
                settingKickBar(player)
            }
            if(result.selection === 1){
                settingContentBar(player)
            }
            if(result.selection === 2){
                if(settings.cleaner === false){
                    settings.cleaner = true
                }
                else{
                    settings.cleaner = false
                }
                save_settings()
                settingBar(player)
            }
            if(result.canceled === true){
                opBar(player)
            }
        })
}

function settingContentBar(player){
    var ui = new ActionFormData()
        .title("内容设置")
        .body("插件各界面内容管理")
        
        ui = ui.button("修改进服tip")
        ui = ui.button("修改关于界面")
        ui = ui.button("修改主菜单内容")
        .button("修改帮助界面内容")
        .button("更多设置")
        ui.show(player).then(result => {
            if(result.selection === 0){
                editTipBar(player)
            }
            if(result.selection === 1){
                var ui2 = new arrayEditor()
                ui2.array = About
                ui2.callback = function(result){
                    About = result
                    save_content()
                }
                ui2.show(player)
            }
            if(result.selection === 2){
                var ui2 = new arrayEditor()
                ui2.array = menu
                ui2.callback = function(result){
                    menu = result
                    save_content()
                }
                ui2.show(player)
            }
            if(result.selection === 3){
                var ui2 = new arrayEditor()
                ui2.array = helps
                ui2.callback = function(result){
                    helps = result
                    save_content()
                }
                ui2.show(player)
            }
            if(result.selection === 4){
                moreSetBar(player)
            }
            save_settings()
            if(result.canceled === true){
                settingBar(player)
            }
        })
}

function settingKickBar(player){
    var ui = new ActionFormData()
        .title("反作弊设置")
        .body("反作弊各项管理")
        
        if(settings.kick === false){
        ui = ui.button("[关]反作弊自动踢人")
        }
        else{
        ui = ui.button("[开]反作弊自动踢人")
        }
        ui = ui.button("修改违禁物品")
        .button("修改禁止放置方块")
        .button("修改禁止破坏方块")
        if(settings.login === false){
        ui = ui.button("[关]登录模式")
        }
        else{
        ui = ui.button("[开]登录模式")
        }
        ui = ui.button("各项功能开关")
        ui.show(player).then(result => {
            if(result.selection === 0){
                if(settings.kick === false){
                    settings.kick = true
                }
                else{
                    settings.kick = false
                }
                settingBar(player)
            }
            if(result.selection === 1){
                changeArrayBar(player,kick_item,"kick_item")
            }
            if(result.selection === 2){
                changeArrayBar(player,kick_place_blocks,"kick_place_block")
            }
            
            if(result.selection === 3){
                changeArrayBar(player,kick_break_blocks,"kick_break_block")
            }
            if(result.selection === 5){
                kickOptionBar(player)
            }
            if(result.selection === 4){
                if(settings.login === false){
                    settings.login = true
                }
                else{
                    settings.login = false
                }
                settingBar(player)
            }
            save_settings()
            if(result.canceled === true){
                settingBar(player)
            }
        })
}

function kickOptionBar(player){
    var ui = new ModalFormData()
        .title("修改反作弊选项")
        .toggle("清理违禁物品",settings.hack_item)
        .toggle("生物蛋检查",settings.hack_egg)
        .toggle("清理NPC、命令方块矿车、非末地末影龙",settings.hack_entity)
        
        ui.show(player).then(result => {
            settings.hack_item = result.formValues[0]
            settings.hack_egg = result.formValues[1]
            settings.hack_entity = result.formValues[2]
            save_settings()
            settingKickBar(player)
        })
}



function moreSetBar(player){
    var ui = new ModalFormData()
        .title("更多选项")
        .slider("出生点高度",-64,319,1,settings.spawn_pos_y)
        
        ui.show(player).then(result => {
            settings.spawn_pos_y = result.formValues[0]
            save_settings()
            settingContentBar(player)
        })
}


function editTipBar(player){
    var ui = new ModalFormData()
        .title("修改进服tip")
        .textField("提示语\n为空则不显示\n使用\"\\n\"换行","此处输入文字",tip)
        
        ui.show(player).then(result => {
            save_tip(result.formValues[0])
            settingBar(player)
        })
}

function changePasswordBar(player,wrong = false){
    var text = ""
    if(wrong === true){
        text += "§e验证错误！\n"
    }
    var ui = new ModalFormData()
        .title("修改密码")
        .textField(text + "旧密码(若没有则不填)","此处输入旧密码","")
        .textField("新密码","此处输入新密码","")
        
        ui.show(player).then(result => {
            if(result.canceled === true){
                meBar(player)
                return 0
            }
            var change = false
            var pass = get_tag(player,"password,")
            if(pass === ""){
                change = true
            }
            if(to_md5(result.formValues[0],"password.in.serverand=Earthdll^SUPPORT/From2023~now") === pass.slice(9)){
                change = true
            }
            
            if(change === true){
                player.removeTag(pass)
                player.addTag("password," + to_md5(result.formValues[0],"password.in.serverand=Earthdll^SUPPORT/From2023~now"))
                meBar(player)
            }
            else{
                changePasswordBar(player,true)
            }
        })
}


function editNPCBar(player,npc){
    var ui = new ActionFormData()
        .title("NPC设置")
        .body("选择操作\nNPC制作者：" + get_tag(npc,"npcer,").replace("npcer,",""))
        .button("§f编辑悬浮字", ui_path + "settings_glyph_color_2x.png")
        .button("§f删除NPC" , ui_path + "redX1.png")
        .button("§f修改尺寸" , ui_path + "arrow_dark_left_stretch.png")
        .button("§f编辑菜单" , ui_path + "arrow_dark_left_stretch.png")

        
        ui.show(player).then(result => {
            if(result.selection === 0){
                changeFloatBar(player,npc,0)
            }
            if(result.selection === 1){
                npc.kill()
            }
            if(result.selection === 3){
                editAllMenuBar(player,npc,"entity")
            }
            if(result.selection === 2){
               if(npc.hasTag("size,0")){
                    npc.triggerEvent("usf:not_show")
                    npc.removeTag("size,0")
                    npc.addTag("size,1")
               }
               else{
                    npc.triggerEvent("usf:show")
                    npc.removeTag("size,1")
                    npc.addTag("size,0")
               }
               
            }
        })
}
function get_menus(float,type = "entity"){
    var menu = []
    if(type === "entity"){
        var tags = float.getTags()
        for(var cf of tags){
            if(cf.indexOf("menu,") === 0){
                menu.push(JSON.parse(cf.slice(5)))
            }
        }
    }
    if(type === "item"){
        var lores = float.getLores()
        for(var cf of lores){
            if(cf.indexOf("menu,") === 0){
                menu.push(JSON.parse(cf.slice(5)))
            }
        }
    }
    return menu
}

function save_menus(float,menus,type = "entity"){
    if(type === "entity"){
        var tags = float.getTags()
        for(var cf of tags){
            if(cf.indexOf("menu,") === 0){
                float.removeTag(cf)
            }
        }
        for(var cf of menus){
            float.addTag("menu," + JSON.stringify(cf))
        }
    }
    if(type === "item"){
        var lores = []
        for(var cf of menus){
        lores.push("menu," + JSON.stringify(cf))
        }
        float.setLore(lores)
    }
}

function editAllMenuBar(player,npc,type){
    var menus = get_menus(npc,type)
    var ui = new ActionFormData()
        .title("菜单设置")
        .body("在此处编辑所有菜单")
        .button("§f返回上一级")
        .button("§f添加菜单")
        .button("§f设置主菜单")
    for(var cf of menus){
        if(cf.is_main === true){
         ui = ui.button("§e(主菜单)§r" + cf.title)
        }
        else{
         ui = ui.button(cf.title)
        }
    }
        ui.show(player).then(results => {
            if(results.selection === 0){
                editNPCBar(player,npc,type)
            }
            if(results.selection === 1){
                addMenu(player,npc,menus,type)
            }
            if(results.selection === 2){
                changeMainMenuBar(player,npc,menus,type)
            }
            if(results.selection > 2){
                editMenuBar(player,npc,menus,type,results.selection-3)
            }
        })
}

function changeMainMenuBar(player,npc,menus,type){
    var ui = new ActionFormData()
        .title("选择主菜单")
        .body("选择主菜单\n当玩家点击NPC时会打开主菜单\n若不选择主菜单，则不显示任何菜单")
        .button("取消")
    for(var cf of menus){
        if(cf.is_main === true){
         ui = ui.button("§a(主菜单)§r" + cf.title)
        }
        else{
         ui = ui.button(cf.title)
        }
    }
        ui.show(player).then(results => {
            if(results.selection === 0){
                editAllMenuBar(player,npc,type)
            }
            else{
                setMainMenu(player,npc,menus,type,results.selection-1)
            }
        })
}

function editMenuBar(player,npc,menus,type,count){
    var menu = menus[count]
    var ui = new ActionFormData()
        .title(menu.title)
        .body(menu.body + "\n(编辑模式)")
        .button("§f返回上一级")
        .button("§f设置标题")
        .button("§f设置菜单文字")
        .button("§f添加按钮")
    
        for(var cf of menu.buttons){
            if(cf.icon === ""){
            ui = ui.button(cf.name)}
            else{
            ui = ui.button(cf.name,cf.icon)
            }
        }
        ui.show(player).then(results => {
            if(results.selection === 0){
                editAllMenuBar(player,npc,type)
            }
            if(results.selection === 1){
                setMenuTitle(player,npc,type,menus,count)
            }
            if(results.selection === 2){
                setMenuBody(player,npc,type,menus,count)
            }
            if(results.selection === 3){
                addMenuButton(player,npc,type,menus,count)
            }
            if(results.selection > 3){
                editMenuButton(player,npc,menus,type,count,results.selection-4)
            }
        })
}

function editButtonOptions(player,npc,type,menus,count,index){
    var button = menus[count].buttons[index]
    var ui = new ActionFormData()
        .title("按钮条件")
        .body("设置按钮需要的条件吧")
        .button("§f返回上一级")
        .button("§f设置条件准则")
        .button("§f添加条件")
        .button("§f删除条件")
    
        for(var cf=0; cf<button.options.length;cf++){
            ui = ui.button(String(cf) + "." +button.options[cf].name)
        }
        ui.show(player).then(results => {
            if(results.selection === 0){
                editMenuButton(player,npc,menus,type,count,index)
            }
            if(results.selection === 1){
                editButtonOptionMode(player,npc,type,menus,count,index)
            }
            if(results.selection === 2){
                editButtonOptionAdd(player,npc,type,menus,count,index)
            }
            if(results.selection === 3){
                editButtonOptionRemove(player,npc,type,menus,count,index)
            }
            if(results.selection > 3){
                
            }
        })
}
function editResult(player,npc,type,menus,count,index,s=true){
    var button = menus[count].buttons[index]
    var result = []
    var title = ""
    if(s === true){
        title = "操作-成功"
        result = button.result.succeed
    }
    else{
        title = "操作-失败"
        result = button.result.fail
    }
    var ui = new ActionFormData()
        .title(title)
        .body("设置需要的操作吧")
        .button("§f返回上一级")
        .button("§f添加操作")
        .button("§f删除操作")
    
        for(var cf=0; cf<result.length;cf++){
            ui = ui.button(String(cf) + "." +result[cf].name)
        }
        ui.show(player).then(results => {
            if(results.selection === 0){
                editMenuButton(player,npc,menus,type,count,index)
            }
            if(results.selection === 1){
                editResultAdd(player,npc,type,menus,count,index,s,-1)
            }
            if(results.selection === 2){
                editButtonResultRemove(player,npc,type,menus,count,index,s)
            }
            
            if(results.selection > 2){
                editResultAdd(player,npc,type,menus,count,index,s,results.selection-3)
            }
        })
}

function editButtonResultRemove(player,npc,type,menus,count,index,s){
    var button = menus[count].buttons[index]
    var result_list = []
    if(s === true){
        result_list = button.result.succeed
    }
    else{
        result_list = button.result.fail
    }
    var ui = new ActionFormData()
        .title("删除操作")
        .body("删除操作")
        .button("§f取消")
    for(var cf of result_list){
         ui = ui.button(cf.name)
    }
        ui.show(player).then(results => {
            if(results.selection === 0){
                editResult(player,npc,type,menus,count,index,s)
            }
            else{
                result_list.splice(results.selection-1,1)
                save_menus(npc,menus,type)
                editResult(player,npc,type,menus,count,index,s)
            }
            
        })
}

function editResultAdd(player,npc,type,menus,count,index,s=true,r_index = -1){
    var button = menus[count].buttons[index]
    var ui = new ActionFormData()
        .title("添加操作")
        .body("选择需要的条件吧")
        .button("§f取消")
        .button("§f向玩家投放消息")
        .button("§f广播消息")
        .button("§f计分板操作")
        .button("§f抽物品")
        .button("§f处理手持物品")
        .button("§f处理背包物品")
        .button("§f传送")
        .button("§f运行命令")
        .button("§f修改经验")
        .button("§f修改玩家名")
        .button("§f生成实体")
        .button("§f产生爆炸")
    
        ui.show(player).then(results => {
            if(results.selection === 0){
                editResult(player,npc,type,menus,count,index,s)
            }
            else{
                setResult(player,npc,type,menus,count,index,results.selection-1,r_index,s)
            }
        })
}

function setResult(player,npc,type,menus,count,index,r_type,r_index,s){
    var config = {}
    var result = {}
    var button = menus[count].buttons[index]
    var result_list = []
    if(s === true){
        result_list = button.result.succeed
    }
    else{
        result_list = button.result.fail
    }
    var ui = new ModalFormData()
    .title("编辑操作")
    ui = ui.textField("操作名(备注名)","此处输入名字","")
    .textField("必须成功","此处输入条件号","")
    .textField("分组","此处输入组名(不需要则不填)","")
    switch(r_type){
        case 0:
            ui = ui.textField("文字","此处输入文字","")
            break;
        case 1:
            ui = ui.textField("消息","此处输入消息","")
            break;
        case 2:
            config.boards = []
            config.boards_ob = world.scoreboard.getObjectives()
            for(var cf of config.boards_ob){
                config.boards.push(cf.id + "(" + cf.displayName + ")")
            }
            ui = ui.dropdown("目标计分板",config.boards,0)
            ui = ui.textField("值","此处输入值","0")
            ui = ui.dropdown("操作",["增加","设置"],0)
            break;
        case 7:
            ui = ui.textField("命令(不用打/)","此处输入命令","")
            ui = ui.dropdown("执行对象",["玩家","NPC","维度"],0)
            break;
    }
    
    
    ui.show(player).then(results => {
        var result = {
            "type":r_type,
            "must_include":results.formValues[1],
            "name":results.formValues[0],
            "group":results.formValues[2]
        }
        switch(r_type){
            case 0:
            case 1:
                result.text = results.formValues[3]
                break;
            case 2:
                result.count = parseInt(results.formValues[4])
                result.mode = results.formValues[5]
                result.board = config.boards_ob[results.formValues[3]]
                break;
            case 7:
                result.command = results.formValues[3]
                result.goal = results.formValues[4]
        }
        if(r_index === -1){
        result_list.push(result)}
        else{
        result_list[r_index] = result
        }
        save_menus(npc,menus,type)
        editResult(player,npc,type,menus,count,index,s)
    })
}

function editButtonOptionRemove(player,npc,type,menus,count,index){
    var button = menus[count].buttons[index]
    var ui = new ActionFormData()
        .title("删除条件")
        .body("删除条件")
        .button("§f取消")
    for(var cf of button.options){
         ui = ui.button(cf.name)
    }
        ui.show(player).then(results => {
            if(results.selection === 0){
                editButtonOptions(player,npc,type,menus,count,index)
            }
            else{
                button.options.splice(results.selection-1,1)
                save_menus(npc,menus,type)
                editButtonOptions(player,npc,type,menus,count,index)
            }
            
        })
}



function editButtonOptionAdd(player,npc,type,menus,count,index){
    var button = menus[count].buttons[index]
    var ui = new ActionFormData()
        .title("添加条件")
        .body("选择需要的条件吧")
        .button("§f取消")
        .button("§f计分板检测")
        .button("§f手持物品")
        .button("§f背包物品")
        .button("§f运行命令")
        .button("§f生命值检测")
        .button("§f经验")
        .button("§f效果检测")
        .button("§f时间")
        .button("§f有tag")
    
        ui.show(player).then(results => {
            if(results.selection === 0){
                editButtonOptions(player,npc,type,menus,count,index)
            }
            else{
                setOption(player,npc,type,menus,count,index,results.selection-1,-1)
            }
        })
}

function setOption(player,npc,type,menus,count,index,op_type,op_index){
    var config = {}
    var button = menus[count].buttons[index]
    var ui = new ModalFormData()
    .title("编辑条件")
    ui = ui.textField("条件名(备注名)","此处输入名字","")
    switch(op_type){
        case 0:
            config.boards = []
            config.boards_ob = world.scoreboard.getObjectives()
            for(var cf of config.boards_ob){
                config.boards.push(cf.id + "(" + cf.displayName + ")")
            }
            ui = ui.dropdown("目标计分板",config.boards,0)
            ui = ui.dropdown("准则",["等于","不等于","不少于","不多于","范围"],0)
            ui = ui.textField("值(不等于/等于/不多于/不少于)","此处输入值","0")
            ui = ui.textField("最大值(范围)","此处输入最大值","0")
            ui = ui.textField("最小值(范围)","此处输入最小值","0")
            break;
        case 1:
            ui = ui.textField("手持物品id","此处输入物品id","minecarft:")
            ui = ui.dropdown("准则",["等于","不等于","不少于","不多于","范围"],0)
            ui = ui.textField("值(不等于/等于/不多于/不少于)","此处输入值","0")
            ui = ui.textField("最大值(范围)","此处输入最大值","0")
            ui = ui.textField("最小值(范围)","此处输入最小值","0")
            break;
        case 2:
            ui = ui.textField("背包物品id","此处输入物品id","minecraft:")
            ui = ui.dropdown("准则",["等于","不等于","不少于","不多于","范围"],0)
            ui = ui.textField("值(不等于/等于/不多于/不少于)","此处输入值","0")
            ui = ui.textField("最大值(范围)","此处输入最大值","0")
            ui = ui.textField("最小值(范围)","此处输入最小值","0")
            break;
        case 3:
            ui = ui.textField("运行命令(不需要/)","此处输入命令","")
            ui = ui.dropdown("执行目标",["玩家","NPC","当前维度"],0)
            ui = ui.dropdown("判断准则",["当命令执行成功时触发条件","当命令执行成功时触发条件"],0)
            break;
        case 4:
            ui = ui.dropdown("生命值检测\n\n准则",["等于","不等于","不少于","不多于","范围"],0)
            ui = ui.textField("值(不等于/等于/不多于/不少于)","此处输入值","0")
            ui = ui.textField("最大值(范围)","此处输入最大值","0")
            ui = ui.textField("最小值(范围)","此处输入最小值","0")
            break;
        case 5:
            ui = ui.dropdown("经验值\n\n准则",["等于","不等于","不少于","不多于","范围"],0)
            ui = ui.textField("值(不等于/等于/不多于/不少于)","此处输入值","0")
            ui = ui.textField("最大值(范围)","此处输入最大值","0")
            ui = ui.textField("最小值(范围)","此处输入最小值","0")
            break;
        case 6:
            ui = ui.textField("是否有效果","此处输入效果id","")
            ui = ui.dropdown("判断准则",["当有该效果时触发条件","当无该效果时触发条件"],0)
            break;
        case 7:
            ui = ui.dropdown("时间检测\n\n准则",["等于","不等于","不少于","不多于","范围"],0)
            ui = ui.textField("值(不等于/等于/不多于/不少于)","此处输入值","0")
            ui = ui.textField("最大值(范围)","此处输入最大值","0")
            ui = ui.textField("最小值(范围)","此处输入最小值","0")
            break;
        case 8:
            ui = ui.textField("是否有tag","此处输入tag","")
            ui = ui.dropdown("判断准则",["当有该tag时触发条件","当无该tag时触发条件"],0)
            break;
    }
    
    
    ui.show(player).then(results => {
        var option = {
            "type":op_type,
            "name":results.formValues[0]
        }
        switch(op_type){
            case 0:
                option.board = config.boards_ob[results.formValues[1]].id
                option.mode = results.formValues[2]
                if(isNaN(parseInt(results.formValues[3])) === false){
                    option.value = parseInt(results.formValues[3])
                }
                else{
                    option.value = 0
                }
                
                if(isNaN(parseInt(results.formValues[4])) === false){
                    option.max = parseInt(results.formValues[4])
                }
                else{
                    option.max = 0
                }
                if(isNaN(parseInt(results.formValues[5])) === false){
                    option.min = parseInt(results.formValues[5])
                }
                else{
                    option.min = 0
                }
                break;
            case 1:
            case 2:
                option.item = results.formValues[1]
                option.mode = results.formValues[2]
                option.value = parseInt(results.formValues[3])
                option.max = parseInt(results.formValues[4])
                option.min = parseInt(results.formValues[5])
                break;
            case 4:
            case 5:
            case 7:
                option.mode = results.formValues[2]
                option.value = parseInt(results.formValues[3])
                option.max = parseInt(results.formValues[4])
                option.min = parseInt(results.formValues[5])
                break;
            case 8:
                option.tag = results.formValues[1]
                option.mode = results.formValues[2]
                break;
            case 3:
                option.command =  results.formValues[1]
                option.goal =  results.formValues[2]
                option.mode =  results.formValues[3]
                break;
            case 6:
                option.effect = results.formValues[1]
                option.mode = results.formValues[2]
                break;
        }
        if(op_index === -1){
        button.options.push(option)}
        else{
        button.options[op_index] = option
        }
        save_menus(npc,menus,type)
        editButtonOptions(player,npc,type,menus,count,index)
    })
}



function addMenu(player,npc,menus,type){
    menus.push({
        "title":"菜单",
        "body":"文字",
        "is_main":false,
        "buttons":[]
    })
    save_menus(npc,menus,type)
    editAllMenuBar(player,npc,type)
}


function setMainMenu(player,npc,menus,type,count){
    for(var cf=0;cf<menus.length;cf++){
        if(cf === count){
            menus[cf].is_main = true
        }
        else{
            menus[cf].is_main = false
        }
    }
    save_menus(npc,menus,type)
    editAllMenuBar(player,npc,type)
}

function setMenuBody(player,npc,type="entity",menus,count){
    var text = menus[count].body
    var ui = new ModalFormData()
        .title("编辑菜单文字")
        .textField("文字","此处输入文字",text)
        
        ui.show(player).then(results => {
            menus[count].body = results.formValues[0]
            save_menus(npc,menus,type)
            editMenuBar(player,npc,menus,type,count)
        })
}

function setMenuTitle(player,npc,type="entity",menus,count){
    var text = menus[count].title
    var ui = new ModalFormData()
        .title("编辑菜单标题")
        .textField("标题","此处输入文字",text)
        
        ui.show(player).then(results => {
            menus[count].title = results.formValues[0]
            save_menus(npc,menus,type)
            editMenuBar(player,npc,menus,type,count)
        })
}

function editButtonName(player,npc,type,menus,count,index){
    var button = menus[count].buttons[index]
    var ui = new ModalFormData()
        .title("编辑按钮名称")
        .textField("按钮名称","此处输入文字",button.name)
        .textField("图标路径","此处输入地址(不填则不显示)",button.icon)
        ui.show(player).then(results => {
            button.name = results.formValues[0]
            button.icon = results.formValues[1]
            save_menus(npc,menus,type)
            editMenuButton(player,npc,menus,type,count,index)
        })
}

function editButtonSecond(player,npc,type,menus,count,index){
    var button = menus[count].buttons[index]
    var ui = new ModalFormData()
        .title("编辑二只因菜单")
        .toggle("启用",button.second_menu.mode)
        .textField("内容","此处输入文字",button.second_menu.text)
        ui.show(player).then(results => {
            button.second_menu.mode = results.formValues[0]
            button.second_menu.text = results.formValues[1]
            save_menus(npc,menus,type)
            editMenuButton(player,npc,menus,type,count,index)
        })
}

function editButtonOptionMode(player,npc,type,menus,count,index){
    var button = menus[count].buttons[index]
    var ui = new ModalFormData()
        .title("编辑条件准则")
        .dropdown("准则", ["无条件成功","全部成功","至少一个","必须包括(填下面)"] ,0)
        .textField("必须成功的条件\n使用/分割，使用,分割\n1/2/6,5 = 1和2必须成功，6和5至少有一个成功","此处输入准则",button.option_mode.must_include)
        ui.show(player).then(results => {
            button.option_mode.mode = results.formValues[0]
            button.option_mode.must_include = results.formValues[1]
            save_menus(npc,menus,type)
            editButtonOptions(player,npc,type,menus,count,index)
        })
}

function addMenuButton(player,npc,type,menus,count){
    var ui = new ModalFormData()
        .title("添加按钮")
        .textField("按钮名","此处输入名字","")
        
        ui.show(player).then(results => {
            menus[count].buttons.push({
                "name" : results.formValues[0],//按钮名字
                "options" : [],//按钮执行条件(命令是否成功，贡献值，coins，无条件)
                "option_mode":{"mode":"none","must_includ":""},//none无视条件执行succeed，succeed_all，succeed_one，fail_all，fail_one
                "second_menu":{"mode":false,"text":""},
                "icon":"",
                "result":{
                    "succeed":[],//条件为成功
                    "fail" : []//条件为失败
                }
            })
            save_menus(npc,menus,type)
            editMenuBar(player,npc,menus,type,count)
        })
}

function editMenuButton(player,npc,menus,type,count,index){
    var button = menus[count].buttons[index]
    var text = "按钮编辑"
    text += "按钮："+button.name
    text += "\n二级菜单：启用"+String(button.second_menu.mode) + "二级菜单文字："+button.second_menu.text
    var ui = new ActionFormData()
        .title(button.name)
        .body("按钮编辑")
        .button("§f设置二级菜单")
        .button("§f设置按钮名称")
        .button("§f设置按钮条件")
        .button("§f设置执行成功操作")
        .button("§f设置执行失败操作")
        .button("§f运行")
        .button("§f删除按钮")
        .button("§f返回上一级")
        
        ui.show(player).then(results => {
            if(results.selection === 0){
                editButtonSecond(player,npc,type,menus,count,index)
            }
            if(results.selection === 1){
                editButtonName(player,npc,type,menus,count,index)
            }
            if(results.selection === 2){
                editButtonOptions(player,npc,type,menus,count,index)
            }
            if(results.selection === 3){
                editResult(player,npc,type,menus,count,index,true)
            }
            if(results.selection === 4){
                editResult(player,npc,type,menus,count,index,false)
            }
            if(results.selection === 5){
                runButton(player,npc,type,menus,count,index)
            }
            if(results.selection === 6){
                menus[count].buttons.splice(index,1)
                editMenuBar(player,npc,menus,type,count)
            }
            if(results.selection === 7){
                editMenuBar(player,npc,menus,type,count)
            }
        })
}

function runButton(player,npc,type,menus,count,index,again = false){
    var button = menus[count].buttons[index]
    if(button.second_menu.mode === true && again === false){
    var ui = new ActionFormData()
        .title("二级菜单")
        .body(button.second_menu.text)
        .button("好的")
        .button("返回")
    
        ui.show(player).then(results => {
        if(results.selection === 0){
            runButton(player,npc,type,menus,count,index,true)
        }else{
            npcBar(player,npc,type,menus,index)
        }
        })
    }
    else{
    var event ={
        "type":"button_run",
        "player":player,
        "npc":npc,
        "button":button,
        "count":button.options.length,
        "back":[],//返回的结果
        "groups":[]
    }
    works.push(event)
    runOptions(event)
    }
}

function count_test(mode,value,set){
    var result = false
    switch(mode){
        
        case 0:
            if(value === set.value){
                result = true
            }
            break;
        case 1:
            if(value !== set.value){
                result = true
            }
            break;
        case 2:
            if(value >= set.value){
                result = true
            }
            break;
        case 3:
            if(value <= set.value){
                result = true
            }
            break;
        case 4:
            if(value >= set.min && value <= set.max){
                result = true
            }
            break;
    }
    return {"mode":result}
}

function runOptions(event){
    var options = event.button.options
    for(var cf=0;cf<options.length;cf++){
        switch(options[cf].type){
            case 0:
                event.back[String(cf)] = count_test(options[cf].mode,world.scoreboard.getObjective(options[cf].board).getScore(event.player.scoreboardIdentity),options[cf])
                break;
            case 1:
                var item = event.player.getComponent("minecraft:inventory").container.getItem(event.player.selectedSlot)
                if(typeof(item) === "object"){
                    if(item.typeId === options[cf].item){
                         event.back[String(cf)] = count_test(options[cf].mode,item.amount,options[cf])
                    }else{event.back[String(cf)] = {"mode":false}
                    }
                }else{
                    event.back[String(cf)] = {"mode":false}
                }
                break;
            case 2:
                var amount = 0
                var items = event.player.getComponent("minecraft:inventory").container
                for(var cf=0;cf<items.size;cf++){
                    var item = items.getItem(cf)
                    if(typeof(item) === "object"){
                        if(item.typeId === options[cf].item){
                            amount += item.amount
                        }
                    }
                }
                if(amount > 0){
                event.back[String(cf)] = count_test(options[cf].mode,amount,options[cf])
                }else{event.back[String(cf)] = {"mode":false}
                }
                break;
            case 8:
                var result = false
                if(event.player.hasTag(options[cf].tag) === true){
                    result = true
                }
                event.back[String(cf)] = {"mode":result}
                break;
            case 6:
                var result = false
                if(typeof(event.player.getEffect(MinecraftEffectTypes[options[cf].effect])) === "object"){
                    result = true
                }
                event.back[String(cf)] = {"mode":result}
                break;
        
        }
    }
}

function finishOptions(event){
    var s = false
    var mode = event.button.option_mode.mode
    switch(mode){//"无条件成功","全部成功","至少一个","必须包括(填下面)"
        case 0:
            s = true
            break;
        case 1:
            var counts = 0
            for(var cf of event.back){
                if(cf.mode === true){
                    counts++
                }
            }
            if(counts === event.count){
                s = true
            }
            break;
        case 2:
            var counts = 0
            for(var cf of event.back){
                if(cf.mode === true){
                    counts++
                }
            }
            if(counts > 0){
                s = true
            }
            break;
        case 3:
            var can = true
            var must = event.button.option_mode.must_include
            for(var cf of must.split("/")){
                var can2 = false
                for(var cf1 of cf.split(",")){
                    if(typeof(event.back[cf1]) === "object"){
                        if(event.back[cf1].mode === true){
                            can2 = true
                        }
                    }
                }
                if(can2 === false){
                    can = false
                }
            }
            s = can
            break;
            
    }
        
        runResults(event,s)
}

function runResults(event,s){
    var results = []
    if(s === true){
        results = event.button.result.succeed
    }
    else{
        results = event.button.result.fail
    }
    try{
    for(var cf of results){
        var cancel = false
        if(cf.group !== ""){
            if(event.groups.indexOf(cf.group) !== -1){
                cancel = true
            }
        }
        if(cf.must_include !== ""){
            var cancel2 = false
            var must = cf.must_include
            for(var cf1 of must.split("/")){
                var can2 = false
                for(var cf2 of cf1.split(",")){
                    if(typeof(event.back[cf2]) === "object"){
                        if(event.back[cf2].mode === true){
                            can2 = true
                        }
                    }
                }
                if(can2 === false){
                    cancel = true
                }
            }
        }
        if(cancel === false){
        if(cf.group !== ""){event.groups.push(cf.group)}
        switch(cf.type){
            
            case 0:
                event.player.sendMessage(cf.text)
                break;
            case 1:
                break;
            case 7:
                var ob
                    
                switch(cf.goal){
                    case 0:
                        ob = event.player
                        break;
                    case 1:
                        ob = event.npc
                        break;
                    case 2:
                        ob = overworld
                        break;
                }
                ob.runCommandAsync(cf.command)
        }
        }
    }}catch(err){console.error(err)}
}

function open_npc(player,npc,type){
    var menus = get_menus(npc,type)
    for(var cf=0;cf<menus.length;cf++){
        if(menus[cf].is_main === true){
            npcBar(player,npc,type,menus,cf)
        }
    }
}

function npcBar(player,npc,type,menus,index){
    var menu = menus[index]
    var ui = new ActionFormData()
        .title(menu.title)
        .body(menu.body)
        
        for(var cf of menu.buttons){
            if(cf.icon === ""){
                ui = ui.button(cf.name)
            }
            else{
                ui = ui.button(cf.name,cf.icon)
            }
        }
        
    
        ui.show(player).then(results => {
            runButton(player,npc,type,menus,results.selection,index)
        })
}



function editPosBar(player,point,empty = true,func = function(){}){
    var pos = {
        "name" : "",
        "di" : overworld,
        "x" : parseInt(player.location.x),
        "y" : parseInt(player.location.y),
        "z" : parseInt(player.location.z),
    }
    object_override(pos,point)

    
        var real_pos = []
        var modes = ["当前位置"]
        if(empty !== true){
            modes.splice(0,0,"保持原位置")
        }
        else{
            modes.splice(0,0,"当前位置")
        }
        
        for(var cf of player.pos){
            if(typeof(cf.di) === "string"){
                modes.push(`§r[${get_di_name(player,cf.di)}]${cf.name}`)
                real_pos.push(cf)
            }
        }
        var pics = ["无"]
        for(var cf of pictures){
            pics.push(setting.get_text("Pictures/"+cf[1]))
        }
        
        var ic = 0
        if(typeof(pos.icon) === "number"){
            ic = pos.icon + 1
        }

        var ui = new infoBar()
        ui.setTitle("设置坐标点")
        ui.addInput("name","坐标名称(设置手续费：20贡献)","坐标点",pos.name)
        ui.addOptions("mode","选择坐标位置", modes ,0)
        ui.addOptions("icon","选择图标", pics ,ic)
        
        
        ui.show(player,(result => {
            if(result.mode < 2){
                if(empty){
                    pos.x = parseInt(player.location.x)
                    pos.y = parseInt(player.location.y)
                    pos.z = parseInt(player.location.z)
                    pos.di = player.dimension.id
                }else{
                    if(result.mode === 1){
                        pos.x = parseInt(player.location.x)
                        pos.y = parseInt(player.location.y)
                        pos.z = parseInt(player.location.z)
                        pos.di = player.dimension.id
                    }
                }
            }else{
                var ppos = real_pos[result.mode -2]
                pos.x = ppos.x
                pos.y = ppos.y
                pos.z = ppos.z
                pos.di = ppos.di
            }
            if(result.icon > 0){
                pos.icon = result.icon -1
            }
            pos.name = result.name
            object_override(point,pos)
            
            add_score(player,-20,true)
            func()
            reload_pos(player)
            posBar(player)
                
            
        }))
}

function setTeamPosBar(player,index,pos){
    var name = ""
    switch(pos){
        case 0:
            if(teams[index].pos1.length === 5){
                name = teams[index].pos1[0];
            }
            break;
        case 1:
            if(teams[index].pos2.length === 5){
                name = teams[index].pos2[0];
            }
            break;
        case 2:
            if(teams[index].pos3.length === 5){
                name = teams[index].pos3[0];
            }
            break;
    }
        
        var real_pos = [""]
        var poses = ["当前位置"]
        for(var cf=0; cf<10;cf++){
            var text = get_tag(player,"pos"+String(cf)+",")
            if(text !== ""){
                var d_name = ""
                if(typeof(text.split(",")[5]) === "string"){
                    d_name = world.getDimension(text.split(",")[5]).name
                }
                else{
                d_name = "未知"
                }
            poses.push("[" + d_name + "]" + text.split(",")[1])
            real_pos.push(text)
        }
        }
        
        var ui = new ModalFormData()
        .title("设置坐标点")
        .textField("坐标名称(设置手续费：20贡献)","队伍坐标点",name)
        .dropdown("选择坐标位置", poses ,0)
        
        
        ui.show(player).then(result => {
            add_score(player,-20,true)
            var pos_text = [  ]
            if(result.formValues[1] === 0){
                pos_text = [result.formValues[0].replaceAll(",","") , player.dimension.id , String(player.location.x) , String(player.location.y) , String(player.location.z)]
            }
            else{
                var thing = real_pos[result.formValues[1]].split(",")
                pos_text = [result.formValues[0].replaceAll(",","") , thing[5] , thing[2] , thing[3] , thing[4]]
            }
            switch(pos){
                case 0:
                    teams[index].pos1 = pos_text
                    break;
                case 1:
                    teams[index].pos2 = pos_text
                    break;
                case 2:
                    teams[index].pos3 = pos_text
                    break;
            }
            save_team(index)
            posBar(player)
        })
}



function banOpBar(player){
    var ui = new buttonsBar()
        ui.setTitle("封禁列表管理")
        ui.setBody("封禁列表管理")
        ui.addButton("封禁列表一览",{},((id,op) =>{
            banListBar(player)
        }))
        ui.addButton("一键封禁/解封",{},((id,op) =>{
            
        }))
        ui.addButton("详细编辑界面",{},((id,op) =>{
            var ui2 = new arrayEditor()
            ui2.array = ban_list
            ui2.callback = function(result){
                ban_list = result
            }
            ui2.show(player)
        }))
        
        ui.show(player)
        /*.then(result => {
            if(result.selection === 0){
                opBar(player)
            }
            if(result.selection === 1){
                chooseBanBar(player)
            }
            if(result.selection === 2){
                banSetBar(player,0)
            }
            if(result.selection === 3){
                banSetBar(player,1)
            }
            if(result.selection === 4){
                banListBar(player)
            }
        })*/
}

function banListBar(player){
    var text = ""
    for(var cf of ban_list){
        text += cf + "\n"
    }
    var ui = new buttonsBar()
        ui.setTitle("封禁列表")
        ui.setBody("封禁列表：\n(共" + String(ban_list.length) + "人)\n" + text)
        ui.addButton("返回上一级" , {icon : ui_path + "arrow_dark_left_stretch.png"},((id,op) => {
            banOpBar(player)
        }))
        ui.setCancel("run",function(p){
            banOpBar(player)
        })
        ui.show(player)
}

function tradeBar(player){
    var ui = new ActionFormData()
        .title("交易界面")
        .body("和玩家们一起交易吧~")
        .button("返回主菜单" , ui_path + "arrow_dark_left_stretch.png")
        .button("添加交易", ui_path + "book_addtextpage_default.png")
        
        for(var cf=0;cf<trades.length;cf++){
            var things = trades[cf].split("，")
            var mode = ""
            switch(things[1]){
                case "0":
                    mode = "卖出"
                    ui = ui.button(mode + " - " + things[3] + "*" + things[4])
                    break;
                case "1":
                    mode = "交换"
                    ui = ui.button(mode + " - " + things[3] + "*" + things[5] + "=" + things[4] + "*"+things[6])
                    break;
                case "2":
                    mode = "回收"
                    ui = ui.button(mode + " - " + things[3] + "*" + things[4])
                    break;
            }
        }
        
        ui.show(player).then(result => {
            if(result.selection === 1){
                addTradeBar(player)
            }
            if(result.selection === 0){
                cdBar(player)
            }
            if(result.selection > 1){
                tradeInfoBar(player,trades[result.selection-2])
            }
        })
}

function addTradeBar(player){
    var ui = new ActionFormData()
        .title("添加交易界面")
        .body("添加你的交易吧~")
        .button("取消" , ui_path + "arrow_dark_left_stretch.png")
        .button("卖出")
        .button("交换")
        .button("回收")
        
        ui.show(player).then(result => {
            if(result.selection === 0){
                tradeBar(player)
            }
            if(result.selection > 0){
                setTradeBar(player,result.selection-1)
            }
        })
}

function tradeInfoBar(player,text){
    var things = text.split("，")
    var show = ""
        switch(things[1]){
            case "0":
                show = "卖出\n"
                show += "发起人：" + things[2] + "\n\n"
                show += "卖出物品：" + things[3] + "\n卖出数量：" + things[4] + "\n价格/每个物品：" + things[5] +"\n交易地点：" + things[6] 
                break;
            case "1":
                show = "交换\n"
                show += "发起人：" + things[2] + "\n\n"
                show += "卖家：\n卖出物品：" + things[3] + "\n卖出数量：" + things[5] + "\n\n买家\n交换物品：" + things[4] +"\n交换数量：" + things[6] +"\n\n交换地点：" + things[7]
                break;
            case "2":
                show = "回收\n"
                show += "发起人：" + things[2] + "\n\n"
                show += "回收物品：" + things[3] + "\n回收数量：" + things[4] + "\n价格/每个物品：" + things[5] +"\n交易地点：" + things[6] 
                break;
        }
    var ui = new ActionFormData()
        .title("交易详情")
        .body(show)
        .button("返回上一页" , ui_path + "arrow_dark_left_stretch.png")
        if(player.name === things[2]){
            ui = ui.button("删除交易信息")
        }
        ui.show(player).then(result => {
            if(result.selection === 0){
                tradeBar(player)
            }
            if(result.selection === 1){
                delete_trades(text)
                tradeBar(player)
            }
        })
}


function setTradeBar(player,mode){
    var ui = new ModalFormData()
        .title("设置交易内容")
        if(mode === 0){
        ui = ui.textField("卖出物品","在此输入","绿帽子")
        .textField("卖出数量","在此输入","64")
        .textField("价格/每个物品","在此输入","5绿宝石")
        .textField("交易地点","在此输入","出生点")
        }
        if(mode === 1){
        ui = ui.textField("卖方物品","在此输入","绿帽子")
        .textField("买方物品","在此输入","红帽子")
        .textField("卖方数量","在此输入","1")
        .textField("买方数量","在此输入","2")
        .textField("交易地点","在此输入","出生点")
        }
        if(mode === 2){
        ui = ui.textField("回收物品","在此输入","绿帽子")
        .textField("回收数量","在此输入","114514")
        .textField("回收价格","在此输入","64绿宝石/组")
        .textField("交易地点","在此输入","出生点")
        }
        ui.show(player).then(result => {
            var text = "trade，"
            text += String(mode) + "，" + player.name + "，"
            switch(mode){
                case 0:
                case 2:
                    text += result.formValues[0] + "，" +result.formValues[1] + "，" +result.formValues[2] + "，" +result.formValues[3]
                    break;
                case 1:
                    text += result.formValues[0] + "，" +result.formValues[1] + "，" +result.formValues[2] + "，" +result.formValues[3] +"，" + result.formValues[4]
                    break;
            }
            save_trades(text)
            tradeBar(player)
        })
}

function try_open_sign_board(player,entity){
    if(entity.typeId === "minecraft:shulker_bullet" && entity.hasTag("usf_board") && has_feature("SignBoard")){
        var owner = get_entity_data(entity,"sign_owner")
        var text = get_entity_data(entity,"sign_board")
        
        var ui = new buttonsBar()
        ui.setTitle(setting.get_text("sign_board/title"))
        if(text === ""){
            ui.setBody(setting.get_text("sign_board/nothing"))
        }else{
            ui.setBody(text.replaceAll("§?",""))
        }
        ui.addButton(setting.get_text("sign_board/add"),{},function(id,option){
            add_text_to_sign_board(player,entity)
        })
        if(player.name === owner){
            ui.addButton(setting.get_text("sign_board/clear"),{},function(id,option){
                save_entity_data(entity,"sign_board","")
                try_open_sign_board(player,entity)
            })
            ui.addButton(setting.get_text("sign_board/kill"),{},function(id,option){
                entity.kill()
            })
        }
        ui.show(player)
    }
}

function add_text_to_sign_board(player,entity){
    var ui = new infoBar()
    ui.setCancel("run",function(){
        try_open_sign_board(player,entity)
    })
    ui.setTitle(setting.get_text("sign_board/add/title"))
    ui.addInput("text",setting.get_text("sign_board/add/text"),setting.get_text("sign_board/add/place"),"")
    ui.show(player,function(result){
        var text = get_entity_data(entity,"sign_board")
        text += `§b${player.name}§r >> ${result.text}\n`
        if(text.length <= 20000){
            save_entity_data(entity,"sign_board",text)
            try_open_sign_board(player,entity)
        }
    })
}

function playerBar(player){
    var talk_mode = get_tag(player,"talk_mode,").slice(10)
    var text = "聊天设置：公共聊天§?Chat setting:Public"
    if(talk_mode == "1"){
        text = "聊天设置：队伍聊天(我的队伍)§?Chat setting:My team Only"
    }
    if(talk_mode == "2"){
        text = "队伍聊天(加入的队伍)§?Chat setting:Team I added Only"
    }
    
    var ui = new buttonsBar()
        ui.setTitle("玩家互动界面§?Player interaction")
        ui.setBody("来和玩家们一起互动吧§?Let's enjoy ourselves with the players together")
        ui.addButton("返回主菜单§?Back" , {icon:ui_path + "arrow_dark_left_stretch.png"},function(id,option){
            cdBar(player)
        })
        ui.addButton("私聊玩家§?Private chat", {icon:ui_path + "mute_off.png"},function(id,option){
            talkBar(player)
        })
        ui.addButton(text , {icon:ui_path + "settings_glyph_color_2x.png"},function(id,option){
            player.removeTag("talk_mode," + String(talk_mode))
                if(talk_mode === ""){
                    player.addTag("talk_mode,1")
                }
                switch(talk_mode){
                case "0" :
                    player.addTag("talk_mode,1")
                    break;
                case "1":
                    player.addTag("talk_mode,2")
                    break;
                case "2":
                    player.addTag("talk_mode,0")
                    break;
                }
                playerBar(player)
        })
        ui.addButton("交易§?Trade" , {icon:ui_path + "icon_book_writable.png"},function(id,option){
            tradeBar(player)
        })
        if(has_feature("Emoji")){
            ui.addButton("emoji大全§?Emojis" , {icon:ui_path + "regeneration_effect.png"},function(id,option){
                emojiBar(player)
            })
        }
        
        
        ui.show(player)
}

function ideaBar(player){
    var ui = new ModalFormData()
        .title("服务器意见反馈")
        .textField("意见反馈","在此输入","")
        
        ui.show(player).then(result => {
            add_score(player,20)
            player.sendMessage("§e意见反馈已收到，奖励20贡献")
            ideas.push(player.name + " >> " + result.formValues[0])
            cdBar(player)
        })
}

function banSetBar(player,mode){
    var ui = new ModalFormData()
        if(mode === 0){
        ui = ui.title("封禁玩家")
        }
        else{
            ui = ui.title("解封玩家")
        }
        ui = ui.textField("玩家名","在此输入","")
        
        ui.show(player).then(result => {
            if(mode === 0){
                ban_list.push(result.formValues[0])
                save_ban_list()
            }
            else{
                if(ban_list.indexOf(result.formValues[0]) !== -1){
                    ban_list.splice(ban_list.indexOf(result.formValues[0]),1)
                    save_ban_list()
                }
            }
            banOpBar(player)
        })
}

function chestKeyBar(player,password,location,owner){
    var ui = new ModalFormData()
        //ui.title("密码验证")
        .textField("箱子启用了密码验证\n箱主："+owner,"在此输入密码","")
        
        ui.show(player).then(result => {
            if(to_md5(result.formValues[0]) === password){
                player.last_chest = location
                player.sendMessage("§e密码正确")
            }
            else{
                player.sendMessage("§e密码错误")
                add_history(`Players/${player.name}`,player.name + get_pos(player) + "(" + player.dimension.name + ")" + "输入错误密码箱密码")
            }
        })
}

function reloginBar(player){
    var ui = new ModalFormData()
        .title("注册界面")
        .textField("§b请注册你的密码：","在此输入密码","")
        if(get_tag(player,"password,")===""){
        ui.show(player).then(result => {
            if(result.canceled){
                    player.sendMessage("§e你未注册，请注意账号安全")
                    player.login = true
                    show_tips(player)
            }
            else{
                player.addTag("password,"+to_md5(result.formValues[0],"password.in.serverand=Earthdll^SUPPORT/From2023~now"))
                player.sendMessage("§e注册成功")
                player.login = true
                show_tips(player)
            }
        })}else{
            player.sendMessage("§e你已有密码，无法注册")
        }
}

function login(player,pass = ""){
     if(settings.login === false){
        player.login = true
     }
     else{
        var tag = get_tag(player,"password,")
        if(tag === ""){
            player.login = true
        }else{
            if(player.hasTag("password," + to_md5(pass,"password.in.serverand=Earthdll^SUPPORT/From2023~now"))){
                player.login = true
                chat("§e登录成功！§?§eLogin！",[player])
             }
             else{
                chat("§e密码错误！§?§eWrong password！",[player])
             }
        }
     }
     if(player.login === true){
        show_tips(player)
        if(has_feature("Board")){
            show_board(player)
        }
     }
}

function loginBar(player){
    var ui = new ModalFormData()
        .title("密码验证")
        .textField("§b(请不要关闭本界面！否则你将被踢出服务器！)\n欢迎进入服务器\n请输入密码登录服务器：","在此输入密码","")
        
        ui.show(player).then(result => {
            if(result.canceled){
                if(result.cancelationReason === "userClosed"){
                    kick(player,"密码验证失败",true,true)
                    return 0
                }
                run_after(3,loginBar,[player])
                 loginBar(player)
            }
            else{
                var pass = get_tag(player,"password,")
                if(to_md5(result.formValues[0],"password.in.serverand=Earthdll^SUPPORT/From2023~now") === pass.slice(9)){
                    player.login = true
                    if(has_feature("Board")){
                        show_board(player)
                    }
                    show_tips(player)
                    player.has_show = true
                }
                else{
                    if(Date.now() - player.join_time > 30000){
                        kick(player,"密码验证失败",true,true)
                    }
                    run_after(3,loginBar,[player])
                }
            }
        })
}


function chooseBanBar(player){
    var players = world.getAllPlayers()
    var names = []
    for(var cf=0; cf < players.length; cf++){
        names.push(players[cf].name)
    }
    
    var ui = new ModalFormData()
        .title("封禁玩家")
        .dropdown("选择玩家", names ,0)
        
        ui.show(player).then(result => {
        kick(players[result.formValues[0]],"管理员踢出")
        })
}



function tpPlayerBar(player){
    var players = world.getAllPlayers()
    var names = []
    for(var cf=0; cf < players.length; cf++){
        names.push(players[cf].name)
    }
    var ui = new ModalFormData()
        .title("传送至玩家")
        .dropdown("选择玩家", names ,0)
        .textField("传送备注","此处输入消息(消耗100贡献)","")
        .toggle("使用tpa弹窗",false)
        
        ui.show(player).then(result => {
            if(result.formValues[2] === true){
            run_after(15,tpaBar,[players[result.formValues[0]],player,result.formValues[1]])
            }
            players[result.formValues[0]].sendMessage("§b玩家" + player.name + "请求传送至您的位置\n对方备注：" + result.formValues[1] + "\n§b1分钟内输入tpaccept即可传送")
            players[result.formValues[0]].tpa_player = {
                "player":player,
                "time":system.currentTick
            }
        })
}

function opTpBar(player){
    var players = world.getAllPlayers()
    var names = []
    for(var cf=0; cf < players.length; cf++){
        names.push(players[cf].name)
    }
    var ui = new ModalFormData()
        .title("传送至玩家(管理模式)")
        .dropdown("选择玩家", names ,0)
        
        ui.show(player).then(result => {
            var loc = players[result.formValues[0]].location
            player.runCommandAsync(`tp @s ` + String(loc.x) + " " + String(loc.y) + " " + String(loc.z))
        })
}

function inCheckBar(player){
    var players = world.getAllPlayers()
    var names = []
    for(var cf=0; cf < players.length; cf++){
        names.push(players[cf].name)
    }
    var ui = new ModalFormData()
        .title("查看玩家物品栏")
        .dropdown("选择玩家", names ,0)
        .dropdown("模式", ["物品一览","高级检查"] ,0)
        
        ui.show(player).then(result => {
            if(result.formValues[1] === 0){
            inLookBar(player,players[result.formValues[0]])
            }else{
                var err = change_to_player_in(player,players[result.formValues[0]])
                if(err){
                    inCheckBar(player)
                }else{
                    player.is_checking_bag = true
                }
            }
        })
}

function re_give(player){
    var err = true
    var chest = player.dimension.getBlock({x:player.location.x,y:player.location.y,z:player.location.z})
    if(chest.typeId === "minecraft:chest"){
        var con = player.getComponent("minecraft:inventory").container
        con.clearAll()
        var chest_con = chest.getComponent("minecraft:inventory").container
        for(var cf=0;cf<chest_con.size;cf++){
            if(typeof(chest_con.getItem(cf)) === "object"){
                con.setItem(cf,chest_con.getItem(cf))
            }
        }
        chest_con.clearAll()
        err = false
    }
    return err
}

function change_to_player_in(player,target){
    var err = false
    var chest = player.dimension.getBlock({x:player.location.x,y:player.location.y,z:player.location.z})
    if(chest.typeId === "minecraft:chest"){if(chest.getComponent("minecraft:inventory").container.size >= 36 && chest.getComponent("minecraft:inventory").container.emptySlotsCount === chest.getComponent("minecraft:inventory").container.size){
        var con = player.getComponent("minecraft:inventory").container
        var chest_con = chest.getComponent("minecraft:inventory").container
        for(var cf=0;cf<36;cf++){
            if(typeof(con.getItem(cf)) === "object"){
                chest_con.setItem(cf,con.getItem(cf))
            }
        }
        con.clearAll()
        var target_con = target.getComponent("minecraft:inventory").container
        for(var cf=0;cf<36;cf++){
            if(typeof(target_con.getItem(cf)) === "object"){
                var item = target_con.getItem(cf)
                con.setItem(cf,item)
            }
        }
    }
    else{err = true}
    }else{
        err = true
    }
    return err
}


function tpaBar(target,player,tpText){
    target.runCommandAsync("damage @s 0 entity_attack")
    var ui = new MessageFormData()
        .title("TPA传送请求")
        .body("(打开该菜单会受到一个假伤害，请忽略)\n玩家" + player.name + "请求传送至您的位置\n对方备注：" + tpText + "\n请通过下方按钮决定")
        .button1("同意")
        .button2("拒绝")
        ui.show(target).then(result => {
            switch(result.selection){
                case 1:
                    var vaule = add_score(player,-100,true)
                    player.sendMessage("§e正在执行传送")
                    target.tpa_player = ""
                    entity_to_entity(player,target,true)
                    break;
                case 0:
                    target.tpa_player = ""
                    player.sendMessage("§e对方拒绝了你的请求")
                    break;
            }
        })

}

function addTeamBar(target,self,index){
    target.runCommandAsync("damage @s 0 entity_attack")
    var ui = new MessageFormData()
        .title("队伍邀请请求")
        .body("(打开该菜单会受到一个假伤害，请忽略)\n玩家" + self.name + "邀请您加入TA的队伍\n请通过下方按钮决定")
        .button1("同意")
        .button2("拒绝")
        ui.show(target).then(result => {
            switch(result.selection){
                case 1:
                if(get_team_by_player(target,1) === ""){
                    teams[index].member.push(target.name)
                    target.addTag("addTeam," + String(teams[index].id))
                    save_team(index)
                    self.sendMessage("§e对方已加入你的队伍")
                    target.sendMessage("§e你已加入对方的队伍")
                    
                    }
                    else{
                    self.sendMessage("§e你已加入其他队伍")
                    target.sendMessage("§e对方已加入其他队伍")
                    }
                    break;
                case 0:
                    self.sendMessage("§e对方拒绝了你的请求")
                    break;
            }
        })

}

function log(text,say = false){
    var thing = get_time() + text
    var server = thing.replace(/§./g,"")
    try{
    http.get("http://127.0.0.1:1024/log?text=" + encodeURI(server))
    }catch(any){}finally{}
    if(say === true){
    try{
    http.get("http://127.0.0.1:1024/send?text=" + encodeURI("检测到服务器出现危险行为，请管理员前往确认"))
    }catch(any){}finally{}
   }
    if(say == true){
    world.sendMessage("§c" + server)
    }
}

function show_board(player){
    var ui = new buttonsBar()
    ui.setTitle("公告板§?Board")
    ui.setBody(totals)
    
    ui.setBusy("again",20)
    ui.setCancel("close")
    
    ui.addButton("打开主菜单§?Menu Page",{icon:ui_path + "icon_crafting.png"},(id,option) => {
        cdBar(player)
    })
    ui.addButton("交易系统§?Trade Page",{icon:ui_path + "icon_deals.png"},(id,option) => {
        tradeBar(player)
    })
    ui.addButton("帮助页面§?Help",{icon:ui_path + "how_to_play_button_default.png"},(id,option) => {
        helpBar(player)
        player_history(player,show_board)
    })
    ui.addButton("语言设置/Language",{icon:ui_path + "world_glyph_color_2x.png"},(id,option) => {
        languageBar(player)
        player_history(player,show_board)
    })
    if(has_feature("Board")){
        ui.show(player)
    }
}


function languageBar(player){
    
    var ui = new infoBar()
    ui.addOptions("lang","选择您的语言\nChoose Your Language",["中文","English"],get_lang(player))
    
    ui.setTitle("语言/Language")
    ui.setBusy("again",20)
    ui.setCancel("back")
    
    ui.show(player,function(result){
        player.language = result.lang
        save_lang(player)
        back_history(player)
    })
}

function save_lang(player){
    var tag = get_tag(player,"lang,")
    if(tag !== ""){
        player.removeTag(tag)
    }
    player.addTag("lang," + JSON.stringify({lang:player.language}))
}

function changeArrayBar(player,array,type=""){
    var config = {
        "title":"",
        "reset":"",
        "edit":"",
        "show_mode":false
    }
    switch(type){
        case "totals":
            config.title = "公告内容"
            config.reset = "重新设置公告内容"
            config.edit = "编辑公告内容"
            config.show_mode = true
            break;
        case "tips":
            config.title = "入群提示"
            config.reset = "重新设置入群提示"
            config.edit = "编辑入群提示"
            break;
        case "kick_item":
            config.title = "违禁物品"
            config.reset = "重设所有违禁物品"
            config.edit = "编辑违禁物品"
            break;
        case "kick_place_block":
            config.title = "禁止放置的方块"
            config.reset = "重设所有方块"
            config.edit = "编辑违禁方块"
            break;
        case "kick_break_block":
            config.title = "禁止破坏的方块"
            config.reset = "重设所有方块"
            config.edit = "编辑违禁方块"
            break;
        case "about":
            config.title = "关于页面"
            config.reset = "重设关于页面内容"
            config.edit = "编辑关于页面"
            config.show_mode = true
            break;
        case "cd":
            config.title = "主菜单内容"
            config.reset = "重设主菜单内容"
            config.edit = "编辑主菜单内容"
            config.show_mode = true
            break;
        case "help":
            config.title = "帮助界面内容"
            config.reset = "重设帮助内容"
            config.edit = "编辑帮助内容"
            config.show_mode = true
            break;
    }
    var text = tran_text(player,array)
    var ui = new ActionFormData()
        .title(config.title)
        .body(text)
        .button(config.reset , ui_path + "icon_book_writable.png")
        .button(config.edit , ui_path + "icon_crafting.png")
        .button("返回上一级")
        
        ui.show(player).then(result => {
            if(result.selection === 1){
                editArrayBar(player,array,type)
            }
            if(result.selection === 0){
                resetArrayBar(player,array,type)
            }
            if(result.selection === 2){
                switch(type){
                    case "totals":
                        opBar(player)
                        break;
                    case "kick_item":
                    case "tips":
                    case "kick_item":
                    case "kick_break_block":
                    case "kick_place_block":
                    case "cd":
                    case "help":
                    case "about":
                        settingBar(player)
                        break;
                }
                
            }
        })
}

function inLookBar(player,target){
    var items = target.getComponent("minecraft:inventory").container
    var text = "玩家名称：" + target.name + ",物品栏数量：" + items.size
    for(var cf=0;cf<items.size;cf++){
        var item = items.getItem(cf)
        if(typeof(item) === "object"){
            text += ",ID:" + item.typeId.replace("minecraft:","") + ";数量:" + String(item.amount) + ";名称:" + item.nameTag + ";数据值:" + String(item.data)
        }
    }
    var ui = new ActionFormData()
        .title("物品栏")
        .body(text.replaceAll(",","\n"))
        .button("推送到日志群")
        .button("返回主菜单")
        .button("违法行为")
        .button("捅了老窝")
        .button("绳之以法")
        
        ui.show(player).then(result => {
            if(result.selection === 0){
                add_history(`Players/${player.name}`,text)
            }
            if(result.selection === 1){
                cdBar(player)
            }
            if(result.selection === 2){
                target.playSound("server.wf")
            }
            if(result.selection === 3){
                target.playSound("server.lw")
            }
            if(result.selection === 4){
                target.playSound("server.szyf")
            }
        })
}

function resetArrayBar(player,array,type,reset=true){
    var title = ""
    switch(type){
        case "totals":
            title = "重置公告"
            break;
        case "kick_place_block":
            title = "重置禁止放置方块"
            break;
        case "kick_break_block":
            title = "重置禁止破坏方块"
            break;
        case "kick_item":
            title = "重置违禁物品"
            break;
        case "about":
            title = "重置关于页面"
            break;
        case "cd":
            title = "重置主菜单文字"
            break;
        case "help":
            title = "重置帮助页面"
            break;
        
        
    }
    var text = ""
    if(reset === true){
        array.splice(0,array.length)
    }
    for(var cf=0;cf<array.length;cf++){
        var line = "§r§a" + String(cf+1) + " "
        if(cf < 9){
            line += "  "
        }
        line += "§r"
        text += line + array[cf] + "\n"
    }
    var ui = new ModalFormData()
        .title(title)
        .textField(text,"新一行内容","")
        .toggle("结束",false)
        ui.show(player).then(result => {
            array.push(result.formValues[0])
            switch(type){
                case "totals":
                    save_totals()
                    break;
                case "kick_item":
                case "kick_break_block":
                case "kick_place_block":
                    save_bans()
                    break;
                case "cd":
                case "about":
                    save_content()
                    break;
                
            }
            if(result.formValues[1] === true){
                changeArrayBar(player,array,type)
            }
            else{
            resetArrayBar(player,array,type,reset=false)
            }
        })
}

function editArrayLineBar(player,array,type,line){
    var title = ""
    var need_change = false
    switch(type){
        case "totals":
            title = "公告单行编辑"
            need_change = true
            break;
        case "kick_place_block":
            title = "禁止放置方块单行编辑"
            break;
        case "kick_break_block":
            title = "禁止破坏方块单行编辑"
            break;
        case "kick_item":
            title = "违禁物品单行编辑"
            break;
        case "tips":
            title = "tips单行编辑"
            break;
        case "cd":
            title = "主菜单单行编辑"
            need_change = true
            break;
        case "about":
            title = "关于界面单行编辑"
            need_change = true
            break;
        case "help":
            title = "帮助界面单行编辑"
            need_change = true
            break;
    }
    var text = array[line]
    
    if(need_change === true){
        text += "\n\n"
        text += "此内容启用了转义，输入以下内容会自动转换\n/pos >>玩家当前位置\n/list >>玩家列表\n/name >>玩家名称\n/time >>世界运行总时间\n/board.计分板ID.score >>玩家计分板分数\n/board.计分板ID.name >>该计分板显示名称"
    }
    var ui = new ModalFormData()
        .title(title)
        .textField(text,"该行内容",array[line])
        .dropdown("操作", ["修改","插入新一行","删除这一行"] ,0)

        ui.show(player).then(result => {
            switch(result.formValues[1]){
                case 0:
                    array[line] = result.formValues[0]
                    break;
                case 1:
                    array.splice(line+1,0,result.formValues[0])
                    break;
                case 2:
                    array.splice(line,1)
                    break;
            }
            switch(type){
                case "totals":
                    save_totals()
                    break;
                case "kick_item":
                case "kick_item":
                case "kick_break_block":
                case "kick_place_block":
                    save_bans()
                    break;
                case "About":
                case "cd":
                case "help":
                    save_content()
                    break;
            }
            editArrayBar(player,array,type,line)
        })
}

function floatLineBar(player,float,choose){
    var texts = float.nameTag.split("\n")
    var text = texts[choose]
    var ui = new ModalFormData()
        .title("悬浮字单行编辑")
        .textField(text,"该行内容",text)
        .dropdown("操作", ["修改","插入新一行","删除这一行"] ,0)

        ui.show(player).then(result => {
            switch(result.formValues[1]){
                case 0:
                    texts[choose] = result.formValues[0]
                    break;
                case 1:
                    texts.splice(choose+1,0,result.formValues[0])
                    break;
                case 2:
                    texts.splice(choose,1)
                    break;
            }
            var name = ""
            for(var cf=0;cf<texts.length;cf++){
                name += texts[cf]
                if(texts.length - cf !== 1){
                name += "\n"
                }
                }
            float.nameTag = name
            changeFloatBar(player,float,choose)
        })
}

function arrayJumpBar(player,array,type){
    var text = ""
    for(var cf=0;cf<array.length;cf++){
        var lines = "§r§a" + String(cf+1) + " "
        if(cf < 9){
            lines += "  "
        }
        lines += "§r"
        text += lines + array[cf] + "\n"
    }
    var ui = new ModalFormData()
        .title("跳转")
        .slider(text + "\n\n跳转到 ",1,array.length,1,1)
        ui.show(player).then(result => {
            editArrayBar(player,array,type,result.formValues[0]-1)
        })
}

function arrayEditor(){
    this.player = null
    this.array = []
    this.callback = function(e){}
    this.line = 0
    
    
    this.show = function(player = null){
        if(player !== null){
            this.player = player
        }
        var text = ""
            this.array = [...this.array]
            var ui = new infoBar()
            ui.setTitle(setting.get_text("ArrayEditor/title"))
            
            if(this.array.length > 0){
            for(var cf=0;cf<this.array.length;cf++){
                if(cf === this.line){
                    text += "§a>>§r"
                }
                else{
                    text += String(cf+1)
                    if(String(cf+1).length == 1){
                        text += " "
                    }
                }
                text += " " + this.array[cf].replaceAll("§?","") + "\n§r"
            }
            }
            ui.addOptions("trol",text + "\n" + tran_lang(this.player,setting.get_text("ArrayEditor/control")),
            [
                setting.get_text("ArrayEditor/control/none"),
                setting.get_text("ArrayEditor/control/up"),
                setting.get_text("ArrayEditor/control/down"),
                setting.get_text("ArrayEditor/control/edit"),
                setting.get_text("ArrayEditor/control/jump"),
                setting.get_text("ArrayEditor/control/add"),
                setting.get_text("ArrayEditor/control/move"),
                setting.get_text("ArrayEditor/control/clear"),
            ],0)
            if(this.array.length > 1){
                ui.addRange("jump",setting.get_text("ArrayEditor/jump"),1,this.array.length,1,this.line+1)
            }
            ui.show(this.player,(result => {
                switch(result.trol){
                    case 0:
                        this.show()
                        break;
                    case 1:
                        if(this.line > 0){
                            this.line --
                        }
                        this.show(this.player)
                        break;
                    case 2:
                        if(this.line < this.array.length - 1){
                            this.line ++
                        }
                        this.show(this.player)
                        break;
                    case 3:
                        if(this.array.length > 0){
                            this.edit()
                        }
                        break;
                    case 4:
                        if(typeof(result.jump) === "number"){
                            this.line = result.jump - 1
                        }
                        this.show(this.player)
                        break;
                    case 5:
                        this.addLine()
                        break;
                    case 6:
                        this.array.splice(this.line + 1,1)
                        this.callback(this.array)
                        this.show()
                        break;
                    case 7:
                        this.array = []
                        this.callback(this.array)
                        this.show()
                        break;
                }
            }))
    }
    
    this.addLine = function(){
        var ui = new infoBar()
        ui.setTitle(setting.get_text("ArrayEditor/addLine/title"))
        ui.addInput("text",setting.get_text("ArrayEditor/addLine/text"),setting.get_text("ArrayEditor/addLine/place"),"")
        ui.show(this.player,(result =>{
            this.array.splice(this.line+1,0,result.text)
            this.callback(this.array)
            this.show()
        }))
    }
    
    this.edit = function(){
        var ui = new infoBar()
        ui.setTitle(setting.get_text("ArrayEditor/edit/title"))
        ui.addInput("text",setting.get_text("ArrayEditor/edit/text"),setting.get_text("ArrayEditor/addLine/place"),this.array[this.line])
        ui.show(this.player,(result =>{
            this.array[this.line] = result.text
            this.callback(this.array)
            this.show()
        }))
    }
}

function editArrayBar(player,array,type,line = 0){
    var text = ""
    var title = ""
    switch(type){
        case "totals":
            title = "编辑公告"
            break;
        case "kick_place_block":
            title = "编辑禁止放置方块"
            break;
        case "kick_break_block":
            title = "编辑禁止破坏方块"
            break;
        case "kick_item":
            title = "编辑违禁物品"
            break;
        case "tips":
            title = "编辑tips"
            break;
    }
    for(var cf=0;cf<array.length;cf++){
        if(cf === line){
            text += "§a>>§r"
        }
        else{
            text += "  "
        }
        text += " " + array[cf] + "\n§r"
    }
    var ui = new ActionFormData()
        .title(title)
        .body(text)
        .button("上一行")
        .button("编辑这一行")
        .button("下一行")
        .button("跳转到指定行")
        .button("返回上一级")
        
        
        ui.show(player).then(result => {
            switch(result.selection){
                case 0:
                    if(line > 0){
                        editArrayBar(player,array,type,line-1)
                    }
                    else{
                        editArrayBar(player,array,type,line)
                    }
                    break;
                case 2:
                    if(line < array.length - 1){
                        editArrayBar(player,array,type,line+1)
                    }
                    else{
                        editArrayBar(player,array,type,line)
                    }
                    break;
                case 4:
                    switch(type){
                        case "totals":
                            opBar(player)
                            break;
                    }
                    break;
                case 3:
                    arrayJumpBar(player,array,type)
                    break;
                case 1:
                    editArrayLineBar(player,array,type,line)
                    break;
            }
        })
}

function changeFloatBar(player,float,choose = 0){
    var texts = float.nameTag.split("\n")
    var text = ""
    for(var cf=0;cf<texts.length;cf++){
        if(cf === choose){
            text += "§a>>§r"
        }
        else{
            text += "  "
        }
        text += " " + texts[cf] + "\n"
    }
    var ui = new ActionFormData()
        .title("悬浮字编辑")
        .body(text)
        .button("上一行")
        .button("编辑这一行")
        .button("下一行")
        .button("完成")
        
        
        ui.show(player).then(result => {
            switch(result.selection){
                case 0:
                    if(choose > 0){
                        changeFloatBar(player,float,choose-1)
                    }
                    else{
                        changeFloatBar(player,float,choose)
                    }
                    break;
                case 2:
                    if(choose < texts.length - 1){
                        changeFloatBar(player,float,choose+1)
                    }
                    else{
                        changeFloatBar(player,float,choose)
                    }
                    break;
                case 3:
                    editFloatBar(player,float)
                    break;
                case 1:
                    floatLineBar(player,float,choose)
                    break;
            }
        })
}

function add_history(path = "unknown" , text , type = "Log" , other = ""){
    var mess = (get_time() + text).replace(/§./g,"")
    if(can_http){
    import('@minecraft/server-net').then(
    (m) => {
        var url = "http://127.0.0.1:1024/Server/" + encodeURI(path) + "?"
        url += "text=" + encodeURI(mess) + "&type=" + type + "&" + other
        m.http.get(url)
    }).catch(err => {can_http = false})
    
    }
    try{
    
    }catch(any){}finally{}
}
add_history("Server","脚本启动，连接高级功能系统")



function beforeWatchdogTerminate(event){
    var text = format(setting.get_text("Console/error/watchdog"),[event.terminateReason])
    add_history("Server",text)
    console.error(text)
    event.cancel = true
}
//习惯了写一个文件，就这样吧。。