import { world } from "@minecraft/server";
//subscribe an entity hit entity event
world.afterEvents.entityHitEntity.subscribe(t => {
//define entities in the event
	var entity = t.hitEntity
	var attack = t.damagingEntity
//use different methods to get items held by different types of entities
	if (attack.typeId == "minecraft:player") {
		var weapon = attack.getComponent("inventory")
			.container.getItem(attack.selectedSlotIndex)
	}
	else {
		var weapon = attack.getComponent("equippable")
			.getEquipment("mainhand")
	}
//when the hitting entity holding wooden sword, affect hit entity poison
	if (weapon.typeId == "minecraft:wooden_sword"){
		entity.runCommand(`effect @s fatal_poison 5 1`);
	}
//when the hitting entity holding iron sword, affect hit entity slowness. especially when hit entity is player, affect it blindness
	if (weapon.typeId == "minecraft:iron_sword"){
		if (entity.typeId == "minecraft:player") {entity.runCommand(`effect @s blindness 120 0`);}
		else {entity.runCommand(`effect @s slowness 120 1`);}
	}
});