import { world, system, BlockPermutation, Direction } from "@minecraft/server"

system.runInterval(() => {
   for (let player of world.getAllPlayers()) {
      let hit = player.getBlockFromViewDirection({ "maxDistance": 20 });
      if (hit !== undefined) {
         let block;
         switch (hit.face) {
            case Direction.Down: {
               block = hit.block.below();
               break;
            }
            case Direction.Up: {
               block = hit.block.above();
               break;
            }
            case Direction.East: {
               block = hit.block.east();
               break;
            }
            case Direction.West: {
               block = hit.block.west();
               break;
            }
            case Direction.North: {
               block = hit.block.north();
               break;
            }
            case Direction.South: {
               block = hit.block.south();
               break;
            }
         }
         let dimension = player.dimension;
         let pos = block.location;
         for (let x = 0; x <= 1; x += 0.5) {
            for (let y = 0; y <= 1; y += 0.5) {
               for (let z = 0; z <= 1; z += 0.5) {
                  dimension.spawnParticle("minecraft:redstone_ore_dust_particle", { "x": pos.x + x, "y": pos.y + y, "z": pos.z + z });
               }
            }
         }
      }
   }
}, 1);
