import { system, world } from '@minecraft/server';

// Display cooldown time remaining in player's hotbar of the player's item in mainhand
system.runInterval(() => {
    world.getAllPlayers().forEach(player => {
        const itemHeld = player.getComponent('equippable').getEquipment('Mainhand');
        const cooldown = itemHeld?.getComponent('cooldown')?.getCooldownTicksRemaining(player);

        if(cooldown !== undefined) {
            player.onScreenDisplay.setActionBar(cooldown.toString());
        }
    });
});

// Using the ItemComponentUseOnEvent
world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.itemComponentRegistry.registerCustomComponent('item:spell_book', {
        onUse(event) {
            const {itemStack, source} = event;
            // itemStack.getComponent('cooldown').startCooldown(source);

            /* Even without this startCooldown, item will still start to cooldown,
             * but with no overlay cooldown. It's on cooldown but cannot be seen.
             * So we add the runInvertal above to see it's actually on cooldown.
             * But adding startCooldown allows us to see cooldown overlay.
             * 
             * Also one problem is it cannot trigger this event while item is
             * in cooldown. As a result, we cannot do something while item is in cooldown.
             */

            source.sendMessage('Do something!...');
        }
    });
});