import { system, world, EntityComponentTypes } from "@minecraft/server";

const overworld = world.getDimension('overworld');

system.afterEvents.scriptEventReceive.subscribe(ev => {
  const {id, sourceBlock} = ev;

  world.sendMessage(id);

  switch(id) {
    case 'ex:shoot1': {
      const arrowSpawnPos = {
        x: sourceBlock.x + 1.5,
        y: sourceBlock.y + 1,
        z: sourceBlock.z - 1.5
      };
      const arrow = overworld.spawnEntity('arrow', arrowSpawnPos);
      const projectileComponent = arrow.getComponent(EntityComponentTypes.Projectile);
      projectileComponent.shoot({x: 0, y: .33, z: -1});

      world.sendMessage('shoot1');
    } break;

    case 'ex:shoot2': {
      const arrowSpawnPos = {
        x: sourceBlock.x - .5,
        y: sourceBlock.y + 1,
        z: sourceBlock.z - 1.5
      };
      const arrow = overworld.spawnEntity('arrow', arrowSpawnPos);
      arrow.applyImpulse({x: 0, y: .33, z: -1});

      world.sendMessage('shoot2');
    } break;
  }
});