import { system, world, ItemStack, BlockPermutation} from "@minecraft/server";

world.beforeEvents.worldInitialize.subscribe((event) => {
    const {blockComponentRegistry} = event
    blockComponentRegistry.registerCustomComponent("custom:beforeOnPlayerPlace", {
        beforeOnPlayerPlace(data) {
            const {block, dimension, face, permutationToPlace, player} = data;

            if (block.above(1).isAir) {
                const set = BlockPermutation.resolve(permutationToPlace.type.id, {
                    ...permutationToPlace.getAllStates(),
                });
                block.above(1).setPermutation(set)
            } else {
                data.cancel = true;
            }
        }
    })
})