import {system} from "@minecraft/server"

function round3(number) {
	return Math.round(number * 1000) / 1000
}

system.beforeEvents.startup.subscribe(
	({blockComponentRegistry}) => {
		blockComponentRegistry.registerCustomComponent(
			"bug_face:logger",
			{
				onPlayerInteract({faceLocation}) {
					const {x, z, y} = faceLocation
					console.warn(`x: ${round3(x)}`, `y: ${round3(y)}`, `z: ${round3(z)}`)
				}
			}
		)
	}
)