import {system, world} from "@minecraft/server"

world.beforeEvents.playerInteractWithBlock.subscribe(
	({block, player, isFirstEvent}) => {
		if (
			!isFirstEvent
			|| (
				block.typeId != "bug_localization:custom_block_without_display_name"
				&& block.typeId != "bug_localization:custom_block_with_display_name"
				&& block.typeId != "minecraft:iron_block"
			)
		) return
		
		system.run(
			() => {
				player.sendMessage(`Localization Key: ${block.localizationKey}`)
				player.sendMessage(["Localized Name According to Scripting: ", {translate: block.localizationKey}])
			}
		)
	}
)