import { system, world, ItemStack, EnchantmentType, BlockPermutation } from "@minecraft/server";
import { ActionFormData, MessageFormData, ModalFormData } from '@minecraft/server-ui';

function round(number, precision) {
  return Math.round(+number + "e" + precision) / Math.pow(10, precision);
};
system.beforeEvents.startup.subscribe((ini) => {
  ini.customCommandRegistry.registerCommand({cheatsRequired: true, permissionLevel: 1, name: "cmd:dynamicproperty", description: "Set or query value of a specific custom property", mandatoryParameters: [{name: "target", type: "EntitySelector"}, {name: "dynamicPropertyId", type: "String"}], optionalParameters: [{name: "value", type: "String"}]}, (executor, arg1, arg2, arg3) => {
    if (arg1.length < 1) {
      return {message: "commands.generic.entity.notFound", status: 1}
    }
    if (arg1.length == 1) {
      if (arg3 === undefined) {
        const query = arg1.getDynamicProperty(arg2)
        if (query === undefined) {
          return {message: "该实体不具有指定的自定义属性", status: 1}
        } else {
          return {message: JSON.stringify(query), status: 0}
        }
      } else {
        world.getEntity(arg1.id).setDynamicProperty(arg2, JSON.parse(arg3))
        return {message: "成功设置自定义属性", status: 0}
      }
    }
    if (arg1.length > 1) {
      return {message: "只能指定一个目标实体", status: 1}
    }
  })
});
system.runInterval(()=>{
  const cd = world.scoreboard.getObjective("cmd:countdown")
  const reg = world.scoreboard.getObjective("cmd:reg")
  let cdlist = Array.from(cd.getParticipants())
  cdlist.forEach(item => {
    if (cd.getScore(item) < 0) {
      cd.removeParticipant(item)
    } else {
      cd.setScore(item, cd.getScore(item)-1)
    }
  })
  let reglist = Array.from(reg.getParticipants())
  const inis = ["cd:spectator","cmd:pri_level","cmd:tnt_p","cmd:non-op_no_debug","cmd:tnt_no_explode","cmd:pos_min_level","pos:high_access_low","pos:edit_min_level","cmd:remove_on_hit","cmd:remove_min_level","pos:opr_min_level","show:chunks","show:biome","cmd:inspect_min_level","inspect:exit_on_leave","inspect:exit_on_hurt","show:cam_pos"]
  const iniVals = [1200,1,4,0,0,2,1,3,1,3,2,0,1,2,1,1,0]
  for (let i = 0; i < inis.length; i++) {
    var ini = reglist.some(t => 
      t.displayName === inis[i]
    )
    if (!ini) {
      reg.setScore(inis[i], iniVals[i])
    }
  }
  reglist.forEach(item => {
    var itemType = regVerify(item.displayName).type
    if (itemType == "eban") {
      let players = Array.from(world.getPlayers())
      players.forEach(player => {
        if (reg.getScore(item) == 0) {
          var entities = player.dimension.getEntities({type: item.displayName.slice(5)})
        }
        if (reg.getScore(item) == 1) {
          var entities = player.dimension.getEntities({families: [item.displayName.slice(5)]})
        }
        if (reg.getScore(item) == 2) {
          reg.setScore(`eban_name:${item.displayName.slice(5)}`, 1)
          reg.removeParticipant(item)
        }
        entities.forEach(entity => {
          if (entity.typeId != "minecraft:player") {
            entity.remove()
          }
        })
      })
    }
    if (itemType == "eban_fixed") {
      let players = Array.from(world.getPlayers())
      players.forEach(player => {
      var entities = player.dimension.getEntities({name: item.displayName.slice(10)})
        entities.forEach(entity => {
          if (entity.typeId === "minecraft:player") {
            entity.runCommand("kick @s")
          } else {
            entity.remove()
          }
        })
      })   
    }
    if (itemType == "iban") {
      let players = Array.from(world.getPlayers())
      players.forEach(player => {
        player.runCommand(`clear @s ${item.displayName.slice(5)} ${reg.getScore(item)}`)
      })
    }
    if (itemType == "pos_x" || itemType == "pos_y" || itemType == "pos_z" || itemType == "pos_dim") {
      if (!reglist.some(r => regVerify(r.displayName).name == regVerify(item.displayName).name && regVerify(r.displayName).type == "pos_owner")) {
        reg.removeParticipant(item)
      }
      if (itemType == "pos_dim" && reg.getScore(item) == -1) {
        reg.setScore(item, 0)
      }
    }
  })
	let players = Array.from(world.getPlayers())
  players.forEach(player => {
    const v = player.location
    const mode = reg.getScore("show:biome")
    var setOp = player.playerPermissionLevel == 2? "add" : "remove"
    player.runCommand(`tag @s ${setOp} op`)
    if (player.commandPermissionLevel > 2) {
      if (!player.hasTag("cmd:owner")) {
        player.addTag("cmd:owner")
        player.runCommand("scoreboard players set @s cmd:reg 5")
      }
    } else {
      player.removeTag("cmd:owner")
    };
    if (!reg.hasParticipant(player)) {
      reg.setScore(player, reg.getScore("cmd:pri_level"))
      player.runCommand('give @s cmd:debug_stick 1 0 {"minecraft:item_lock":{"mode":"lock_in_inventory"},"minecraft:keep_on_death":{}}')
    }
    else if (reg.getScore(player) > 5) {
      reg.setScore(player, 5)
      player.sendMessage({translate: "你无法取得更高的权限等级！"})
      player.runCommand('tellraw @a[tag=cmd:owner] {"rawtext":[{"translate":"该玩家正在尝试获得更高级别的权限，已自动降级"}]}')
    };
    if (mode == 2) {
      player.runCommand(`titleraw @s actionbar {"rawtext":[{"translate":"你来到了："},{"translate":"${player.dimension.getBiome(v).id}"}]}`)
    };
    if (player.getDynamicProperty("cmd:prebiome") === undefined || mode == 0) {
      player.setDynamicProperty("cmd:prebiome", "")
    } else {
      if (player.dimension.getBiome(v).id !== player.getDynamicProperty("cmd:prebiome")) {
        if (mode == 1) {
          player.runCommand(`titleraw @s title {"rawtext":[{"translate":"${player.dimension.getBiome(v).id}"}]}`)
        }
        if (mode == 3) {
          player.sendMessage({rawtext:[{translate: "你来到了："},{translate: String(player.dimension.getBiome(v).id)}]})
        }
        player.setDynamicProperty("cmd:prebiome", String(player.dimension.getBiome(v).id))
      }
    };
    if (reg.getScore("show:chunks") == 1) {
      function calculateBounds(val) {
        if (val >= 0) {
          const lower = Math.floor(val / 16) * 16;
          return [lower, lower + 15];
        } else {
          const upper = Math.ceil(val / 16) * 16 - 1;
          return [upper, upper - 15];
        }
      }
      const [x1, x2] = calculateBounds(v.x)
      const [y1, y2] = calculateBounds(v.y)
      const [z1, z2] = calculateBounds(v.z)
      function generateLinePoints() {
        const points = []
        const edges = [
          [{x: x1, y: y1, z: z1}, {x: x2, y: y1, z: z1}],
          [{x: x1, y: y1, z: z2}, {x: x2, y: y1, z: z2}],
          [{x: x1, y: y2, z: z1}, {x: x2, y: y2, z: z1}],
          [{x: x1, y: y2, z: z2}, {x: x2, y: y2, z: z2}],
          [{x: x1, y: y1, z: z1}, {x: x1, y: y2, z: z1}],
          [{x: x1, y: y1, z: z2}, {x: x1, y: y2, z: z2}],
          [{x: x2, y: y1, z: z1}, {x: x2, y: y2, z: z1}],
          [{x: x2, y: y1, z: z2}, {x: x2, y: y2, z: z2}],
          [{x: x1, y: y1, z: z1}, {x: x1, y: y1, z: z2}],
          [{x: x1, y: y2, z: z1}, {x: x1, y: y2, z: z2}],
          [{x: x2, y: y1, z: z1}, {x: x2, y: y1, z: z2}],
          [{x: x2, y: y2, z: z1}, {x: x2, y: y2, z: z2}]
        ]
        edges.forEach(edge => {
          const start = edge[0]
          const end = edge[1]
          const dx = Math.sign(end.x - start.x)
          const dy = Math.sign(end.y - start.y)
          const dz = Math.sign(end.z - start.z)
          let current = {...start};
          while (true) {
            points.push({...current});
            if (current.x === end.x && current.y === end.y && current.z === end.z) {
              break;
            }
            if (current.x !== end.x) current.x += dx;
            else if (current.y !== end.y) current.y += dy;
            else if (current.z !== end.z) current.z += dz;
          }
        });
        return points;
      }
      const linePoints = generateLinePoints()
      const range = player.dimension.heightRange
      linePoints.forEach(point => {
        if (point.y >= range.min && point.y < range.max) {
          player.runCommand(`particle "minecraft:shulker_bullet" ${point.x} ${point.y+0.5} ${point.z}`);
        }
      });
    };
    if (player.hasTag("cmd:inspect")) {
      let x = player.getDynamicProperty("inspect:pre_pos").x
      let y = player.getDynamicProperty("inspect:pre_pos").y
      let z = player.getDynamicProperty("inspect:pre_pos").z
      let inputX = player.inputInfo.getMovementVector().x
      let inputZ = player.inputInfo.getMovementVector().y
      let vertical = 0+(player.inputInfo.getButtonState("Jump") == "Pressed"?1:0)-(player.inputInfo.getButtonState("Sneak") == "Pressed"?1:0)
      let rotX = player.getRotation().x
      let rotY = player.getRotation().y
      let offsetX = (player.getDynamicProperty("inspect:speed")??0.11)*(inputX*Math.cos(rotY/180*Math.PI)-inputZ*Math.sin(rotY/180*Math.PI))
      let offsetY = vertical*(player.getDynamicProperty("inspect:speed")??0.11)
      let offsetZ = (player.getDynamicProperty("inspect:speed")??0.11)*(inputX*Math.sin(rotY/180*Math.PI)+inputZ*Math.cos(rotY/180*Math.PI))
      player.camera.setCamera("custom:free_inspect", {location: {x: round(x+offsetX, 2), y: round(y+offsetY, 2), z: round(z+offsetZ, 2)}, rotation: {x: rotX, y: rotY}})
      player.setDynamicProperty("inspect:pre_pos", {x: x+offsetX, y: y+offsetY, z: z+offsetZ})
      if (reg.getScore("show:cam_pos") == 1) {
        player.onScreenDisplay.setActionBar(`x: ${round(x+offsetX, 2)}, y: ${round(y+offsetY, 2)}, z: ${round(z+offsetZ, 2)}`)
      }
    }
  })
  let participants = Array.from(world.scoreboard.getParticipants())
  for(let participant of participants) {
    if (reg.getScore(participant) < 0 && participant.displayName == "cmd:tnt_p") {
      reg.setScore(participant, 0)
    }
    if (participant.type != "FakePlayer") {
      if (reg.getScore("cmd:tnt_no_explode") == 1 && cd.getScore(participant) == 0 && participant.getEntity().typeId == "minecraft:tnt") {
        var tnt = participant.getEntity()
        var p = reg.getScore("cmd:tnt_p")
        tnt.runCommand(`tag @e[r=${Math.round(p*2)}] add ck:tnt_damage`)
        var org = tnt.location
        let entities = Array.from(tnt.dimension.getEntities({tags: ["ck:tnt_damage"]}))
        entities.forEach(entity => {
          if (entity !== tnt) {
            var offset = entity.location
            var d = ((org.x-offset.x)**2+(org.y-offset.y)**2+(org.z-offset.z)**2)**(1/2)
            var f = (1-d/(2*p))
            entity.runCommand(`damage @s ${Math.round(7*(f**2+f)*p+1)} entity_explosion entity @e[scores={cmd:countdown=0},type=tnt,c=1]`)
          }
        })
        tnt.runCommand("tag @e remove ck:tnt_damage")
        tnt.runCommand("kill @s")
      }
    }
  }
});
function regVerify(regItem) {
  const item = regItem
  if (item.startsWith('cmd:')) {
    return {type: "root", name: item.slice(4)}
  }
  if (item.startsWith('cd:')) {
    return {type: "cd", name: item.slice(3)}
  }
  if (item.startsWith('pos:')) {
    return {type: "pos", name: item.slice(4)}
  }
  if (item.startsWith('pos_owner:')) {
    const dvd = item.indexOf('|');
    const ownerID = item.substring(10,dvd);
    const name = item.substring(dvd+1)
    return {type: "pos_owner", id: ownerID, name: name}
  }
  if (item.startsWith('pos_x|') || item.startsWith('pos_y|') || item.startsWith('pos_z|')) {
    return {type: item.slice(0,5), name: item.slice(6)}
  }
  if (item.startsWith('pos_dim|')) {
    return {type: "pos_dim", name: item.slice(8)}
  }
  if (item.startsWith('iban:') || item.startsWith('eban:')) {
    return {type: item.slice(0,4), name: item.slice(5)}
  }
  if (item.startsWith('eban_name:')) {
    return {type: "eban_fixed", name: item.slice(10)}
  }
  if (item.startsWith('show:')) {
    return {type: "display", name: item.slice(5)}
  }
  if (item.startsWith('inspect:')) {
    return {type: "free_cam", name: item.slice(8)}
  }
  return {type: null, id: null, name: null}
};
function editEntity(player, entity) {
  system.run(() => {
    const players = Array.from(world.getPlayers())
    const names = players.map(p => p.name)
    const none = {translate:"action:none"}
    var pool = [none]
    const paletteColor = ["White", "Orange", "Magenta", "LightBlue", "Yellow", "Lime", "Pink", "Gray", "Silver", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"]
    const inventoryType = [{translate: "chestScreen.header.player"}]
    const equipmentType = ["Mainhand", "Offhand", "Head", "Chest", "Legs", "Feet", "Body"]
    if (entity.hasComponent("minecraft:inventory")) {
      pool = pool.concat(inventoryType)
    }
    if (entity.hasComponent("minecraft:equippable")) {
      pool = pool.concat(equipmentType)
    }
    const reg = world.scoreboard.getObjective("cmd:reg")
    const h = entity.getComponent("minecraft:health")
    const f = entity.getComponent("minecraft:onfire")??{onFireTicksRemaining: 0}
    const tags = entity.getTags()
    var effects = entity.getEffects().map(effect => [effect.typeId, effect.duration, effect.amplifier+1])
    if (reg.getScore(player) > 3) {
      var box = new ModalFormData()
      box = box.title({rawtext: [{translate: "ID: "}, {text: entity.typeId}]})
        .textField({translate: "customName"}, {translate: "type:?"}, {defaultValue: entity.nameTag})
        if (h) {
          box.textField({translate: "health"}, {translate: "type:..."}, {tooltip: {translate: "有可能设置失败，留空则恢复默认血量"}, defaultValue: String(h.currentValue)})
        } else {
          box.label({translate: "Cannot read health"})
        }
        box.textField({translate: "commands.tag.description"}, {translate: "type:[]"}, {tooltip: {translate: "方括号的保留是必要的，不同标签应当用半角引号扩起并用逗号隔开"}, defaultValue: JSON.stringify(tags)})
        .textField({translate: "key.mobEffects"}, {translate: "type:[]"}, {tooltip: {translate: "[[效果类型1, 效果时长（数字，若填-1则为无限时长）, 效果等级（数字）, 是否隐藏粒子效果（布尔值，可选）],[效果类型2, 效果时长, 效果等级, 是否隐藏粒子效果]]，最外层的方括号必须保留"}, defaultValue: JSON.stringify(effects)})
        .dropdown({translate: "编辑槽位"}, pool, {tooltip: {translate: "如果不编辑任何槽位，请选action:none。Body槽只适合非人形生物"}, defaultValueIndex: pool.indexOf(none)})
        .textField({translate: "槽位序号"}, {translate: "type:..."}, {tooltip: {translate: "如果指定槽位是单一槽位的槽位类型，则可留空"}})
        .textField({translate: "property"}, {translate: "type:?"}, {tooltip: {translate: "要查看或编辑的属性的ID，留空则略过"}})
        .textField({translate: "onFireTicksRemaining"}, {translate: "type:..."}, {tooltip: {translate: "以游戏刻为单位的实体起火时间，只能为(-2^31+1)*20至(2^31-1)*20之间的整数，若为0则实体不着火"}, defaultValue: String(f.onFireTicksRemaining)})
        .textField({translate: "rotation"}, {translate: "type:JSON"}, {tooltip: {translate: '{"x": 竖直朝向（数字）, "y": 水平朝向（数字）}'}, defaultValue: `{"x": ${entity.getRotation().x}, "y": ${entity.getRotation().y}}`})
        if (entity.hasComponent("minecraft:color")) {
          var c1 = entity.getComponent("minecraft:color")
          box.dropdown({translate: "color1"}, Array.from(paletteColor), {defaultValueIndex: c1.value})
        } else {
          box.label({translate: "No color"})
        }
        if (entity.hasComponent("minecraft:tameable")) {
          var t = entity.getComponent("minecraft:tameable")
          box.dropdown({translate: "选择驯服它的玩家"}, pool.concat(names))
        } else {
          box.label({translate: "Not tameable"})
        }
        if (entity.hasComponent("minecraft:tamemount")) {
          var tm = entity.getComponent("minecraft:tamemount")
          box.dropdown({translate: "选择驯服它的玩家"}, pool.concat(names))
        } else {
          box.label({translate: "Not tamemount"})
        }
        box.toggle({translate: "编辑自定义属性"}, {tooltip: {translate: "如果你不明白这是什么，请不要开启"}})
      box.show(player)
        .then(edit => {
          entity.nameTag = edit.formValues[0]
          if (h) {
            if (edit.formValues[1] !== "") {
              h.setCurrentValue(Number(edit.formValues[1]))
            } else {
              h.resetToDefaultValue()
            }
          }
          tags.forEach(tag => {
            if (!JSON.parse(edit.formValues[2]).includes(tag)) {
              entity.removeTag(tag)
            }
          })
          JSON.parse(edit.formValues[2]).forEach(tag => {
            if (!tags.includes(tag)) {
              entity.addTag(tag)
            }
          })
          if (edit.formValues[3]) {
            entity.runCommand("effect @s clear")
          }
          effects = JSON.parse(edit.formValues[3])
          effects.forEach(effect => {
            entity.runCommand(`effect @s ${effect[0].startsWith("minecraft:")?effect[0].slice(10):effect[0]} ${effect[1] === -1?"infinite":effect[1]} ${effect[2]-1} ${effect[3]??false}`)
          })
          if (equipmentType.includes(pool[edit.formValues[4]])) {
            const e = entity.getComponent("minecraft:equippable")
            var item = e.getEquipment(pool[edit.formValues[4]])
            editItem(player, item, (newItem) => {
              e.setEquipment(pool[edit.formValues[4]], newItem)
            })
          }
          if (inventoryType.includes(pool[edit.formValues[4]])) {
            const c = entity.getComponent("minecraft:inventory").container
            const slot = Number(edit.formValues[5]) ?? 0
            var item = c.getItem(slot)
            editItem(player, item, (newItem) => {
              c.setItem(slot, newItem)
            })
          }
          if (edit.formValues[6] !== "") {
            const propVal = entity.getProperty(edit.formValues[6])
            if (propVal !== undefined) {
              var box = new ModalFormData()
              box = box.title(edit.formValues[6])
                .textField({translate: "属性值"}, {translate: "type:JSON"}, {defaultValue: JSON.stringify(propVal)})
              box.show(player)
                .then(val => {
                  entity.setProperty(edit.formValues[6], JSON.parse(val.formValues[0]))
                })
            } else {
              player.sendMessage({translate: "实体不具有该属性，请查看实体文件中的定义"})
            }
          }
          entity.setOnFire(edit.formValues[7]/20)
          entity.setRotation(JSON.parse(edit.formValues[8]))
          if (c1) {
            c1.value = edit.formValues[9]
          }
          if (t && edit.formValues[10] > 0) {
            t.tame(players[edit.formValues[10]-1])
          }
          if (tm && edit.formValues[11] > 0) {
            tm.tameToPlayer(true, players[edit.formValues[11]-1])
          }
          if (edit.formValues[12]) {
            const p = entity.getDynamicPropertyIds()
            var box = new ModalFormData()
            box = box.title({ translate: "item.customProperties"})
              .dropdown({translate: "dynamicPropertyID"}, p.concat([{translate: "action:+"}]))
            box.show(player)
              .then(select => {
                var box = new ModalFormData()
                if (select.formValues == p.length) {
                  box.textField({translate: "dynamicPropertyID"}, {translate: "type:?"})
                    .textField({translate: "dynamicPropertyValue"}, {translate: "type:JSON"})
                } else {
                  box.label({rawtext:[{translate: "dynamicPropertyID: "}, {text: p[select.formValues]}]})
                    .textField({translate: "dynamicPropertyValue"}, {translate: "type:JSON"}, {defaultValue: JSON.stringify(entity.getDynamicProperty(p[select.formValues]))})
                }
                box.show(player)
                  .then(edit => {
                    if (edit.formValues[0]) {
                      p.push(edit.formValues[0])
                    }
                    entity.setDynamicProperty(p[select.formValues], JSON.parse(edit.formValues[1]))
                  })
              })
          }
        })
    }
  })
};
function editItem(player, item, callback) {
  system.run(() => {
    const lockMode = ["none", "inventory", "slot"]
    if (!item) {
      var box = new ModalFormData()
      box = box.title({ translate: "controller.buttonTip.edit" })
        .textField({translate: "ID"}, {translate: "type:?"}, {tooltip: {translate: "如果某些槽位不支持你设置的物品，你的修改可能不会成功"}})
        .slider({translate: "amount"}, 1, 255, {valueStep: 1})
        .textField({translate: "customName"}, {translate: "type:?"})
        .textField({translate: "lore"},{translate: "type:[]"},{tooltip: {translate: "方括号的保留是必要的，不同行应当用半角引号扩起并用逗号隔开"}, defaultValue: "[]"})
        .toggle({translate: "item.itemLock.keepOnDeath"})
        .dropdown({translate: "lockMode"}, lockMode)
        .textField({translate: "item.canPlace"}, {translate: "type:[]"}, {tooltip: {translate: "方括号的保留是必要的，不同方块的ID应当用半角引号扩起并用逗号隔开"}, defaultValue: "[]"})
        .textField({translate: "item.canBreak"}, {translate: "type:[]"}, {tooltip: {translate: "方括号的保留是必要的，不同方块的ID应当用半角引号扩起并用逗号隔开"}, defaultValue: "[]"})
        .textField({translate: "durability"}, {translate: "type:..."}, {tooltip: {translate: "不应大于所设置物品的最大耐久度，输入max则为最大耐久度"}})
        .textField({translate: "howtoplay.enchantingTable.header.1"}, {translate: "type:[]"}, {tooltip: {translate: "[[附魔类型1, 附魔等级（数字）],[附魔类型2, 附魔等级]]，最外层的方括号必须保留"}, defaultValue: "[]"})
        .divider()
        .header({ translate: "item.customProperties" })
        .textField({translate: "dynamicPropertyID"}, {translate: "type:?"}, {tooltip: {translate: "自定义属性的标识符，如果你不明白这是什么，请留空"}})
        .textField({translate: "dynamicPropertyValue"}, {translate: "type:JSON"}, {tooltip: {translate: "自定义属性的值，如果上面的标识符已填，则该项必填"}})
      box.show(player)
        .then(edit => {
          item = new ItemStack(edit.formValues[0], edit.formValues[1])
          item.nameTag = edit.formValues[2]
          item.setLore(JSON.parse(edit.formValues[3]))
          item.keepOnDeath = edit.formValues[4]
          item.lockMode = lockMode[edit.formValues[5]]
          item.setCanPlaceOn(JSON.parse(edit.formValues[6]))
          item.setCanDestroy(JSON.parse(edit.formValues[7]))
          if (item.hasComponent("minecraft:durability")) {
            var d = item.getComponent("minecraft:durability")
            if (edit.formValues[8] === "max") {
              d.damage = 0
            } else {
              d.damage = d.maxDurability-edit.formValues[8]
            }
          }
          if (item.hasComponent("minecraft:enchantable")) {
            var en = item.getComponent("minecraft:enchantable")
            const enchs = JSON.parse(edit.formValues[9])
            enchs.forEach(ench => {
              en.addEnchantment({type: new EnchantmentType(ench[0]), level: ench[1]})
            })
          }
          if (edit.formValues[12] !== "") {
            item.setDynamicProperty(edit.formValues[12], JSON.parse(edit.formValues[13]))
          }
          callback(item)
        })
    } else {
      var box = new ModalFormData()
      box = box.title({ translate: "controller.buttonTip.edit" })
        .label({rawtext: [{translate: "ID: "}, {text: item.typeId}]})
        .slider({translate: "amount"}, 1, 255, {valueStep: 1, defaultValue: item.amount})
        .textField({translate: "customName"}, {translate: "type:?"}, {defaultValue: item.nameTag})
        .textField({translate: "lore"}, {translate: "type:[]"}, {tooltip: {translate: "方括号的保留是必要的，不同行应当用半角引号扩起并用逗号隔开"}, defaultValue: JSON.stringify(item.getLore())})
        .toggle({translate: "item.itemLock.keepOnDeath"}, {defaultValue: item.keepOnDeath})
        .dropdown({translate: "lockMode"}, lockMode, {defaultValueIndex: lockMode.indexOf(String(item.lockMode))})
        .textField({translate: "item.canPlace"}, {translate: "type:[]"}, {tooltip: {translate: "方括号的保留是必要的，不同方块的ID应当用半角引号扩起并用逗号隔开"}, defaultValue: JSON.stringify(item.getCanPlaceOn())})
        .textField({translate: "item.canBreak"}, {translate: "type:[]"}, {tooltip: {translate: "方括号的保留是必要的，不同方块的ID应当用半角引号扩起并用逗号隔开"}, defaultValue: JSON.stringify(item.getCanDestroy())})
        if (item.hasComponent("minecraft:durability")) {
          var d = item.getComponent("minecraft:durability")
          box.textField({translate: "durability"}, {translate: "type:..."}, {tooltip: {translate: "不应大于所设置物品的最大耐久度，输入max则为最大耐久度"}, defaultValue: String(d.maxDurability-d.damage)})
        } else {
          box.label({translate: "No durability"})
        }
        if (item.hasComponent("minecraft:enchantable")) {
          var en = item.getComponent("minecraft:enchantable")
          var enchs = en.getEnchantments().map(ench => [ench.type.id, ench.level])
          box.textField({translate: "howtoplay.enchantingTable.header.1"}, {translate: "type:[]"}, {tooltip: {translate: "[[附魔类型1, 附魔等级（数字）],[附魔类型2, 附魔等级]]，最外层的方括号必须保留"}, defaultValue: JSON.stringify(enchs)})
        } else {
          box.label({translate: "Not enchantable"})
        }
        if (item.hasComponent("minecraft:book")) {
          var b = item.getComponent("minecraft:book")
          box.slider({translate: "action.interact.write"}, 0, b.pageCount+1, {tooltip: {translate: "选择0则不编辑，滑至相应的页码来编辑相应的页面（滑至最大值则是新建页面）"}, defaultValueIndex: 0})
        } else {
          box.label({translate: "Not book"})
        }
        if (item.hasComponent("minecraft:inventory")) {
          box.textField({translate: "槽位序号"}, {translate: "type:..."}, {tooltip: "若留空，则不编辑物品库存"})
        } else {
          box.label({translate: "No inventory"})
        }
        if (!item.isStackable) {
          box.toggle({translate: "编辑自定义属性"}, {tooltip: {translate: "如果你不明白这是什么，请不要开启"}})
        }
      box.show(player)
        .then(edit => {
          item.amount = edit.formValues[1]
          item.nameTag = edit.formValues[2]
          item.setLore(JSON.parse(edit.formValues[3]))
          item.keepOnDeath = edit.formValues[4]
          item.lockMode = lockMode[edit.formValues[5]]
          item.setCanPlaceOn(JSON.parse(edit.formValues[6]))
          item.setCanDestroy(JSON.parse(edit.formValues[7]))
          if (d) {
            if (edit.formValues[8] === "max") {
              d.damage = 0
            } else {
              d.damage = d.maxDurability-edit.formValues[8]
            }
          }
          if (en) {
            if (edit.formValues[9]) {
              enchs = JSON.parse(edit.formValues[9])
              en.removeAllEnchantments()
              enchs.forEach(ench => {
                en.addEnchantment({type: new EnchantmentType(ench[0]), level: ench[1]})
              })
            }
          }
          if (b) {
            if (edit.formValues[10] && edit.formValues[10] !== 0) {
              bookEditor(edit.formValues[10], item, player, (newBook) => {
                callback(newBook)
              })
            }
          }
          if (edit.formValues[11] && edit.formValues[11] !== "") {
            const c = item.getComponent("minecraft:inventory").container
            var innerItem = c.getItem(Number(edit.formValues[11]))
            const fix = item
            editItem(player, innerItem, (newItem) => {
              fix.getComponent("minecraft:inventory").container.setItem(Number(edit.formValues[11]), newItem)
              callback(fix)
            })
          }
          if (edit.formValues[12]) {
            const p = item.getDynamicPropertyIds()
            var box = new ModalFormData()
            box = box.title({ translate: "item.customProperties"})
              .dropdown({translate: "dynamicPropertyID"}, p.concat([{translate: "action:+"}]))
            box.show(player)
              .then(select => {
                var box = new ModalFormData()
                if (select.formValues == p.length) {
                  box.textField({translate: "dynamicPropertyID"}, {translate: "type:?"})
                    .textField({translate: "dynamicPropertyValue"}, {translate: "type:JSON"})
                } else {
                  box.label({rawtext: [{translate: "dynamicPropertyID: "}, {text: p[select.formValues]}]})
                    .textField({translate: "dynamicPropertyValue"}, {translate: "type:JSON"}, {defaultValue: JSON.stringify(item.getDynamicProperty(p[select.formValues]))})
                }
                box.show(player)
                  .then(edit => {
                    if (edit.formValues[0]) {
                      p.push(edit.formValues[0])
                    }
                    item.setDynamicProperty(p[select.formValues], JSON.parse(edit.formValues[1]))
                    callback(item)
                  })
              })
          }
          callback(item)
        })
    }
  })
};
function bookEditor(pageNum, item, player, callback) {
  const book = item.getComponent("minecraft:book")
  var oprs = [{translate:"action:none"}, {translate: "向上新建页面？"}, {translate: "向下新建页面？"}]
  const del = {translate: "删除此页面"}
  const up = { translate: "createWorld.customize.custom.prev"}
  const down = { translate: "createWorld.customize.custom.next" }
  if (pageNum !== 1) {
    oprs = oprs.concat(up)
  }
  if (pageNum < book.pageCount) {
    oprs = oprs.concat(down)
  }
  if (book.pageCount !== 0) {
    oprs = oprs.concat(del)
  }
  var box = new ModalFormData()
  box = box.title({translate: "item.written_book.name"})
    .textField({translate: "portfolioScreen.page", with: [String(pageNum)]}, {translate: "type:JSON"}, {defaultValue: book.getPageContent(pageNum-1)??`{"rawtext":[${JSON.stringify(book.getRawPageContent(pageNum-1)??{})}]}`})
    .dropdown({translate: "操作页面"}, oprs, {tooltip: {translate: "如果在书籍页数已达50时新建页面，则不会成功；选择action:none则不做额外操作"}})
  if (book.isSigned) {
    box.label({rawtext: [{translate: "book.byAuthor"}, {text: book.author+"；"}, {translate: "book.editTitle"}, {text: book.title}]})
  } else {
    box.textField({translate: "book.signButton"}, {translate: "type:[]"}, {tooltip: {translate: '["作者名", "书名"]，若留空，则不签名'}})
  }
  box.show(player)
    .then(b => {
      book.setPageContent(pageNum-1, b.formValues[0])
      if (b.formValues[1] === 1) {
        book.insertPage(pageNum-2, "")
        bookEditor(pageNum-1, item, player, (newBook) => callback(newBook))
      }
      if (b.formValues[1] === 2) {
        book.insertPage(pageNum, "")
        bookEditor(pageNum+1, item, player, (newBook) => callback(newBook))
      }
      if (b.formValues[1] === oprs.indexOf(del)) {
        book.removePage(pageNum-1)
      }
      if (b.formValues[1] === oprs.indexOf(up)) {
        bookEditor(pageNum-1, item, player, (newBook) => callback(newBook))
      }
      if (b.formValues[1] === oprs.indexOf(down)) {
        bookEditor(pageNum+1, item, player, (newBook) => callback(newBook))
      }
      if (b.formValues[2]??"" !== "") {
        const overwrite = JSON.parse(b.formValues[2])
        book.signBook(overwrite[1], overwrite[0])
      }
      callback(item)
    })
};
function joinInspect(player) {
  player.camera.setCamera("custom:free_inspect", {location: player.location, rotation: player.getRotation()})
  player.setDynamicProperty("inspect:pre_pos", player.location)
  player.inputPermissions.setPermissionCategory(2, false)
};
function exitInspect(player) {
  player.removeTag("cmd:inspect")
  player.camera.clear()
  player.setDynamicProperty("inspect:pre_pos", null)
  player.inputPermissions.setPermissionCategory(2, true)
};
function cmdBox(player) {
  const reg = world.scoreboard.getObjective("cmd:reg")
  var box = new ActionFormData()
  box = box.body({ translate: "advMode.setCommand" })
    .title({ translate: "key.command" })
    .button({ translate: "advMode.command" })
    .button({ translate: "管理注册表" })
    .button({ translate: "hostOption.codeBuilder" })
    .button({ translate: "howtoplay.encyclopedia" })
    .button({ translate: "createWorldScreen.game.settings" })
    .button({ translate: "传送锚点" })
    .button({ translate: "menu.editorMode" })
    .button({ translate: "灵魂出窍"})
  box.show(player)
    .then((val) => {
      switch (val.selection) {
        case 0:
          if (reg.getScore(player) > 3 || player.hasTag("cmd:owner")) {
            var box = new ModalFormData()
            box = box.title({ translate: "howtoplay.commands" })
              .textField({translate: "key.command"}, {translate:"furnaceScreen.input"})
            box.show(player)
              .then((val) => {
                player.runCommand(`${val.formValues[0]}`)
              })
          }
        break
        case 1:
          if (player.hasTag("cmd:owner")) {
            const list = reg.getParticipants()
            var box = new ModalFormData()
            box = box.title({translate: "选择要编辑的注册项"})
              .dropdown({translate: "jigsaw.title.name"}, list.map(t => t.displayName))
            box.show(player)
              .then((opt) => {
                const p = list[opt.formValues[0]]
                const ver = regVerify(p.displayName)
                var box = new ModalFormData()
                box = box.title({ translate: "options.edit" })
                  .label({rawtext: [{translate: "注册项类型："}, {text: p.type}]})
                if (p.type === "FakePlayer") {
                  if (ver.type === "root") {
                    var tips1 = {translate: "该注册项为系统设置项，请从世界设置功能分区修改，如果一定要修改请在世界设置中的数值范围内选择"}
                    var tips2 = {translate: "布尔值0或1，枚举值最低为0最高为项数-1，滑块数值的范围就是数据的范围"}
                  }
                  if (ver.type === "cd") {
                    var tips1 = {rawtext: [{translate: "该注册项为"}, {text: ver.name}, {translate: "的计时项初始值"}]}
                    var tips2 = {translate: "这里是以随机刻为单位存储的时间"}
                  }
                  if (ver.type === "pos") {
                    var tips1 = {translate: "该注册项为传送锚点的设置项，请尽量在世界设置中修改"}
                    var tips2 = {translate: "开关为0或1，玩家权限等级只有0至5六个数字可选"}
                  }
                  if (ver.type === "pos_owner") {
                    var tips1 = {rawtext: [{translate:"该注册项为传送锚点存储项的主键，"}, {text:ver.id}, {translate:"为传送锚点拥有者的ID，"}, {text:ver.name}, {translate:"为传送锚点的名称"}]}
                    var tips2 = {translate: "数值是锚点创建时玩家的权限等级，这代表了传送锚点本身的等级"}
                  }
                  if (ver.type?.startsWith("pos_") && ver.type !== "pos_owner") {
                    var tips1 = {rawtext: [{translate:"该注册项为传送锚点的存储项，"}, {text:ver.name}, {translate:"为传送锚点名称"}]}
                    if (ver.type === "pos_dim") {
                      var tips2 = {translate: "0为主世界，1为地狱，2为末地"}
                    } else {
                      var tips2 = {translate: "数值是相应的坐标值"}
                    }
                  }
                  if (ver.type === "iban") {
                    var tips1 = {translate: "该注册项为禁物品注册项，正确的格式需要在冒号后边加上封禁物品的标识符"}
                    var tips2 = {rawtext: [{translate: "该值应该为"}, {text: ver.name}, {translate: "的有效数据值或-1"}]}
                  }
                  if (ver.type === "eban") {
                    var tips1 = {translate: "该注册项为禁实体注册项，正确的格式需要在冒号后边加上封禁实体的标识符或族标签或名称"}
                    var tips2 = {translate: "0为标识符，1为族标签，2为名称"}
                  }
                  if (ver.type === "eban_fixed") {
                    var tips1 = {translate: "该注册项为禁实体注册项，正确的格式需要在冒号后边加上封禁实体的名称"}
                    var tips2 = {translate: "这是修正注册项，值无效"}
                  }
                  if (ver.type === "display") {
                    var tips1 = {translate: "某些显示设置，可能消耗性能"}
                    var tips2 = {translate: "布尔值0或1，枚举值最低为0最高为项数-1，滑块数值的范围就是数据的范围"}
                  }
                  if (ver.type === "free_cam") {
                    var tips1 = {translate: "该注册项为灵魂出窍的设置项"}
                    var tips2 = {translate: "布尔值0或1，枚举值最低为0最高为项数-1，滑块数值的范围就是数据的范围"}
                  }
                  if (ver.type === null) {
                    var tips1 = {translate: "这个注册项没有定义，你是想存储一个自定义注册项吗？"}
                    var tips2 = ""
                  }
                  box.textField({translate: "注册项名称"}, {translate: "type:?"}, {tooltip: tips1, defaultValue: p.displayName})
                } else {
                  if (p.type === "Player") {
                    var tips2 = {translate: "修改玩家的权限等级，应该为0至5（包括边界）的整数"}
                  }
                  if (p.type === "Entity") {
                    var tips2 = {translate: "这个注册项没有定义，你是想存储一个自定义注册项吗？"}
                  }
                  box.label({rawtext: [{translate: "注册项名称："}, {text: p.displayName}]})
                }
                box.textField({translate: "注册项的值"}, {translate: "type:..."}, {tooltip: tips2, defaultValue: String(reg.getScore(p))})
                  .toggle({translate: "删除注册项"}, {tooltip: {translate: "如果你不知道自己在做什么，不要开启这个开关！"}})
                box.show(player)
                  .then(mod => {
                    if (mod.formValues[3]) {
                      reg.removeParticipant(p)
                    } else {
                      if (p.type === "FakePlayer" && p.displayName !== mod.formValues[1]) {
                        if (reg.hasParticipant(mod.formValues[1])) {
                          var box = new MessageFormData()
                          box = box.title({ translate: "createWorld.customize.custom.confirmTitle" })
                            .body({translate: "已经存在另一个拥有该名称的注册项，你确定要覆盖并合并这两个注册项吗？"})
                            .button1({ translate: "gui.no" })
                            .button2({ translate: "gui.yes" })
                          box.show(player)
                            .then(conf => {
                              if (Boolean(conf.selection)) {
                                reg.setScore(mod.formValues[1], Number(mod.formValues[2]))
                                reg.removeParticipant(p)
                              } else {
                                reg.setScore(p, Number(mod.formValues[2]))
                                player.sendMessage({translate: "仅应用了对注册项值的更改"})
                              }
                            })
                        } else {
                          reg.setScore(mod.formValues[1], Number(mod.formValues[2]))
                          reg.removeParticipant(p)
                        }
                      } else {
                        reg.setScore(p, Number(mod.formValues[2]))
                      }
                    }
                  })
              })
          }
        break
        case 2:
          var box = new ActionFormData()
          box = box.body({ translate: "hostOption.codeBuilder" })
            .title({ translate: "howtoplay.commands"})
            .button({ translate: "selectWorld.gameMode" })
            .button({ translate: "tile.bed.respawnSet" })
            .button({ translate: "hostOption.teleport" })
            .button({ translate: "hostOption.time" })
            .button({ translate: "hostOption.weather" })
            .button({ translate: "key.mobEffects" })
            .button({ translate: "commands.gamerule.description" })
          box.show(player)
            .then((val) => {
              if (val.selection == 0 && reg.getScore(player) > 1) {
                var box = new ModalFormData()
                box = box.title({ translate: "selectWorld.gameMode" })
                  .dropdown({translate: "selectWorld.gameMode"}, [{translate: "selectWorld.gameMode.adventure"}, {translate: "selectWorld.gameMode.creative"}, {translate: "selectWorld.gameMode.spectator"}, {translate: "selectWorld.gameMode.survival"}])
                box.show(player)
                  .then((mode) => {
                    const pool = ["Adventure", "Creative", "Spectator", "Survival"]
                    player.setGameMode(pool[mode.formValues[0]])
                  })
              }
              if (val.selection == 1) {
                const choice = reg.getScore(player) > 1? [{translate: "tile.respawn_anchor.respawnSet"}, {translate: "hostOption.setWorldSpawn"}] : [{translate: "tile.respawn_anchor.respawnSet"}]
                var box = new ModalFormData()
                box = box.title({ translate: "tile.bed.respawnSet" })
                  .dropdown({translate: "tile.bed.respawnSet"}, choice)
                  .textField({translate: "key.copyCoordinates"}, {translate: "type:?"})
                box.show(player)
                  .then((spawn) => {
                    const pool = ["spawnpoint @s", "setworldspawn"]
                    player.runCommand(`${pool[spawn.formValues[0]]} ${spawn.formValues[1]}`)
                  })
              }
              if (val.selection == 2) {
                var box = new ModalFormData()
                if (reg.getScore(player) > 1) {
                  box = box.title({ translate: "hostOption.teleport" })
                    .textField({translate: "hostOption.teleport.who"}, {translate: "type:@"})
                    .textField({translate: "hostOption.teleport.where"}, {translate: "type:@"})
                  box.show(player)
                    .then((obj) => {
                      player.runCommand(`tp ${obj.formValues[0]} ${obj.formValues[1]}`)
                    })
                } else {
                  let players = Array.from(world.getPlayers())
                  const pool = players.map(t => t.name)
                  box = box.title({ translate: "hostOption.teleport" })
                    .dropdown({translate: "hostOption.teleport.who"}, pool)
                    .dropdown({translate: "hostOption.teleport.where"}, pool)
                  box.show(player)
                    .then((obj) => {
                      player.runCommand(`tp ${pool[obj.formValues[0]]} ${pool[obj.formValues[1]]}`)
                    })
                }
              }
              if (val.selection == 3) {
                var box = new ModalFormData()
                box = box.title({ translate: "hostOption.time" })
                  .dropdown({translate: "hostOption.time"}, [{translate: "hostOption.time.day"}, {translate: "hostOption.time.midnight"}, {translate: "hostOption.time.noon"}, {translate: "hostOption.time.night"}, {translate: "hostOption.time.sunrise"}, {translate: "hostOption.time.sunset"}])
                box.show(player)
                  .then((time) => {
                    const pool = ["day", "midnight", "noon", "night", "sunrise", "sunset"]
                    player.runCommand(`time set ${pool[time.formValues[0]]}`)
                  })
              }
              if (val.selection == 4) {
                var box = new ModalFormData()
                box = box.title({ translate: "hostOption.weather" })
                  .dropdown({translate: "hostOption.weather"}, [{translate: "hostOption.weather.clear"}, {translate: "hostOption.weather.rain"}, {translate: "hostOption.weather.thunderstorm"}])
                box.show(player)
                  .then((weather) => {
                    const pool = ["clear", "rain", "thunder"]
                    player.runCommand(`weather ${pool[weather.formValues[0]]}`)
                  })
              }
              if (val.selection == 5 && reg.getScore(player) > 2) {
                var box = new ModalFormData()
                box = box.title({ translate: "key.mobEffects" })
                  .textField({translate: "hostOption.teleport.who"}, {translate: "type:@"})
                  .textField({translate: "key.mobEffects"}, {translate: "type:?"})
                  .textField({translate: "commands.schedule.delay.negativeTime"}, {translate: "type:..."}, {defaultValue: "infinite"})
                  .slider({translate: "generator.amplified"}, 0, 255, {valueStep: 1})
                  .toggle({ translate: "commands.spawnParticleEmitter.description" })
                box.show(player)
                  .then((effect) => {
                    player.runCommand(`effect ${effect.formValues[0]} ${effect.formValues[1]} ${effect.formValues[2]} ${effect.formValues[3]} ${effect.formValues[4]}`)
                  })
              }
              if (val.selection == 6 && reg.getScore(player) > 1) {
                var box = new ModalFormData()
                box = box.title({ translate: "commands.gamerule.description" })
                  .dropdown({translate: "howtoplay.gameSettings.header.2"}, [{translate:"commandblockoutput"},{translate:"createWorldScreen.daylightcycle"},{translate:"createWorldScreen.entitiesdroploot"},{translate:"createWorldScreen.fireSpreads"},{translate:"createWorldScreen.recipesUnlock"},{translate:"dolimitedcrafting"},{translate:"createWorldScreen.mobLoot"},{translate:"createWorldScreen.mobSpawn"},{translate:"createWorldScreen.tileDrops"},{translate:"createWorldScreen.weathercycle"},{translate:"drowningdamage"},{translate:"falldamage"},{translate:"firedamage"},{translate:"createWorldScreen.keepInventory"},{translate:"createWorldScreen.locatorBar"},{translate:"createWorldScreen.mobgriefing"},{translate:"createWorldScreen.pvp"},{translate:"createWorldScreen.showCoordinates"},{translate:"createWorldScreen.showDaysPlayed"},{translate:"createWorldScreen.naturalregeneration"},{translate:"createWorldScreen.tntexplodes"},{translate:"sendcommandfeedback"},{translate:"doinsomnia"},{translate:"createWorldScreen.commandblocksenabled"},{translate:"createWorldScreen.immediaterespawn"},{translate:"showdeathmessages"},{translate:"showtags"},{translate:"freezedamage"},{translate:"createWorldScreen.respawnblocksexplode"},{translate:"showbordereffect"},{translate:"showrecipemessages"},{translate:"projectilescanbreakblocks"},{translate:"tntexplosiondropdecay"},{translate:"..."}])
                  .toggle("T/F")
                box.show(player)
                  .then((rule) => {
                    if (rule.formValues[0] <= 32) {
                      const pool = ["commandblockoutput","dodaylightcycle","doentitydrops","dofiretick","recipesunlock","dolimitedcrafting","domobloot","domobspawning","dotiledrops","doweathercycle","drowningdamage","falldamage","firedamage","keepinventory","locatorbar","mobgriefing","pvp","showcoordinates","showdaysplayed","naturalregeneration","tntexplodes","sendcommandfeedback","doinsomnia","commandblocksenabled","doimmediaterespawn","showdeathmessages","showtags","freezedamage","respawnblocksexplode","showbordereffect","showrecipemessages","projectilescanbreakblocks","tntexplosiondropdecay"]
                      player.runCommand(`gamerule ${pool[rule.formValues[0]]} ${rule.formValues[1]}`)
                    };
                    if (rule.formValues[0] == 33) {
                      var box = new ModalFormData()
                      box = box.title({translate: "..."})
                        .dropdown({translate: "..."}, [{translate: "maxcommandchainlength"}, {translate: "createWorldScreen.randomtickspeed"}, {translate: "functioncommandlimit"}, {translate: "createWorldScreen.respawnRadius"}, {translate: "createWorldScreen.playerSleepPercentage"}])
                        .textField({translate: "commands.schedule.delay.negativeTime"}, {translate: "type:..."})
                      box.show(player)
                        .then((rule) => {
                          const pool = ["maxcommandchainlength", "randomtickspeed", "functioncommandlimit", "spawnradius", "playerssleepingpercentage"]
                          player.runCommand(`gamerule ${pool[rule.formValues[0]]} ${rule.formValues[1]}`)
                        })
                    };
                  })
              }
            })
        break
        case 3:
          var box = new ModalFormData()
          box = box.title({ translate: "howtoplay.encyclopedia" })
            .dropdown({translate: "portfolioScreen.page", with: ["?"]}, ["aimassist","alwaysday","camera","camerashake","clear","clearspawnpoint","clone","damage","daylock","dialogue","difficulty","effect","enchant","event","execute","fill","fog","gamemode","gamerule","give","hud","kill","locate","loot","mobevent","music","particle","place","playanimation","playsound","recipe","replaceitem","ride","say","scoreboard","setblock","setworldspawn","spawnpoint","spreadplayers","stopsound","structure","summon","tag","teleport(tp)","testfor","testforblock","testforblocks","tickingarea","time","title","titleraw","toggledownfall","weather","xp","cmd:dynamicproperty"])
          box.show(player)
            .then((help) => {
              const pool = [
                "aimassist <players: target> clear \naimassist <players: target> set [x angle: float] [y angle: float] [max distance: float] [target mode: AimAssistTargetMode] [preset id: string]",
                "alwaysday [lock: Boolean]",
                "camera <players: target> set <preset: CameraPresets> ease <easeTime: float> <easeType: Easing> pos <position: x y z> rot <xRot: rotation> <yRot: rotation> \ncamera <players: target> set <preset: CameraPresets> ease <easeTime: float> <easeType: Easing> pos <position: x y z> facing <lookAtEntity: target|lookAtPosition: x y z> \ncamera <players: target> set <preset: CameraPresets> ease <easeTime: float> <easeType: Easing> pos <position: x y z> \ncamera <players: target> set <preset: CameraPresets> ease <easeTime: float> <easeType: Easing> rot <xRot: rotation> <yRot: rotation> \ncamera <players: target> set <preset: CameraPresets> ease <easeTime: float> <easeType: Easing> facing <lookAtEntity: target|lookAtPosition: x y z> \ncamera <players: target> set <preset: CameraPresets> ease <easeTime: float> <easeType: Easing> [default: default] \ncamera <players: target> set <preset: CameraPresets> pos <position: x y z> rot <xRot: rotation> <yRot: rotation> \ncamera <players: target> set <preset: CameraPresets> pos <position: x y z> facing <lookAtEntity: target|lookAtPosition: x y z> \ncamera <players: target> target_entity <entity: target> [target_center_offset] [xTargetCenterOffset: float] [yTargetCenterOffset: float] [zTargetCenterOffset: float] \ncamera <players: target> remove_target \ncamera <players: target> set <preset: CameraPresets> view_offset <xViewOffset: float> <yViewOffset: float> \ncamera <players: target> set <preset: CameraPresets> entity_offset <xEntityOffset: float> <yEntityOffset: float> <zEntityOffset: float> \ncamera <players: target> set <preset: CameraPresets> rot <xRot: rotation> <yRot: rotation> view_offset <xViewOffset: float> <yViewOffset: float> \ncamera <players: target> set <preset: CameraPresets> rot <xRot: rotation> <yRot: rotation> entity_offset <xEntityOffset: float> <yEntityOffset: float> <zEntityOffset: float> \ncamera <players: target> set <preset: CameraPresets> view_offset <xViewOffset: float> <yViewOffset: float> entity_offset <xEntityOffset: float> <yEntityOffset: float> <zEntityOffset: float> \ncamera <players: target> set <preset: CameraPresets> rot <xRot: rotation> <yRot: rotation> view_offset <xViewOffset: float> <yViewOffset: float> entity_offset <xEntityOffset: float> <yEntityOffset: float> <zEntityOffset: float> \ncamera <players: target> set <preset: CameraPresets> pos <position: x y z> \ncamera <players: target> set <preset: CameraPresets> rot <xRot: rotation> <yRot: rotation> \ncamera <players: target> set <preset: CameraPresets> facing <lookAtEntity: target|lookAtPosition: x y z> \ncamera <players: target> set <preset: CameraPresets> [default: default] \ncamera <players: target> clear \ncamera <players: target> fade time <fadeInSeconds: float> <holdSeconds: float> <fadeOutSeconds: float> color <red: int> <green: int> <blue: int> \ncamera <players: target> fade time <fadeInSeconds: float> <holdSeconds: float> <fadeOutSeconds: float> \ncamera <players: target> fade color <red: int> <green: int> <blue: int> \ncamera <players: target> fade",
                "camerashake add <player: target> [intensity: float] [seconds: float] [shakeType: positional|rotational] \ncamerashake stop [player: target]",
                "clear [player: target] [itemNmae: item] [data: int] [maxCount: int]",
                "clearspawnpoint [player: target]",
                "clone <begin: x y z> <end: x y z> <destination: x y z> [maskMode: replace|masked] [cloneMode: force|move|normal] \nclone <begin: x y z> <end: x y z> <destination: x y z> filtered <cloneMode: force|move|normal> <tileName: Block> [blockStates: blockproperties]",
                "damage <target: target> <amount: int> [cause: DamageCause] \ndamage <target: target> <amount: int> <cause: DamageCause> entity <damager: target>",
                "daylock [lock: Boolean]",
                "dialogue open <npc: target> <player: target> [sceneName: string] \ndialogue change <npc: target> <sceneName: string> [players: target]",
                "difficulty <difficulty: p:peaceful|e:easy|n:normal|h:hard> \ndifficulty <difficulty: int>",
                "effect <player: target> clear [effect: Effect] \neffect <player: target> <effect: Effect> [seconds: int|infinite] [amplifier: int] [hideParticles: Boolean]",
                "enchant <player: target> <enchantmentName: Enchant> [level: int] \nenchant <player: target> <enchantmentId: int> [level: int]",
                "event entity <target: target> <eventName: EntityEvents>",
                "execute run <command: command> \nexecute <if|unless> score <target: target> <objective: ScoreboardObjectives> matches <range: fullintegerrange> [chainedCommand: executechainedoption_0] \nexecute <if|unless> score <target: target> <objective: ScoreboardObjectives> <operation: compareoperator> <source: target> <objective: ScoreboardObjectives> [chainedCommand: executechainedoption_0] \nexecute <if|unless> entity <target: target> [chainedCommand: executechainedoption_0] \nexecute <if|unless> blocks <begin: x y z> <end: x y z> <destination: x y z> <scan mode: BlocksScanMode> [chainedCommand: executechainedoption_0] \nexecute <if|unless> block <position: x y z> <block: Block> <blockStates: block properties> [chainedCommand: executechainedoption_0] \nexecute <if|unless> block <position: x y z> <block: Block> [chainedCommand: executechainedoption_0] \nexecute anchored <anchored: ActorLocation> <chainedCommand: executechainedoption_0> \nexecute align <axes: string> <chainedCommand: executechainedoption_0> \nexecute facing entity <origin: target> <anchor: ActorLocation> <chainedCommand: executechainedoption_0> \nexecute facing <position: x y z> <chainedCommand: executechainedoption_0> \nexecute rotated as <origin: target> <chainedCommand: executechainedoption_0> \nexecute rotated <yaw: rotation> <pitch: rotation> <chainedCommand: executechainedoption_0> \nexecute positioned as <origin: target> <chainedCommand: executechainedoption_0> \nexecute positioned <position: x y z> <chainedCommand: executechainedoption_0> \nexecute in <dimension: Dimension> <chainedCommand: executechainedoption_0> \nexecute at <origin: target> <chainedCommand: executechainedoption_0> \nexecute as <origin: target> <chainedCommand: executechainedoption_0>",
                "fill <from: x y z> <to: x y z> <tileName: Block> <blockStates: block properties> [oldBlockHandling: FillMode] \nfill <from: x y z> <to: x y z> <tileName: Block> [oldBlockHandling: hollow|destroy|keep|outline] \nfill <from: x y z> <to: x y z> <tileName: Block> [blockStates: block properties] replace [replaceTileName: Block] [replaceBlockStates: block properties]",
                "fog <victim: target> push <fogId: string> <userProvidedId: string> \nfog <victim: target> <mode: pop|remove> <userProvidedId: string>",
                "gamemode <gameMode: GameMode> [player: target] \ngamemode <gameMode: int> [player: target]",
                "gamerule \ngamerule <rule: BoolGameRule> [value: Boolean] \ngamerule <rule: IntGameRule> [value: int]",
                "give <player: target> <itemName: Item> [amount: int] [data: int] [components: json]",
                "hud <target: target> <visible: hide|reset> [hud_element: HudElement]",
                "kill [target: target]",
                "locate structure <structure: StructureFeature> [useNewChunksOnly: Boolean] \nlocate biome <biome: Biome>",
                "loot spawn <position: x y z> loot <loot_table: string> [<tool>|mainhand|offhand: Tool] \nloot spawn <position: x y z> kill <entity: target> [<tool>|mainhand|offhand: Tool] \nloot spawn <position: x y z> mine <TargetBlockPosition: x y z> [<tool>|mainhand|offhand: Tool] \nloot give <players: target> loot <loot_table: string> [<tool>|mainhand|offhand: Tool] \nloot give <players: target> kill <entity: target> [<tool>|mainhand|offhand: Tool] \nloot give <players: target> mine <TargetBlockPosition: x y z> [<tool>|mainhand|offhand: Tool] \nloot insert <position: x y z> loot <loot_table: string> [<tool>|mainhand|offhand: Tool] \nloot insert <position: x y z> kill <entity: target> [<tool>|mainhand|offhand: Tool] \nloot insert <position: x y z> mine <TargetBlockPosition: x y z> [<tool>|mainhand|offhand: Tool] \nloot replace entity <entity: target> <slotType: EntityEquipmentSlot> <slotId: int> <count: int> loot <loot_table: string> [<tool>|mainhand|offhand: Tool] \nloot replace entity <entity: target> <slotType: EntityEquipmentSlot> <slotId: int> loot <loot_table: string> [<tool>|mainhand|offhand: Tool] \nloot replace entity <entity: target> <slotType: EntityEquipmentSlot> <slotId: int> <count: int> kill <entity: target> [<tool>|mainhand|offhand: Tool] \nloot replace entity <entity: target> <slotType: EntityEquipmentSlot> <slotId: int> kill <entity: target> [<tool>|mainhand|offhand: Tool] \nloot replace entity <entity: target> <slotType: EntityEquipmentSlot> <slotId: int> <count: int> mine <TargetBlockPosition: x y z> [<tool>|mainhand|offhand: Tool] \nloot replace entity <entity: target> <slotType: EntityEquipmentSlot> <slotId: int> mine <TargetBlockPosition: x y z> [<tool>|mainhand|offhand: Tool] \nloot replace block <position: x y z> slot.container <slotId: int> <count: int> loot <loot_table: string> [<tool>|mainhand|offhand: Tool] \nloot replace block <position: x y z> slot.container <slotId: int> loot <loot_table: string> [<tool>|mainhand|offhand: Tool] \nloot replace block <position: x y z> slot.container <slotId: int> <count: int> kill <entity: target> [<tool>|mainhand|offhand: Tool] \nloot replace block <position: x y z> slot.container <slotId: int> kill <entity: target> [<tool>|mainhand|offhand: Tool] \nloot replace block <position: x y z> slot.container <slotId: int> <count: int> mine <TargetBlockPosition: x y z> [<tool>|mainhand|offhand: Tool] \nloot replace block <position: x y z> slot.container <slotId: int> mine <TargetBlockPosition: x y z> [<tool>|mainhand|offhand: Tool]",
                "mobevent <event: MobEvent> [value: Boolean]",
                "music queue <trackName: string> [volume: float] [fadeSeconds: float] [repeatMode: MusicRepeatMode] \nmusic play <trackName: string> [volume: float] [fadeSeconds: float] [repeatMode: MusicRepeatMode] \nmusic stop [fadeSeconds: float] \nmusic volume <volume: float>",
                "particle <effect: string> [position: x y z]",
                "place structure <structure: JigsawStructure> [pos: x y z] [ignoreStartHeight: Boolean] [keepJigsaws: Boolean] [includeEntities: Boolean] \nplace jigsaw <pool: filepath> <jigsawTarget: string> <maxDepth: int> [pos: x y z] [keepJigsaws: Boolean] [includeEntities: Boolean] \nplace feature <feature: features> [position: x y z] \nplace featurerule <featurerule: featureRules> [position: x y z]",
                "playanimation <entity: target> <animation: string> [next_state: string] [blend_out_time: float] [stop_expression: string] [controller: string]",
                "playsound <sound: string> [player: target] [position: x y z] [volume: float] [pitch: float] [minimumVolume: float]",
                "recipe give <player: target> <recipe: UnlockableRecipeValues> \nrecipe take <player: target> <recipe: UnlockableRecipeValues>",
                "replaceitem block <position: x y z> slot.container <slotId: int> [oldItemHandling: ReplaceMode] <itemName: Item> [amount: int] [data: int] [components: json] \nreplaceitem entity <target: target> <slotType: EntityEquipmentSlot> <slotId: int> [oldItemHandling: ReplaceMode] <itemName: Item> [amount: int] [data: int] [components: json]",
                "ride <riders: target> start_riding <ride: target> [teleportRules: TeleportRules] [howToFill: FillType] \nride <riders: target> stop_riding \nride <rides: target> evict_riders \nride <rides: target> summon_rider <entityType: EntityType> [spawnEvent: string] [nameTag: string] \nride <riders: target> summon_ride <entityType: EntityType> [rideRules: RideRules] [spawnEvent: string] [nameTag: string]",
                "say <message: message>",
                "scoreboard objectives add <objective: ScoreboardObjectives> dummy [displayName: string] \nscoreboard objectives remove <objective: ScoreboardObjectives> \nscoreboard objectives list \nscoreboard objectives setdisplay <displaySlot: list|sidebar> [objective: ScoreboardObjectives] [sortOrder: ascending|descending] \nscoreboard objectives setdisplay belowname [objective: ScoreboardObjectives] \nscoreboard players list [playername: target] \nscoreboard players reset <player: target> [objective: ScoreboardObjectives] \nscoreboard players test <player: target> <objective: ScoreboardObjectives> <min: wildcard int> [max: wildcard int] \nscoreboard players random <player: target> <objective: ScoreboardObjectives> <min: int> <max: int> \nscoreboard players <action: ScoreboardPlayersNumAction> <player: target> <objective: ScoreboardObjectives> <count: int> \nscoreboard players operation <targetName: target> <targetObjective: ScoreboardObjectives> <operation: operator> <selector: target> <objective: ScoreboardObjectives>",
                "setblock <position: x y z> <tileName: Block> [blockStates: block properties] [oldBlockHandling: replace|destroy|keep]",
                "setworldspawn [spawnPoint: x y z]",
                "spawnpoint [player: target] [spawnPos: x y z]",
                "spreadplayers <x: rotation> <z: rotation> <spreadDistance: float> <maxRange: float> <victim: target> [maxHeight: rotation]",
                "stopsound <player: target> [sound: string]",
                "structure save <name: string> <from: x y z> <to: x y z> [includeEntities: Boolean] [saveMode: StructureSaveMode] [includeBlocks: Boolean] \nstructure delete <name: string> \nstructure load <name: string> <to: x y z> [rotation: Rotation] [mirror: Mirror] [animationMode: StructureAnimationMode] [animationSeconds: float] [includeEntities: Boolean] [includeBlocks: Boolean] [waterlogged: Boolean] [integrity: float] [seed: string]",
                "summon <entityType: EntityType> [spawnPos: x y z] [yRot: rotation] [xRot: rotation] [spawnEvent: EntityEvents] [nameTag: string] \nsummon <entityType: EntityType> <nameTag: string> [spawnPos: x y z] \nsummon <entityType: EntityType> [spawnPos: x y z] facing <lookAtPosition: x y z> [spawnEvent: EntityEvents] [nameTag: string] \nsummon <entityType: EntityType> [spawnPos: x y z] facing <lookAtEntity: target> [spawnEvent: EntityEvents] [nameTag: string]",
                "tag <entity: target> <action: add|remove> <name: TagValues> \ntag <entity: target> list",
                "teleport [victim: target] <destination: x y z> [checkForBlocks: Boolean] \nteleport [victim: target] <destination: x y z> [yRot: rotation] [xRot: rotation] [checkForBlocks: Boolean] \nteleport [victim: target] <destination: x y z> facing <lookAtPosition: x y z> [checkForBlocks: Boolean] \nteleport [victim: target] <destination: x y z> facing <lookAtEntity: target> [checkForBlocks: Boolean] \nteleport [victim: target] <destination: target> [checkForBlocks: Boolean]",
                "testfor <victim: target>",
                "testforblock <position: x y z> <tileName: Block> [blockStates: block properties]",
                "testforblocks <begin: x y z> <end: x y z> <destination: x y z> [mode: TestForBlocksMode]",
                "tickingarea add <from: x y z> <to: x y z> [name: string] [preload: Boolean] \ntickingarea add circle <center: x y z> <radius: int> [name: string] [preload: Boolean] \ntickingarea remove <position: x y z> \ntickingarea remove <name: string> \ntickingarea remove_all \ntickingarea list [all-dimensions: AllDimensions] \ntickingarea preload <position: x y z> [preload: Boolean] \ntickingarea preload <name: string> [preload: Boolean]",
                "time add <amount: int> \ntime set <amount: int> \ntime set <time: TimeSpec> \ntime query <time: TimeQuery>",
                "title <player: target> clear \ntitle <player: target> reset \ntitle <player: target> <titleLocation: title|subtitle|actionbar> <titleText: message> \ntitle <player: target> times <fadeIn: int> <stay: int> <fadeOut: int>",
                "titleraw <player: target> clear \ntitleraw <player: target> reset \ntitleraw <player: target> <titleLocation: title|subtitle|actionbar> <raw json titleText: json> \ntitleraw <player: target> times <fadeIn: int> <stay: int> <fadeOut: int>",
                "toggledownfall",
                "weather <type: WeatherType> [duration: int] \nweather query",
                "xp <amount: int> [player: target] \nxp <amount: int>L [player: target]",
                "cmd:dynamicproperty <target: target> <dynamicPropertyId: string> [value: JSON]"
              ]
              player.sendMessage(`${pool[help.formValues[0]]}`)
            })
        break
        case 4:
          var box = new ActionFormData()
          box = box.body({ translate: "createWorldScreen.game.settings" })
            .button({ translate: "基础设置" })
            .button({ translate: "高级设置" })
            .button({ translate: "playfab.account.banned.permanent" })
          box.show(player)
            .then((select) => {
              if (select.selection == 0 && reg.getScore(player) > 2) {
                var box = new ModalFormData()
                box = box.title({ translate: "基础设置" })
                  .textField({translate: "设置处于旁观者模式下的最大秒数"}, {translate: "type:..."}, {defaultValue: `${reg.getScore("cd:spectator")/20}`})
                  .toggle({translate: "是否TNT无害化"}, {tooltip: {translate: "“无害”是指对建筑无害"}, defaultValue: Boolean(reg.getScore("cmd:tnt_no_explode"))})
                  .textField({translate: "设置无害化TNT的爆炸威力"}, {translate: "type:..."}, {defaultValue: `${reg.getScore("cmd:tnt_p")}`})
                  .toggle({translate: "是否点击即移除实体"}, {tooltip: {translate: "仅在手持调试棒时有效"}, defaultValue: Boolean(reg.getScore("cmd:remove_on_hit"))})
                  .toggle({translate: "是否使用区块标示"}, {defaultValue: Boolean(reg.getScore("show:chunks"))})
                  .dropdown({translate: "设置生物群系的显示方式"}, [{translate: "action:none"}, {translate: "title"}, {translate: "actionbar"}, {translate: "message"}], {defaultValueIndex: reg.getScore("show:biome")})
                  .toggle({translate: "重进即退出灵魂出窍"}, {defaultValue: Boolean(reg.getScore("inspect:exit_on_leave"))})
                  .toggle({translate: "受到伤害即退出灵魂出窍"}, {defaultValue: Boolean(reg.getScore("inspect:exit_on_hurt"))})
                  .toggle({translate: "显示相机点位坐标"}, {defaultValue: Boolean(reg.getScore("show:cam_pos"))})
                box.show(player)
                  .then((set) => {
                    reg.setScore("cd:spectator", set.formValues[0]*20)
                    reg.setScore("cmd:tnt_no_explode", Number(set.formValues[1]))
                    reg.setScore("cmd:tnt_p", Number(set.formValues[2]))
                    reg.setScore("cmd:remove_on_hit", Number(set.formValues[3]))
                    reg.setScore("show:chunks", Number(set.formValues[4]))
                    reg.setScore("show:biome", Number(set.formValues[5]))
                    reg.setScore("inspect:exit_on_leave", Number(set.formValues[6]))
                    reg.setScore("inspect:exit_on_hurt", Number(set.formValues[7]))
                    reg.setScore("show:cam_pos", Number(set.formValues[8]))
                  })
              };
              if (select.selection == 1 && reg.getScore(player) > 4) {
                var box = new ModalFormData()
                box = box.title("高级设置")
                  .slider({translate: "hbui.CreateNewWorld.multiplayer.playerPermissionsTitle"}, 0, 4, {valueStep: 1, defaultValue: reg.getScore("cmd:pri_level")})
                  .toggle({translate: "是否禁止管理员之外的成员获得调试棒"}, {defaultValue: Boolean(reg.getScore("cmd:non-op_no_debug"))})
                  .slider({translate: "设置编辑传送锚点需要的最小等级"}, 0, 5, {valueStep: 1, defaultValue: reg.getScore("pos:edit_min_level")})
                  .slider({translate: "设置传送锚点基本操作需要的最小等级"}, 0, 5, {valueStep: 1, defaultValue: reg.getScore("pos:opr_min_level")})
                  .slider({translate: "设置使用传送锚点需要的最小等级"}, 0, 5, {valueStep: 1, defaultValue: reg.getScore("cmd:pos_min_level")})
                  .toggle({translate: "是否允许更高的权限等级访问更低权限等级的传送锚点"}, {defaultValue: Boolean(reg.getScore("pos:high_access_low"))})
                  .slider({translate: "设置点击移除实体需要的最小等级"}, 0, 5, {valueStep: 1, defaultValue: reg.getScore("cmd:remove_min_level")})
                  .slider({translate: "使用灵魂出窍的最小等级"}, 0, 5, {valueStep: 1, defaultValue: reg.getScore("cmd:inspect_min_level")})
                box.show(player)
                  .then((set) => {
                    reg.setScore("cmd:pri_level", set.formValues[0])
                    if (set.formValues[1]) {
                      reg.setScore("cmd:non-op_no_debug", 1)
                    }
                    else {
                      reg.setScore("cmd:non-op_no_debug", 0)
                      player.runCommand("give @a[hasitem={item=cmd:debug_stick,quantity=!1..}] cmd:debug_stick 1 0 {\"minecraft:item_lock\":{\"mode\":\"lock_in_inventory\"},\"minecraft:keep_on_death\":{}}")
                    };
                    reg.setScore("pos:edit_min_level", set.formValues[2])
                    reg.setScore("pos:opr_min_level", set.formValues[3])
                    reg.setScore("cmd:pos_min_level", set.formValues[4])
                    reg.setScore("pos:high_access_low", Number(set.formValues[5]))
                    reg.setScore("cmd:remove_min_level", set.formValues[6])
                    reg.setScore("cmd:inspect_min_level", set.formValues[7])
                  })
              };
              if (select.selection == 2 && reg.getScore(player) > 3) {
                var box = new MessageFormData()
                box = box.title({ translate: "playfab.account.banned.permanent" })
                  .body({ translate: "你想禁止还是解禁某个项？" })
                  .button1({ translate: "禁止" })
                  .button2({ translate: "解禁" })
                box.show(player)
                  .then((select) => {
                    var box = new ModalFormData()
                    box = box.title(select.selection == 0? {translate: "禁止"}:{translate: "解禁"})
                      .textField({translate: "entity.item.name"}, {translate: "ID"})
                      .textField({translate: "data"}, {translate: "type:..."}, {defaultValue: "0", tooltip: {translate: "如果留空则禁止任意data值的该类物品"}})
                      .textField({translate: "structure_block.include_entities"}, {translate: "type:?"})
                      .dropdown({translate: "按字段筛选"}, [{translate:"type"}, {translate:"family"}, {translate:"name"}],{tooltip: {translate: "如果要禁的生物的名称和类型或族标识符重叠，应该先设置生物的名称"}})
                    box.show(player)
                      .then((ban) => {
                        if (select.selection == 0 && ban.formValues[2] !== "minecraft:player" && ban.formValues[2] !== "player") {
                          if (ban.formValues[0] !== "" && ban.formValues[1] !== "") {reg.setScore(`iban:${ban.formValues[0]}`, Number(ban.formValues[1]))}
                          if (ban.formValues[0] !== "" && ban.formValues[1] == "") {reg.setScore(`iban:${ban.formValues[0]}`, -1)}
                          if (ban.formValues[2] !== "") {reg.setScore(`eban:${ban.formValues[2]}`, ban.formValues[3])}
                        }
                        if (select.selection == 1) {
                          reg.removeParticipant(`iban:${ban.formValues[0]}`)
                          if (ban.formValues[3] == 2) {
                            reg.removeParticipant(`eban_name:${ban.formValues[2]}`)
                          }
                          else {
                            reg.removeParticipant(`eban:${ban.formValues[2]}`)
                          }
                        }
                        if (ban.formValues[2] === "minecraft:player" || ban.formValues[3] === "player") {
                          player.sendMessage({translate: "请不要尝试封禁玩家实体，这是不被允许的！"})
                        }
                      })
                  })
              }
            })
        break
        case 5:
          if (reg.getScore(player) >= reg.getScore("cmd:pos_min_level")) {
            var box = new ActionFormData()
            box = box.title({ translate: "npcscreen.requiresop" })
              .body({ translate: "选择你要执行的操作" })
              .button({ translate: "添加或覆盖传送锚点" })
              .button({ translate: "删除传送锚点" })
              .button({ translate: "传至传送锚点" })
              .button({ translate: "强行修改传送锚点" })
              .button({ translate: "查看在场玩家的ID" })
            box.show(player)
              .then((pos) => {
                const dimList = ["minecraft:overworld", "minecraft:nether", "minecraft:the_end"]
                if (pos.selection < 2 && reg.getScore(player) >= reg.getScore("pos:opr_min_level")) {
                  var box = new ModalFormData()
                  const pool = [{translate: "添加或覆盖传送锚点"}, {translate: "删除传送锚点"}]
                  box = box.title(pool[pos.selection])
                    .textField({ translate: "npcscreen.name" }, {translate: "type:?"})
                  box.show(player)
                    .then((done) => {
                      if (reg.getParticipants().some(p => (regVerify(p.displayName).type == "pos_owner" && regVerify(p.displayName).name == done.formValues[0] && regVerify(p.displayName).id != player.id))) {
                        player.sendMessage({translate: "这个名字的传送锚点已经存在，而它是其他玩家创建的，你不能在这里操作它。"})
                      } else {
                        if (pos.selection == 0) {
                          reg.setScore(`pos_owner:${player.id}|${done.formValues[0]}`, reg.getScore(player))
                          reg.setScore(`pos_x|${done.formValues[0]}`, Math.round(player.location.x))
                          reg.setScore(`pos_y|${done.formValues[0]}`, Math.round(player.location.y))
                          reg.setScore(`pos_z|${done.formValues[0]}`, Math.round(player.location.z))
                          reg.setScore(`pos_dim|${done.formValues[0]}`, dimList.indexOf(player.dimension.id))
                        }
                        if (pos.selection == 1) {
                          reg.removeParticipant(`pos_owner:${player.id}|${done.formValues[0]}`)
                        }
                      }
                    })
                }
                if (pos.selection == 2) {
                  var pool = reg.getParticipants().filter(p => regVerify(p.displayName).type == "pos_owner" && regVerify(p.displayName).id == player.id)
                  if (reg.getScore("pos:high_access_low") == 1) {
                    var pool = pool.concat(reg.getParticipants().filter(p => regVerify(p.displayName).type == "pos_owner" && reg.getScore(p) < reg.getScore(player) && pool.findIndex(i => regVerify(i.displayName).name === regVerify(p.displayName).name) === -1))
                  }
                  const name = pool.map(p => regVerify(p.displayName).name)
                  if (name.length > 0) {
                    var box = new ModalFormData()
                    box = box.title({translate: "选择锚点"})
                      .dropdown({translate: "按名称选择"}, name)
                    box.show(player)
                      .then((done) => {
                        const check = name[done.formValues[0]]
                        player.teleport({x:reg.getScore(`pos_x|${check}`), y:reg.getScore(`pos_y|${check}`), z:reg.getScore(`pos_z|${check}`)}, {dimension: world.getDimension(dimList[reg.getScore(`pos_dim|${check}`)])})
                      })
                  } else {
                    player.sendMessage({translate: "还没有任何可传至的传送锚点！"})
                  }
                }
                if (pos.selection == 3 && reg.getScore("pos:high_access_low") == 1 && reg.getScore(player) >= reg.getScore("pos:edit_min_level")) {
                  const pool = reg.getParticipants().filter(p => regVerify(p.displayName).type == "pos_owner" && reg.getScore(p) < reg.getScore(player))
                  const name = pool.map(p => regVerify(p.displayName).name)
                  if (name.length > 0) {
                    var box = new ModalFormData()
                    box = box.title({translate: "修改或删除"})
                      .dropdown({translate: "选择要更改的传送锚点"}, name)
                    box.show(player)
                      .then((done) => {
                        const index = done.formValues[0]
                        var box = new ModalFormData()
                        box = box.title({translate: "store.promo.details"})
                          .textField({translate: "拥有者的ID"}, {translate: "type:?"}, {defaultValue: regVerify(pool[index].displayName).id, tooltip: {translate: "应当在“查看在场玩家的ID”处按玩家的名字查询对应"}})
                          .textField({ translate: "npcscreen.name" }, {translate: "type:?"}, {defaultValue: name[index], tooltip: {translate: "传送锚点的名字"}})
                          .textField({translate: "x"}, {translate: "type:..."}, {defaultValue: `${reg.getScore(`pos_x|${name[index]}`)}`, tooltip: {translate: "只能是-2^31+1到2^31-1之间的整数"}})
                          .textField({translate: "y"}, {translate: "type:..."}, {defaultValue: `${reg.getScore(`pos_y|${name[index]}`)}`, tooltip: {translate: "只能是-2^31+1到2^31-1之间的整数"}})
                          .textField({translate: "z"}, {translate: "type:..."}, {defaultValue: `${reg.getScore(`pos_z|${name[index]}`)}`, tooltip: {translate: "只能是-2^31+1到2^31-1之间的整数"}})
                          .textField({translate: "dimension"}, {translate: "type:?"}, {defaultValue: dimList[reg.getScore(`pos_dim|${name[index]}`)], tooltip: {rawtext: [{translate: "只能为以下值："}, {text: `${dimList}`}]}})
                          .slider({translate: "hbui.CreateNewWorld.multiplayer.playerPermissionsTitle"}, 0, 5, {valueStep: 1, defaultValue: reg.getScore(pool[index])})
                          .toggle({translate: "是否删除传送锚点"}, {defaultValue: false})
                        box.show(player)
                          .then((mod) => {
                            if (mod.formValues) {
                              reg.removeParticipant(pool[index])
                              if (!mod.formValues[7]) {
                                reg.setScore(`pos_owner:${mod.formValues[0]}|${mod.formValues[1]}`, mod.formValues[6])
                                reg.setScore(`pos_dim|${mod.formValues[1]}`, dimList.indexOf(mod.formValues[5]))
                                reg.setScore(`pos_x|${mod.formValues[1]}`, Number(mod.formValues[2]))
                                reg.setScore(`pos_y|${mod.formValues[1]}`, Number(mod.formValues[3]))
                                reg.setScore(`pos_z|${mod.formValues[1]}`, Number(mod.formValues[4]))
                              }
                            }
                          })
                      })                    
                  } else {
                    player.sendMessage({translate: "没有可供操作的传送锚点"})
                  }
                }
                if (pos.selection == 4 && reg.getScore(player) > 4) {
                  const players = world.getPlayers()
                  var box = new ModalFormData()
                  box = box.dropdown({translate: "按名称选择"}, players.map(p => p.name))
                  box.show(player)
                    .then(query => {
                      player.sendMessage(players[query.formValues[0]].id)
                    })
                }
              })
          }
        break
        case 6:
          if (reg.getScore(player) > 3) {
            var box = new ActionFormData()
            box = box.body({ translate: "codeScreen.buttonTTS.selectEditor" })
              .button({ translate: "entity.item.name" })
              .button({ translate: "structure_block.include_entities" })
              .button({ translate: "howtoplay.blocks" })
            box.show(player)
              .then(type => {
                if (type.selection == 0) {
                  const pool = ["Mainhand", "Offhand", "Head", "Chest", "Legs", "Feet", {translate: "chestScreen.header.player"}, {translate: "container.enderchest"}]
                  var box = new ModalFormData()
                  box = box.title({translate: "选择槽位"})
                    .dropdown({translate: "槽位类型"}, pool, {tooltip: {translate: "如果选择的槽位已有物品，则编辑该物品"}})
                    .textField({translate: "槽位序号"}, {translate: "type:..."}, {tooltip: {translate: "如果指定槽位是单一槽位的槽位类型，则可留空"}})
                  box.show(player)
                    .then(opt => {
                      if (opt.formValues[0] < 6) {
                        const e = player.getComponent("minecraft:equippable")
                        var item = e.getEquipment(pool[opt.formValues[0]])
                        editItem(player, item, (newItem) => {
                          e.setEquipment(pool[opt.formValues[0]], newItem)
                        })
                      }
                      if (opt.formValues[0] == 6) {
                        const c = player.getComponent("minecraft:inventory").container
                        const slot = Number(opt.formValues[1]) ?? 0
                        var item = c.getItem(slot)
                        editItem(player, item, (newItem) => {
                          c.setItem(slot, newItem)
                        })
                      }
                      if (opt.formValues[0] == 7) {
                        player.sendMessage("仍在计划中")
                      }
                    })
                }
                if (type.selection == 1) {
                  const entities = player.getEntitiesFromViewDirection({ignoreBlockCollision: false, includeLiquidBlocks: false, includePassableBlocks: false, maxDistance: 30, maxHorizontalRotation: 90, maxVerticalRotation: 90})
                  const fix = Math.min(...entities.map(item => item.distance))
                  var entity = entities.filter(item => item.distance === fix).map(item => item.entity)[0]
                  editEntity(player, entity)
                }
                if (type.selection == 2) {
                  const fluidType = ["Lava", "Potion", "PowderSnow", "Water"]
                  const dyeColor = ["Black", "Blue", "Brown", "Cyan", "Gray", "Green", "LightBlue", "Lime", "Magenta", "Orange", "Pink", "Purple", "Red", "Silver", "White", "Yellow"]
                  var block = player.getBlockFromViewDirection({includeLiquidBlocks: true, includePassableBlocks: true, maxDistance: 30})?.block
                  var vector = block?.location??{x: "", y: "", z: ""}
                  var box = new ModalFormData()
                  box = box.title({translate: "确认选取方块的坐标"})
                    .textField({translate: "x"}, {translate: "type:..."}, {defaultValue: String(vector.x)})
                    .textField({translate: "y"}, {translate: "type:..."}, {defaultValue: String(vector.y)})
                    .textField({translate: "z"}, {translate: "type:..."}, {defaultValue: String(vector.z)})
                  box.show(player)
                    .then(conf => {
                      block = player.dimension.getBlock({x: Number(conf.formValues[0]), y: Number(conf.formValues[1]), z: Number(conf.formValues[2])})
                      const i = block.getComponent("minecraft:inventory")
                      const f = block.getComponent("minecraft:fluid_container")
                      const s = block.getComponent("minecraft:sign")
                      var box = new ModalFormData()
                      box = box.textField({translate: "ID"}, {translate: "type:?"}, {defaultValue: block.typeId})
                        .toggle({translate: "是否含水"}, {tooltip: {translate: "可能设置失败"}, defaultValue: block.isWaterlogged})
                      if (i) {
                        box.textField({translate: "物品槽位序号"}, {translate: "type:..."}, {tooltip: {translate: "若留空则不编辑方块中的物品"}})
                      } else {
                        box.label({translate: "No inventory"})
                      }
                      if (f) {
                        box.textField({translate: "内容液体设置"}, {translate: "type:[]"}, {tooltip: {rawtext: [{translate:'[内容液高度（数字）, 内容液颜色（{"alpha": 数字, "blue": 数字, "green": 数字, "red": 数字}）, 内容液类型（只能是'}, {text:`${fluidType}`}, {translate:"当中的一个）, 药水类型（不一定反应真实值）]。可能设置失败"}]}, defaultValue: JSON.stringify([f.fillLevel, {alpha: f.fluidColor.alpha, blue: f.fluidColor.blue, green: f.fluidColor.green, red: f.fluidColor.red}, f.getFluidType()??"Water"])})
                      } else {
                        box.label({translate: "Not fluid container"})
                      }
                      if (s) {
                        box.textField({translate: "告示文字"}, {translate: "type:JSON"}, {tooltip: {rawtext: [{translate: '{"back": [告示文本, 文字染色（只能是以下值：'},{text: `${dyeColor}`},{translate: '，如果设置为null，则不着色）], "front": [告示文本, 文字染色], "wax": 是否被蜡封（布尔值）}'}]}, defaultValue: JSON.stringify({back: [s.getText("Back"), s.getTextDyeColor("Back")], front: [s.getText("Front"), s.getTextDyeColor("Front")], wax: s.isWaxed})})
                      } else {
                        box.label({translate: "Not sign"})
                      }
                      box.toggle({translate: "是否编辑方块序列"}, {tooltip: {translate: "序列是指方块状态的组合"}})
                      box.show(player)
                        .then(edit => {
                          const copy = block.permutation
                          block.setType(edit.formValues[0])
                          if (edit.formValues[5]) {
                            var perm = copy.type.id === edit.formValues[0]? copy.getAllStates() : block.permutation.getAllStates()
                            var box = new ModalFormData()
                            box = box.title({translate: "编辑序列"})
                              .textField({translate: "Permutation"}, {translate: "type:[]"}, {tooltip: {translate: '[["方块状态1", 值], ["方块状态2", 值]]，最外层的方括号必须保留'}, defaultValue: JSON.stringify(Object.entries(perm))})
                            box.show(player)
                              .then(states => {
                                perm = Object.fromEntries(JSON.parse(states.formValues))
                                block.setPermutation(BlockPermutation.resolve(edit.formValues[0], perm))
                              })
                              .catch(() => {
                                block.setPermutation(BlockPermutation.resolve(edit.formValues[0], perm))
                              })
                          } else if (copy.type.id === edit.formValues[0]) {
                            block.setPermutation(copy)
                          }
                          block.setWaterlogged(edit.formValues[1])
                          if (edit.formValues[2] && edit.formValues[2] !== "") {
                            var item = i.container.getItem(Number(edit.formValues[2]))
                            editItem(player, item, (newItem) => {
                              i.container.setItem(Number(edit.formValues[2]), newItem)
                            })
                          }
                          if (f) {
                            const newF = JSON.parse(edit.formValues[3])
                            f.setFluidType(newF[2])
                            f.fillLevel = newF[0]
                            f.fluidColor = newF[1]
                          }
                          if (s) {
                            const sign = JSON.parse(edit.formValues[4])
                            s.setWaxed(sign.wax)
                            s.setText(sign.back[0], "Back")
                            s.setTextDyeColor(sign.back[1], "Back")
                            s.setText(sign.front[0], "Front")
                            s.setTextDyeColor(sign.front[1], "Front")
                          }
                        })
                    })
                }
              })
          }
        break
        case 7:
          if (reg.getScore(player) >= reg.getScore("cmd:inspect_min_level")) {
            var box = new ModalFormData()
            box = box.title({ translate: "灵魂出窍" })
              .textField({translate: "灵魂出窍下的移动速度"}, {translate: "type:..."}, {defaultValue: String(player.getDynamicProperty("inspect:speed")??0.11), tooltip: {translate: "单位是block/tick"}})
              .toggle({translate: "进入灵魂出窍"}, {defaultValue: player.hasTag("cmd:inspect")})
            box.show(player)
              .then((inspect) => {
                player.setDynamicProperty("inspect:speed", round(Number(inspect.formValues[0]), 2))
                if (inspect.formValues[1]) {
                  player.addTag("cmd:inspect")
                  joinInspect(player)
                } else if (inspect.formValues[1] === false) {
                  exitInspect(player)
                };
              })
          }
        break
      }
    })
};
world.afterEvents.itemUse.subscribe(t => {
  const reg = world.scoreboard.getObjective("cmd:reg")
  var item = t.itemStack
  var player = t.source
  if (item.typeId == 'cmd:debug_stick' && reg.getScore(player) > 0) {
    cmdBox(player)
  }
});
world.afterEvents.entityHitEntity.subscribe(t => {
  const reg = world.scoreboard.getObjective("cmd:reg")
  var player = t.damagingEntity
  if (Boolean(reg.getScore("cmd:remove_on_hit")) && player.typeId == "minecraft:player" && t.hitEntity.typeId != "minecraft:player") {
    if (reg.getScore(player) >= reg.getScore("cmd:remove_min_level") && player.getComponent("minecraft:inventory").container.getItem(player.selectedSlotIndex).typeId == "cmd:debug_stick") {
      t.hitEntity.remove()
    }
  }
});
world.beforeEvents.playerInteractWithEntity.subscribe(t => {
  if (t.itemStack.typeId == "cmd:debug_stick") {
    editEntity(t.player, t.target)
  }
});
world.afterEvents.playerJoin.subscribe(t => {
  const reg = world.scoreboard.getObjective("cmd:reg")
  var player = world.getEntity(t.playerId)
  if (reg.getScore("inspect:exit_on_leave") == 0) {
    if (player.hasTag("cmd:inspect")) {
      joinInspect(player)
    }
  } else {
    exitInspect(player)
  }
});
world.afterEvents.entityHurt.subscribe((t => {
  const reg = world.scoreboard.getObjective("cmd:reg")
  if (reg.getScore("inspect:exit_on_hurt") == 1) {
    exitInspect(t.hurtEntity)
  }
}), {entityTypes: ["minecraft:player"]});
world.afterEvents.entityDie.subscribe((t => {
  const reg = world.scoreboard.getObjective("cmd:reg")
  if (reg.getScore("inspect:exit_on_hurt") == 1) {
    exitInspect(t.deadEntity)
  }
}), {entityTypes: ["minecraft:player"]})