import { system } from "@minecraft/server";

system.beforeEvents.startup.subscribe((event) => {
  event.customCommandRegistry.registerCommand({
    cheatsRequired: false,
    description: "peek",
    name: "storage:peek",
    permissionLevel: 0,
  }, (origin, ...args) => {
    const stack = origin.sourceEntity
      ?.getComponent("minecraft:equippable")
      ?.getEquipment("Mainhand");
    const feedback = [stack?.typeId];
    const inventory = stack?.getComponent("minecraft:inventory");
    feedback.push(`Inventory[isValid]: ${inventory?.isValid}`);
    try {
      const container = inventory?.container;
      feedback.push(`Container[isValid]: ${container?.isValid}`);
      return {
        status: 0,
        message: feedback.join("\n"),
      };
    } catch (e) {
      feedback.push(e.message);
      return {
        status: 1,
        message: feedback.join("\n"),
      };
    }
  });
});