/**
 * Addon name:Entity Random Multiplier Loot
 * License:MIT
 */
// get loot count
function lootCount(count) {
    if (count.max !== 'default' || count.min !== 'default') {
        return {
            max: count.max === 'default' ? 50 : count.max,
            min: count.min === 'default' ? 1 : count.min
        };
    }
    const memoryTier = system.serverSystemInfo.memoryTier;
    const list = [
        // SuperLow 
        {
            max: 10,
            min: 1,
        },
        // Low
        {
            max: 30,
            min: 1,
        },
        // Mid
        {
            max: 50,
            min: 1,
        },
        // High
        {
            max: 100,
            min: 1,
        },
        // SuperHigh
        {
            max: 255,
            min: 1,
        }
    ];
    return list[memoryTier] || list[2];
}
import { EntityComponentTypes, EquipmentSlot, Player, system, world } from "@minecraft/server";
import { Entity_Loot_Count } from "./config";
// Random Function
function getRandomInt(min, max) {
    max = Math.floor(max);
    return Math.floor(Math.random() * (max - min)) + min;
}
world.afterEvents.entityDie.subscribe((event) => {
    // check if the attacker is a player
    const attacker = event.damageSource.damagingEntity;
    if (attacker && attacker instanceof Player) {
        const deadEntity = event.deadEntity;
        // get item
        const item = attacker.getComponent(EntityComponentTypes.Equippable)?.getEquipment(EquipmentSlot.Mainhand);
        // get dimension
        const dimension = world.getDimension(deadEntity.dimension.id);
        // if the dead entity is not a player'
        if (deadEntity.typeId !== 'minecraft:player') {
            const { min, max } = lootCount(Entity_Loot_Count);
            const random = getRandomInt(min, max);
            for (let i = 0; i < random; i++) {
                const loots = world.getLootTableManager().generateLootFromEntity(deadEntity, item);
                if (loots) {
                    console.log(`is has loots`);
                    system.run(() => {
                        try {
                            loots.forEach(item => {
                                dimension.spawnItem(item, deadEntity.location);
                                console.log(`spawn item: ${item.typeId}`);
                            });
                        }
                        catch (error) {
                            console.error('Spawn item failed:', error);
                        }
                    });
                }
            }
        }
    }
});
