import { Block, EffectType, EntityEffectOptions, Player, Vector3 } from "@minecraft/server";
import { LuckyBlockEventName, LuckyBlockEventType, LuckyBlockType, spawnLocationBlock } from "./enum";

// 幸运方块参数接口
export interface LuckyBlockParams {
    /** 是否是幸运方块 */
    is_lucky_block: boolean,
    /** 幸运方块类型 */
    lucky_block_type: LuckyBlockType | string,
    /** 幸运方块值 */
    lucky_value: number
}

export interface ItemList {
    /** 物品ID */
    item: string;
    /** 权重 */
    weight: number;
    /** 数量 */
    count: count
}

// 物品数量范围接口
export interface count {
    max: number;
    min: number;
}

// 幸运方块事件参数类型

/** 随机物品事件参数类型 */
export type RandomItemParamsType = (player: Player, block: Block, context: RandomItemConfig) => void;
/** 生成实体事件参数类型 */
export type SpawnEntityParamsType = (player: Player, block: Block, context: EntityConfig) => void;
/** 随机箱子战利品事件参数类型 */
export type ChestLootParamsType = (player: Player, block: Block, context: ChestLootConfig) => void;
/** 生成随机结构事件参数类型 */
export type StructureParamsType = (player: Player, block: Block, context: StructureConfig) => void;
/** 设置方块事件参数类型 */
export type SetBlockParamsType = (player: Player, block: Block, context: SetBlockConfig) => void;

// 幸运方块事件参数接口

export interface RandomItemConfig {
    /** 随机物品特有，定义一个范围 */
    range: LuckyBlockItemRange;
    /** 是否为混合物品，即数组（用于随机多个类型） */
    isMixed?: boolean;
    /** 物品ID，用于随机物品事件 */
    itemTypeId: string[] | string;
}

// 随机箱子战利品配置接口
export interface ChestLootConfig {
    /** 战利品列表，用于随机箱子事件 */
    lootlist: string[];
}


// 生成随机结构配置接口
export interface StructureConfig {
    structureTypeId: string; // 结构ID
}

// 通用附加条件
// 通用附加条件接口
export interface Options {
    /** 消息 */
    message?: string;
    /** 音效 */
    sound?: string;
    /** 间隔时间,单位:tick (1tick=0.05s) */
    interval?: number | count;
}



interface BlockEvent {
    /**是否有闪电 */
    hasLightning?: boolean;
    /**闪电之后是否着火 */
    onFire?: boolean;
    /**生成位置 */
    location?: spawnLocationBlock
    /**生成概率
     * 0 - 100
     * 默认为100
     */
    probability?: number;
}
// 设置方块配置接口
export interface SetBlockConfig {
    isPillar?: boolean; // 是否为 pillar(柱子) 类型
    blockPillar?: {
        blockTypeIdList: string[]; // 方块ID列表
        /**起始高度 */
        startHeight?: number; // 提供Y值，默认打破方块的位置，为正数则加为负数则减
        /** 顶部方块ID */
        topBlockTypeId?: string | string[];
        /** 高度 */
        height?: number | count; // 默认提供3格
        /**是否打乱数组 */
        isShuffled?: boolean;
        /**转换成新的方块，注意新的方块必须有彩色（如 wool_carpet） */
        conversion?: string;
    }
    /** 方块ID */
    blockTypeId?: string | string[];
    /** 方块事件 */
    blockEvent?: BlockEvent
    /** 附加条件 */
    options?: Options;

}


// 实体配置接口
// 生成接口

// 药水接口
interface PotionEffect {
    /** 药水效果ID */
    effectType: EffectType | string;
    /** 药水效果持续时间，单位：tick */
    duration: number;
    /** 药水效果 amplifier */
    options?: EntityEffectOptions;
}

interface Spawn {
    /** 实体ID */
    entityTypeId: string;
    /**
     * 生成位置偏移
     * 偏移强度，0为当前位置，参数必须为正数
     */
    offset?: number;
    /** 实体名字
     * 重命名实体，默认状态下没有名字
     */
    name?: string;
    /** 实体数量
     * 生成实体数量，默认1个
     */
    count?: number | count;
    /** 实体效果
     * 实体生成为实体附加的药水效果
     */
    entityEffects?: PotionEffect[];
    /** 附加的buff 
 * 实体生成时为玩家附加的药水效果
*/
    playerEffects?: PotionEffect[];
    /** 附加条件 */
    options?: Options;
}
export interface EntityConfig {
    spawn: Spawn[];
    /** 设置时间 */
    setTime?: number;
}

// 幸运方块事件列表接口
export interface LuckyBlockEventList {
    /** 权重值 */
    weight: number;
    /** 随机物品特有，定义一个物品配置 */
    RandomItemConfig?: RandomItemConfig;
    /** 随机箱子特有，定义一个战利品配置 */
    ChestLootConfig?: ChestLootConfig;
    /** 生成实体特有，定义一个实体配置 */
    EntityConfig?: EntityConfig;
    /** 生成随机结构特有，定义一个结构配置 */
    StructureConfig?: StructureConfig;
    /** 设置方块特有，定义一个方块配置 */
    SetBlockConfig?: SetBlockConfig;
    /** 事件对象 */
    event: RandomItemParamsType | SpawnEntityParamsType | ChestLootParamsType | StructureParamsType | SetBlockParamsType;
}


// 主事件类别接口
export interface LuckyBlockEventCategory {
    /** 事件类型 */
    eventType: LuckyBlockEventType;
    /** 事件名称 */
    eventName: LuckyBlockEventName;
    /** 权重值 */
    weight: number;
    /** 子事件 */
    events: LuckyBlockEventList[];
}


// 随机物品范围接口
export interface LuckyBlockItemRange {
    /**随机物品种类数量 */
    amount: number | count;
    /** 随机单个物品数量范围 */
    count: number | count;
}