import { Player } from "@minecraft/server";
import { armorSetTypeId, bucketTypeId, chestsLootlist, decorationStoneTypeId, foodTypeId, logTypeId, oreBlockTypeId, oreItemTypeId, oreTypeId, redstoneTypeTypeId } from "../setItemTypeId";
import { LuckyBlockEventList } from "../types/type";
import { chestLoot, randomItem, setBlock, setBlockPillar, spawnEntity } from "./commonEvent";
import { getMaterialTypeId, getRandomElements, randint } from "../types/function";
import { spawnLocationBlock } from "../types/enum";
/**
 * 特殊说明
 * 如果事件头部注释 debug 则为调试事件，不参与随机
 */

// 随机物品事件
export const RandomItemEvent: LuckyBlockEventList[] = [
    // 随机食物
    {
        weight: 1,
        RandomItemConfig: {
            itemTypeId: foodTypeId,
            range: {
                amount: 5,
                count: {
                    max: 10,
                    min: 5,
                }
            }
        },
        event: randomItem,
    },
    // 随机彩色羊毛
    {
        weight: 1,
        RandomItemConfig: {
            itemTypeId: getMaterialTypeId("wool"),
            range: {
                amount: {
                    max: 7,
                    min: 3
                },
                count: {
                    max: 12,
                    min: 7,
                }
            }
        },
        event: randomItem,
    },
    // 随机彩色混泥土
    {
        weight: 1,
        RandomItemConfig: {
            itemTypeId: getMaterialTypeId("concrete"),
            range: {
                amount: {
                    max: 7,
                    min: 3
                },
                count: {
                    max: 12,
                    min: 7,
                }
            }
        },
        event: randomItem,
    },
    // 随机彩色羊毛地毯
    {
        weight: 1,
        RandomItemConfig: {
            itemTypeId: getMaterialTypeId("carpet"),
            range: {
                amount: {
                    max: 7,
                    min: 3
                },
                count: {
                    max: 12,
                    min: 7,
                }
            }
        },
        event: randomItem,
    },
    // 随机彩色玻璃
    {
        weight: 1,
        RandomItemConfig: {
            itemTypeId: getMaterialTypeId("stained_glass"),
            range: {
                amount: {
                    max: 7,
                    min: 3
                },
                count: {
                    max: 12,
                    min: 7,
                }
            }
        },
        event: randomItem,
    },
    // 随机彩色玻璃板
    {
        weight: 1,
        RandomItemConfig: {
            itemTypeId: getMaterialTypeId("stained_glass_pane"),
            range: {
                amount: {
                    max: 7,
                    min: 3
                },
                count: {
                    max: 12,
                    min: 7,
                }
            }
        },
        event: randomItem,
    },
    // 随机原木
    {
        weight: 1,
        RandomItemConfig: {
            itemTypeId: logTypeId,
            range: {
                amount: 3,
                count: {
                    max: 64,
                    min: 16,
                }
            }
        },
        event: randomItem,
    },
    // 随机桶
    {
        weight: 1,
        RandomItemConfig: {
            itemTypeId: bucketTypeId,
            range: {
                amount: 4,
                count: 1
            }
        },
        event: randomItem,
    },
    // 随机装饰石头
    {
        weight: 1,
        RandomItemConfig: {
            itemTypeId: decorationStoneTypeId,
            range: {
                amount: {
                    max: 6,
                    min: 3
                },
                count: {
                    max: 32,
                    min: 12,
                }
            }
        },
        event: randomItem,
    },
    // 随机矿石原矿
    {
        weight: 1,
        RandomItemConfig: {
            itemTypeId: oreTypeId,
            range: {
                amount: 3,
                count: {
                    max: 32,
                    min: 12,
                }
            }
        },
        event: randomItem,
    },
    // 随机矿石块
    {
        weight: 1,
        RandomItemConfig: {
            itemTypeId: oreBlockTypeId,
            range: {
                amount: 1,
                count: {
                    max: 3,
                    min: 1,
                }
            }
        },
        event: randomItem,
    },
    // 随机矿石物品
    {
        weight: 1,
        RandomItemConfig: {
            itemTypeId: oreItemTypeId,
            range: {
                amount: 3,
                count: {
                    max: 12,
                    min: 4,
                }
            }
        },
        event: randomItem,
    },
    // 随机红石器具
    {
        weight: 1,
        RandomItemConfig: {
            itemTypeId: redstoneTypeTypeId,
            range: {
                amount: 6,
                count: {
                    max: 46,
                    min: 16,
                }
            }
        },
        event: randomItem,
    },
    // 随机套装
    {
        weight: 1,
        RandomItemConfig: {
            isMixed: true, // 用于标记是否为混合物品，继返回多个种类的数组
            itemTypeId: armorSetTypeId, //返回的是数组而不是物品id
            range: {
                amount: {
                    max: 4,
                    min: 2,
                },
                count: 1
            }
        },
        event: randomItem,
    }
]

// 随机箱子战利品
export const chestLootEvent: LuckyBlockEventList[] = [
    {
        weight: 1,
        ChestLootConfig: {
            lootlist: chestsLootlist,
        },
        event: chestLoot,
    }
]


// 设置方块
export const setBlockEvent: LuckyBlockEventList[] = [
    {
        weight: 1,
        SetBlockConfig: {
            isPillar: true,
            blockPillar: {
                blockTypeIdList: getMaterialTypeId("concrete_powder"),
                topBlockTypeId: oreBlockTypeId,
                height: {
                    max: 7,
                    min: 3,
                },
                isShuffled: true,
                startHeight: 20,
                conversion: "concrete",
            },
            options: {
                sound: "random.orb",
                interval: 10
            }
        },
        event: setBlockPillar,
    },
    {
        weight: 123456,
        SetBlockConfig: {
            blockTypeId: oreBlockTypeId,
            blockEvent: {
                hasLightning: true,
                onFire: true,
                location: spawnLocationBlock.block,
                probability: 50
            },
            /** 附加条件 */
            options: {
                message: "你获得了一个%$blockname", // 语法说明：'%' 为格式化字符（通常配合翻译键名使用） $blockname 为方块名称(本地化键名)，具体有哪些可以去 setBlock 函数查看实现
                sound: "random.orb",
                interval: randint(10, 20)
            }
        },
        event: setBlock,
    }
]

// 生成实体事件
export const spawnEntityEvent: LuckyBlockEventList[] = [
    // debug
    {
        weight: 10,
        EntityConfig: {
            spawn: [
                {
                    offset: 2,
                    entityTypeId: "minecraft:pig",
                    count: {
                        max: 4,
                        min: 2,
                    },
                    name: "幸运猪猪",
                    options: {
                        interval: 10
                    }
                }
            ]
        },
        event: spawnEntity,
    }
]