import { EntityComponentTypes, EntityDamageCause, EquipmentSlot, ItemStack, Player, system, VanillaEntityIdentifier, world } from "@minecraft/server";

/**
 * 苦力怕剑效果：
 * 每次攻击都会造成一次不会破坏地形的爆炸;
 * 此外，被苦力怕剑杀死的生物有75%的概率掉落头颅
 */

system.beforeEvents.startup.subscribe((init) => {
    init.itemComponentRegistry.registerCustomComponent('xxr:creeper_sword', {
        onHitEntity: (event) => {
            // 注册占位
        }
    })
})

// 头颅Map
const creeperSwordHeads = new Map<string, string>([
    ['minecraft:creeper', 'minecraft:creeper_head'],
    ['minecraft:skeleton', 'minecraft:skeleton_skull'],
    ['minecraft:wither_skeleton', 'minecraft:wither_skeleton_skull'],
    ['minecraft:zombie', 'minecraft:zombie_head'],
    ['minecraft:player', 'minecraft:player_head'],

]);

world.afterEvents.entityHurt.subscribe((event) => {
    if (event.damageSource.damagingEntity?.typeId !== 'minecraft:player') return;
    // 获取攻击者
    const attacker = event.damageSource.damagingEntity as Player;
    // 获取攻击者的手持武器是否有xxr:creeper_sword组件
    const item = attacker.getComponent(EntityComponentTypes.Equippable)?.getEquipment(EquipmentSlot.Mainhand);
    if (item?.hasComponent('xxr:creeper_sword')) {
        // 有xxr:creeper_sword组件，执行逻辑
        try {
            world.getDimension(event.hurtEntity.dimension.id).createExplosion(event.hurtEntity.location, 1, {
                allowUnderwater: true,
                breaksBlocks: false,
                causesFire: false
            });

        } catch (error) {
            console.error('苦力怕剑伤害失败:', error);
        }
    }
})

world.afterEvents.entityDie.subscribe((event) => {
    if (event.damageSource.damagingEntity?.typeId !== 'minecraft:player') return;
    // 获取攻击者
    const attacker = event.damageSource.damagingEntity as Player;
    // 获取攻击者的手持武器是否有xxr:creeper_sword
    const item = attacker.getComponent(EntityComponentTypes.Equippable)?.getEquipment(EquipmentSlot.Mainhand);
    if (item?.hasComponent('xxr:creeper_sword')) {
        // 有xxr:creeper_sword
        console.log(creeperSwordHeads.get(event.deadEntity.typeId));
        
        if (Math.random() < 0.75) {
            try {
                // 生成被击杀生物的头颅
                const headTypeId = creeperSwordHeads.get(event.deadEntity.typeId);
                if (headTypeId) {
                    const item = new ItemStack(headTypeId);
                    world.getDimension(event.deadEntity.dimension.id).spawnItem(item, event.deadEntity.location);
                }
            } catch (error) {
                console.error('苦力怕剑掉落头颅失败:', error);
            }
        }
    }
})


