import { Block, GameMode, ItemStack, system, Vector3, world } from "@minecraft/server";
import { wishEventSpawnItem, wishLuckBlock } from "../../events/wishEvent";
import { main } from "../../events/commonEvent";
import { LuckyBlockParams } from "../../types/type";
import { LuckyBlockType } from "../../types/enum";



/**
 * 幸运方块类型
 * @param Common 普通幸运方块
 * @param Wish 许愿方块
 */

system.beforeEvents.startup.subscribe((init) => {
    init.blockComponentRegistry.registerCustomComponent('xxr:lucky_block', {
        onPlayerBreak: (event, p) => {
            const params = p.params as LuckyBlockParams
            const player = event.player
            const block = event.block
            // 是幸运方块
            if (params.is_lucky_block) {
                // 许愿方块幸运方块彩蛋事件
                if (params.lucky_block_type == LuckyBlockType.Wish) {
                    if (player) {
                        if (!player.getDynamicProperty('许愿井幸运方块挖掘彩蛋') && player.getGameMode() != GameMode.Creative) {
                            player.setDynamicProperty('许愿井幸运方块挖掘彩蛋', true)
                            player.sendMessage('[彩蛋] 请不要尝试直接破坏这种幸运方块，因为你会发现什么都没有~')
                        }
                    }

                }
                // 普通幸运方块事件
                if (params.lucky_block_type == LuckyBlockType.Common) {
                    if (!player) return;
                    // 幸运方块事件
                    main(player, block, params.lucky_value);
                }
            }
        },
        onTick: (event, p) => {
            if (event) {
                // console.log('许愿方块');
                const block = event.block;
                const getRedstonePower = block.getRedstonePower();
                const params = p.params as LuckyBlockParams
                if (params.lucky_block_type == LuckyBlockType.Wish) {
                    // 许愿方块
                    wishLuckBlock(block, getRedstonePower)
                }
            }
        }
    })
})
