import { ItemStack, system, world } from "@minecraft/server";
import { getRandomByWeight, getRandomElements, getRandomEventCategory, spawnItem, normalizeCount, shuffle, randint, getColor, getRandomXZOffset, getSpawnY } from "../types/function";
import { LuckyBlockEventName, LuckyBlockEventType, spawnLocationBlock } from "../types/enum";
import { chestLootEvent, RandomItemEvent, setBlockEvent, spawnEntityEvent } from "./luckyBlockEventConfig";
// 2025-9-26
// 只是完成一些基础框架和方便测试，后面慢慢优化
/**
 * 在这期间在完善功能，没有记录
 */
// 2025-10-2
// 完善了main函数
// 随机物品单独事件
// 定义幸运方块事件列表
const luckyBlockEventList = [
    {
        eventName: LuckyBlockEventName.RandomItem,
        eventType: LuckyBlockEventType.lucky,
        weight: 1,
        events: RandomItemEvent,
    },
    {
        eventName: LuckyBlockEventName.ChestLoot,
        eventType: LuckyBlockEventType.lucky,
        weight: 1,
        events: chestLootEvent,
    },
    {
        eventName: LuckyBlockEventName.SpawnEntity,
        eventType: LuckyBlockEventType.lucky,
        weight: 1,
        events: spawnEntityEvent,
    }, {
        eventName: LuckyBlockEventName.Structure,
        eventType: LuckyBlockEventType.lucky,
        weight: 0,
        events: RandomItemEvent, // 占位中
    },
    {
        eventName: LuckyBlockEventName.SetBlock,
        eventType: LuckyBlockEventType.lucky,
        weight: 1234567,
        events: setBlockEvent,
    },
];
export function main(player, block, luckyValue) {
    // debug
    lucky(player, block);
    return;
    if (luckyValue === 0) {
        // 我直接50%概率
        if (Math.random() < 0.5) {
            lucky(player, block);
            console.log('is lucky');
        }
        else {
            unLucky(player, block);
            console.log('is unLucky');
        }
        return;
    }
    const bonus = Math.floor(Math.random() * (luckyValue + 1));
    const totalRange = 100 + Math.abs(bonus);
    const luckyThreshold = 50 + bonus;
    const randomResult = Math.floor(Math.random() * totalRange);
    if (randomResult < luckyThreshold) {
        lucky(player, block);
        console.log('is lucky');
    }
    else {
        unLucky(player, block);
        console.log('is unLucky');
    }
}
// 幸运方块主函数
function lucky(player, block) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p;
    // 随机获取一个事件分类，它的类型必须是幸运的
    const category = getRandomEventCategory(luckyBlockEventList.filter(c => c.eventType === LuckyBlockEventType.lucky));
    // 执行事件
    try {
        // 如果随机的是随机物品事件
        if ((category === null || category === void 0 ? void 0 : category.eventName) === LuckyBlockEventName.RandomItem) {
            // 随机获取一个事件
            const event = getRandomByWeight(category.events);
            // 执行事件
            if ((_a = event.RandomItemConfig) === null || _a === void 0 ? void 0 : _a.itemTypeId) {
                const typeId = event.RandomItemConfig.itemTypeId;
                const randomItems = getRandomElements(typeId, normalizeCount((_c = (_b = event.RandomItemConfig) === null || _b === void 0 ? void 0 : _b.range) === null || _c === void 0 ? void 0 : _c.amount));
                event.event(player, block, { range: (_d = event.RandomItemConfig) === null || _d === void 0 ? void 0 : _d.range, itemTypeId: randomItems, isMixed: (_e = event.RandomItemConfig) === null || _e === void 0 ? void 0 : _e.isMixed });
                return;
            }
        }
        // 如果随机的是箱子战利品事件
        if ((category === null || category === void 0 ? void 0 : category.eventName) === LuckyBlockEventName.ChestLoot) {
            // 随机获取一个事件
            const event = getRandomByWeight(category.events);
            // 执行事件
            if ((_f = event.ChestLootConfig) === null || _f === void 0 ? void 0 : _f.lootlist) {
                const lootId = event.ChestLootConfig.lootlist;
                event.event(player, block, { lootlist: lootId });
                return;
            }
        }
        // 随机生成方块事件
        if ((category === null || category === void 0 ? void 0 : category.eventName) === LuckyBlockEventName.SetBlock) {
            // 随机获取一个事件
            const event = getRandomByWeight(category.events);
            // 执行事件
            if ((_g = event.SetBlockConfig) === null || _g === void 0 ? void 0 : _g.isPillar) {
                const isPillar = event.SetBlockConfig.isPillar;
                event.event(player, block, {
                    isPillar: isPillar,
                    blockPillar: (_h = event.SetBlockConfig) === null || _h === void 0 ? void 0 : _h.blockPillar,
                    options: (_j = event.SetBlockConfig) === null || _j === void 0 ? void 0 : _j.options,
                });
                return;
            }
            if ((_k = event.SetBlockConfig) === null || _k === void 0 ? void 0 : _k.blockTypeId) {
                const blockTypeId = event.SetBlockConfig.blockTypeId;
                event.event(player, block, {
                    blockTypeId: blockTypeId,
                    blockEvent: (_l = event.SetBlockConfig) === null || _l === void 0 ? void 0 : _l.blockEvent,
                    options: (_m = event.SetBlockConfig) === null || _m === void 0 ? void 0 : _m.options,
                });
                return;
            }
        }
        // 如果随机的是生成实体事件
        if ((category === null || category === void 0 ? void 0 : category.eventName) === LuckyBlockEventName.SpawnEntity) {
            // 随机获取一个事件
            const event = getRandomByWeight(category.events);
            // 执行事件
            if ((_o = event.EntityConfig) === null || _o === void 0 ? void 0 : _o.spawn) {
                const spawn = event.EntityConfig.spawn;
                event.event(player, block, {
                    spawn: spawn,
                    setTime: (_p = event.EntityConfig) === null || _p === void 0 ? void 0 : _p.setTime,
                });
                return;
            }
        }
    }
    catch (error) {
        console.error("幸运方块事件执行失败：" + error);
    }
}
function unLucky(player, block) {
    // 随机一个事件分类，它的类型必须是厄运的
    // 随机获取一个事件分类，它的类型必须是厄运的
    const category = getRandomEventCategory(luckyBlockEventList.filter(c => c.eventType === LuckyBlockEventType.unLucky));
    // 执行事件
    try {
        // 占位中，什么都不做
    }
    catch (error) {
        console.error("厄运方块事件执行失败：" + error);
    }
}
class Options {
    constructor(player) {
        this.player = player;
    }
    // 发送消息
    sendMessage(message, interval) {
        if (!message)
            return;
        if (interval) {
            system.runTimeout(() => {
                if (message)
                    this.player.sendMessage(message);
            }, interval);
        }
        else {
            if (message)
                this.player.sendMessage(message);
        }
    }
    // 播放音效
    playSound(sound, interval) {
        if (!sound)
            return;
        if (interval) {
            system.runTimeout(() => {
                if (sound)
                    this.player.playSound(sound);
            }, interval);
        }
        else {
            if (sound)
                this.player.playSound(sound);
        }
    }
}
// 随机物品
export function randomItem(player, block, params) {
    const { range, itemTypeId, isMixed } = params;
    // 生成随机物品
    const actualRange = range;
    const items = itemTypeId || [];
    if (isMixed) {
        const randomItem = getRandomElements(items, normalizeCount(actualRange.amount));
        for (const item of randomItem) {
            spawnItem(player.dimension.id, new ItemStack(item, normalizeCount(actualRange.count)), block.location);
        }
    }
    else {
        for (const item of items) {
            spawnItem(player.dimension.id, new ItemStack(item, normalizeCount(actualRange.count)), block.location);
        }
    }
}
// 生成箱子战利品
export function chestLoot(player, block, params) {
    const { lootlist } = params;
    const lootId = getRandomElements(lootlist, 1)[0];
    const getLootTable = world.getLootTableManager().getLootTable(lootId);
    if (!getLootTable)
        return;
    const generateLootFromTable = world.getLootTableManager().generateLootFromTable(getLootTable);
    if (!generateLootFromTable)
        return;
    for (const item of generateLootFromTable) {
        try {
            spawnItem(player.dimension.id, item, block.location);
        }
        catch (error) {
            console.error("生成箱子战利品失败：" + error);
        }
    }
}
// 生成方块柱子
export function setBlockPillar(player, block, params) {
    var _a, _b;
    let { isPillar } = params;
    let { interval, message, sound } = params.options || {};
    const conversion = (_a = params.blockPillar) === null || _a === void 0 ? void 0 : _a.conversion;
    const BlockEvent = params.blockEvent;
    let { hasLightning, onFire, location, probability } = BlockEvent || {};
    if (!location)
        location = spawnLocationBlock.block;
    const options = new Options(player);
    if (!isPillar || !params.blockPillar) {
        console.warn('不是方块柱子类型或者方块柱子配置缺失');
        return;
    }
    let { blockTypeIdList, topBlockTypeId, height, isShuffled } = params.blockPillar;
    if (!interval)
        interval = 0;
    if (interval) {
        interval = normalizeCount(interval);
    }
    if (!blockTypeIdList)
        return;
    if (!topBlockTypeId) {
        topBlockTypeId = ["minecraft:coal_block"];
    }
    options.playSound(sound);
    options.sendMessage(message);
    // 随机获取一个方块ID列表
    if (!height) {
        height = {
            max: 3,
            min: 3,
        };
    }
    else if (typeof height === 'number') {
        height = {
            max: height,
            min: height,
        };
    }
    // 获取起始高度
    const startHeight = ((_b = params.blockPillar) === null || _b === void 0 ? void 0 : _b.startHeight) || 0;
    // 随机获取一个方块ID列表
    const newBlockTypeIdList = isShuffled ? shuffle(getRandomElements(blockTypeIdList, randint(height.min, height.max))) : getRandomElements(blockTypeIdList, randint(height.min, height.max));
    //是混泥土粉末
    const hasConcretePowder = newBlockTypeIdList.some(blockId => blockId.includes('concrete_powder'));
    // 按顺序设置方块，每个间隔 interval tick
    for (let i = 0; i < newBlockTypeIdList.length; i++) {
        const y = block.location.y + i + startHeight;
        system.runTimeout(() => {
            try {
                world.getDimension(block.dimension.id).setBlockType({ x: block.location.x, y: y, z: block.location.z }, newBlockTypeIdList[i]);
                // 在最后一个的上面生成矿石块并生成闪电，然后检查是否可以转换
                if (i === newBlockTypeIdList.length - 1) {
                    system.runTimeout(() => {
                        world.getDimension(block.dimension.id).setBlockType({ x: block.location.x, y: block.location.y + i + 1, z: block.location.z }, getRandomElements(shuffle(topBlockTypeId), 1)[0]);
                        // 生成闪电
                        system.runTimeout(() => {
                            try {
                                /** 生成概率 默认100 */
                                probability = probability !== null && probability !== void 0 ? probability : 100;
                                if (randint(0, 100) <= probability) {
                                    // 生成闪电
                                    if (hasLightning) {
                                        if (location == spawnLocationBlock.block) {
                                            world.getDimension(block.dimension.id).runCommand(`summon lightning_bolt ${block.location.x + 0.5} ${block.location.y + i + 1} ${block.location.z + 0.5}`);
                                        }
                                        else if (location == spawnLocationBlock.player) {
                                            world.getDimension(block.dimension.id).runCommand(`summon lightning_bolt ${player.location.x + 0.5} ${player.location.y} ${player.location.z + 0.5}`);
                                        }
                                    }
                                    // 生成火
                                    if (onFire) {
                                        if (location == spawnLocationBlock.block) {
                                            world.getDimension(block.dimension.id).setBlockType({ x: block.location.x, y: block.location.y + i + 2, z: block.location.z }, 'minecraft:fire');
                                        }
                                        else if (location == spawnLocationBlock.player) {
                                            world.getDimension(block.dimension.id).setBlockType({ x: player.location.x, y: player.location.y, z: player.location.z }, 'minecraft:fire');
                                        }
                                    }
                                }
                                // 检查是否可以转换
                                if (conversion) {
                                    for (let i = 0; i < newBlockTypeIdList.length; i++) {
                                        const y = block.location.y + i + startHeight;
                                        // 获取当前位置的方块
                                        const currentBlock = world.getDimension(block.dimension.id).getBlock({
                                            x: block.location.x,
                                            y: block.location.y + i,
                                            z: block.location.z
                                        });
                                        if (currentBlock) {
                                            // 获取原方块的颜色
                                            const color = getColor(currentBlock.typeId);
                                            // 替换方块
                                            if (color) {
                                                world.getDimension(block.dimension.id).setBlockType({ x: block.location.x, y: block.location.y + i, z: block.location.z }, `minecraft:${color}_${conversion}`);
                                            }
                                        }
                                    }
                                }
                            }
                            catch (error) {
                                console.error("生成闪电、火焰、或者方块替换失败" + error);
                            }
                        }, 5);
                    }, hasConcretePowder ? interval * (startHeight + newBlockTypeIdList.length) / 5 : interval);
                }
            }
            catch (error) {
                console.error("设置方块柱子失败：" + error);
            }
        }, interval * i);
    }
}
// 设置方块
export function setBlock(player, block, params) {
    var _a;
    /**提取配置 */
    const { blockTypeId } = params;
    let { message, sound } = params.options || {};
    /** 间隔时间 默认0*/
    let interval = ((_a = params.options) === null || _a === void 0 ? void 0 : _a.interval) || 0;
    /**方块事件 */
    const BlockEvent = params.blockEvent;
    let { hasLightning, onFire, location, probability } = BlockEvent || {};
    /**生成位置默认为方块位置 */
    if (!location)
        location = spawnLocationBlock.block;
    /** 选项 */
    const options = new Options(player);
    if (interval) {
        interval = normalizeCount(interval);
    }
    if (!blockTypeId)
        return;
    let newBlockTypeId;
    if (Array.isArray(blockTypeId)) {
        newBlockTypeId = blockTypeId[randint(0, blockTypeId.length - 1)];
    }
    else {
        newBlockTypeId = blockTypeId;
    }
    let newBlockItem = new ItemStack(newBlockTypeId);
    try {
        system.runTimeout(() => {
            world.getDimension(block.dimension.id).setBlockType({ x: block.location.x, y: block.location.y, z: block.location.z }, newBlockTypeId);
            system.runTimeout(() => {
                /** 生成概率 默认100 */
                probability = probability !== null && probability !== void 0 ? probability : 100;
                if (randint(0, 100) <= probability) {
                    // 生成闪电
                    if (hasLightning) {
                        if (location == spawnLocationBlock.block) {
                            world.getDimension(block.dimension.id).runCommand(`summon lightning_bolt ${block.location.x + 0.5} ${block.location.y + 1} ${block.location.z + 0.5}`);
                        }
                        else if (location == spawnLocationBlock.player) {
                            world.getDimension(block.dimension.id).runCommand(`summon lightning_bolt ${player.location.x + 0.5} ${player.location.y} ${player.location.z + 0.5}`);
                        }
                    }
                    // 生成火
                    if (onFire) {
                        if (location == spawnLocationBlock.block) {
                            world.getDimension(block.dimension.id).setBlockType({ x: block.location.x, y: block.location.y + 1, z: block.location.z }, 'minecraft:fire');
                        }
                        else if (location == spawnLocationBlock.player) {
                            world.getDimension(block.dimension.id).setBlockType(player.location, 'minecraft:fire');
                        }
                    }
                }
            }, 5);
        }, interval);
    }
    catch (error) {
        console.error("生成闪电或者火焰失败" + error);
    }
    options.sendMessage(message === null || message === void 0 ? void 0 : message.replace('$blockname', newBlockItem.localizationKey), interval);
    options.playSound(sound, interval);
}
// 生成实体
export function spawnEntity(player, block, params) {
    // console.log('进入函数');
    var _a, _b;
    let { setTime } = params;
    for (const spawn of params.spawn) {
        let { entityTypeId, offset, name, count, entityEffects, playerEffects } = spawn;
        let { message, sound } = spawn.options || {};
        let interval = ((_a = spawn.options) === null || _a === void 0 ? void 0 : _a.interval) || 0;
        const options = new Options(player);
        if (interval) {
            interval = normalizeCount(interval);
        }
        count = (_b = normalizeCount(count)) !== null && _b !== void 0 ? _b : 1;
        if (!entityTypeId)
            return;
        try {
            system.runTimeout(() => {
                var _a;
                let x = block.location.x + 0.5;
                let z = block.location.z + 0.5;
                const offsetXZ = getRandomXZOffset(offset !== null && offset !== void 0 ? offset : 0);
                // 生成实体
                for (let i = 0; i < count; i++) {
                    const blockY = !offset || ((_a = world.getDimension(block.dimension.id).getBlock({ x: x + offsetXZ.x, y: block.location.y, z: z + offsetXZ.z })) === null || _a === void 0 ? void 0 : _a.typeId) == 'minecraft:air' ? block.location.y : getSpawnY({ x: x + offsetXZ.x, y: block.location.y, z: z + offsetXZ.z }, block.dimension.id);
                    let entity = world.getDimension(block.dimension.id).spawnEntity(entityTypeId, { x: x + offsetXZ.x, y: blockY, z: z + offsetXZ.z });
                    if (name) {
                        entity.nameTag = name;
                    }
                }
            }, interval);
        }
        catch (error) {
            console.error("生成实体失败：" + error);
        }
        options.sendMessage(message, interval);
        options.playSound(sound, interval);
    }
}
