import { ItemStack, system, world } from "@minecraft/server";
import { applyDamage } from "../../types/function";
/**
 
 */
system.beforeEvents.startup.subscribe((init) => {
    init.itemComponentRegistry.registerCustomComponent('xxr:spider_man_sword', {
        onUse: (event) => {
            var _a, _b;
            // 获取玩家看向的实体
            const player = event.source;
            const entity = (_a = player.getEntitiesFromViewDirection()[0]) === null || _a === void 0 ? void 0 : _a.entity;
            if (entity) {
                // 在实体那生成蜘蛛网
                // 获取玩家背包
                const container = (_b = player.getComponent('inventory')) === null || _b === void 0 ? void 0 : _b.container;
                const findWeb = container === null || container === void 0 ? void 0 : container.find(new ItemStack('minecraft:web'));
                const findString = container === null || container === void 0 ? void 0 : container.find(new ItemStack('minecraft:string'));
                if (findWeb != undefined || findString != undefined) {
                    if (findWeb != undefined) {
                        player.runCommand('clear @s minecraft:web 0 1');
                        createWeb(entity);
                        sound(player);
                        applyDamage(entity, Math.floor(Math.random() * 2) + 1);
                        return;
                    }
                    if (findString != undefined) {
                        player.runCommand('clear @s minecraft:string 0 1');
                        createWeb(entity);
                        sound(player);
                        applyDamage(entity, Math.floor(Math.random() * 2) + 1);
                        return;
                    }
                }
                else {
                    player.sendMessage('你没有蜘蛛网或线');
                }
            }
        }
    });
});
function sound(player) {
    const sound = ['xxr.tusi.1', 'xxr.tusi.2', 'xxr.tusi.3', 'xxr.tusi.4'];
    player.playSound(sound[Math.floor(Math.random() * sound.length)]);
}
function createWeb(entity) {
    world.getDimension(entity.dimension.id).setBlockType(entity.location, 'minecraft:web');
}
