import { EntityComponentTypes, EquipmentSlot, system, world } from "@minecraft/server";
/**
 * 青金石剑效果：
 * 击杀生物时会生成6个经验球
 */
system.beforeEvents.startup.subscribe((init) => {
    init.itemComponentRegistry.registerCustomComponent('xxr:lapis_sword', {
        onHitEntity: (event) => {
            // 注册占位
        }
    });
});
world.afterEvents.entityDie.subscribe((event) => {
    var _a, _b;
    if (((_a = event.damageSource.damagingEntity) === null || _a === void 0 ? void 0 : _a.typeId) !== 'minecraft:player')
        return;
    // 获取攻击者
    const attacker = event.damageSource.damagingEntity;
    // 获取攻击者的手持武器是否有xxr:lapis_sword组件
    const item = (_b = attacker.getComponent(EntityComponentTypes.Equippable)) === null || _b === void 0 ? void 0 : _b.getEquipment(EquipmentSlot.Mainhand);
    if (item === null || item === void 0 ? void 0 : item.hasComponent('xxr:lapis_sword')) {
        // 有xxr:lapis_sword组件，执行逻辑
        try {
            // 生成6个经验球
            for (let i = 0; i < 6; i++) {
                world.getDimension(event.deadEntity.dimension.id).spawnEntity("minecraft:xp_orb", event.deadEntity.location);
            }
        }
        catch (error) {
            console.error('青金石剑生成经验球失败:', error);
        }
    }
});
