import os

def get_json_names(directory):
    json_names = []
    
    # 遍历目录及其所有子目录
    for root, dirs, files in os.walk(directory):
        for file in files:
            # 检查文件是否为JSON文件
            if file.endswith('.json'):
                # 获取相对于chests目录的路径
                relative_path = os.path.relpath(root, directory)
                # 获取不带后缀的文件名
                name = os.path.splitext(file)[0]
                
                # 构建完整路径
                if relative_path == '.':
                    full_path = f'loot_tables\\chests\\{name}'
                else:
                    full_path = f'loot_tables\\chests\\{relative_path}\\{name}'
                
                json_names.append(full_path)
    
    return json_names

# 指定目录
directory = 'chests'

# 检查目录是否存在
if os.path.exists(directory):
    # 获取所有JSON文件名
    json_names = get_json_names(directory)
    
    # 打印数组格式
    print("[")
    for i, name in enumerate(json_names):
        if i == len(json_names) - 1:  # 最后一个元素
            print(f"    \"{name}\"")
        else:
            print(f"    \"{name}\",")
    print("]")
    
else:
    print(f"目录 '{directory}' 不存在")

# 等待用户按回车键退出
input("\n按回车键退出...")