
//base wave algorithm from SEUS PE shader by Gabriel Paixao
//modified by me
highp float getWave(highp vec3 pos){
      pos.z += TIME * 0.4;
      highp float w = sin(noise(vec2(pos.x*0.2 + pos.z *0.2 + pos.y*0.3 + pos.x*0.2, pos.z*0.3 + pos.x*0.2 + pos.z*0.4)));

      highp float f = sin(noise(vec2(pos.z + pos.y, pos.x + pos.z)));
      float dist = sin(TIME * 1.7 + pos.x + pos.z)*sin(TIME * 1.2 + pos.x);
return mix(w, f, dist);
}

//base normal water code from Zaifa's shader v3 this code with permission from dev
//modified by me
highp float getWater(vec3 pos, vec3 dpos){
      float a = getWave(pos), b = getWave(pos-0.1), c = a-b;

      vec3 n = vec3(c,-c,1.0);
      vec3 N = normalize(reflect(dpos,n));
            dpos = normalize(dpos);

      vec3 np = n*0.5 + 0.0*n*sin(dpos)/max(-0.3,length(dpos.xzy*1.0));

return dot(sin(np),vec3(-0.5,1.0,1.5));
}

vec4 water(function m, Color n){
      highp float wave = getWater(2.7*position.zyx, worldpos);
      vec4 fake_reflect = max(vec4(0.5,0.7,0.9,1.0)*n.fc,fbm(worldpos.xz*0.01*pow(wave*4.0,2.0), 0.002, 0.8)*1.2*(1.0-m.nightfunc));

      vec4 water_col = vec4(mix(vec3(0.0, 0.43, 0.8) * n.fc.rgb, n.fc.rgb*0.6, m.lp), 0.3-clamp(wave, 0.0, 1.0));

      vec4 res = mix(water_col, fake_reflect, pow(wave,1.0)*clamp(m.lp+0.5, 0.0, 0.8));
         res.a += pow(m.lp, 7.0);
return res;
}