import { Server } from "./../../../library/Minecraft.js";
import { registerCommand } from "../register_commands.js";
import { assertPermission } from "./../../modules/assert.js";
import { Mask } from "./../../modules/mask.js";
import { RawText } from "./../../../library/Minecraft.js";
const registerInformation = {
    name: "tool",
    description: "commands.wedit:tool.description",
    usage: [
        {
            subName: "none"
        },
        {
            subName: "stacker",
            permission: "worldedit.tool.stack",
            description: "commands.wedit:tool.description.stacker",
            args: [
                {
                    name: "range",
                    type: "int",
                    range: [1, null],
                    default: 1
                }, {
                    name: "mask",
                    type: "Mask",
                    default: new Mask()
                }
            ]
        },
        {
            subName: "selwand",
            permission: "worldedit.setwand",
            description: "commands.wedit:tool.description.selwand"
        },
        {
            subName: "navwand",
            permission: "worldedit.setwand",
            description: "commands.wedit:tool.description.navwand"
        },
        {
            subName: "farwand",
            permission: "worldedit.farwand",
            description: "commands.wedit:tool.description.farwand"
        },
        {
            subName: "cmd",
            permission: "worldedit.tool.cmd",
            description: "commands.wedit:tool.description.cmd",
            args: [
                {
                    name: "command",
                    type: "string..."
                }
            ]
        },
        {
            subName: "repl",
            permission: "worldedit.repl",
            description: "commands.wedit:tool.description.repl",
            args: [
                {
                    name: "pattern",
                    type: "Pattern"
                }
            ]
        },
        {
            subName: "cycler",
            permission: "worldedit.cycler",
            description: "commands.wedit:tool.description.cycler"
        }
    ]
};
// TODO: Add floodfill tool
// TODO: Add delete tree tool
function heldItemName(player) {
    const name = Server.player.getHeldItem(player).typeId;
    return name.replace("minecraft:", "");
}
const stack_command = (session, builder, args) => {
    assertPermission(builder, registerInformation.usage[1].permission);
    session.bindTool("stacker_wand", null, args.get("range"), args.get("mask"));
    return RawText.translate("commands.wedit:tool.bind.stacker").with(heldItemName(builder));
};
const selwand_command = (session, builder) => {
    assertPermission(builder, registerInformation.usage[2].permission);
    session.bindTool("selection_wand", null);
    return RawText.translate("commands.wedit:tool.bind.selwand").with(heldItemName(builder));
};
const navwand_command = (session, builder) => {
    assertPermission(builder, registerInformation.usage[3].permission);
    session.bindTool("navigation_wand", null);
    return RawText.translate("commands.wedit:tool.bind.navwand").with(heldItemName(builder));
};
const farwand_command = (session, builder) => {
    assertPermission(builder, registerInformation.usage[4].permission);
    session.bindTool("far_selection_wand", null);
    return RawText.translate("commands.wedit:tool.bind.farwand").with(heldItemName(builder));
};
const cmd_command = (session, builder, args) => {
    assertPermission(builder, registerInformation.usage[5].permission);
    session.bindTool("command_wand", null, args.get("command").join(" "));
    return RawText.translate("commands.wedit:tool.bind.cmd").with(heldItemName(builder));
};
const repl_command = (session, builder, args) => {
    assertPermission(builder, registerInformation.usage[6].permission);
    session.bindTool("replacer_wand", null, args.get("pattern"));
    return RawText.translate("commands.wedit:tool.bind.repl").with(heldItemName(builder));
};
const cycler_command = (session, builder) => {
    assertPermission(builder, registerInformation.usage[7].permission);
    session.bindTool("cycler_wand", null);
    return RawText.translate("commands.wedit:tool.bind.cycler").with(heldItemName(builder));
};
registerCommand(registerInformation, function (session, builder, args) {
    let msg;
    if (args.has("stacker")) {
        msg = stack_command(session, builder, args);
    }
    else if (args.has("selwand")) {
        msg = selwand_command(session, builder);
    }
    else if (args.has("navwand")) {
        msg = navwand_command(session, builder);
    }
    else if (args.has("farwand")) {
        msg = farwand_command(session, builder);
    }
    else if (args.has("cmd")) {
        msg = cmd_command(session, builder, args);
    }
    else if (args.has("repl")) {
        msg = repl_command(session, builder, args);
    }
    else if (args.has("cycler")) {
        msg = cycler_command(session, builder);
    }
    else {
        session.unbindTool(null);
        return "commands.wedit:tool.unbind";
    }
    return msg.append("text", "\n").append("translate", "commands.generic.wedit:unbindInfo").with(";tool none");
});
