import { world, system } from "@minecraft/server";

world.afterEvents.itemCompleteUse.subscribe(event=>{
	if (event.itemStack.typeId == "custom:random_popsicle"){
		var select=Math.floor(Math.random()*30);
		var effect=["absorption","haste","speed","strength","regeneration","water_breathing","fire_resistance","resistance","instant_health","jump_boost","night_vision","village_hero","saturation","slow_falling","instant_damage","darkness","poison","weakness","blindness","levitation","oozing","hunger","slowness","bad_omen","mining_fatigue","nausea","wither","infested","wind","turtle","clear"]
		if (select > 27) {
			switch (effect[select]) {
				case "clear":
				event.source.runCommand(`effect @s clear`);
				break
				case "turtle":
				event.source.runCommand(`effect @s slowness 120 3`);
				event.source.runCommand(`effect @s resistance 120 2`);
				break
				case "wind":
				event.source.runCommand(`effect @s wind_charged 99999 0`);
				break
			}
		}
		else {
			if (select < 14) {event.source.runCommand(`effect @s ${effect[select]} 120 0`);}
			else {event.source.runCommand(`effect @s ${effect[select]} 30 0`);}
		}
		event.source.runCommand(`titleraw @s actionbar {\"rawtext\":[{\"translate\":\"dia.text.eat_random\"}]}`);
	}
	if (event.itemStack.typeId == "custom:banana_popsicle"){event.source.runCommand(`effect @s night_vision 120 0`);}
	if (event.itemStack.typeId == "custom:grape_popsicle"){event.source.runCommand(`effect @s regeneration 120 0`);}
	if (event.itemStack.typeId == "custom:honey_popsicle"){event.source.runCommand(`effect @s fire_resistance 120 0`);}
	if (event.itemStack.typeId == "custom:lemon_popsicle"){event.source.runCommand(`effect @s strength 120 0`);}
	if (event.itemStack.typeId == "custom:melon_popsicle"){event.source.runCommand(`effect @s instant_health`);}
	if (event.itemStack.typeId == "custom:milk_popsicle"){event.source.runCommand(`effect @s invisibility 120 0`);}
	if (event.itemStack.typeId == "custom:mint_popsicle"){event.source.runCommand(`effect @s speed 120 0`);}
	if (event.itemStack.typeId == "custom:pomelo_popsicle"){event.source.runCommand(`effect @s jump_boost 120 0`);}
	if (event.itemStack.typeId == "custom:popsicle"){event.source.runCommand(`effect @s slow_falling 120 0`);}
	if (event.itemStack.typeId == "custom:yogurt_popsicle"){event.source.runCommand(`effect @s water_breathing 120 0`);}
	if (event.itemStack.typeId == "custom:blueberry_popsicle"){event.source.runCommand(`effect @s slowness 120 3`); event.source.runCommand(`effect @s resistance 120 2`);}
});
world.afterEvents.entityHitEntity.subscribe(t => {
	var entity = t.hitEntity
	var attack = t.damagingEntity
	if (attack.runCommand("testfor @s[hasitem={item=custom:oxidized_copper_sword,location=slot.weapon.mainhand}]").successCount == 1){
		entity.runCommand(`effect @s fatal_poison 5 1`)
	}
	if (attack.runCommand("testfor @s[hasitem={item=custom:amethyst_sword,location=slot.weapon.mainhand}]").successCount == 1){
		if (entity.typeId == "minecraft:player") {entity.runCommand(`effect @s blindness 15 0`);}
		else {entity.runCommand(`effect @s slowness 15 1`)}
	}
});
world.afterEvents.itemUse.subscribe(u => {
	var actor = u.source
	if (u.itemStack.typeId == "custom:netherite_wand") {
		if (actor.runCommand("testfor @s[hasitem={item=custom:rune_of_lightning}]").successCount == 1) {
			actor.runCommand("tag @s add sm:actor")
			actor.runCommand(`execute positioned as @s run execute positioned as @e[r=30,tag=!sm:actor,c=1] run summon lightning_bolt`)
			actor.runCommand("clear @s[m=!c] custom:rune_of_lightning 0 1")
			actor.runCommand("tag @s remove sm:actor")
		}
	}
});
system.runInterval(()=>{
	const lvl = world.scoreboard.getObjective("level")
	const time = world.scoreboard.getObjective("time")
	const piece = world.scoreboard.getObjective("pieces")
	let players = Array.from(world.getPlayers())
	for(let player of players){
		const x = player.location.x
		const y = player.location.y
		const z = player.location.z
		if (!piece.hasParticipant(player)) {
			piece.setScore(player, 0)
		}
		if (!player.getEffect("regeneration") && piece.getScore(player) > 1) {
			player.addEffect("regeneration", 20000000, {amplifier: 1})
		}
		if (!player.getEffect("health_boost") && piece.getScore(player) > 2) {
			player.runCommand("effect @s health_boost infinite 4")
		}
		if (!lvl.hasParticipant(player)) {
			lvl.setScore(player, 0)
			player.runCommand("function ach/ncomer")
		}
		for(let slot=0; slot<player.getComponent('inventory').container.size; slot++){
			if(player.getComponent('inventory').container.getItem(slot) == undefined){
				continue
			}
			let item = player.getComponent("inventory")
				.container.getItem(slot)
			if (item.typeId == "custom:oxidized_copper_sword") {
				item.setLore([{translate: "dia.lore.oxidized_sword"}])
				player.getComponent(`inventory`)
            		.container.setItem(slot, item)
			}
		}
	}
});