import { world, system } from "@minecraft/server";

const TARGET_NPC = "hivehub:game_kits";
const TP_POS = { x: 1000, y: 5, z: -1000 };
const TP_FACING = { x: 1001, y: 5, z: -1000 };

// === PLAYER INTERACT ===
world.afterEvents.playerInteractWithEntity.subscribe(({ player, target }) => {
    if (!player || !target || target.typeId !== TARGET_NPC) return;

    player.runCommandAsync(
        `tp @s ${TP_POS.x} ${TP_POS.y} ${TP_POS.z} facing ${TP_FACING.x} ${TP_FACING.y} ${TP_FACING.z}`
    ).then(() => {
        system.runTimeout(() => {
            player.runCommandAsync(`particle minecraft:knockback_roar_particle ~ ~ ~`);
            player.runCommandAsync(`spawnpoint @s ${TP_POS.x} ${TP_POS.y} ${TP_POS.z}`);
            player.addEffect("blindness", 20, { amplifier: 0, showParticles: false });
            player.playSound("mob.endermen.portal");
        }, 1);
    });
});

// === ENTITY HIT ===
world.afterEvents.entityHitEntity.subscribe(({ damagingEntity, hitEntity }) => {
    if (!damagingEntity || damagingEntity.typeId !== "minecraft:player") return;
    if (!hitEntity || hitEntity.typeId !== TARGET_NPC) return;

    damagingEntity.runCommandAsync(
        `tp @s ${TP_POS.x} ${TP_POS.y} ${TP_POS.z} facing ${TP_FACING.x} ${TP_FACING.y} ${TP_FACING.z}`
    ).then(() => {
        system.runTimeout(() => {
            damagingEntity.runCommandAsync(`particle minecraft:knockback_roar_particle ~ ~ ~`);
            damagingEntity.runCommandAsync(`spawnpoint @s ${TP_POS.x} ${TP_POS.y} ${TP_POS.z}`);
            damagingEntity.addEffect("blindness", 20, { amplifier: 0, showParticles: false });
            damagingEntity.playSound("mob.endermen.portal");
        }, 1);
    });
});