import { world, system } from "@minecraft/server";
import { ActionFormData } from "@minecraft/server-ui";


world.afterEvents.playerInteractWithEntity.subscribe(event => {
    const { player, target } = event;
    if (!target || target.typeId !== "npc:npc_custom8") return;
    enchantments(player);
    player.playSound("random.pop2");
    player.playSound("mob.villager.haggle");
});


world.afterEvents.entityHitEntity.subscribe(event => {
    const { damagingEntity, hitEntity } = event;
    if (!(damagingEntity?.typeId === "minecraft:player")) return;
    if (!hitEntity || hitEntity.typeId !== "npc:npc_custom8") return;
    enchantments(damagingEntity);
    damagingEntity.playSound("random.pop2");
    damagingEntity.playSound("mob.villager.haggle");
});

function enchantments(player) {
    let prices = [
        165987, 67789, 70234, 72300, 90279,
        180000, 155000, 150000, 145000, 148999,
        175000, 80000, 185999, 178877, 178999,
        40899, 42588, 50000
    ];

    let structures = [
        "a1", "a2", "a3", "a4", "a5",
        "a6", "a7", "a8", "a9", "a10",
        "a11", "a12", "a13", "a14", "a15",
        "a16", "a17", "a18"
    ];

    let names = [
        "Protection X", "Blast Protection X", "Projectile Protection X", "Fire Protection X", "Feather Falling X",
        "Sharpness X", "Smite X", "Looting X", "Fire Aspect X", "Thorns X",
        "Power X", "Unbreaking X", "Fortune X", "Efficiency X", "Impaling X",
        "Luck of the Sea X", "Lure X", "Piercing X"
    ];

    function showForm() {
        let moneyObjective = world.scoreboard.getObjective("Money");
        let currentMoney = moneyObjective.getScore(player) ?? 0;

        let form = new ActionFormData()
            .title("§lOP Enchanter")
            .body(`Choose an enchantment below!\nYour Current Amount of\n§aMoney: §a${currentMoney}\n\n§e- Important:\nMinecraft Bedrock has a "Too Expensive" anvil enchantment limit.\nApply enchantments at your own risk.\nAvoid stacking too many Level X enchants on a single item!`)

        for (let i = 0; i < names.length; i++) {
            form.button(`§l${names[i]}\n§rPrice = §a${prices[i]}`, "textures/items/book");
        }

        form.show(player).then(response => {
            if (response.canceled) return;

            let selection = response.selection;
            currentMoney = moneyObjective.getScore(player) ?? 0;

            let selectedPrice = prices[selection];
            let structureName = structures[selection];
            let enchantName = names[selection];

            if (currentMoney >= selectedPrice) {
                player.runCommandAsync(`scoreboard players remove @s Money ${selectedPrice}`);
                player.runCommandAsync(`structure load ${structureName} ~ ~ ~`);
                player.sendMessage(`§a${enchantName} Purchased Successfully!`);
                player.playSound("random.orb");
                system.runTimeout(() => showForm(), 1);
            } else {
                player.sendMessage("§cNot enough money!");
                player.playSound("mob.villager.no");
            }
        });
    }

    showForm();
}