import { world, system } from "@minecraft/server";
import { ActionFormData } from "@minecraft/server-ui";


world.afterEvents.playerInteractWithEntity.subscribe(event => {
    const { player, target } = event;
    if (!target || target.typeId !== "hivehub:game_wars") return;

    game(player);
});


world.afterEvents.entityHitEntity.subscribe(event => {
    const { damagingEntity, hitEntity } = event;
    if (!(damagingEntity?.typeId === "minecraft:player")) return;
    if (!hitEntity || hitEntity.typeId !== "hivehub:game_wars") return;

    game(damagingEntity);
});

function game(player) {
	const over = world.getDimension("minecraft:overworld");
	player.playSound("random.pop2");
        new ActionFormData()
            .title("§lMINI GAMES")
            .body('Choose where you wanna Teleport!')
            .button('§l§bP§eV§bP\n§r§7[ Click to Teleport ]', "textures/ui/pvp")
            .button('§l§bTHE END\n§r§7[ Click to Teleport ]', "textures/ui/end")
            .button('§l§5Parkour\n§r§7[ Click to Teleport ]', "textures/ui/parkour")
            .button('§l§cBow§bWars\n§r§7[ Click to Teleport ]', "textures/items/bow_standby")
            .button('§l§dBlock§6Drop §l§c[BETA]\n§r§7[ Click to Teleport ]', "textures/ui/blockdrop")
            .button('§l§bSky§eWars\n§r§7[ Click to Teleport ]', "textures/ui/skywars")
            .button('§l§dBlock§bParty\n§l§c[Not Available]')
            .button('§g§lDeathRun\n§l§c[Not Available]')
            .button('§l§fGravity\n§l§c[Not Available]')
            .show(player).then(r => {
            	if (r.selection == 0) {
    const locations = [
        { x: -993, y: 31, z: 1007 },
        { x: -1007, y: 31, z: 1007 },
        { x: -1007, y: 31, z: 993 },
        { x: -993, y: 31, z: 993 }
    ];

    // Pick a random location
    const loc = locations[Math.floor(Math.random() * locations.length)];

    over.runCommandAsync(`tp "${player.name}" ${loc.x} ${loc.y} ${loc.z}`).then(() => {
        system.runTimeout(() => {
            player.runCommandAsync(`particle minecraft:knockback_roar_particle ~ ~ ~`);
            player.addEffect("blindness", 20, {
                amplifier: 0,
                showParticles: false
            });
            player.playSound("mob.endermen.portal");
        }, 1); // delay by 1 tick
    });
}
                if (r.selection == 1) {
                    const end = world.getDimension("minecraft:the_end");
                      end.runCommandAsync(`tp "${player.name}" 18 63 0`).then(() => {
        system.runTimeout(() => {
            player.runCommandAsync(`particle minecraft:knockback_roar_particle ~ ~ ~`);
            player.addEffect("blindness", 20, {
  amplifier: 0,
  showParticles: false
});
            player.playSound("mob.endermen.portal");
        }, 1); // delay by 1 tick (~50ms)
    });
                }
                if (r.selection == 2) {
                    over.runCommandAsync(`tp "${player.name}" -2000 5 -2000 facing -2000 5 -1999`).then(() => {
        system.runTimeout(() => {
            player.runCommandAsync(`particle minecraft:knockback_roar_particle ~ ~ ~`);
            player.addEffect("blindness", 20, {
  amplifier: 0,
  showParticles: false
});
            player.playSound("mob.endermen.portal");
        }, 1); // delay by 1 tick (~50ms)
    });
                }
                if (r.selection == 3) {
                    over.runCommandAsync(`tp "${player.name}" -3000 5 3000 facing -2999 5 3000`).then(() => {
        system.runTimeout(() => {
            player.runCommandAsync(`particle minecraft:knockback_roar_particle ~ ~ ~`);
            player.addEffect("blindness", 20, {
  amplifier: 0,
  showParticles: false
});
            player.playSound("mob.endermen.portal");
        }, 1); // delay by 1 tick (~50ms)
    });
                }
                if (r.selection == 4) {
                    over.runCommandAsync(`tp "${player.name}" 2000 5 -2000 facing 2000 5 -1999`).then(() => {
        system.runTimeout(() => {
            player.runCommandAsync(`particle minecraft:knockback_roar_particle ~ ~ ~`);
            player.addEffect("blindness", 20, {
  amplifier: 0,
  showParticles: false
});
            player.playSound("mob.endermen.portal");
        }, 1); // delay by 1 tick (~50ms)
    });
                }
                if (r.selection == 5) {
    // === SkyWars random teleport ===
    const skywarsSpawns = [
        { x: 4974, y: 62, z: 4943 },
        { x: 4943, y: 62, z: 4970 },
        { x: 4935, y: 62, z: 4998 },
        { x: 4943, y: 62, z: 5026 },
        { x: 4970, y: 62, z: 5057 },
        { x: 4998, y: 62, z: 5065 },
        { x: 5026, y: 62, z: 5057 },
        { x: 5057, y: 62, z: 5030 },
        { x: 5065, y: 62, z: 5002 },
        { x: 5057, y: 62, z: 4974 },
        { x: 5030, y: 62, z: 4943 },
        { x: 5002, y: 62, z: 4935 },
    ];

    // Pick random spawn
    const spawn = skywarsSpawns[Math.floor(Math.random() * skywarsSpawns.length)];

    // Teleport facing the middle (5000 60 5000)
    over.runCommandAsync(`tp "${player.name}" ${spawn.x} ${spawn.y} ${spawn.z} facing 5000 60 5000`).then(() => {
        system.runTimeout(() => {
            player.runCommandAsync(`particle minecraft:knockback_roar_particle ~ ~ ~`);
            player.addEffect("blindness", 20, {
                amplifier: 0,
                showParticles: false
            });
            player.playSound("mob.endermen.portal");
        }, 1); // delay by 1 tick (~50ms)
    });
}
            })
    }