import { world, system } from "@minecraft/server";

const TARGET_NPC = "hivehub:npc_region";

world.afterEvents.playerInteractWithEntity.subscribe(({ player, target }) => {
    if (!player || !target || target.typeId !== TARGET_NPC) return;

    player.runCommandAsync("tp @s 0 200 0 facing 0 200 1").then(() => {
        system.runTimeout(() => {
            player.runCommandAsync(`particle minecraft:knockback_roar_particle ~ ~ ~`);
            player.runCommandAsync(`clearspawnpoint @s`);
            player.addEffect("blindness", 20, {
                amplifier: 0,
                showParticles: false
            });
            player.playSound("item.trident.return");
        }, 1);
    });
});

world.afterEvents.entityHitEntity.subscribe(({ damagingEntity, hitEntity }) => {
    if (!damagingEntity || damagingEntity.typeId !== "minecraft:player") return;
    if (!hitEntity || hitEntity.typeId !== TARGET_NPC) return;

    damagingEntity.runCommandAsync("tp @s 0 200 0 facing 0 200 1").then(() => {
        system.runTimeout(() => {
            damagingEntity.runCommandAsync(`particle minecraft:knockback_roar_particle ~ ~ ~`);
            damagingEntity.runCommandAsync(`clearspawnpoint @s`);
            damagingEntity.addEffect("blindness", 20, {
                amplifier: 0,
                showParticles: false
            });
            damagingEntity.playSound("item.trident.return");
        }, 1);
    });
});