import { world, system } from "@minecraft/server";
import { ActionFormData } from "@minecraft/server-ui";


world.afterEvents.playerInteractWithEntity.subscribe(event => {
    const { player, target } = event;
    if (!target || target.typeId !== "hivehub:game_hide") return;

    player.runCommandAsync("tp @s -3000 5 -3000");
});


world.afterEvents.entityHitEntity.subscribe(event => {
    const { damagingEntity, hitEntity } = event;

    
    if (!(damagingEntity?.typeId === "minecraft:player")) return;

    
    if (!hitEntity || hitEntity.typeId !== "hivehub:game_hide") return;

    
    damagingEntity.runCommandAsync("tp @s -3000 5 -3000");
});