import { world } from "@minecraft/server";
import { ActionFormData } from "@minecraft/server-ui";


world.afterEvents.playerInteractWithEntity.subscribe(event => {
    const { player, target } = event;
    if (!target || target.typeId !== "hivehub:npc_postbox") return;

    about(player);
    player.runCommandAsync("playsound note.xylophone @s");
});


world.afterEvents.entityHitEntity.subscribe(event => {
    const { damagingEntity, hitEntity } = event;
    if (!(damagingEntity?.typeId === "minecraft:player")) return;
    if (!hitEntity || hitEntity.typeId !== "hivehub:npc_postbox") return;

    about(damagingEntity);
    damagingEntity.runCommandAsync("playsound note.xylophone @s");
});

function about(player) {
        new ActionFormData()
            .title('§e§lServer Info')
            .body("Choose an option below")
            .button('§cRules\n§r§7[ Click to View ]', "textures/ui/ErrorGlyph")
            .button('§9How to play\n§r§7[ Click to View ]', "textures/ui/blue_info_glyph")
            .button('§eCredits\n§r§7[ Click to View ]', "textures/ui/permissions_op_crown")
            .button('§gChangelog\n§r§7[ Click to View ]', "textures/items/book_writable")
            .show(player).then(r => {
                if (r.selection == 0) rules(player)
                if (r.selection == 1) howtoplay(player)
                if (r.selection == 2) Credits(player)
                if (r.selection == 3) changelog(player)
            })
    }
    
    function changelog(player) {
    new ActionFormData()
        .title("§l§gChangelog")
        .body("§eSelect a version to view its changes")
        .button('§aBETA 5.0', "textures/items/book_writable")
        .button('§aBETA 4.0', "textures/items/book_writable")
        .button('§aBETA 3.0', "textures/items/book_writable")
        .button('§l§cBack', "textures/ui/arrow_left")
        .show(player).then(r => {
            if (r.selection == 0) changelogBeta5(player)
            if (r.selection == 1) changelogBeta4(player)
            if (r.selection == 2) changelogBeta3(player)
            if (r.selection == 3) about(player)
        });
}

function changelogBeta5(player) {
    new ActionFormData()
        .title("§lChangelog – BETA 5.0")
        .body(
            `§l§nCHANGELOG§r\n` +
            `§r§eVersion: §cBETA 5.0\n\n` +

            `§l§aNew Features:\n` +
            `§7• New §2Wood Mining Area§7 with §aLumber Merchant§7 (left side of Mining Simulator)\n` +
            `§7• New §bSkyWars!§r\n` +
            `   §7- Mining §cRedstone Ore§7 gives extra hearts (up to 8)\n` +
            `   §7- Redstone regenerates after 9 seconds\n` +
            `   §7- Only §8Andesite§7 can be placed, disappears after 9 seconds (keeps map clean)\n` +
            `§7• §6The Land§7 system updated with 9 plots\n` +
            `   §7- Players can own up to 2 plots at once\n` +
            `   §7- Other players cannot build/break in owned plots\n\n` +

            `§l§eImprovements:\n` +
            `§7• PvE now supports up to §aWave 40\n` +
            `§7• New Kill/Death reward system:\n` +
            `   §7- Every 600 kills: +100k (then increases gradually)\n` +
            `   §7- Every additional 600 kills: +30k bonus\n` +
            `   §7- 50 deaths: -5k | 100 deaths: -8k | 150 deaths: -10k (gradual increase)\n` +
            `§7• Barrier borders added in PvP arena\n` +
            `§7• Anvils added under feet on main BlockDrop map\n` +
            `§7• Server menu improvements + new §aPlot Manager§7 item (Shop → Other Items)\n` +
            `§7• Discounts added for higher ranks in Shop\n` +
            `§7• VIP Minerals sell option in Shop & Sell menu\n` +
            `§7• New §eServer UI textures\n` +
            `§7• Added §6Pressure Plate Boost§7 (Stone & Dark Oak plates)\n` +
            `§7• Added §fFeather Boost§7 (boosts based on where you look)\n` +
            `§7• Fancy Teleporting system added\n` +
            `§7• Killing players now gives §a5k Money§7 each\n` +
            `§7• Durability viewer for tools & armor added\n` +
            `§7• Many more general improvements\n\n` +

            `§l§cFixes:\n` +
            `§7• Restricted block breaking/placing/interaction in protected areas\n` +
            `   (e.g., trapdoors, fence gates, crafting table UIs, etc.)\n` +
            `§7• Fixed PvE bug where spamming start/stop caused glitches\n` +
            `§7• Fixed bug where players could open admin chests in Admin Shop\n` +
            `§7• Fixed bug where teleporting from End sometimes created nether portal in Lobby\n` +
            `§7• Disabled Nether dimension (Quick TP to Overworld instead)\n` +
            `§7• Placed missing border blocks in Admin Shop & PvP Arena\n` +
            `§7• Ranks now update correctly after heavy rejoins\n` +
            `§7• Parkour checkpoint now uses dynamic properties instead of /spawnpoint\n` +
            `§7• BlockDrop now supports max 8 players\n` +
            `§7• Many more bug fixes\n\n` +

            `§l§9Technical Changes:\n` +
            `§7• Removed excessive §bDimension.getEntities§7 calls (FPS boost)\n` +
            `§7• Replaced tags.includes with §btags.delete§7 (better performance)\n` +
            `§7• Optimized §bworld.getPlayers§7 → now cached every 10 ticks (faster scripts)\n` +
            `§7• Used dynamic properties for saving ranked players' particle toggles\n\n` +

            `§l§aThanks for playing and enjoy BETA 5.0!`
        )
        .button('§l§cBack', "textures/ui/arrow_left")
        .show(player).then(r => {
            if (r.selection === 0) changelog(player);
        });
}

function changelogBeta4(player) {
    new ActionFormData()
        .title("§lChangelog – BETA 4.0")
        .body(
            `§l§nCHANGELOG§r\n` +
            `§r§eVersion: §cBETA 4.0\n\n` +

            `§l§aNew Features:\n` +
            `§7• Totally a new lobby (big lobby added)\n` +
            `§7• Added RANKS NPC in the lobby with new rank system\n` +
            `§7• Warrior rank: Strength V and Resistance III permanently\n` +
            `§7• Healer rank: Regeneration V permanently\n` +
            `§7• Miner rank: Haste V permanently\n` +
            `§7• New PvP area added (coming fully soon)\n` +
            `§7• New PvE area in cave-like dungeons (script-based with custom AI & loot)\n` +
            `§7• Shulker Box Place added\n` +
            `§7• Relaxing Park added\n` +
            `§7• Relaxing Place removed (will return in a future update)\n` +
            `§7• New Admin Shop area\n` +
            `§7• New cave-like Mining Area 2\n` +
            `§7• Improved Enchanting Room and Smelting Room\n` +
            `§7• New NPCs with better functions\n\n` +

            `§l§eImprovements:\n` +
            `§7• Parkour checkpoint now uses dynamic properties\n` +
            `§7• BowWars slightly improved\n` +
            `§7• BlockDrop fully changed, now Hive-like using dynamic properties\n` +
            `§7• Server GUI improved with new player info buttons\n` +
            `§7• Scoreboard display system (can hide/unhide via settings)\n` +
            `§7• Gamerules, weather, and time now saved properly\n` +
            `§7• Kills/deaths count properly with fire aspect/flame\n` +
            `§7• Small changes in School & Neighborhood\n` +
            `§7• Slightly improved VIP Zone\n\n` +

            `§l§cFixes:\n` +
            `§7• End reward requires dragon kill (script-based)\n` +
            `§7• Land disabled due to bugs (back in future)\n` +
            `§7• Admin OP shop removed, replaced by OP Enchanter NPC\n` +
            `§7• Several bug fixes\n\n` +

            `§l§aThanks for playing and enjoy BETA 4.0!`
        )
        .button('§l§cBack', "textures/ui/arrow_left")
        .show(player).then(r => {
            if (r.selection === 0) changelog(player);
        });
}

function changelogBeta3(player) {
    new ActionFormData()
        .title("§lChangelog – BETA 3.0")
        .body(
            `§l§nCHANGELOG§r\n` +
            `§r§eVersion: §cBETA 3.0\n\n` +

            `§l§aNew Features:\n` +
            `§7• Lobby updated\n` +
            `§7• SkyWars lobby added\n\n` +

            `§l§eImprovements:\n` +
            `§7• Skyblock mine expanded to 3×3\n` +
            `§7• Renamed mining areas\n` +
            `§7• Fixed bank manager teleportation\n` +
            `§7• Land improvements\n` +
            `§7• New PvE arena + system improvements\n` +
            `§7• Trees added to Relaxing Park border\n` +
            `§7• PvP system enhancements\n` +
            `§7• Selling is now 5× faster\n` +
            `§7• Server menu improved\n` +
            `§7• AFK detection in selling room\n` +
            `§7• Shop/sell prices adjusted\n\n` +

            `§l§cFixes:\n` +
            `§7• Removed info popup\n` +
            `§7• General bug fixes\n\n` +

            `§l§aThanks for playing and enjoy BETA 3.0!`
        )
        .button('§l§cBack', "textures/ui/arrow_left")
        .show(player).then(r => {
            if (r.selection === 0) changelog(player);
        });
}
    
    function rules(player) {
    new ActionFormData()
        .title('§l§cServer Rules')
        .body(
            `§l§cMUST READ - SERVER RULES\n` +
            `§r§7Violating any of these rules may result in §4ban, mute, or restrictions.\n\n` +

            `§l§eRule 1: §r§fCrafting Tables are §cNOT allowed§f.\n` +
            `§7Use only the server's official systems to obtain items.\n\n` +

            `§l§eRule 2: §r§fNo §cgriefing§f or §chacking§f.\n` +
            `§7Cheating or destroying others' builds = §4instant ban§7.\n\n` +

            `§l§eRule 3: §r§fNo §ctoxic behavior§f.\n` +
            `§7Spamming, trolling, and offensive language are punishable.\n\n` +

            `§l§eRule 4: §r§fAlways §brespect§f others.\n` +
            `§7Be kind, no bullying or hate speech.\n\n` +

            `§l§eRule 5: §r§fNo §cstealing§f.\n` +
            `§7Do not take items from other players or chests without permission.\n\n` +

            `§l§eRule 6: §r§fDo not exploit bugs or glitches.\n` +
            `§7Report any exploits to staff immediately.\n\n` +

            `§l§eRule 7: §r§fFollow staff instructions at all times.\n` +
            `§7Disrespecting staff can lead to a ban.\n\n` +

            `§l§eRule 8: §r§fNo alt accounts to bypass bans or gain unfair advantages.\n\n` +

            `§r§cThese rules apply everywhere — §lno exceptions.§r\n`
        )
        .button('§l§cBack', 'textures/ui/arrow_left')
        .show(player).then(r => {
            if (r.selection === 0) about(player);
        });
}

    function howtoplay(player) {
    new ActionFormData()
        .title("§l§9How to play")
        .body(
            `§l§n§bHOW TO PLAY§r\n\n` +

            `§r§7Welcome to the world of §aMining Simulator§7!\n` +
            `§7Here, your mission is to become the §6§lRichest Miner Alive!§r\n\n` +

            `§l§6▶ STARTING OFF ◀§r\n` +
            `§r• Get a free §2Wooden Pickaxe §rfrom §aThe Merchant§r.\n` +
            `• Also grab a §6Wooden Axe§r to start chopping trees!\n` +
            `• Collect valuable logs: §6Oak§r, §8Dark Oak§r, §2Spruce§r, §fBirch§r,\n  §ePale Oak§r, §aJungle§r, §cAcacia§r, §dCherry§r.\n` +
            `• Head into the §aMining Area§r and start digging for ores!\n` +
            `• Collect valuable ores: §7Cobblestone§r, §8Coal§r, §fIron§r, §6Gold§r,\n  §1Lapis§r, §4Redstone§r, §9Flint§r, §8Copper§r, §2Emerald§r,\n  §bDiamond§r, §0Obsidian§r, and §5Ancient Debris§r.\n\n` +

            `§l§e▶ SELL & UPGRADE ◀§r\n` +
            `§r• Sell ores & logs to the §eMineral Merchant §rfor money.\n` +
            `• Use your earnings to §aUpgrade Tools§r, §bBuy Armor§r,\n  §dPotions§r, §cFood§r, and more in the §aThe Merchant§r.\n\n` +

            `§l§3▶ MINI GAMES ◀§r\n` +
            `§r§d• PVP     • PVE     • Parkour\n` +
            `• BlockDrop     • SkyWars     • BowWars\n` +
            `• §5The End §7- §rKill the Ender Dragon for special rewards\n` +
            `§8(More mini-games coming soon!)\n\n` +

            `§l§9▶ PLACES TO EXPLORE ◀§r\n` +
            `§7• §fGarbage Bank§8 – Retrieve cleared items\n` +
            `§7• §fShulker Box Area§8 – Organize your gear\n` +
            `§7• §fRelaxing Park§8 – Take a break with friends\n` +
            `§7• §fSchool & Neighborhood§8 – Explore secrets\n` +
            `§7• §fThe Land§8 – Buy land and build your dream base\n` +
            `§7• §6VIP Zone§8 – Exclusive area for VIP players\n\n` +

            `§l§aReady to begin your journey? Let’s dig in!`
        )
        .button('§l§cBack', "textures/ui/arrow_left")
        .show(player).then(r => {
            if (r.selection === 0) about(player);
        });
}

    function Credits(player) {
    new ActionFormData()
        .title("§l§eCredits")
        .body(
            // Header
            `§l§nCREDITS§r\n\n` +

            // Developer section
            `§l§dDeveloper & Architect:\n` +
            `§r §bFly Sakib\n\n` +

            // Builders section
            `§l§9Builders:\n` +
            `§r §aAdwin1st\n` +
            ` §aPiste9642\n\n` +
            ` §aBluewwie\n\n` +

            // Tools & Technology
            `§l§aBuilt With:\n` +
            `§r §7• Minecraft Bedrock Scripting API\n` +
            ` §7• Custom Behavior Packs\n` +
            ` §7• Hundreds of Command Blocks\n` +
            ` §7• Creative Vision & Late Nights\n\n` +

            // Special Thanks
            `§l§eSpecial Thanks To:\n` +
            `§r §bCommunity Testers & Players\n` +
            ` §bFeedback Contributors\n` +
            ` §bFriends & Family\n\n` +

            // Acknowledgments
            `§l§6Acknowledgments:\n` +
            `§r §7- Everyone who offered ideas\n` +
            ` §7- Those patient with testing phases\n` +
            ` §7- Anyone who supported the project\n\n` +

            // Final note
            `§l§cThank You For Playing!\n` +
            `§r§bYour adventures power this world.\n` +
            `§r§bKeep mining, exploring, and having fun!`
        )
        .button('§l§cBack', "textures/ui/arrow_left")
        .show(player).then(r => {
            if (r.selection === 0) about(player);
        });
}