import { world, system } from "@minecraft/server";
import { ActionFormData } from "@minecraft/server-ui";


world.afterEvents.playerInteractWithEntity.subscribe(event => {
    const { player, target } = event;
    if (!target || target.typeId !== "npc:npc_custom2") return;

    openmineMenu(player);
});


world.afterEvents.entityHitEntity.subscribe(event => {
    const { damagingEntity, hitEntity } = event;
    if (!(damagingEntity?.typeId === "minecraft:player")) return;
    if (!hitEntity || hitEntity.typeId !== "npc:npc_custom2") return;

    openmineMenu(damagingEntity);
});

function openmineMenu(player) {
	player.runCommandAsync("tp @s 3000 6 -3000 facing 2999 6 -3000").then(() => {
        system.runTimeout(() => {
            player.runCommandAsync(`particle minecraft:knockback_roar_particle ~ ~ ~`);
            player.addEffect("blindness", 20, {
  amplifier: 0,
  showParticles: false
});
            player.playSound("mob.endermen.portal");
        }, 1); // delay by 1 tick (~50ms)
    });
    }
