import { world, system } from '@minecraft/server';

var kemuridama = [];
var kemuridama2 = [];
var kemuridamaL = [];
var kemuridamaT = [];
var kemuridamaD = [];
var tickC = 0;

system.runInterval(() => {
    tickC++;
    if(tickC % 10 === 0){
        if(kemuridamaL.length >= 1){
            for(let i = 0; i < kemuridamaL.length + 1; i++){
                for(let key = -2; key < 3; key++){
                    for(let kex = -4; kex < 5; kex++){
                        for(let kez = -4; kez < 5; kez++){
                            world.getDimension(kemuridamaD[i]).spawnParticle('minecraft:campfire_tall_smoke_particle',{ x: kemuridamaL[i].x - kex, y:  kemuridamaL[i].y - key, z:  kemuridamaL[i].z - kez });
                        }
                    }
                }
                if(kemuridamaT[i] <= 0){
                    kemuridamaD.splice(i,1);
                    kemuridamaL.splice(i,1);
                    kemuridamaT.splice(i,1);
                }
                kemuridamaT.splice(i,1,kemuridamaT[i] - 1);
            }
        }
    }
    if(tickC >= 1000){
        tickC = 0;
    }
},1);

world.afterEvents.entitySpawn.subscribe((ev) => {
    const { entity } = ev;
    if(entity.typeId === 'minecraft:egg'){
        if(entity.isValid){
            entity.runCommand('tag @p add kemuridamanko2');
            for(const player of world.getPlayers({tags:['kemuridamanko2']})){
                if(player.hasTag('kemuridamanko')){
                    kemuridama.push(entity.id);
                    player.removeTag('kemuridamanko');
                    player.removeTag('kemuridamanko2');
                }
            }
        } else {
            kemuridama2.push(entity.id);
        }
    }
});

world.afterEvents.projectileHitBlock.subscribe((ev) => {
    const { projectile, location, source, dimension } = ev;
    if(projectile.typeId === 'minecraft:egg'){
        if(kemuridama.includes(projectile.id)){
            kemuridamaL.push(location);
            kemuridamaT.push(30);
            kemuridamaD.push(dimension.id);
            kemuridama.splice(kemuridama.indexOf(projectile.id),1);
        } else {
            if(kemuridama2.includes(projectile.id)){
                if(source.hasTag('kemuridamanko')){
                    kemuridamaL.push(location);
                    kemuridamaT.push(30);
                    kemuridamaD.push(dimension.id);
                    kemuridama2.splice(kemuridama2.indexOf(projectile.id),1);
                }
            }
        }
    }
});

world.afterEvents.itemUse.subscribe((ev) => {
    const { itemStack, source } = ev;
    if(itemStack.typeId === 'minecraft:egg'){
        if(itemStack.nameTag === '§9煙玉§r'){
            source.addTag('kemuridamanko');
        } else {
            source.removeTag('kemuridamanko');
        }
    }
});