import {
  EntityDamageCause,
  world
} from '@minecraft/server'

console.warn(String(EntityDamageCause.sonicBoom))//It is undefined
const list = []
for (const cause in EntityDamageCause) {
  list.push(cause)
}
console.warn(list);//There is no "sonic_boom".

world.afterEvents.entityHurt.subscribe(args => {
  console.warn(String(args.damageSource.cause))// When this event is triggered by Warden's ranged attack, it will be undefined.
})

world.afterEvents.chatSend.subscribe(args => {
  const player = args.sender
  switch (args.message) {
    case 'attack.normal':
      player.getEntitiesFromViewDirection().forEach(target => {
        target.applyDamage(1, { damagingEntity: player, cause: EntityDamageCause.suicide })//Works as expected.
      })
      break;
    case 'attack.sonic_boom.enum':
      player.getEntitiesFromViewDirection().forEach(target => {
        target.applyDamage(1, { damagingEntity: player, cause: EntityDamageCause.sonicBoom })//TypeError: Native optional type conversion failed.
      })
      break;
    case 'attack.sonic_boom.string':
      player.getEntitiesFromViewDirection().forEach(target => {
        target.applyDamage(1, { damagingEntity: player, cause: 'sonic_boom' })//TypeError: Native optional type conversion failed.
      })
      break;
  }
})