import { ItemStack, Items, world } from '@minecraft/server';
import { ActionFormData, ModalFormData } from '@minecraft/server-ui';
const Current = {
  block: {
    id: null,
    pos: null
  },
  property: null,
  state: null
};
const Player = 'minecraft:player';
const DebugStick = 'gametest:debug_stick';
const GameModeBook = 'gametest:game_mode_book';
const GameModeSwitcher = new ActionFormData()
  .title('createWorldScreen.gameMode')
  .button('gameMode.survival', 'textures/items/iron_sword')
  .button('gameMode.creative', 'textures/ui/worldsIcon')
  .button('gameMode.adventure', 'textures/items/map_empty')
  .button('gameMode.spectator', 'textures/items/ender_eye')

function GameModeResponse(response, player) {
  switch (response.selection) {
    case 0: player.runCommandAsync(`gamemode survival ${player.nameTag}`); break;
    case 1: player.runCommandAsync(`gamemode creative ${player.nameTag}`); break;
    case 2: player.runCommandAsync(`gamemode adventure ${player.nameTag}`); break;
    case 3: player.runCommandAsync(`gamemode spectator ${player.nameTag}`); break;
  }
}

function ItemUse(args) {
  if (args.item.typeId == GameModeBook && args.source.typeId == Player) {
    let player = args.source
    GameModeSwitcher.show(player).then(response => GameModeResponse(response, player))
  }
}
function EntityHit(args) {
  if (args.entity.typeId == Player) {
    let player = args.entity;
    let itemStack = player.getComponent('inventory').container.getItem(player.selectedSlot) ?? {}
    switch (itemStack.typeId) {
      case GameModeBook: ItemUse({ item: { id: GameModeBook }, source: player }); break;
      case DebugStick:
        if (args.hitBlock) {
          let properties = args.hitBlock.permutation.getAllProperties()
          if (Current.block.typeId == args.hitBlock.typeId && Current.block.pos.equals(args.hitBlock.location)) {
            let target = -1
            for (let index = 0; index < properties.length; index++) {
              if (target == index) {
                Current.property = properties[index].name
                Current.state = properties[index].value
                player.onScreenDisplay.setActionBar(`selected "${Current.property}" (${Current.state})`)
                break
              } else if (properties[index].name == Current.property) {
                if (index + 1 == properties.length) {
                  index = -1
                }
                target = index + 1
              }
            }
          } else {
            if (properties.length) {
              let property = properties[0]
              Current.block.typeId = args.hitBlock.typeId
              Current.block.pos = args.hitBlock.location
              Current.property = property.name
              Current.state = property.value
              player.onScreenDisplay.setActionBar(`selected "${Current.property}" (${Current.state})`)
            } else {
              Current.block.typeId = null
              Current.block.pos = null
              Current.property = null
              Current.state = null
            }
          }
        }
        break;
    }
  }
}
function ItemUseOn(args) {
  console.warn('use')
  switch (args.item.typeId) {
    case DebugStick: {
      let block = args.source.dimension.getBlock(args.blockLocation)
      let permutation = block.permutation.clone()
      function setState(property) {
        let target = -1
        for (let index = 0; index < property.validValues.length; index++) {
          if (target == index) {
            try {
              Current.state = property.value = property.validValues[index]
              block.setPermutation(permutation)
              args.source.onScreenDisplay.setActionBar(`"${Current.property}" to ${Current.state}`)
            } catch (error) { }
            break
          } else if (property.validValues[index] == Current.state) {
            if (index + 1 == property.validValues.length) {
              index = -1
            }
            target = index + 1
          }
        }
      }
      if (Current.block.typeId == block.typeId && Current.block.pos.equals(args.blockLocation)) {
        setState(permutation.getProperty(Current.property))
      } else {
        let properties = permutation.getAllProperties()
        if (properties.length) {
          let property = properties[0]
          Current.block.typeId = block.typeId
          Current.block.pos = args.blockLocation
          Current.property = property.name
          Current.state = property.value
          setState(property)
        } else {
          Current.block.typeId = null
          Current.block.pos = null
          Current.property = null
          Current.state = null
        }
      }
      break;
    }
    case 'gametest:info_stick': {
      console.warn('info')
      let block = args.source.dimension.getBlock(args.blockLocation)
      console.warn('block')
      block.permutation.getAllProperties().forEach(property => {
        args.source.tell(`${property.name}: ${property.value}`)
      });
      break;
    }
  }
}
export { EntityHit, ItemUse, ItemUseOn };