import { world } from "@minecraft/server";

const ItemMiningDamageComponent = {
  onMineBlock(event) {
    damageItem(event.source, event.itemStack);
  },
};

world.beforeEvents.worldInitialize.subscribe(({ itemComponentRegistry} ) => {
  itemComponentRegistry.registerCustomComponent("custom:damage_when_mining", ItemMiningDamageComponent);
});

function damageItem(player, itemStack) {
  let durability = itemStack.getComponent("durability");
  if (!durability?.isValid()) return;
  if (durability.damage + 1 < durability.maxDurability) {
    durability.damage += 1;
  } else {
    itemStack = undefined;
  }
  let inventory = player.getComponent("inventory").container;
  inventory.setItem(player.selectedSlotIndex, itemStack);
}