export const English = {
    labels: {
        empty: "Empty:",
        yaw: "Angle of Attack:",
        direction: "Facing Direction:",
        chunkLoc: "Chunk Loc:",
        entityCount: "Entity Count:",
        tps: "TPS:",
        lightLevel: "Light level:",
        elTime: "Elapsed Time:",
        dimension: "Dimension:",
        weather: "Weather:",
        dayCount: "Day Count:",
        moonPhase: "Moon Phase:",
        biome: "Biome:",
        inVillage: "In village?:",
        isUnderground: "Is underground?:",
        difficulty: "Difficulty:"
    },
    menu: {
        mainTitle: "Star's Debug Screen Settings",
        mainBody: "What do you want to do?",
        mainLangBtn: "Change Language",
        mainFieldBtn: "Customize Fields",
        langTitle: "Language Customization Menu",
        langDropdownLabel: "Select Language",
        langUpdateMessage: "Your Language has been updated to:",
        fieldTitle: "Field Customization Menu",
        fieldPanelSelectBody: "Select which panel to customize:",
        leftPanelBtn: "Left Panel",
        rightPanelBtn: "Right Panel",
        fieldDropdownLabel: "Field no: ",
        fieldUpdateMessage: "Debug Screen's Fields have been customized."
    },
    weatherList: {
        0: "Clear",
        1: "Rain",
        2: "Thunder"
    },
    directionList: {
        east: "East",
        west: "West",
        north: "North",
        south: "South"
    },
    dimensionList: {
        "minecraft:overworld": "minecraft:overworld",
        "minecraft:nether": "minecraft:nether",
        "minecraft:the_end": "minecraft:the_end"
    },
    moonPhaseList: [
        "0 (Full Moon)",
        "1 (Waning Gibbous)",
        "2 (First Quarter)",
        "3 (Waning Crescent)",
        "4 (New Moon)",
        "5 (Waxing Crescent)",
        "6 (Last Quarter)",
        "7 (Waxing Gibbous)"
    ],
    difficultyList: [
        "peaceful",
        "easy",
        "normal",
        "hard"
    ],
    booleans: [
        "False",
        "True"
    ],
    biomeList: {
        bamboo_jungle: "bamboo_jungle",
        bamboo_jungle_hills: "bamboo_jungle_hills",
        basalt_deltas: "basalt_deltas",
        beach: "beach",
        birch_forest: "birch_forest",
        birch_forest_hills: "birch_forest_hills",
        birch_forest_hills_mutated: "birch_forest_hills_mutated",
        birch_forest_mutated: "birch_forest_mutated",
        cherry_grove: "cherry_grove",
        cold_beach: "cold_beach",
        cold_ocean: "cold_ocean",
        cold_taiga: "cold_taiga",
        cold_taiga_hills: "cold_taiga_hills",
        cold_taiga_mutated: "cold_taiga_mutated",
        crimson_forest: "crimson_forest",
        deep_cold_ocean: "deep_cold_ocean",
        deep_dark: "deep_dark",
        deep_frozen_ocean: "deep_frozen_ocean",
        deep_lukewarm_ocean: "deep_lukewarm_ocean",
        deep_ocean: "deep_ocean",
        deep_warm_ocean: "deep_warm_ocean",
        desert: "desert",
        desert_hills: "desert_hills",
        desert_mutated: "desert_mutated",
        dripstone_caves: "dripstone_caves",
        extreme_hills: "extreme_hills",
        extreme_hills_edge: "extreme_hills_edge",
        extreme_hills_mutated: "extreme_hills_mutated",
        extreme_hills_plus_trees: "extreme_hills_plus_trees",
        extreme_hills_plus_trees_mutated: "extreme_hills_plus_trees_mutated",
        flower_forest: "flower_forest",
        forest: "forest",
        forest_hills: "forest_hills",
        frozen_ocean: "frozen_ocean",
        frozen_peaks: "frozen_peaks",
        frozen_river: "frozen_river",
        grove: "grove",
        hell: "hell",
        ice_mountains: "ice_mountains",
        ice_plains: "ice_plains",
        ice_plains_spikes: "ice_plains_spikes",
        jagged_peaks: "jagged_peaks",
        jungle: "jungle",
        jungle_edge: "jungle_edge",
        jungle_edge_mutated: "jungle_edge_mutated",
        jungle_hills: "jungle_hills",
        jungle_mutated: "jungle_mutated",
        legacy_frozen_ocean: "legacy_frozen_ocean",
        lukewarm_ocean: "lukewarm_ocean",
        lush_caves: "lush_caves",
        mangrove_swamp: "mangrove_swamp",
        meadow: "meadow",
        mega_taiga: "mega_taiga",
        mega_taiga_hills: "mega_taiga_hills",
        mesa: "mesa",
        mesa_bryce: "mesa_bryce",
        mesa_plateau: "mesa_plateau",
        mesa_plateau_mutated: "mesa_plateau_mutated",
        mesa_plateau_stone: "mesa_plateau_stone",
        mesa_plateau_stone_mutated: "mesa_plateau_stone_mutated",
        mushroom_island: "mushroom_island",
        mushroom_island_shore: "mushroom_island_shore",
        ocean: "ocean",
        plains: "plains",
        redwood_tiaga_hills_mutated: "redwood_tiaga_hills_mutated",
        redwood_tiaga_mutated: "redwood_tiaga_mutated",
        river: "river",
        roofed_forest: "roofed_forest",
        roofed_forest_mutated: "roofed_forest_mutated",
        savanna: "savanna",
        savanna_mutated: "savanna_mutated",
        savanna_plateau: "savanna_plateau",
        savanna_plateau_mutated: "savanna_plateau_mutated",
        snowy_slopes: "snowy_slopes",
        soulsand_valley: "soulsand_valley",
        stone_beach: "stone_beach",
        stony_peaks: "stony_peaks",
        sunflower_plains: "sunflower_plains",
        swampland: "swampland",
        swampland_mutated: "swampland_mutated",
        taiga: "taiga",
        taiga_hills: "taiga_hills",
        taiga_mutated: "taiga_mutated",
        the_end: "the_end",
        warm_ocean: "warm_ocean",
        warped_forest: "warped_forest",
        pale_garden: "pale_garden"
    }
};

export const Spanish = {
    labels: {
        empty: "Vacío:",
        yaw: "Ángulo de Ataque:",
        direction: "Dirección:",
        chunkLoc: "Ubicación del Fragmento:",
        entityCount: "Cantidad de Entidades:",
        tps: "TPS:",
        lightLevel: "Nivel de Luz:",
        elTime: "Tiempo Transcurrido:",
        dimension: "Dimensión:",
        weather: "Clima:",
        dayCount: "Conteo de Días:",
        moonPhase: "Fase Lunar:",
        biome: "Bioma:",
        inVillage: "¿En la aldea?:",
        isUnderground: "¿Está bajo tierra?:",
        difficulty: "Dificultad:"
    },
    menu: {
        mainTitle: "Configuración de la pantalla de depuración de Star",
        mainBody: "¿Qué quieres hacer?",
        mainLangBtn: "Cambiar idioma",
        mainFieldBtn: "Personalizar campos",
        langTitle: "Menú de personalización de idioma",
        langDropdownLabel: "Seleccionar idioma",
        langUpdateMessage: "Tu idioma ha sido actualizado a:",
        fieldTitle: "Menú de personalización de campos",
        fieldPanelSelectBody: "Selecciona qué panel personalizar:",
        leftPanelBtn: "Panel izquierdo",
        rightPanelBtn: "Panel derecho",
        fieldDropdownLabel: "Campo núm.: ",
        fieldUpdateMessage: "Los campos de la pantalla de depuración han sido personalizados."
    },
    weatherList: {
        0: "Despejado",
        1: "Lluvia",
        2: "Tormenta"
    },
    directionList: {
        east: "Este",
        west: "Oeste",
        north: "Norte",
        south: "Sur"
    },
    dimensionList: {
        "minecraft:overworld": "minecraft:sobre-mundo",
        "minecraft:nether": "minecraft:nether",
        "minecraft:the_end": "minecraft:el_fin"
    },
    moonPhaseList: [
        "0 (Luna llena)",
        "1 (Cuarto menguante)",
        "2 (Primer cuarto)",
        "3 (Cuarto creciente)",
        "4 (Luna nueva)",
        "5 (Creciente)",
        "6 (Último cuarto)",
        "7 (Menguante)"
    ],
    difficultyList: [
        "pacífico",
        "fácil",
        "normal",
        "difícil"
    ],
    booleans: [
        "Falso",
        "Verdadero"
    ],
    biomeList: {
        bamboo_jungle: "Bosque de bambú",
        bamboo_jungle_hills: "Colinas de bosque de bambú",
        basalt_deltas: "Delta de basalto",
        beach: "Playa",
        birch_forest: "Bosque de abedules",
        birch_forest_hills: "Colinas de bosque de abedules",
        birch_forest_hills_mutated: "Colinas de bosque de abedules mutado",
        birch_forest_mutated: "Bosque de abedules mutado",
        cherry_grove: "Arboleda de cerezos",
        cold_beach: "Playa fría",
        cold_ocean: "Océano frío",
        cold_taiga: "Taiga fría",
        cold_taiga_hills: "Colinas de taiga fría",
        cold_taiga_mutated: "Taiga fría mutada",
        crimson_forest: "Bosque carmesí",
        deep_cold_ocean: "Océano frío profundo",
        deep_dark: "Oscuridad profunda",
        deep_frozen_ocean: "Océano congelado profundo",
        deep_lukewarm_ocean: "Océano tibio profundo",
        deep_ocean: "Océano profundo",
        deep_warm_ocean: "Océano cálido profundo",
        desert: "Desierto",
        desert_hills: "Colinas del desierto",
        desert_mutated: "Desierto mutado",
        dripstone_caves: "Cuevas de piedra goteante",
        extreme_hills: "Montañas extremas",
        extreme_hills_edge: "Extremo de montañas extremas",
        extreme_hills_mutated: "Montañas extremas mutadas",
        extreme_hills_plus_trees: "Montañas extremas con árboles",
        extreme_hills_plus_trees_mutated: "Montañas extremas con árboles mutadas",
        flower_forest: "Bosque de flores",
        forest: "Bosque",
        forest_hills: "Colinas del bosque",
        frozen_ocean: "Océano congelado",
        frozen_peaks: "Picos congelados",
        frozen_river: "Río congelado",
        grove: "Arboleda",
        hell: "Inframundo",
        ice_mountains: "Montañas de hielo",
        ice_plains: "Llanuras de hielo",
        ice_plains_spikes: "Picos de llanuras de hielo",
        jagged_peaks: "Picos dentados",
        jungle: "Selva",
        jungle_edge: "Borde de la selva",
        jungle_edge_mutated: "Borde de la selva mutado",
        jungle_hills: "Colinas de la selva",
        jungle_mutated: "Selva mutada",
        legacy_frozen_ocean: "Océano congelado heredado",
        lukewarm_ocean: "Océano tibio",
        lush_caves: "Cuevas exuberantes",
        mangrove_swamp: "Ciénaga de mangle",
        meadow: "Pradera",
        mega_taiga: "Mega taiga",
        mega_taiga_hills: "Colinas de mega taiga",
        mesa: "Meseta",
        mesa_bryce: "Mesa Bryce",
        mesa_plateau: "Meseta de mesa",
        mesa_plateau_mutated: "Meseta de mesa mutada",
        mesa_plateau_stone: "Meseta de mesa de piedra",
        mesa_plateau_stone_mutated: "Meseta de mesa de piedra mutada",
        mushroom_island: "Isla de champiñones",
        mushroom_island_shore: "Orilla de la isla de champiñones",
        ocean: "Océano",
        plains: "Llanuras",
        redwood_tiaga_hills_mutated: "Colinas de taiga de madera roja mutadas",
        redwood_tiaga_mutated: "Taiga de madera roja mutada",
        river: "Río",
        roofed_forest: "Bosque cubierto",
        roofed_forest_mutated: "Bosque cubierto mutado",
        savanna: "Sabana",
        savanna_mutated: "Sabana mutada",
        savanna_plateau: "Meseta de sabana",
        savanna_plateau_mutated: "Meseta de sabana mutada",
        snowy_slopes: "Laderas nevadas",
        soulsand_valley: "Valle de arena de almas",
        stone_beach: "Playa de piedra",
        stony_peaks: "Picos rocosos",
        sunflower_plains: "Llanuras de girasol",
        swampland: "Pantano",
        swampland_mutated: "Pantano mutado",
        taiga: "Taiga",
        taiga_hills: "Colinas de taiga",
        taiga_mutated: "Taiga mutada",
        the_end: "El Fin",
        warm_ocean: "Océano cálido",
        warped_forest: "Bosque deformado",
        pale_garden: "jardín pálido"
    }
};

export const Portuguese = {
    labels: {
        empty: "Vazio:",
        yaw: "Ângulo de Ataque:",
        direction: "Direção:",
        chunkLoc: "Localização do Choco:",
        entityCount: "Contagem de Entidades:",
        tps: "TPS:",
        lightLevel: "Nível de Luz:",
        elTime: "Tempo Decorrido:",
        dimension: "Dimensão:",
        weather: "Clima:",
        dayCount: "Contagem de Dias:",
        moonPhase: "Fase Lunar:",
        biome: "Bioma:",
        inVillage: "Na Vila?:",
        isUnderground: "Está Subterrâneo?:",
        difficulty: "Dificuldade:"
    },
    menu: {
        mainTitle: "Configurações da Tela de Depuração do Star",
        mainBody: "O que você quer fazer?",
        mainLangBtn: "Alterar idioma",
        mainFieldBtn: "Personalizar campos",
        langTitle: "Menu de Personalização de Idioma",
        langDropdownLabel: "Selecionar idioma",
        langUpdateMessage: "Seu idioma foi atualizado para:",
        fieldTitle: "Menu de Personalização de Campos",
        fieldPanelSelectBody: "Selecione qual painel personalizar:",
        leftPanelBtn: "Painel esquerdo",
        rightPanelBtn: "Painel direito",
        fieldDropdownLabel: "Campo nº: ",
        fieldUpdateMessage: "Os campos da tela de depuração foram personalizados."
    },
    weatherList: {
        0: "Limpo",
        1: "Chuva",
        2: "Trovoada"
    },
    directionList: {
        east: "Leste",
        west: "Oeste",
        north: "Norte",
        south: "Sul"
    },
    dimensionList: {
        "minecraft:overworld": "minecraft:superior",
        "minecraft:nether": "minecraft:nether",
        "minecraft:the_end": "minecraft:o_fim"
    },
    moonPhaseList: [
        "0 (Lua Cheia)",
        "1 (Minguante)",
        "2 (Primeiro Quarto)",
        "3 (Crescente)",
        "4 (Lua Nova)",
        "5 (Crescente)",
        "6 (Último Quarto)",
        "7 (Minguante)"
    ],
    difficultyList: [
        "pacífico",
        "fácil",
        "normal",
        "difícil"
    ],
    booleans: [
        "Falso",
        "Verdadeiro"
    ],
    biomeList: {
        bamboo_jungle: "Selva de Bambu",
        bamboo_jungle_hills: "Colinas de Selva de Bambu",
        basalt_deltas: "Deltas de Basalto",
        beach: "Praia",
        birch_forest: "Floresta de Bétulas",
        birch_forest_hills: "Colinas de Floresta de Bétulas",
        birch_forest_hills_mutated: "Colinas Mutantes de Floresta de Bétulas",
        birch_forest_mutated: "Floresta de Bétulas Mutante",
        cherry_grove: "Bosque de Cerejeiras",
        cold_beach: "Praia Fria",
        cold_ocean: "Oceano Frio",
        cold_taiga: "Taiga Fria",
        cold_taiga_hills: "Colinas de Taiga Fria",
        cold_taiga_mutated: "Taiga Fria Mutante",
        crimson_forest: "Floresta Carmesim",
        deep_cold_ocean: "Oceano Profundo Frio",
        deep_dark: "Escuridão Profunda",
        deep_frozen_ocean: "Oceano Profundo Congelado",
        deep_lukewarm_ocean: "Oceano Profundo Morno",
        deep_ocean: "Oceano Profundo",
        deep_warm_ocean: "Oceano Profundo Quente",
        desert: "Deserto",
        desert_hills: "Colinas do Deserto",
        desert_mutated: "Deserto Mutante",
        dripstone_caves: "Cavernas de Pedra Pungente",
        extreme_hills: "Montanhas Extremas",
        extreme_hills_edge: "Extremo de Montanhas Extremas",
        extreme_hills_mutated: "Montanhas Extremas Mutantes",
        extreme_hills_plus_trees: "Montanhas Extremas com Árvores",
        extreme_hills_plus_trees_mutated: "Montanhas Extremas com Árvores Mutantes",
        flower_forest: "Floresta de Flores",
        forest: "Floresta",
        forest_hills: "Colinas de Floresta",
        frozen_ocean: "Oceano Congelado",
        frozen_peaks: "Picos Congelados",
        frozen_river: "Rio Congelado",
        grove: "Arboleda",
        hell: "Inferno",
        ice_mountains: "Montanhas de Gelo",
        ice_plains: "Planícies de Gelo",
        ice_plains_spikes: "Espigões de Planícies de Gelo",
        jagged_peaks: "Picos Irregulares",
        jungle: "Selva",
        jungle_edge: "Borda da Selva",
        jungle_edge_mutated: "Borda da Selva Mutante",
        jungle_hills: "Colinas da Selva",
        jungle_mutated: "Selva Mutante",
        legacy_frozen_ocean: "Oceano Congelado Antigo",
        lukewarm_ocean: "Oceano Morno",
        lush_caves: "Cavernas Exuberantes",
        mangrove_swamp: "Pântano de Mangue",
        meadow: "Prado",
        mega_taiga: "Mega Taiga",
        mega_taiga_hills: "Colinas de Mega Taiga",
        mesa: "Mesa",
        mesa_bryce: "Mesa Bryce",
        mesa_plateau: "Planalto de Mesa",
        mesa_plateau_mutated: "Planalto de Mesa Mutante",
        mesa_plateau_stone: "Planalto de Mesa de Pedra",
        mesa_plateau_stone_mutated: "Planalto de Mesa de Pedra Mutante",
        mushroom_island: "Ilha de Cogumelos",
        mushroom_island_shore: "Litoral da Ilha de Cogumelos",
        ocean: "Oceano",
        plains: "Planícies",
        redwood_tiaga_hills_mutated: "Colinas Mutantes de Taiga Vermelha",
        redwood_tiaga_mutated: "Taiga Vermelha Mutante",
        river: "Rio",
        roofed_forest: "Floresta Coberta",
        roofed_forest_mutated: "Floresta Coberta Mutante",
        savanna: "Savana",
        savanna_mutated: "Savana Mutante",
        savanna_plateau: "Planalto de Savana",
        savanna_plateau_mutated: "Planalto de Savana Mutante",
        snowy_slopes: "Encostas Nevadas",
        soulsand_valley: "Vale de Areia Ardente",
        stone_beach: "Praia de Pedra",
        stony_peaks: "Picos Rochosos",
        sunflower_plains: "Planícies de Girassol",
        swampland: "Pântano",
        swampland_mutated: "Pântano Mutante",
        taiga: "Taiga",
        taiga_hills: "Colinas de Taiga",
        taiga_mutated: "Taiga Mutante",
        the_end: "O Fim",
        warm_ocean: "Oceano Quente",
        warped_forest: "Floresta Distorcida",
        pale_garden: "jardim pálido"
    }
};

export const Chinese = {
    labels: {
        empty: "空的：",
        yaw: "攻击角度:",
        direction: "朝向方向:",
        chunkLoc: "区块位置:",
        entityCount: "实体数量:",
        tps: "每秒游戏刻数:",
        lightLevel: "光照等级:",
        elTime: "经过时间:",
        dimension: "维度:",
        weather: "天气:",
        dayCount: "游戏天数:",
        moonPhase: "月相:",
        biome: "生态群系:",
        inVillage: "在村庄中?:",
        isUnderground: "在地下?:",
        difficulty: "难度:"
    },
    menu: {
        mainTitle: "星星的调试屏幕设置",
        mainBody: "你想做什么？",
        mainLangBtn: "更改语言",
        mainFieldBtn: "自定义字段",
        langTitle: "语言自定义菜单",
        langDropdownLabel: "选择语言",
        langUpdateMessage: "您的语言已更新为：",
        fieldTitle: "字段自定义菜单",
        fieldPanelSelectBody: "选择要自定义的面板：",
        leftPanelBtn: "左侧面板",
        rightPanelBtn: "右侧面板",
        fieldDropdownLabel: "字段编号：",
        fieldUpdateMessage: "调试屏幕的字段已被自定义。"
    },
    weatherList: {
        0: "晴朗",
        1: "雨",
        2: "雷电"
    },
    directionList: {
        east: "东",
        west: "西",
        north: "北",
        south: "南"
    },
    dimensionList: {
        "minecraft:overworld": "minecraft:主世界",
        "minecraft:nether": "minecraft:下界",
        "minecraft:the_end": "minecraft:末地"
    },
    moonPhaseList: [
        "0 (满月)",
        "1 (亏凸月)",
        "2 (第一季)",
        "3 (亏缺月)",
        "4 (新月)",
        "5 (盈凸月)",
        "6 (最后一季)",
        "7 (盈缺月)"
    ],
    difficultyList: [
        "和平",
        "简单",
        "普通",
        "困难"
    ],
    booleans: [
        "假",
        "真"
    ],
    biomeList: {
        bamboo_jungle: "竹林",
        bamboo_jungle_hills: "竹林丘陵",
        basalt_deltas: "玄武岩三角洲",
        beach: "沙滩",
        birch_forest: "白桦林",
        birch_forest_hills: "白桦林丘陵",
        birch_forest_hills_mutated: "白桦林丘陵变异",
        birch_forest_mutated: "白桦林变异",
        cherry_grove: "樱花林",
        cold_beach: "寒冷沙滩",
        cold_ocean: "寒冷海洋",
        cold_taiga: "寒冷针叶林",
        cold_taiga_hills: "寒冷针叶林丘陵",
        cold_taiga_mutated: "寒冷针叶林变异",
        crimson_forest: "绯红森林",
        deep_cold_ocean: "深寒冷海洋",
        deep_dark: "深暗深渊",
        deep_frozen_ocean: "深冰冻海洋",
        deep_lukewarm_ocean: "深温暖海洋",
        deep_ocean: "深海洋",
        deep_warm_ocean: "深暖海洋",
        desert: "沙漠",
        desert_hills: "沙漠丘陵",
        desert_mutated: "沙漠变异",
        dripstone_caves: "滴水洞穴",
        extreme_hills: "巨大山脉",
        extreme_hills_edge: "巨大山脉边缘",
        extreme_hills_mutated: "巨大山脉变异",
        extreme_hills_plus_trees: "巨大山脉加树",
        extreme_hills_plus_trees_mutated: "巨大山脉加树变异",
        flower_forest: "花之森林",
        forest: "森林",
        forest_hills: "森林丘陵",
        frozen_ocean: "冰冻海洋",
        frozen_peaks: "冰冻峰",
        frozen_river: "冰冻河流",
        grove: "树丛",
        hell: "地狱",
        ice_mountains: "冰山",
        ice_plains: "冰原",
        ice_plains_spikes: "冰原尖峰",
        jagged_peaks: "崎岖山峰",
        jungle: "丛林",
        jungle_edge: "丛林边缘",
        jungle_edge_mutated: "丛林边缘变异",
        jungle_hills: "丛林丘陵",
        jungle_mutated: "丛林变异",
        legacy_frozen_ocean: "传统冰冻海洋",
        lukewarm_ocean: "温暖海洋",
        lush_caves: "茂盛洞穴",
        mangrove_swamp: "红树沼泽",
        meadow: "草地",
        mega_taiga: "巨型针叶林",
        mega_taiga_hills: "巨型针叶林丘陵",
        mesa: "沙漠高原",
        mesa_bryce: "沙漠布莱斯",
        mesa_plateau: "沙漠高原",
        mesa_plateau_mutated: "沙漠高原变异",
        mesa_plateau_stone: "石头沙漠高原",
        mesa_plateau_stone_mutated: "石头沙漠高原变异",
        mushroom_island: "蘑菇岛",
        mushroom_island_shore: "蘑菇岛海滩",
        ocean: "海洋",
        plains: "平原",
        redwood_tiaga_hills_mutated: "红木太阳岸丘陵变异",
        redwood_tiaga_mutated: "红木太阳岸变异",
        river: "河流",
        roofed_forest: "覆盖的森林",
        roofed_forest_mutated: "覆盖的森林变异",
        savanna: "热带草原",
        savanna_mutated: "热带草原变异",
        savanna_plateau: "热带草原高原",
        savanna_plateau_mutated: "热带草原高原变异",
        snowy_slopes: "雪坡",
        soulsand_valley: "灵魂沙谷",
        stone_beach: "石头海滩",
        stony_peaks: "岩石山峰",
        sunflower_plains: "向日葵平原",
        swampland: "沼泽地",
        swampland_mutated: "沼泽地变异",
        taiga: "针叶林",
        taiga_hills: "针叶林丘陵",
        taiga_mutated: "针叶林变异",
        the_end: "末地",
        warm_ocean: "温暖海洋",
        warped_forest: "维度森林",
        pale_garden: "苍白的花园"
    }
};

export const Japanese = {
    labels: {
        empty: "空（から）：",
        yaw: "攻撃角度:",
        direction: "方向:",
        chunkLoc: "チャンクの位置:",
        entityCount: "エンティティ数:",
        tps: "TPS:",
        lightLevel: "光度:",
        elTime: "経過時間:",
        dimension: "ディメンション:",
        weather: "天気:",
        dayCount: "日数:",
        moonPhase: "月の位相:",
        biome: "生息地:",
        inVillage: "村にいる?:",
        isUnderground: "地下にいる?:",
        difficulty: "難易度:"
    },
    menu: {
        mainTitle: "スターのデバッグ画面設定",
        mainBody: "何をしますか？",
        mainLangBtn: "言語を変更",
        mainFieldBtn: "フィールドをカスタマイズ",
        langTitle: "言語カスタマイズメニュー",
        langDropdownLabel: "言語を選択",
        langUpdateMessage: "言語が更新されました:",
        fieldTitle: "フィールドカスタマイズメニュー",
        fieldPanelSelectBody: "カスタマイズするパネルを選択してください:",
        leftPanelBtn: "左パネル",
        rightPanelBtn: "右パネル",
        fieldDropdownLabel: "フィールド番号: ",
        fieldUpdateMessage: "デバッグ画面のフィールドがカスタマイズされました。"
    },
    weatherList: {
        0: "晴れ",
        1: "雨",
        2: "雷"
    },
    directionList: {
        east: "東",
        west: "西",
        north: "北",
        south: "南"
    },
    dimensionList: {
        "minecraft:overworld": "minecraft:オーバーワールド",
        "minecraft:nether": "minecraft:ネザー",
        "minecraft:the_end": "minecraft:ジ・エンド"
    },
    moonPhaseList: [
        "0（満月）",
        "1（下弦の月）",
        "2（第一四半期）",
        "3（下弦の三日月）",
        "4（新月）",
        "5（上弦の三日月）",
        "6（第三四半期）",
        "7（上弦の月）"
    ],
    difficultyList: [
        "平和",
        "簡単",
        "普通",
        "難しい"
    ],
    booleans: [
        "偽",
        "真"
    ],
    biomeList: {
        bamboo_jungle: "竹ジャングル",
        bamboo_jungle_hills: "竹ジャングルの丘",
        basalt_deltas: "玄武岩デルタ",
        beach: "ビーチ",
        birch_forest: "白樺の森",
        birch_forest_hills: "白樺の森の丘",
        birch_forest_hills_mutated: "白樺の森の丘（変異）",
        birch_forest_mutated: "白樺の森（変異）",
        cherry_grove: "チェリーグローブ",
        cold_beach: "寒いビーチ",
        cold_ocean: "寒い海",
        cold_taiga: "寒冷なタイガ",
        cold_taiga_hills: "寒冷なタイガの丘",
        cold_taiga_mutated: "寒冷なタイガ（変異）",
        crimson_forest: "クリムゾンフォレスト",
        deep_cold_ocean: "深い寒冷な海",
        deep_dark: "深いダーク",
        deep_frozen_ocean: "深い凍った海",
        deep_lukewarm_ocean: "深いぬるい海",
        deep_ocean: "深い海",
        deep_warm_ocean: "深い温かい海",
        desert: "砂漠",
        desert_hills: "砂漠の丘",
        desert_mutated: "砂漠（変異）",
        dripstone_caves: "ドリップストーン洞窟",
        extreme_hills: "エクストリームヒルズ",
        extreme_hills_edge: "エクストリームヒルズエッジ",
        extreme_hills_mutated: "エクストリームヒルズ（変異）",
        extreme_hills_plus_trees: "エクストリームヒルズプラスツリー",
        extreme_hills_plus_trees_mutated: "エクストリームヒルズプラスツリー（変異）",
        flower_forest: "フラワーフォレスト",
        forest: "森",
        forest_hills: "森の丘",
        frozen_ocean: "凍った海",
        frozen_peaks: "凍った山",
        frozen_river: "凍った川",
        grove: "グローブ",
        hell: "地獄",
        ice_mountains: "氷山",
        ice_plains: "氷の平原",
        ice_plains_spikes: "氷の平原スパイク",
        jagged_peaks: "尖った峰",
        jungle: "ジャングル",
        jungle_edge: "ジャングルエッジ",
        jungle_edge_mutated: "ジャングルエッジ（変異）",
        jungle_hills: "ジャングルの丘",
        jungle_mutated: "ジャングル（変異）",
        legacy_frozen_ocean: "レガシーフローズンオーシャン",
        lukewarm_ocean: "ぬるい海",
        lush_caves: "豊かな洞窟",
        mangrove_swamp: "マングローブ沼地",
        meadow: "牧草地",
        mega_taiga: "メガタイガ",
        mega_taiga_hills: "メガタイガの丘",
        mesa: "メサ",
        mesa_bryce: "メサブライス",
        mesa_plateau: "メサプラトー",
        mesa_plateau_mutated: "メサプラトー（変異）",
        mesa_plateau_stone: "メサプラトーストーン",
        mesa_plateau_stone_mutated: "メサプラトーストーン（変異）",
        mushroom_island: "キノコ島",
        mushroom_island_shore: "キノコ島の岸",
        ocean: "海",
        plains: "平原",
        redwood_tiaga_hills_mutated: "レッドウッドタイガヒルズ（変異）",
        redwood_tiaga_mutated: "レッドウッドタイガ（変異）",
        river: "川",
        roofed_forest: "覆われた森",
        roofed_forest_mutated: "覆われた森（変異）",
        savanna: "サバンナ",
        savanna_mutated: "サバンナ（変異）",
        savanna_plateau: "サバンナプラトー",
        savanna_plateau_mutated: "サバンナプラトー（変異）",
        snowy_slopes: "雪の斜面",
        soulsand_valley: "ソウルサンドバレー",
        stone_beach: "石のビーチ",
        stony_peaks: "石のピーク",
        sunflower_plains: "ひまわりの平原",
        swampland: "湿地",
        swampland_mutated: "湿地（変異）",
        taiga: "タイガ",
        taiga_hills: "タイガの丘",
        taiga_mutated: "タイガ（変異）",
        the_end: "ジ・エンド",
        warm_ocean: "温かい海",
        warped_forest: "ワープドフォレスト",
        pale_garden: "淡い庭"
    }
};

export const Russian = {
    labels: {
        empty: "Пусто:",
        yaw: "Угол атаки:",
        direction: "Направление:",
        chunkLoc: "Местоположение чанка:",
        entityCount: "Количество сущностей:",
        tps: "TPS:",
        lightLevel: "Уровень света:",
        elTime: "Прошедшее время:",
        dimension: "Измерение:",
        weather: "Погода:",
        dayCount: "Количество дней:",
        moonPhase: "Фаза луны:",
        biome: "Биом:",
        inVillage: "В деревне?:",
        isUnderground: "Под землей?:",
        difficulty: "Сложность:"
    },
    menu: {
        mainTitle: "Настройки экрана отладки Star",
        mainBody: "Что вы хотите сделать?",
        mainLangBtn: "Изменить язык",
        mainFieldBtn: "Настроить поля",
        langTitle: "Меню настройки языка",
        langDropdownLabel: "Выберите язык",
        langUpdateMessage: "Ваш язык был обновлен на:",
        fieldTitle: "Меню настройки полей",
        fieldPanelSelectBody: "Выберите, какой панель настроить:",
        leftPanelBtn: "Левая панель",
        rightPanelBtn: "Правая панель",
        fieldDropdownLabel: "Поле №: ",
        fieldUpdateMessage: "Поля экрана отладки были настроены."
    },
    weatherList: {
        0: "Ясно",
        1: "Дождь",
        2: "Гроза"
    },
    directionList: {
        east: "Восток",
        west: "Запад",
        north: "Север",
        south: "Юг"
    },
    dimensionList: {
        "minecraft:overworld": "minecraft:overworld",
        "minecraft:nether": "minecraft:nether",
        "minecraft:the_end": "minecraft:the_end"
    },
    moonPhaseList: [
        "0 (Полнолуние)",
        "1 (Убывающая Луна)",
        "2 (Первая Четверть)",
        "3 (Старая Луна)",
        "4 (Новолуние)",
        "5 (Молодая Луна)",
        "6 (Последняя Четверть)",
        "7 (Прибывающая Луна)"
    ],
    difficultyList: [
        "мирная",
        "легкая",
        "нормальная",
        "сложная"
    ],
    booleans: [
        "Ложь",
        "Истина"
    ],
    biomeList: {
        bamboo_jungle: "бамбуковые_джунгли",
        bamboo_jungle_hills: "холмы_бамбуковых_джунглей",
        basalt_deltas: "базальтовые_дельты",
        beach: "пляж",
        birch_forest: "березовый_лес",
        birch_forest_hills: "холмы_березового_леса",
        birch_forest_hills_mutated: "мутировавшие_холмы_березового_леса",
        birch_forest_mutated: "мутировавший_березовый_лес",
        cherry_grove: "вишневая_рощ",
        cold_beach: "холодный_пляж",
        cold_ocean: "холодный_океан",
        cold_taiga: "холодная_тайга",
        cold_taiga_hills: "холмы_холодной_тайги",
        cold_taiga_mutated: "мутировавшая_холодная_тайга",
        crimson_forest: "багровый_лес",
        deep_cold_ocean: "глубокий_холодный_океан",
        deep_dark: "глубокий_темный",
        deep_frozen_ocean: "глубокий_замерзший_океан",
        deep_lukewarm_ocean: "глубокий_теплый_океан",
        deep_ocean: "глубокий_океан",
        deep_warm_ocean: "глубокий_теплый_океан",
        desert: "пустыня",
        desert_hills: "пустынные_холмы",
        desert_mutated: "мутировавшая_пустыня",
        dripstone_caves: "капельные_пещеры",
        extreme_hills: "экстремальные_холмы",
        extreme_hills_edge: "край_экстремальных_холмов",
        extreme_hills_mutated: "мутировавшие_экстремальные_холмы",
        extreme_hills_plus_trees: "экстремальные_холмы_с_деревьями",
        extreme_hills_plus_trees_mutated: "мутировавшие_экстремальные_холмы_с_деревьями",
        flower_forest: "цветочный_лес",
        forest: "лес",
        forest_hills: "лесистые_холмы",
        frozen_ocean: "замерзший_океан",
        frozen_peaks: "замерзшие_пики",
        frozen_river: "замерзшая_река",
        grove: "роща",
        hell: "ад",
        ice_mountains: "ледяные_горы",
        ice_plains: "ледяные_равнины",
        ice_plains_spikes: "ледяные_равнины_со_шипами",
        jagged_peaks: "зубчатые_пики",
        jungle: "джунгли",
        jungle_edge: "край_джунглей",
        jungle_edge_mutated: "мутировавший_край_джунглей",
        jungle_hills: "холмы_джунглей",
        jungle_mutated: "мутировавшие_джунгли",
        legacy_frozen_ocean: "старый_замерзший_океан",
        lukewarm_ocean: "теплый_океан",
        lush_caves: "роскошные_пещеры",
        mangrove_swamp: "мангровое_болото",
        meadow: "луг",
        mega_taiga: "мега_тайга",
        mega_taiga_hills: "холмы_мега_тайги",
        mesa: "меса",
        mesa_bryce: "меса_Брайс",
        mesa_plateau: "плато_меса",
        mesa_plateau_mutated: "мутировавшее_плато_меса",
        mesa_plateau_stone: "каменное_плато_меса",
        mesa_plateau_stone_mutated: "мутировавшее_каменное_плато_меса",
        mushroom_island: "грибной_остров",
        mushroom_island_shore: "берег_грибного_острова",
        ocean: "океан",
        plains: "равнины",
        redwood_tiaga_hills_mutated: "мутировавшие_холмы_красной_тайги",
        redwood_tiaga_mutated: "мутировавшая_красная_тайга",
        river: "река",
        roofed_forest: "крытый_лес",
        roofed_forest_mutated: "мутировавший_крытый_лес",
        savanna: "саванна",
        savanna_mutated: "мутировавшая_саванна",
        savanna_plateau: "плато_саванны",
        savanna_plateau_mutated: "мутировавшее_плато_саванны",
        snowy_slopes: "снежные_склоны",
        soulsand_valley: "долина_душ",
        stone_beach: "каменный_пляж",
        stony_peaks: "каменные_пики",
        sunflower_plains: "подсолнечные_равнины",
        swampland: "болото",
        swampland_mutated: "мутировавшее_болото",
        taiga: "тайга",
        taiga_hills: "холмы_тайги",
        taiga_mutated: "мутировавшая_тайга",
        the_end: "конец",
        warm_ocean: "теплый_океан",
        warped_forest: "искаженный_лес",
        pale_garden: "pale_gaбледный садrden"
    }
};
