import { world, system } from "@minecraft/server";

world.afterEvents.worldLoad.subscribe(() => {
	system.run(startupRepeat);
});

function startupRepeat() {
	const players = world.getPlayers();
	if (players.length > 0) {
		system.run(startup);
	} else {
		system.run(startupRepeat);
	}
}

function startup() {
	const players = world.getPlayers();

	system.run(start);

	system.runInterval(() => {
		system.run(main);
	});
}

function start() {}

function main() {
	let players = world.getPlayers();
	let overworld = world.getDimension("overworld");

	for (const player of players) {
		let playerLocation = player.location;

		if (playerLocation.y >= -63) {
			let playerLocationBlock = overworld.getBlock(playerLocation);

			if (playerLocationBlock.type.id === "minecraft:trip_wire") {
				player.applyImpulse({
					x: -0.5,
					y: 0,
					z: 0,
				});
			}
		}
	}
}
