import { BlockTypes, world } from "@minecraft/server";

function dumpStacks(stacks) {
    if (stacks.length == 0) {
        return "nothing";
    }
    else {
        return stacks
                 .map(stack => `${stack.typeId} x ${stack.amount}`)
                 .join(", ");
    }
}

world.afterEvents.playerHotbarSelectedSlotChange.subscribe(ev => {
    const ltm   = world.getLootTableManager();
    const block = BlockTypes.get("minecraft:iron_ore");
    const loot  = ltm.generateLootFromBlockType(block, ev.itemStack);

    ev.player.sendMessage(
        "Breaking an iron ore block with " +
            (ev.itemStack ? "the selected " + ev.itemStack.typeId : "bare hand") +
            (loot
             ? " yields " + dumpStacks(loot) + "."
             : " is impossible."));
});
