import { debugDrawer, DebugBox } from '@minecraft/debug-utilities';
import { system, world } from '@minecraft/server';

system.afterEvents.scriptEventReceive.subscribe((event) => {
    if (event.id !== 'debug:testdraw')
        return;
    const box = new DebugBox(event.sourceEntity.location);
    debugDrawer.addShape(box);
}, { namespaces: ['debug'] });

system.afterEvents.scriptEventReceive.subscribe((event) => {
    if (event.id !== 'debug:softlock')
        return;
    world.setDynamicProperty('shouldSoftlock', true);
});

world.afterEvents.playerJoin.subscribe((event) => {
    if (!world.getDynamicProperty('shouldSoftlock'))
        return;
    const playerId = event.playerId;
    system.run((event) => { // Wait for the player to be initialized enough to have a location
        const player = world.getEntity(playerId);
        const box = new DebugBox(player.location);
        debugDrawer.addShape(box);
    });
});