import { ActionFormData } from "@minecraft/server-ui";
import { world } from "@minecraft/server";

function showMainMenu(player) {
    const playGUI = new ActionFormData()
        .title("The Intruder")
        .button("Easy Mode")
        .button("Hard Mode")
        .button("Nightmare Mode")
        .button("Remove tags (temporary)");

    playGUI.show(player).then(r => {
        if (r.canceled) return;

        let response = r.selection;
        switch (response) {
            case 0:
                player.sendMessage("Easy Mode is in progress");
                player.runCommand("stopsound @s");
                player.addTag("easy");
                playGUI.show(player);
                break;
            case 1:
                player.sendMessage("Hard Mode is in progress");
                player.runCommand("stopsound @s");
                player.addTag("hard");
                playGUI.show(player);
                break;
            case 2:
                player.sendMessage("Nightmare Mode is in progress");
                player.runCommand("stopsound @s");
                player.addTag("nightmare");
                playGUI.show(player);
                break;
            case 3:
                player.sendMessage("Removed tags");
                player.runCommand("stopsound @s");
                player.removeTag("easy");
                player.removeTag("hard");
                player.removeTag("nightmare");
                playGUI.show(player);
                break;
        }
    });
}

world.afterEvents.itemUse.subscribe(event => {
    const player = event.source;
    if (event.itemStack.typeId === "minecraft:book") {
        showMainMenu(player);
        player.playSound("the_intruder_main_screen");
    }
});