import { world, system } from "@minecraft/server";

const teleportPositions = [
    { x: 70, y: 65, z: -123 },
    { x: 80, y: 63, z: -112 }
];

const teleportIntervals = {
    easy: 45,
    hard: 25,
    nightmare: 10
};

// Store last teleport times for entities
let lastTeleportTime = {};

function getPlayerTagInterval(player) {
    for (const tag in teleportIntervals) {
        if (player.hasTag(tag)) {
            return teleportIntervals[tag];
        }
    }
    return null; // No valid tag, no teleport
}

system.runInterval(() => {
    world.sendMessage("Debug: Running teleportation check...");

    for (const player of world.getAllPlayers()) {
        const interval = getPlayerTagInterval(player);
        if (interval) {
            let currentTime = system.currentTick;
            world.sendMessage(`Debug: Player ${player.name} has interval ${interval} seconds`);

            let intruders = world.getDimension("overworld").getEntities({ type: "bridge:the_intruder" });

            world.sendMessage(`Debug: Found ${intruders.length} intruder(s)`);

            intruders.forEach(intruder => {
                let entityId = intruder.id; // Get unique entity ID
                let lastTime = lastTeleportTime[entityId] || 0;

                world.sendMessage(`Debug: Intruder ${entityId} last teleported at tick ${lastTime}, current tick is ${currentTime}`);

                // If enough time has passed, teleport
                if (currentTime - lastTime >= interval * 20) {
                    let possiblePositions = teleportPositions.filter(pos =>
                        pos.x !== intruder.location.x ||
                        pos.y !== intruder.location.y ||
                        pos.z !== intruder.location.z
                    );

                    if (possiblePositions.length > 0) {
                        let targetPos = possiblePositions[Math.floor(Math.random() * possiblePositions.length)];
                        intruder.teleport(targetPos);
                        lastTeleportTime[entityId] = currentTime; // Update last teleport time
                        world.sendMessage(`Debug: Teleported ${intruder.type} to ${targetPos.x}, ${targetPos.y}, ${targetPos.z}`);
                    } else {
                        world.sendMessage("Debug: No valid new position found, teleportation skipped");
                    }
                } else {
                    let remainingTime = ((lastTime + interval * 20) - currentTime) / 20;
                    world.sendMessage(`Debug: Intruder ${entityId} waiting, next teleport in ${remainingTime.toFixed(1)} seconds`);
                }
            });
        } else {
            world.sendMessage(`Debug: Player ${player.name} has no valid tag, skipping teleportation`);
        }
    }
}, 20);
