#version 150

in vec4 vertexColor;

uniform vec4 ColorModulator;
uniform float GameTime;

out vec4 fragColor;

const vec3 TooltipRainbowArray[8] = vec3[8](
    vec3( 1.0, 0.0, 0.0 ),
    vec3( 1.0, 0.5, 0.0 ),
    vec3( 1.0, 1.0, 0.0 ),
    vec3( 0.0, 0.5, 0.0 ),
    vec3( 0.0, 0.0, 1.0 ),
    vec3( 0.25, 0.0, 0.5 ),
    vec3( 0.9, 0.5, 0.9 ),
    vec3( 1.0, 1.0, 1.0 )
    );

void main() {
    vec4 color = vertexColor;
    if (color.a == 0.0) {
        discard;
    }
	
	if (color.rgb == vec3(1.0)) {
		color = (TooltipRainbowArray[(int)mod(GameTime, 8)], color.a);
	}
    fragColor = color * ColorModulator;
}
