

import { world, EquipmentSlot, EntityEquippableComponent } from '@minecraft/server';
import { veinminerManager } from './classes/veinminerManager';
import { shovelminerManager } from './classes/shovelminerManager';
world.beforeEvents.playerBreakBlock.subscribe((data) => {
    const { block, itemStack, player } = data;
    if (!itemStack) return;
    const mainhand = player.getComponent(EntityEquippableComponent.componentId).getEquipmentSlot(EquipmentSlot.Mainhand);
    const item = mainhand.getItem();
    if (!item) return;
    if (!player.isSneaking) return;
    if (item.typeId.includes("_pickaxe")) {
        if (veinminerManager.oreIDs.includes(block.typeId)) {
            veinminerManager.start(player, block, item, mainhand);
        }
    } else if (item.typeId.includes("_shovel")) {
        if (shovelminerManager.gravelIDs.includes(block.typeId)) {
            shovelminerManager.start(player, block, item, mainhand);
        }
    }
});
