import { randomNum } from "../math/randomNumbers";
export class ItemManager {
    static spawnItem(item, dimension, location) {
        if (item.typeId == "")
            return;
        const itemEntity = dimension.spawnItem(item, { x: location.x, y: 100, z: location.z });
        itemEntity.teleport(location);
        return itemEntity;
    }
    static reduceDurability(unbreakingLevel) {
        let reduce = true;
        const random = randomNum(0, 100);
        if (unbreakingLevel == undefined) {
            return reduce;
        }
        else {
            switch (unbreakingLevel) {
                case 1:
                    if (random <= 20)
                        reduce = false;
                    break;
                case 2:
                    if (random <= 26.7)
                        reduce = false;
                    break;
                case 3:
                    if (random <= 30)
                        reduce = false;
                    break;
            }
        }
        return reduce;
    }
    static calculateExtraItems(itemsPerLevel, chance, fortuneLevel) {
        let extra = 0;
        for (let i = 0; i < fortuneLevel; i++) {
            for (let i = 0; i < itemsPerLevel; i++) {
                const num = randomNum(0, 1);
                if (num <= chance) {
                    extra = extra + 1;
                }
            }
        }
        return extra;
    }
}
