import { shovelminerManager } from './classes/shovelminerManager';
import { hoeminerManager } from './classes/hoeminerManager';
import { treecapitatorManager } from './classes/treecapitatorManager';
import { veinminerManager } from './classes/veinminerManager';
import { shearsManager } from "./classes/shearsManager"
import { world, EquipmentSlot, EntityEquippableComponent, system } from '@minecraft/server';
world.beforeEvents.playerBreakBlock.subscribe((data) => {
    const { block, itemStack, player } = data;
    if (!itemStack) return;
    const mainhand = player.getComponent(EntityEquippableComponent.componentId).getEquipmentSlot(EquipmentSlot.Mainhand);
    const item = mainhand.getItem();
    if (!item) return;
    if (!player.isSneaking) return;
    if (item.typeId.includes("_axe")) {
        if (treecapitatorManager.logIDs.includes(block.typeId)) {
            treecapitatorManager.startNoLeaves(player, block, item, mainhand);
        }
    } else if (item.typeId.includes("_pickaxe")) {
        if (veinminerManager.oreIDs.includes(block.typeId)) {
            veinminerManager.start(player, block, item, mainhand);
        }
    } else if (item.typeId.includes("_shovel")) {
        if (shovelminerManager.gravelIDs.includes(block.typeId)) {
            shovelminerManager.start(player, block, item, mainhand);
        }
    } else if (item.typeId.includes("_hoe")) {
        if (hoeminerManager.hoeBlockIDs.includes(block.typeId)) {
            hoeminerManager.start(player, block, item, mainhand);
        }
    } else if (item.typeId == "minecraft:shears") {
        if (shearsManager.shearBlockIDs.includes(block.typeId)) {
            shearsManager.start(player, block, item, mainhand)
        }
    }
});

system.afterEvents.scriptEventReceive.subscribe((data) => {
    if (data.id != "veincapitator:mainhand") return
    world.sendMessage(data.sourceEntity.getComponent(EntityEquippableComponent.componentId).getEquipmentSlot(EquipmentSlot.Mainhand).getItem().typeId)
})