import os
from PIL import Image

def upscale_texture(image_path):
    with Image.open(image_path) as img:
        if img.size != (2, 2):
            return  # Ignore images that are not 2x2

        # Upscale using nearest neighbor
        upscaled_img = img.resize((16, 16), Image.NEAREST)
        upscaled_img.save(image_path)  # Overwrite original file
        print(f"Upscaled: {image_path}")

def is_image_file(filename):
    extensions = ('.png', '.jpg', '.jpeg', '.bmp', '.gif')
    return filename.lower().endswith(extensions)

def main():
    folder = os.getcwd()
    for filename in os.listdir(folder):
        if is_image_file(filename):
            filepath = os.path.join(folder, filename)
            try:
                upscale_texture(filepath)
            except Exception as e:
                print(f"Failed to process {filename}: {e}")

if __name__ == "__main__":
    main()

