#version 150

#moj_import <minecraft:fog.glsl>

uniform sampler2D Sampler0;

uniform float GameTime;
uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;

in float GameTime2;

out vec4 fragColor;

void main() {
    vec4 color = texture(Sampler0, texCoord0) * vertexColor * ColorModulator;
    if (color.a < 0.1) {
        discard;
    }

    float t = fract(GameTime * 2000.0);
    if (t < 0.5) {
        fragColor = vec4(1,0,0,1);
    } else {
        fragColor = vec4(0,1,0,1);
    }
}
