import { world } from "@minecraft/server";

const BlockFaceLocationComponent = {
  onPlayerInteract(e) {
    if (!e.faceLocation) return;
    const { x, y, z } = e.faceLocation;

    const message = [x.toFixed(2), y.toFixed(2), z.toFixed(2)].join(" ");
    world.sendMessage(message);
  },
};

world.beforeEvents.worldInitialize.subscribe((e) => {
  e.blockComponentRegistry.registerCustomComponent(
    "bug:face_location",
    BlockFaceLocationComponent
  );
});
