const Server = require('./Server')
const Events = require('./Events')

const uuid = require('uuid/v4')

const server = new Server()

server.on(Events.ClientConnected, () => {
    console.log('Connected')
})

server.on(Events.ServerMessage, (event) => {
    console.log(JSON.stringify(event.payload))
    if (event.payload.body.properties.Sender !== 'External') {
        event.socket.json({
            body: {
                origin: {
                    type: 'player'
                },
                commandLine: `say foo`,
                version: 1,
                overload: 'default'
            },
            header: {
                requestId: uuid(),
                messagePurpose: 'commandRequest',
                version: 1,
                messageType: 'commandRequest'
            }
        })
    }
})

server.on('error', (error) => {
    console.log(error.payload)
})


server.listen(1337)