const WebSocket = require('ws')
const uuid = require('uuid')

const Events = require('./Events')
const MinecraftEventNames = require('./MinecraftEventNames')

const EventEmitter = require('events')

class Server extends EventEmitter {
    constructor () {
        super()
        this._socket = null
    }

    listen(port = process.env.PORT, options = {}) {
        this._socket = new WebSocket.Server({port, ...options})

		this._socket.on('connection', socket => {
			socket.json = obj => socket.send(JSON.stringify(obj))

			this.emit(Events.ClientConnected)

            MinecraftEventNames.forEach((eventName) => {
                socket.json({
                    body: {
                        eventName: eventName
                    },
                    header: {
                        requestId: uuid(),
                        messagePurpose: 'subscribe',
                        version: 1,
                        messageType: eventName
                    }
                })
            })

		    socket.on('message', (message) => {
		    	let data = JSON.parse(message)

		    	switch (data.header.messagePurpose) {
		    		case 'error':
                        this.emit(Events.ServerError, { payload: data, socket })
		    			break

                    case 'event':
                        this.emit(Events.ServerMessage, { payload: data, socket })
			            break
		    	}
		    })

		    socket.on('close', () => this.emit(Events.ClientDisconnected))
		})

    	console.log('Server Created! Listening on port %s', port)
    }
}

module.exports = Server
