const cs = server;
const csFlag = 'S';
const system = cs.registerSystem(0, 0);

/////////////////////////////////////////////////////////////////////////////////////////
// Logging
/////////////////////////////////////////////////////////////////////////////////////////

system.enableLogging = function () {
    let eventData = system.createEventData("minecraft:script_logger_config");
    eventData.data.log_errors = true;
    eventData.data.log_warnings = true;
    eventData.data.log_information = true;
    system.broadcastEvent("minecraft:script_logger_config", eventData);
}

system.log = function (...items) {
    const toString = item => {
        switch (Object.prototype.toString.call(item)) {
            case '[object Undefined]':
                return 'undefined';
            case '[object Null]':
                return 'null';
            case '[object String]':
                return `"${item}"`;
            case '[object Array]':
                const array = item.map(toString);
                return `[${array.join(', ')}]`;
            case '[object Object]':
                const object = Object.keys(item).map(key => `${key}: ${toString(item[key])}`);
                return `{${object.join(', ')}}`;
            case '[object Function]':
                return item.toString();
            default:
                return item;
        }
    }
    msg = csFlag + " | " + items.map(toString).join(' ');

    cs.log(msg);

    let chatEventData = system.createEventData("minecraft:display_chat_event");
    chatEventData.data.message = msg;
    system.broadcastEvent("minecraft:display_chat_event", chatEventData);
}

/////////////////////////////////////////////////////////////////////////////////////////
// Main
/////////////////////////////////////////////////////////////////////////////////////////

// Register script only components and listen for events
system.initialize = function () {
    system.enableLogging();

    system.log("initializing");

    system.listenForEvent("minecraft:block_interacted_with", eventData => system.onBlockInteractedWith(eventData));

    system.log("initialized");
};

system.onBlockInteractedWith = function (eventData) {
    system.log("onBlockInteractedWith()", eventData.data);
}

// Update is called every tick
system.update = function () {
    // pass
};
