var TARDIS = server.registerSystem(0, 0);
TARDIS.entity = { __type__: "entity", __identifier__: "minecraft:armor_stand" };
TARDIS.mark = { __type__: "entity", __identifier__: "tardis:mark", name: ((Math.random() * 255).toString(16) + "\n\u00a7r\ue101The Inside of TARDIS") };
TARDIS.Inside = { mark: null, Position: null, door: null, yIncluded: 128, summoningMark: true, resummoningDoor: false };
TARDIS.loaded = null;
TARDIS.Outside = { entity: null, tpDelay: 0, geronimo: false };
TARDIS.Destination = null;
TARDIS.flying = [null, null, null];
TARDIS.Interfaces = {
    Geronimo: {
        block: "lever 6", x: 9, y: 7, z: 9, Interface: { x: 3, y: 3, z: 3 }, interaction: null, enabled: false
    }
};
TARDIS.initialize = function () {
    this.listenForEvent("minecraft:entity_created", (eventData) => this.entityLoaded(eventData.entity));
    this.listenForEvent("TARDIS:here_we_go", (player) => this.playerCame(player))
};
TARDIS.update = function () {
    if (this.loaded == false) this.loaded = true;
    if (this.isValidMark(this.Inside.mark) && this.isValidTARDIS(this.Inside.door)) {
        for (let i in this.Interfaces) {
            if (this.Interfaces[i].enabled) this.broadcastEvent("minecraft:execute_command", '/execute @e[name="' + this.mark.name + '"] ~ ~ ~ detect ' + (this.Inside.Position.x + this.Interfaces[i].x) + " " + (this.Inside.Position.y + this.Interfaces[i].y) + " " + (this.Inside.Position.z + this.Interfaces[i].z) + " " + this.Interfaces[i].block + " setblock " + (this.Interfaces[i].Interface.x + this.Inside.Position.x) + " " + (this.Interfaces[i].Interface.y + this.Inside.Position.y) + " " + (this.Interfaces[i].Interface.z + this.Inside.Position.z) + " sand 0")
        }
    }
    if (this.flying[0] != null && this.flying[0] <= 620) {
        if (this.flying[0] == 55 || this.flying[0] == 86 || this.flying[0] == 125 || this.flying[0] == 159 || this.flying[0] == 189 || this.flying[0] == 260) {
            this.broadcastEvent("minecraft:execute_command", "/clone " + (this.Inside.Position.x + 7) + " " + (this.Inside.Position.y + 5) + " " + (this.Inside.Position.z + 7) + " " + (this.Inside.Position.x + 8) + " " + (this.Inside.Position.y + 14) + " " + (this.Inside.Position.z + 8) + " " + (this.Inside.Position.x + 7) + " " + (this.Inside.Position.y + 6) + " " + (this.Inside.Position.z + 7) + " masked move");
            this.broadcastEvent("minecraft:execute_command", "/fill " + (this.Inside.Position.x + 7) + " " + (this.Inside.Position.y + 5) + " " + (this.Inside.Position.z + 7) + " " + (this.Inside.Position.x + 8) + " " + (this.Inside.Position.y + 5) + " " + (this.Inside.Position.z + 8) + " beacon 0");
            this.flying[2] = true;
            if (this.isValidTARDIS(this.flying[1])) {
                let Nameable = this.createComponent(this.flying[1], "minecraft:nameable");
                Nameable.name = ("\n\u00a7k" + (Math.random() * 255).toString(16) + "\u00a7r");
                this.applyComponentChanges(this.flying[1], Nameable);
                this.broadcastEvent("minecraft:execute_command", '/effect @e[name="' + Nameable.name + '"] invisibility 4 1 true')
            }
        }
        if (this.flying[0] == 70 || this.flying[0] == 102 || this.flying[0] == 139 || this.flying[0] == 174 || this.flying[0] == 210) {
            this.broadcastEvent("minecraft:execute_command", "/clone " + (this.Inside.Position.x + 7) + " " + (this.Inside.Position.y + 6) + " " + (this.Inside.Position.z + 7) + " " + (this.Inside.Position.x + 8) + " " + (this.Inside.Position.y + 15) + " " + (this.Inside.Position.z + 8) + " " + (this.Inside.Position.x + 7) + " " + (this.Inside.Position.y + 5) + " " + (this.Inside.Position.z + 7) + " masked move");
            this.broadcastEvent("minecraft:execute_command", '/fill ' + (this.Inside.Position.x + 7) + " " + (this.Inside.Position.y + 15) + " " + (this.Inside.Position.z + 7) + " " + (this.Inside.Position.x + 8) + " " + (this.Inside.Position.y + 15) + " " + (this.Inside.Position.z + 8) + " glowstone 0");
            this.flying[2] = false;
            if (this.isValidTARDIS(this.flying[1])) {
                let Nameable = this.createComponent(this.flying[1], "minecraft:nameable");
                Nameable.name = ("\n\u00a7k" + (Math.random() * 256).toString(16) + "\u00a7r");
                this.applyComponentChanges(this.flying[1], Nameable);
                this.broadcastEvent("minecraft:execute_command", '/effect @e[name="' + Nameable.name + '"] invisibility 0 1 true')
            }
        }
        if (this.flying[0] == 283) {
            this.broadcastEvent("minecraft:execute_command", '/stopsound @a "mob.TARDIS.fading"');
            this.destroyEntity(this.flying[1])
        }
        if (this.isValidTARDIS(this.Outside.entity)) {
            if (this.flying[0] == 410 || this.flying[0] == 438 || this.flying[0] == 486 || this.flying[0] == 524 || this.flying[0] == 552 || this.flying[0] == 583 || this.flying[0] == 615) {
                this.broadcastEvent("minecraft:execute_command", "/clone " + (this.Inside.Position.x + 7) + " " + (this.Inside.Position.y + 6) + " " + (this.Inside.Position.z + 7) + " " + (this.Inside.Position.x + 8) + " " + (this.Inside.Position.y + 15) + " " + (this.Inside.Position.z + 8) + " " + (this.Inside.Position.x + 7) + " " + (this.Inside.Position.y + 5) + " " + (this.Inside.Position.z + 7) + " masked move");
                this.broadcastEvent("minecraft:execute_command", '/fill ' + (this.Inside.Position.x + 7) + " " + (this.Inside.Position.y + 15) + " " + (this.Inside.Position.z + 7) + " " + (this.Inside.Position.x + 8) + " " + (this.Inside.Position.y + 15) + " " + (this.Inside.Position.z + 8) + " glowstone 0");
                this.flying[2] = false;
                let Nameable = this.createComponent(this.Outside.entity, "minecraft:nameable");
                Nameable.name = ("\n\u00a7k" + (Math.random() * 255).toString(16) + "\u00a7r");
                this.applyComponentChanges(this.Outside.entity, Nameable);
                this.broadcastEvent("minecraft:execute_command", '/effect @e[name="' + Nameable.name + '"] invisibility 0 1 true');
                Nameable.name = "\n";
                this.applyComponentChanges(this.Outside.entity, Nameable)
            }
            if (this.flying[0] == 421 || this.flying[0] == 455 || this.flying[0] == 497 || this.flying[0] == 536 || this.flying[0] == 568 || this.flying[0] == 596) {
                this.broadcastEvent("minecraft:execute_command", "/clone " + (this.Inside.Position.x + 7) + " " + (this.Inside.Position.y + 5) + " " + (this.Inside.Position.z + 7) + " " + (this.Inside.Position.x + 8) + " " + (this.Inside.Position.y + 14) + " " + (this.Inside.Position.z + 8) + " " + (this.Inside.Position.x + 7) + " " + (this.Inside.Position.y + 6) + " " + (this.Inside.Position.z + 7) + " masked move");
                this.broadcastEvent("minecraft:execute_command", "/fill " + (this.Inside.Position.x + 7) + " " + (this.Inside.Position.y + 5) + " " + (this.Inside.Position.z + 7) + " " + (this.Inside.Position.x + 8) + " " + (this.Inside.Position.y + 5) + " " + (this.Inside.Position.z + 8) + " beacon 0");
                this.flying[2] = true;
                let Nameable = this.createComponent(this.Outside.entity, "minecraft:nameable");
                Nameable.name = ("\n\u00a7k" + (Math.random() * 255).toString(16) + "\u00a7r");
                this.applyComponentChanges(this.Outside.entity, Nameable);
                this.broadcastEvent("minecraft:execute_command", '/effect @e[name="' + Nameable.name + '"] invisibility 4 1 true');
                Nameable.name = "\n";
                this.applyComponentChanges(this.Outside.entity, Nameable)
            }
        } else {
            this.Outside.entity = null;
            if (this.flying[0] > 283) {
                this.flying[0] = null;
                this.Outside.geronimo = false;
                if (this.flying[2]) {
                    this.broadcastEvent("minecraft:execute_command", "/clone " + (this.Inside.Position.x + 7) + " " + (this.Inside.Position.y + 6) + " " + (this.Inside.Position.z + 7) + " " + (this.Inside.Position.x + 8) + " " + (this.Inside.Position.y + 15) + " " + (this.Inside.Position.z + 8) + " " + (this.Inside.Position.x + 7) + " " + (this.Inside.Position.y + 5) + " " + (this.Inside.Position.z + 7) + " masked move");
                    this.broadcastEvent("minecraft:execute_command", '/fill ' + (this.Inside.Position.x + 7) + " " + (this.Inside.Position.y + 15) + " " + (this.Inside.Position.z + 7) + " " + (this.Inside.Position.x + 8) + " " + (this.Inside.Position.y + 15) + " " + (this.Inside.Position.z + 8) + " glowstone 0")
                }
                this.flying = [null, null, null];
                this.broadcastEvent("minecraft:execute_command", '/stopsound @a "mob.TARDIS.noise"')
            }
        }
        if (this.flying[0] != null) this.flying[0]++
    } else {
        if (this.Outside.geronimo) {
            this.broadcastEvent("minecraft:execute_command", "/setblock "(this.Inside.Position.x + 9) + " " + (this.Inside.Position.y + 7) + " " + (this.Inside.Position.z + 9) + " lever 14");
            this.Outside.geronimo = false
        }
        this.flying = [null, null, null]
    }
};
TARDIS.shutdown = function () {
};
TARDIS.playerCame = function (player) {
    if (this.loaded == null) {
        this.listenForEvent("minecraft:player_attacked_actor", (eventData) => this.paa(eventData.player, eventData.attacked_entity));
        this.listenForEvent("minecraft:entity_tick", (eventData) => this.entityTick(eventData.entity));
        this.broadcastEvent("minecraft:display_chat_event", "\ue060\n\u00a7ITARDIS");
        this.loaded = true;
        if (this.isValidMark(this.Inside.mark)) {
            this.Inside.resummoningDoor = true;
            this.broadcastEvent("minecraft:execute_command", "/summon " + this.entity.__identifier__ + " " + (this.Inside.Position.x + 8) + " " + (this.Inside.Position.y + 6) + " " + (this.Inside.Position.z + 14))
        }
    }
};
TARDIS.isValidTARDIS = function (entity) {
    return (entity && this.isValidEntity(entity) && entity.__type__ == this.entity.__type__ && entity.__identifier__ == this.entity.__identifier__);
};
TARDIS.isValidMark = function (entity) {
    return (entity && this.isValidEntity(entity) && entity.__type__ == this.mark.__type__ && entity.__identifier__ == this.mark.__identifier__);
};
TARDIS.isFalling_block = function (entity) {
    return (entity && this.isValidEntity(entity) && entity.__type__ == "entity" && entity.__identifier__ == "minecraft:falling_block");
};
TARDIS.entityLoaded = function (entity) {
    if (this.isValidMark(entity)) {
        if (this.Inside.summoningMark) {
            this.Inside.summoningMark = false;
            let Position = this.getComponent(entity, "minecraft:position");
            let Nameable = this.createComponent(entity, "minecraft:nameable");
            let ChunkBenchmark = {};
            ChunkBenchmark.x = (Math.floor(Position.x / 16) * 16);
            ChunkBenchmark.y = (Math.floor(this.Inside.yIncluded / 16) * 16);
            ChunkBenchmark.z = (Math.floor(Position.z / 16) * 16);
            if (!this.isValidMark(this.Inside.mark)) {
                if (this.isSameEntity(this.Inside.mark, entity)) {
                    this.broadcastEvent("minecraft:display_chat_event", "wtf");
                    throw ("wtf")
                } else {
                    Position.x = (ChunkBenchmark.x + 7);
                    Position.y = (ChunkBenchmark.y + 2);
                    Position.z = (ChunkBenchmark.z + 7);
                    this.applyComponentChanges(entity, Position);
                    Nameable.name = this.mark.name;
                    this.applyComponentChanges(entity, Nameable);
                    this.Inside.Position = { x: ChunkBenchmark.x, y: ChunkBenchmark.y, z: ChunkBenchmark.z };
                    this.Destination = { x: (ChunkBenchmark.x + 7), y: (ChunkBenchmark.y + 16), z: (ChunkBenchmark.z + 7) };
                    this.Inside.mark = entity;
                    if (this.loaded) this.buildInside()
                }
            }
        } else {
            this.destroyEntity(this.Inside.door);
            this.Inside.door = null;
            this.destroyEntity(entity)
        }
    }
    if (this.isValidTARDIS(entity)) {
        let Position = this.getComponent(entity, "minecraft:position");
        if (this.isValidMark(this.Inside.mark) && this.loaded) {
            if (this.isValidTARDIS(this.Inside.door)) {
                if (this.flying[0] != null) this.destroyEntity(entity); else {
                    this.Outside.geronimo = false;
                    this.moveTo(entity)
                }
            } else {
                this.Inside.door = entity;
                let Rotation = this.createComponent(entity, "minecraft:rotation");
                Position.x = (this.Inside.Position.x + 8);
                Position.y = (this.Inside.Position.y + 6);
                Position.z = (this.Inside.Position.z + 13.9375);
                this.applyComponentChanges(entity, Position);
                Rotation.x = 0;
                Rotation.y = 0;
                this.applyComponentChanges(entity, Rotation);
                if (this.flying[0] == null && !this.Inside.resummoningDoor) this.buildInside();
                this.Inside.resummoningDoor = false
            }
        } else {
            this.destroyEntity(entity);
            if (this.loaded) {
                this.Inside.summoningMark = true;
                this.broadcastEvent("minecraft:execute_command", "/summon " + this.mark.__identifier__ + " " + Position.x + " " + Position.y + " " + Position.z)
            }
        }
    }
    if (this.isFalling_block(entity)) {
        let Position = this.getComponent(entity, "minecraft:position");
        let ChunkBenchmark = {};
        ChunkBenchmark.x = (Math.floor(Position.x / 16) * 16);
        ChunkBenchmark.y = (Math.floor(Position.y / 16) * 16);
        ChunkBenchmark.z = (Math.floor(Position.z / 16) * 16);
        if (this.isValidMark(this.Inside.mark) && ChunkBenchmark.x == this.Inside.Position.x && ChunkBenchmark.y == this.Inside.Position.y && ChunkBenchmark.z == this.Inside.Position.z) this.interact(entity, Position)
    }
};
TARDIS.entityTick = function (entity) {
    if (this.isSameEntity(entity, this.Inside.mark)) {
        let Position = this.createComponent(entity, "minecraft:position");
        Position.x = (this.Inside.Position.x + 7);
        Position.y = (this.Inside.Position.y + 2);
        Position.z = (this.Inside.Position.z + 7);
        this.applyComponentChanges(entity, Position)
    }
    if (this.isValidTARDIS(entity)) {
        if (this.isValidMark(this.Inside.mark)) {
            let Position = this.getComponent(entity, "minecraft:position");
            let Rotation = this.getComponent(entity, "minecraft:rotation");
            if (this.isSameEntity(entity, this.Inside.door)) {
                Position.x = (this.Inside.Position.x + 8);
                Position.y = (this.Inside.Position.y + 6);
                Position.z = (this.Inside.Position.z + 13.9375);
                Rotation.y = 0;
                if (this.Outside.tpDelay < 4) this.Outside.tpDelay++; else {
                    this.Outside.tpDelay = 0;
                    if (this.isValidTARDIS(this.Outside.entity) && this.flying[0] == null) {
                        {
                            let Position = this.getComponent(this.Outside.entity, "minecraft:position");
                            let Rotation = this.getComponent(this.Outside.entity, "minecraft:rotation");
                            let Nameable = this.createComponent(this.Outside.entity, "minecraft:nameable");
                            Nameable.name = ("\n\u00a7k" + (Math.random() * 255).toString(16) + "\u00a7r");
                            this.applyComponentChanges(this.Outside.entity, Nameable);
                            this.broadcastEvent("minecraft:execute_command", '/execute @e[name="' + this.mark.name + '"] ~ ~ ~ tp @e[x=' + (this.Inside.Position.x + 7) + ",y=" + (this.Inside.Position.y + 6) + ",z=" + (this.Inside.Position.z + 14) + ",dx=1,dy=1,dz=0] " + (this.Inside.Position.x + 8) + ".0 " + (this.Inside.Position.y + 6) + " " + (this.Inside.Position.z + 13.5));
                            this.broadcastEvent("minecraft:execute_command", "/execute @e[x=" + (this.Inside.Position.x + 8) + ",y=" + (this.Inside.Position.y + 6) + ",z=" + (this.Inside.Position.z + 13.5) + ",r=0] ~ ~ ~ tp @s ~ ~ ~ ~" + (Rotation.y) + " ~");
                            this.broadcastEvent("minecraft:execute_command", '/execute @e[name="' + this.mark.name + '"] ~ ~ ~ tp @e[x=' + (this.Inside.Position.x + 8) + ",y=" + (this.Inside.Position.y + 6) + ",z=" + (this.Inside.Position.z + 13.5) + ',r=0] @e[name="' + Nameable.name + '",c=1]');
                            this.broadcastEvent("minecraft:execute_command", '/execute @e[name="' + Nameable.name + '"] ~ ~ ~ tp @e[name=!"' + Nameable.name + '",r=0] ^^^1.5');
                            Nameable.name = "\n";
                            this.applyComponentChanges(this.Outside.entity, Nameable)
                        }
                        {
                            let Rotation = this.getComponent(this.Outside.entity, "minecraft:rotation");
                            let From = this.createComponent(this.Outside.entity, "minecraft:nameable");
                            let To = this.createComponent(entity, "minecraft:nameable");
                            From.name = ("\n\u00a7k" + (Math.random() * 255).toString(16) + "\u00a7r");
                            To.name = ("\n\u00a7k" + (Math.random() * 255).toString(16) + "\u00a7r");
                            this.applyComponentChanges(this.Outside.entity, From);
                            this.applyComponentChanges(entity, To);
                            this.broadcastEvent("minecraft:execute_command", '/execute @e[name="' + From.name + '"] ~ ~ ~ tp @a[r=1] @s');
                            let Position = this.getComponent(this.Outside.entity, "minecraft:position");
                            this.broadcastEvent("minecraft:execute_command", "/execute @a[x=" + (Position.x) + ",y=" + (Position.y) + ",z=" + (Position.z) + ",r=0] ~ ~ ~ tp @s ~ ~ ~ ~" + (-Rotation.y) + " ~");
                            this.broadcastEvent("minecraft:execute_command", '/execute @e[name="' + From.name + '"] ~ ~ ~ tp @a[r=0] @e[name="' + To.name + '",c=1]');
                            From.name = "\n";
                            this.applyComponentChanges(this.Outside.entity, From);
                            To.name = "\n";
                            this.applyComponentChanges(entity, To);
                        }
                    }
                }
            } else {
                Position.x = (Math.round(Position.x));
                Position.y = (Math.round(Position.y));
                Position.z = (Math.round(Position.z));
                Rotation.y = (Math.round(Rotation.y / 90) * 90)
            }
            Rotation.x = 0;
            this.applyComponentChanges(entity, Position);
            this.applyComponentChanges(entity, Rotation)
        }
    } else {
        this.Inside.mark = null;
        this.Inside.Position = null;
        this.destroyEntity(this.Outside.entity);
        this.Outside.entity = null;
        this.destroyEntity(this.Inside.door);
        this.Inside.door = null;
        this.destroyEntity(entity)
    }
};
TARDIS.interact = function (entity, Position) {
    let isInterface = false;
    for (let i in this.Interfaces) {
        if (Position.x == (this.Interfaces[i].Interface.x + this.Inside.Position.x + 0.5) && Position.y == (this.Interfaces[i].Interface.y + this.Inside.Position.y + 0.5) && Position.z == (this.Interfaces[i].Interface.z + this.Inside.Position.z + 0.5)) {
            isInterface = true;
            this.Interfaces[i].interaction(this)
        }
    }
    if (isInterface) this.destroyEntity(entity)
};
TARDIS.Interfaces.Geronimo.interaction = function (that) {
    that.broadcastEvent("minecraft:display_chat_event", "Geronimo!");
};
TARDIS.paa = function (player, victim) {
};
TARDIS.isSameEntity = function (thisOne, thatOne) {
    let isSame = true;
    if (this.isValidEntity(thisOne) && this.isValidEntity(thatOne)) {
        for (let i in thisOne) {
            if (i == "__unique_id__") {
                for (let id in thisOne[i]) {
                    if (thisOne[i][id] != thatOne[i][id]) isSame = false
                }
            } else if (thisOne[i] != thatOne[i]) isSame = false
        }
        for (let i in thatOne) {
            if (i == "__unique_id__") {
                for (let id in thatOne[i]) {
                    if (thatOne[i][id] != thisOne[i][id]) isSame = false
                }
            } else if (thatOne[i] != thisOne[i]) isSame = false
        }
    } else isSame = false;
    return isSame;
};
TARDIS.buildInside = function () {
    this.broadcastEvent("minecraft:execute_command", "/fill " + (this.Inside.Position.x) + " " + (this.Inside.Position.y) + " " + (this.Inside.Position.z) + " " + (this.Inside.Position.x + 15) + " " + (this.Inside.Position.y + 15) + " " + (this.Inside.Position.z + 15) + " glowstone 0 hollow");
    this.broadcastEvent("minecraft:execute_command", "/fill " + (this.Inside.Position.x + 1) + " " + (this.Inside.Position.y + 1) + " " + (this.Inside.Position.z + 1) + " " + (this.Inside.Position.x + 14) + " " + (this.Inside.Position.y + 14) + " " + (this.Inside.Position.z + 14) + " quartz_block 3 hollow");
    this.broadcastEvent("minecraft:execute_command", "/fill " + (this.Inside.Position.x + 2) + " " + (this.Inside.Position.y + 2) + " " + (this.Inside.Position.z + 2) + " " + (this.Inside.Position.x + 13) + " " + (this.Inside.Position.y + 13) + " " + (this.Inside.Position.z + 13) + " lantern 0 hollow");
    this.broadcastEvent("minecraft:execute_command", "/fill " + (this.Inside.Position.x + 3) + " " + (this.Inside.Position.y + 2) + " " + (this.Inside.Position.z + 3) + " " + (this.Inside.Position.x + 12) + " " + (this.Inside.Position.y + 13) + " " + (this.Inside.Position.z + 12) + " air 0");
    this.broadcastEvent("minecraft:execute_command", "/fill " + (this.Inside.Position.x + 1) + " " + (this.Inside.Position.y + 4) + " " + (this.Inside.Position.z + 1) + " " + (this.Inside.Position.x + 14) + " " + (this.Inside.Position.y + 5) + " " + (this.Inside.Position.z + 14) + " quartz_block 3");
    this.broadcastEvent("minecraft:execute_command", "/fill " + (this.Inside.Position.x + 6) + " " + (this.Inside.Position.y + 4) + " " + (this.Inside.Position.z + 6) + " " + (this.Inside.Position.x + 9) + " " + (this.Inside.Position.y + 4) + " " + (this.Inside.Position.z + 9) + " diamond_block 0");
    this.broadcastEvent("minecraft:execute_command", "/fill " + (this.Inside.Position.x + 5) + " " + (this.Inside.Position.y + 2) + " " + (this.Inside.Position.z + 5) + " " + (this.Inside.Position.x + 10) + " " + (this.Inside.Position.y + 3) + " " + (this.Inside.Position.z + 10) + " iron_block 0");
    this.broadcastEvent("minecraft:execute_command", "/fill " + (this.Inside.Position.x + 7) + " " + (this.Inside.Position.y + 5) + " " + (this.Inside.Position.z + 7) + " " + (this.Inside.Position.x + 8) + " " + (this.Inside.Position.y + 5) + " " + (this.Inside.Position.z + 8) + " stone_slab4 9");
    this.broadcastEvent("minecraft:execute_command", "/fill " + (this.Inside.Position.x + 7) + " " + (this.Inside.Position.y + 6) + " " + (this.Inside.Position.z + 7) + " " + (this.Inside.Position.x + 8) + " " + (this.Inside.Position.y + 6) + " " + (this.Inside.Position.z + 8) + " beacon 0");
    this.broadcastEvent("minecraft:execute_command", "/fill " + (this.Inside.Position.x + 7) + " " + (this.Inside.Position.y + 14) + " " + (this.Inside.Position.z + 7) + " " + (this.Inside.Position.x + 8) + " " + (this.Inside.Position.y + 14) + " " + (this.Inside.Position.z + 8) + " enchanting_table 0");
    this.broadcastEvent("minecraft:execute_command", "/fill " + (this.Inside.Position.x + 6) + " " + (this.Inside.Position.y + 5) + " " + (this.Inside.Position.z + 13) + " " + (this.Inside.Position.x + 9) + " " + (this.Inside.Position.y + 9) + " " + (this.Inside.Position.z + 14) + " lapis_block 0");
    this.broadcastEvent("minecraft:execute_command", "/fill " + (this.Inside.Position.x + 7) + " " + (this.Inside.Position.y + 6) + " " + (this.Inside.Position.z + 13) + " " + (this.Inside.Position.x + 8) + " " + (this.Inside.Position.y + 8) + " " + (this.Inside.Position.z + 14) + " air 0");
    this.broadcastEvent("minecraft:execute_command", "/fill " + (this.Inside.Position.x + 6) + " " + (this.Inside.Position.y + 6) + " " + (this.Inside.Position.z + 6) + " " + (this.Inside.Position.x + 6) + " " + (this.Inside.Position.y + 6) + " " + (this.Inside.Position.z + 8) + " smooth_quartz_stairs 4");
    this.broadcastEvent("minecraft:execute_command", "/fill " + (this.Inside.Position.x + 9) + " " + (this.Inside.Position.y + 6) + " " + (this.Inside.Position.z + 7) + " " + (this.Inside.Position.x + 9) + " " + (this.Inside.Position.y + 6) + " " + (this.Inside.Position.z + 9) + " smooth_quartz_stairs 5");
    this.broadcastEvent("minecraft:execute_command", "/fill " + (this.Inside.Position.x + 7) + " " + (this.Inside.Position.y + 6) + " " + (this.Inside.Position.z + 6) + " " + (this.Inside.Position.x + 9) + " " + (this.Inside.Position.y + 6) + " " + (this.Inside.Position.z + 6) + " smooth_quartz_stairs 6");
    this.broadcastEvent("minecraft:execute_command", "/fill " + (this.Inside.Position.x + 6) + " " + (this.Inside.Position.y + 6) + " " + (this.Inside.Position.z + 9) + " " + (this.Inside.Position.x + 8) + " " + (this.Inside.Position.y + 6) + " " + (this.Inside.Position.z + 9) + " smooth_quartz_stairs 7");
    this.broadcastEvent("minecraft:execute_command", "/setblock " + (this.Inside.Position.x + 7) + " " + (this.Inside.Position.y + 7) + " " + (this.Inside.Position.z + 6) + " lever 5");
    this.broadcastEvent("minecraft:execute_command", "/setblock " + (this.Inside.Position.x + 8) + " " + (this.Inside.Position.y + 7) + " " + (this.Inside.Position.z + 6) + " unpowered_repeater 14");
    this.broadcastEvent("minecraft:execute_command", "/setblock " + (this.Inside.Position.x + 6) + " " + (this.Inside.Position.y + 7) + " " + (this.Inside.Position.z + 8) + " lever 6");
    this.broadcastEvent("minecraft:execute_command", "/setblock " + (this.Inside.Position.x + 6) + " " + (this.Inside.Position.y + 7) + " " + (this.Inside.Position.z + 7) + " unpowered_repeater 13");
    this.broadcastEvent("minecraft:execute_command", "/setblock " + (this.Inside.Position.x + 9) + " " + (this.Inside.Position.y + 7) + " " + (this.Inside.Position.z + 7) + " lever 14");
    this.broadcastEvent("minecraft:execute_command", "/setblock " + (this.Inside.Position.x + 9) + " " + (this.Inside.Position.y + 7) + " " + (this.Inside.Position.z + 8) + " unpowered_repeater 15");
    this.broadcastEvent("minecraft:execute_command", "/setblock " + (this.Inside.Position.x + 9) + " " + (this.Inside.Position.y + 7) + " " + (this.Inside.Position.z + 9) + " lever 14");
    if (this.isValidTARDIS(this.Inside.door)) {
        let Position = this.createComponent(this.Inside.door, "minecraft:position");
        let Rotation = this.createComponent(this.Inside.door, "minecraft:rotation");
        Position.x = (this.Inside.Position.x + 8);
        Position.y = (this.Inside.Position.y + 6);
        Position.z = (this.Inside.Position.z + 13.9375);
        this.applyComponentChanges(this.Inside.door, Position);
        Rotation.x = 0;
        Rotation.y = 0;
        this.applyComponentChanges(this.Inside.door, Rotation)
    } else {
        this.Inside.door = null;
        this.broadcastEvent("minecraft:execute_command", "/summon " + this.entity.__identifier__ + " " + (this.Inside.Position.x + 8) + " " + (this.Inside.Position.y + 6) + " " + (this.Inside.Position.z + 14))
    }
};
TARDIS.moveTo = function (entity) {
    this.broadcastEvent("minecraft:execute_command", '/stopsound @a "mob.TARDIS.fading"');
    if (this.isValidEntity(this.flying[1])) {
        this.flying[0] = null;
        this.destroyEntity(this.flying[1])
    }
    this.flying[1] = this.Outside.entity;
    let Position = this.getComponent(entity, "minecraft:position");
    this.broadcastEvent("minecraft:execute_command", '/stopsound @a "mob.TARDIS.noise"');
    if (this.isValidEntity(this.Outside.entity)) {
        this.broadcastEvent("minecraft:execute_command", '/playsound "mob.TARDIS.noise" @a ' + (this.Inside.Position.x + 7) + " " + (this.Inside.Position.y + 6) + " " + (this.Inside.Position.z + 7));
        this.broadcastEvent("minecraft:execute_command", '/playsound "mob.TARDIS.noise" @a ' + Position.x + " " + Position.y + " " + Position.z);
        {
            let Position = this.getComponent(this.Outside.entity, "minecraft:position");
            this.broadcastEvent("minecraft:execute_command", '/playsound "mob.TARDIS.fading" @a ' + Position.x + " " + Position.y + " " + Position.z)
        }
        this.flying[0] = 0;
        let Nameable = this.createComponent(entity, "minecraft:nameable");
        Nameable.name = ("\n\u00a7k" + (Math.random() * 255).toString(16) + "\u00a7r");
        this.applyComponentChanges(entity, Nameable);
        this.broadcastEvent("minecraft:execute_command", '/effect @e[name="' + Nameable.name + '"] invisibility 32 1 true');
        Nameable.name = "\n";
        this.applyComponentChanges(entity, Nameable)
    }
    let Rotation = this.getComponent(entity, "minecraft:rotation");
    Rotation.x = (Math.round(Rotation.x / 90) * 90);
    this.applyComponentChanges(entity, Rotation);
    this.Outside.entity = entity;
    this.destroyEntity(this.Inside.door);
    this.broadcastEvent("minecraft:execute_command", "/summon " + this.entity.__identifier__ + " " + (this.Inside.Position.x + 8) + " " + (this.Inside.Position.y + 6) + " " + (this.Inside.Position.z + 14))
};